/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.item.InvalidMaterialException;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.profile.PlayerProfile;

public class ItemData
implements com.elmakers.mine.bukkit.api.item.ItemData,
ItemUpdatedCallback,
Cloneable {
    public static final String MINECRAFT_ITEM_PREFIX = "minecraft:";
    public static double EARN_SCALE = 0.5;
    private final MageController controller;
    private String key;
    private String baseKey;
    private String materialKey;
    private ItemStack item;
    private ConfigurationSection configuration;
    private double worth;
    private Double earns;
    private Integer damage;
    private Set<String> categories = ImmutableSet.of();
    private String creatorId;
    private String creator;
    private boolean cache = true;
    private boolean locked;
    private boolean loaded;
    private boolean exactIngredient;
    private boolean replaceOnEquip;
    private List<String> discoverRecipes;
    private List<PendingUpdate> pending = null;

    public ItemData(ItemStack itemStack, MageController controller) {
        this.controller = controller;
        this.item = CompatibilityLib.getItemUtils().getCopy(itemStack);
        Object itemKey = itemStack.getType().toString();
        if (itemStack.getAmount() > 1) {
            itemKey = (String)itemKey + "@" + itemStack.getAmount();
        }
        this.setKey((String)itemKey);
    }

    public ItemData(String materialKey, MageController controller) {
        this(materialKey, materialKey, controller);
    }

    public ItemData(String key, String materialKey, MageController controller) {
        this.controller = controller;
        this.setKey(key);
        this.materialKey = materialKey;
    }

    public ItemData(String key, ConfigurationSection configuration, MageController controller) {
        List<String> categoriesList;
        this.controller = controller;
        this.configuration = configuration;
        this.setKey(key);
        this.materialKey = key;
        this.worth = configuration.getDouble("worth", this.worth);
        this.earns = configuration.contains("earns") ? Double.valueOf(configuration.getDouble("earns")) : null;
        this.creator = configuration.getString("creator");
        this.creatorId = configuration.getString("creator_id");
        this.locked = configuration.getBoolean("locked");
        this.replaceOnEquip = configuration.getBoolean("replace_on_equip");
        this.exactIngredient = configuration.getBoolean("exact_ingredient");
        this.discoverRecipes = ConfigurationUtils.getStringList(configuration, "discover_recipes");
        this.damage = ConfigurationUtils.getOptionalInteger(configuration, "damage");
        this.cache = configuration.getBoolean("cache", true);
        if (this.discoverRecipes != null && this.discoverRecipes.isEmpty()) {
            this.discoverRecipes = null;
        }
        if ((categoriesList = ConfigurationUtils.getStringList(configuration, "categories")) != null) {
            this.categories = ImmutableSet.copyOf(categoriesList);
        }
    }

    private ItemStack createItemFromConfiguration() throws InvalidMaterialException {
        ItemMeta meta;
        ConfigurationSection potionEffects;
        ItemMeta meta2;
        ConfigurationSection color;
        List<String> lore;
        String customName;
        ConfigurationSection tagSection;
        ConfigurationSection configuration = this.configuration;
        if (this.cache) {
            this.configuration = null;
        }
        ItemStack item = null;
        if (configuration.isItemStack("item")) {
            item = configuration.getItemStack("item");
        } else if (configuration.isConfigurationSection("item")) {
            ConfigurationSection itemConfiguration = configuration.getConfigurationSection("item");
            String materialKey = itemConfiguration.getString("type", this.key);
            MaterialAndData material = new MaterialAndData(materialKey = ItemData.cleanMinecraftItemName(materialKey));
            if (material.isValid()) {
                item = material.getItemStack(1);
            }
            if (item == null) {
                throw new InvalidMaterialException("Invalid item key: " + materialKey);
            }
            ConfigurationSection tagSection2 = itemConfiguration.getConfigurationSection("tags");
            if (tagSection2 != null) {
                item = CompatibilityLib.getItemUtils().makeReal(item);
                CompatibilityLib.getNBTUtils().saveTagsToItem(tagSection2, item);
            }
        } else {
            String materialKey = configuration.getString("item", this.key);
            MaterialAndData material = new MaterialAndData(materialKey = ItemData.cleanMinecraftItemName(materialKey));
            if (material.isValid()) {
                item = material.getItemStack(1);
            }
            if (item == null) {
                throw new InvalidMaterialException("Invalid item key: " + materialKey);
            }
        }
        if (item == null) {
            throw new InvalidMaterialException("Invalid item configuration: " + this.key);
        }
        List<ConfigurationSection> attributes = ConfigurationUtils.getNodeList(configuration, "attributes");
        if (attributes != null && !attributes.isEmpty()) {
            item = CompatibilityLib.getItemUtils().makeReal(item);
            for (ConfigurationSection attributeConfig : attributes) {
                String attributeKey = attributeConfig.getString("type");
                attributeKey = attributeConfig.getString("attribute", attributeKey);
                try {
                    Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                    double value = attributeConfig.getDouble("amount");
                    value = attributeConfig.getDouble("value", value);
                    String slot = attributeConfig.getString("slot");
                    String uuidString = attributeConfig.getString("uuid");
                    UUID uuid = null;
                    if (uuidString != null) {
                        try {
                            uuid = UUID.fromString(uuidString);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (uuid == null) {
                        uuid = UUID.randomUUID();
                    }
                    int operation = attributeConfig.getInt("operation", 0);
                    if (CompatibilityLib.getCompatibilityUtils().setItemAttribute(item, attribute, value, slot, operation, uuid)) continue;
                    Bukkit.getLogger().warning("Failed to set attribute: " + attributeKey);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Invalid attribute: " + attributeKey);
                }
            }
        } else {
            ConfigurationSection simpleAttributes = configuration.getConfigurationSection("attributes");
            if (simpleAttributes != null) {
                CompatibilityLib.getInventoryUtils().applyAttributes(item, simpleAttributes, configuration.getString("attribute_slot"));
            }
        }
        if ((tagSection = configuration.getConfigurationSection("tags")) != null) {
            item = CompatibilityLib.getItemUtils().makeReal(item);
            CompatibilityLib.getNBTUtils().saveTagsToItem(tagSection, item);
        }
        if ((customName = configuration.getString("name")) == null) {
            customName = this.controller.getMessages().getIfSet("items." + this.key + ".name");
        }
        if (customName != null) {
            ItemMeta meta3 = item.getItemMeta();
            meta3.setDisplayName(CompatibilityLib.getCompatibilityUtils().translateColors(customName));
            item.setItemMeta(meta3);
        }
        if ((lore = configuration.getStringList("lore")) == null) {
            lore = this.controller.getMessages().getAll("items." + this.key + ".lore");
        }
        if (lore != null && !lore.isEmpty()) {
            ItemMeta meta4 = item.getItemMeta();
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, CompatibilityLib.getCompatibilityUtils().translateColors(lore.get(i)));
            }
            meta4.setLore(lore);
            item.setItemMeta(meta4);
        }
        if ((color = configuration.getConfigurationSection("color")) != null && (meta2 = item.getItemMeta()) instanceof LeatherArmorMeta) {
            int red = color.getInt("red");
            int green = color.getInt("green");
            int blue = color.getInt("blue");
            LeatherArmorMeta leather = (LeatherArmorMeta)meta2;
            leather.setColor(Color.fromRGB((int)red, (int)green, (int)blue));
            item.setItemMeta(meta2);
        }
        if ((potionEffects = configuration.getConfigurationSection("potion_effects")) != null && (meta = item.getItemMeta()) instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            int potionEffectDuration = configuration.getInt("potion_effect_duration");
            Collection<PotionEffect> effects = ConfigurationUtils.getPotionEffects(potionEffects, potionEffectDuration);
            for (PotionEffect effect : effects) {
                potion.addCustomEffect(effect, true);
            }
            item.setItemMeta((ItemMeta)potion);
        }
        return item;
    }

    private void setKey(String key) {
        this.key = key;
        this.checkKey();
    }

    public void checkKey() {
        String[] pieces = StringUtils.split(this.key, "@", 2);
        this.baseKey = pieces[0];
        if (this.worth == 0.0 && pieces.length > 1) {
            try {
                com.elmakers.mine.bukkit.api.item.ItemData singular;
                int amount = Integer.parseInt(pieces[1]);
                if (amount > 1 && (singular = this.controller.getItem(this.baseKey)) != null) {
                    this.worth = singular.getWorth() * (double)amount;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ItemData(String key, ItemStack item, double worth, MageController controller) throws Exception {
        this.controller = controller;
        if (item == null) {
            throw new Exception("Invalid item");
        }
        this.key = key;
        this.materialKey = key;
        this.item = item;
        this.worth = worth;
    }

    public static String cleanMinecraftItemName(String materialKey) {
        if (materialKey.startsWith(MINECRAFT_ITEM_PREFIX)) {
            materialKey = materialKey.substring(MINECRAFT_ITEM_PREFIX.length());
        }
        return materialKey;
    }

    public ItemData createVariant(String key, short damage) throws Exception {
        ItemData variant = (ItemData)this.clone();
        variant.damage = damage;
        variant.key = key;
        variant.materialKey = key;
        if (variant.item != null) {
            variant.item = variant.item.clone();
            CompatibilityLib.getDeprecatedUtils().setItemDamage(variant.item, damage);
        }
        return variant;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getBaseKey() {
        return this.baseKey;
    }

    @Override
    public double getWorth() {
        return this.worth;
    }

    @Override
    public double getEarns() {
        return this.earns == null ? this.worth * EARN_SCALE : this.earns;
    }

    @Override
    public boolean hasCustomEarns() {
        return this.earns != null;
    }

    @Override
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount) {
        return this.getItemStack(amount, (ItemUpdatedCallback)null);
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount, ItemUpdatedCallback callback) {
        return this.getItemStack((Integer)amount, callback);
    }

    @Override
    @Nullable
    public ItemStack getItemStack() {
        return this.getItemStack(null, null);
    }

    @Nullable
    private ItemStack getItemStack(Integer amount, ItemUpdatedCallback callback) {
        ItemStack newItem = CompatibilityLib.getItemUtils().getCopy(this.getOrCreateItemStack());
        if (newItem == null) {
            if (callback != null) {
                callback.updated(null);
            }
            return null;
        }
        if (this.pending != null) {
            this.pending.add(new PendingUpdate(newItem, callback));
        } else if (callback != null) {
            callback.updated(newItem);
        }
        if (amount != null) {
            newItem.setAmount(amount.intValue());
        }
        return newItem;
    }

    @Nonnull
    public ItemStack getOrCreateItemStack() {
        if (this.item == null || !this.cache) {
            if (this.configuration != null) {
                try {
                    this.item = this.createItemFromConfiguration();
                }
                catch (InvalidMaterialException ex) {
                    this.controller.info("Invalid item type '" + this.key + "', may not exist on your server version: " + ex.getMessage(), 2);
                }
                if (this.item == null) {
                    this.item = new ItemStack(Material.AIR);
                }
            } else {
                try {
                    this.item = this.controller.createItem(this.materialKey, null, false, this);
                }
                catch (Exception ex) {
                    this.controller.info("There was an error creating an item of type: " + this.materialKey);
                }
                if (!this.loaded && CompatibilityLib.getInventoryUtils().isSkull(this.item)) {
                    this.pending = new ArrayList<PendingUpdate>();
                }
                if (this.item == null) {
                    this.controller.getLogger().warning("Invalid item key: " + this.materialKey);
                    this.item = new ItemStack(Material.AIR);
                }
            }
            if (this.item != null && this.damage != null) {
                CompatibilityLib.getDeprecatedUtils().setItemDamage(this.item, (short)this.damage.intValue());
            }
        }
        return this.item;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public Material getType() {
        return this.getOrCreateItemStack().getType();
    }

    public int getCustomModelData() {
        return CompatibilityLib.getItemUtils().getCustomModelData(this.getOrCreateItemStack());
    }

    @Override
    @Nullable
    @Deprecated
    public MaterialData getMaterialData() {
        ItemStack item = this.getOrCreateItemStack();
        MaterialData materialData = item.getData();
        materialData.setData((byte)item.getDurability());
        return materialData;
    }

    @Override
    public int getDurability() {
        return CompatibilityLib.getDeprecatedUtils().getItemDamage(this.getOrCreateItemStack());
    }

    @Override
    public int getAmount() {
        return this.getOrCreateItemStack().getAmount();
    }

    @Override
    @Nullable
    public ItemMeta getItemMeta() {
        return this.getOrCreateItemStack().getItemMeta();
    }

    @Override
    @Nullable
    public MaterialAndData getMaterialAndData() {
        return new MaterialAndData(this.getOrCreateItemStack());
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isExactIngredient() {
        return this.exactIngredient;
    }

    public boolean isReplaceOnEquip() {
        return this.replaceOnEquip;
    }

    @Override
    public void updated(@Nullable ItemStack itemStack) {
        this.loaded = true;
        if (this.pending != null && itemStack != null) {
            this.item = itemStack;
            ItemMeta populatedMeta = itemStack.getItemMeta();
            PlayerProfile profile = null;
            if (populatedMeta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)populatedMeta;
                profile = skullMeta.getOwnerProfile();
            }
            for (PendingUpdate update : this.pending) {
                ItemStack item;
                ItemMeta updateMeta;
                if (profile != null && (updateMeta = (item = update.item).getItemMeta()) instanceof SkullMeta) {
                    SkullMeta updateSkullMeta = (SkullMeta)updateMeta;
                    updateSkullMeta.setOwnerProfile(profile);
                    item.setItemMeta(updateMeta);
                }
                if (update.callback == null) continue;
                update.callback.updated(update.item);
            }
        }
        this.pending = null;
    }

    public int getMaxDurability() {
        ItemStack itemStack = this.getItemStack();
        return itemStack == null ? 0 : (int)itemStack.getType().getMaxDurability();
    }

    @Override
    @Nullable
    public Collection<String> getDiscoverRecipes() {
        return this.discoverRecipes;
    }

    @Override
    public void addDiscoverRecipe(String recipe) {
        if (this.discoverRecipes == null) {
            this.discoverRecipes = new ArrayList<String>();
        }
        this.discoverRecipes.add(recipe);
    }

    private static class PendingUpdate {
        public ItemStack item;
        public ItemUpdatedCallback callback;

        public PendingUpdate(ItemStack item, ItemUpdatedCallback callback) {
            this.item = item;
            this.callback = callback;
        }
    }
}

