/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.EffectContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.configuration.TranslatingConfigurationSection;
import com.elmakers.mine.bukkit.effect.EffectLibManager;
import com.elmakers.mine.bukkit.effect.EffectLibPlay;
import com.elmakers.mine.bukkit.effect.EffectUtils;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.effect.Visibility;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleOptions;
import com.elmakers.mine.bukkit.tasks.PlayEffectTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class EffectPlayer
implements com.elmakers.mine.bukkit.api.effect.EffectPlayer {
    private static final String EFFECT_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.effect.builtin";
    public static boolean ENABLE_VANILLA_SOUNDS = true;
    public static boolean ENABLE_CUSTOM_SOUNDS = true;
    public static double VOLUME_SCALE = 1.0;
    public static int PARTICLE_RANGE = 32;
    private static Map<String, Class<?>> effectClasses = new HashMap();
    private static EffectLibManager effectLib = null;
    private ConfigurationSection effectLibConfig = null;
    private Collection<EffectPlay> currentEffects = null;
    public static boolean SOUNDS_ENABLED = true;
    protected Plugin plugin;
    protected Logger logger;
    protected String logContext;
    private DynamicLocation origin;
    private DynamicLocation target;
    private DynamicLocation selection;
    private Vector originOffset;
    private Vector targetOffset;
    private Vector originRelativeOffset;
    private Vector targetRelativeOffset;
    private Visibility visibility = Visibility.ALL;
    private Collection<UUID> observers = null;
    protected boolean playAtOrigin = true;
    protected boolean playAtTarget = false;
    protected boolean targetIsSelection = false;
    protected boolean originIsSelection = false;
    protected boolean playAtAllTargets = false;
    protected Color color = null;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material;
    protected int delayTicks = 0;
    protected double probability = 1.0;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material1;
    protected Color color1 = null;
    protected Color color2 = null;
    protected boolean useColor = true;
    protected EntityEffect entityEffect = null;
    protected Effect effect = null;
    protected Integer effectData = null;
    protected SoundEffect sound = null;
    protected boolean broadcastSound = true;
    protected boolean hasFirework = false;
    protected FireworkEffect.Type fireworkType;
    protected int fireworkPower = 1;
    protected Boolean fireworkFlicker;
    protected boolean fireworkSilent;
    protected FireworkEffect fireworkEffect;
    protected Particle particleType = null;
    protected Particle particleOverride = null;
    protected String useParticleOverride = null;
    protected String useColorOverride = null;
    protected String radiusOverride = null;
    protected float particleData = 0.0f;
    protected float particleXOffset = 0.3f;
    protected float particleYOffset = 0.3f;
    protected float particleZOffset = 0.3f;
    protected int particleCount = 1;
    protected float particleSize = 1.0f;
    protected int arrivalTime;
    protected boolean requireEntity = false;
    protected boolean requireTargetEntity = false;
    protected boolean noTargetEntity = false;
    protected boolean sampleTarget = false;
    protected SourceLocation sourceLocation = null;
    protected SourceLocation targetLocation = null;
    protected float scale = 1.0f;
    protected ConfigurationSection parameterMap = null;

    public static boolean initialize(Plugin plugin, Logger logger) {
        effectLib = EffectLibManager.initialize(plugin, logger);
        return effectLib != null;
    }

    public static void ignorePlayer(Player player, boolean ignore) {
        if (effectLib != null) {
            effectLib.ignorePlayer(player, ignore);
        }
    }

    public static void debugEffects(boolean debug) {
        if (effectLib != null) {
            effectLib.enableDebug(debug);
        }
    }

    public static void showStackTraces(boolean debug) {
        if (effectLib != null) {
            effectLib.enableStackTraces(debug);
        }
    }

    public static void setParticleRange(int range) {
        PARTICLE_RANGE = range;
        if (effectLib != null) {
            effectLib.setParticleRange(range);
        }
    }

    public static void setForceShow(boolean forceShow) {
        if (effectLib != null) {
            effectLib.setForceShow(forceShow);
        }
    }

    public EffectPlayer() {
    }

    public EffectPlayer(Plugin plugin) {
        this.plugin = plugin;
    }

    @Nullable
    private Logger getLogger() {
        if (this.logger == null && this.plugin != null) {
            this.logger = this.plugin.getLogger();
        }
        return this.logger;
    }

    private void warn(String warning) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.warning(warning);
        }
    }

    public static Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> loadEffects(Plugin plugin, ConfigurationSection root, String key) {
        return EffectPlayer.loadEffects(plugin, root, key, null, null, null);
    }

    public static Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> loadEffects(Plugin plugin, ConfigurationSection root, String key, Logger logger, String logContext, ConfigurationSection parameterMap) {
        ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer> players = new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        List<ConfigurationSection> effectNodes = ConfigurationUtils.getNodeList(root, key);
        if (effectNodes != null) {
            for (ConfigurationSection effectValues : effectNodes) {
                Object effectClass = effectValues.getString("class", "EffectSingle");
                try {
                    Class<?> genericClass;
                    if (!((String)effectClass).contains(".")) {
                        if (!((String)effectClass).startsWith("Effect")) {
                            effectClass = "Effect" + (String)effectClass;
                        }
                        effectClass = "com.elmakers.mine.bukkit.effect.builtin." + (String)effectClass;
                    }
                    if ((genericClass = effectClasses.get(effectClass)) == null) {
                        genericClass = Class.forName((String)effectClass);
                        effectClasses.put((String)effectClass, genericClass);
                    }
                    if (!EffectPlayer.class.isAssignableFrom(genericClass)) {
                        throw new Exception("Must extend EffectPlayer");
                    }
                    Class<?> playerClass = genericClass;
                    EffectPlayer player = (EffectPlayer)playerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    player.load(plugin, effectValues, logger, logContext, parameterMap);
                    players.add(player);
                }
                catch (ClassNotFoundException unknown) {
                    if (logger == null) continue;
                    logger.warning("Unknown effect class in " + logContext + ": " + (String)effectClass);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (logger == null) continue;
                    logger.warning("Error creating effect class in " + logContext + ": " + (String)effectClass + " " + ex.getMessage());
                }
            }
        }
        return players;
    }

    public void load(Plugin plugin, ConfigurationSection configuration) {
        String visibilityType;
        String typeName;
        boolean enableCustomSounds;
        boolean enableVanillaSounds;
        String effectName;
        this.plugin = plugin;
        if (effectLib != null && configuration.contains("effectlib")) {
            this.effectLibConfig = ConfigurationUtils.getConfigurationSection(configuration, "effectlib");
            if (this.effectLibConfig == null) {
                Object rawConfig = configuration.get("effectlib");
                this.warn("Could not load effectlib node of type " + String.valueOf(rawConfig.getClass()));
            }
        } else {
            this.effectLibConfig = null;
        }
        Logger logger = this.getLogger();
        this.probability = configuration.getDouble("probability", 1.0);
        this.broadcastSound = configuration.getBoolean("sound_broadcast", true);
        this.useParticleOverride = configuration.getString("particle_override", null);
        this.useColorOverride = configuration.getString("color_override", null);
        this.radiusOverride = configuration.getString("radius_override", null);
        this.originOffset = ConfigurationUtils.getVector(configuration, "origin_offset", ConfigurationUtils.getVector(configuration, "offset", null, logger, this.logContext), logger, this.logContext);
        this.targetOffset = ConfigurationUtils.getVector(configuration, "target_offset", null, logger, this.logContext);
        this.originRelativeOffset = ConfigurationUtils.getVector(configuration, "relative_offset", null, logger, this.logContext);
        this.targetRelativeOffset = ConfigurationUtils.getVector(configuration, "relative_target_offset", null, logger, this.logContext);
        this.delayTicks = configuration.getInt("delay", this.delayTicks) * 20 / 1000;
        this.material1 = ConfigurationUtils.getMaterialAndData(configuration, "material");
        if (configuration.isBoolean("color") && !configuration.getBoolean("color")) {
            this.useColor = false;
        } else {
            this.color1 = ConfigurationUtils.getColor(configuration, "color", null);
            this.color2 = ConfigurationUtils.getColor(configuration, "color2", null);
            if (this.color2 == null) {
                this.color2 = ConfigurationUtils.getColor(configuration, "to_color", null);
            }
        }
        if (configuration.contains("effect")) {
            effectName = configuration.getString("effect");
            try {
                this.effect = Effect.valueOf((String)effectName.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.effect == null) {
                this.warn("Unknown effect type " + effectName);
            } else {
                this.effectData = ConfigurationUtils.getInteger(configuration, "effect_data", this.effectData);
            }
        }
        if (configuration.contains("entity_effect")) {
            effectName = configuration.getString("entity_effect");
            try {
                this.entityEffect = EntityEffect.valueOf((String)effectName.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.entityEffect == null) {
                this.warn("Unknown entity effect type " + effectName);
            }
        }
        if (configuration.contains("sound")) {
            this.sound = new SoundEffect(configuration.getString("sound"));
        } else if (configuration.contains("custom_sound")) {
            this.sound = new SoundEffect(configuration.getString("custom_sound"));
        }
        if (this.sound != null) {
            double volume = configuration.getDouble("sound_volume", (double)this.sound.getVolume());
            this.sound.setVolume((float)(volume *= VOLUME_SCALE));
            this.sound.setPitch((float)configuration.getDouble("sound_pitch", (double)this.sound.getPitch()));
            this.sound.setRange(configuration.getInt("sound_range", this.sound.getRange()));
        }
        if (!(enableVanillaSounds = configuration.getBoolean("enable_vanilla_sounds", ENABLE_VANILLA_SOUNDS)) && this.sound != null && !this.sound.isCustom()) {
            this.sound = null;
        }
        if (!(enableCustomSounds = configuration.getBoolean("enable_custom_sounds", ENABLE_CUSTOM_SOUNDS)) && this.sound != null && this.sound.isCustom()) {
            this.sound = null;
        }
        if (configuration.contains("firework") || configuration.contains("firework_power")) {
            this.hasFirework = true;
            this.fireworkType = null;
            if (configuration.contains("firework")) {
                typeName = configuration.getString("firework");
                try {
                    this.fireworkType = FireworkEffect.Type.valueOf((String)typeName.toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.fireworkType == null) {
                    this.warn("Unknown firework type " + typeName);
                }
            }
            this.fireworkPower = configuration.getInt("firework_power", this.fireworkPower);
            this.fireworkFlicker = ConfigurationUtils.getBoolean(configuration, "firework_flicker", this.fireworkFlicker);
            this.fireworkSilent = configuration.getBoolean("firework_silent", true);
        }
        if (configuration.contains("particle")) {
            typeName = configuration.getString("particle");
            this.particleType = CompatibilityLib.getCompatibilityUtils().getParticle(typeName);
            if (this.particleType == null) {
                this.warn("Unknown particle type " + typeName);
            } else {
                this.particleData = (float)configuration.getDouble("particle_data", (double)this.particleData);
                this.particleData = (float)configuration.getDouble("particle_speed", (double)this.particleData);
                Vector particleOffsetVector = ConfigurationUtils.getVector(configuration, "particle_offset");
                if (particleOffsetVector != null) {
                    this.particleXOffset = (float)particleOffsetVector.getX();
                    this.particleYOffset = (float)particleOffsetVector.getY();
                    this.particleZOffset = (float)particleOffsetVector.getZ();
                } else {
                    this.particleXOffset = (float)configuration.getDouble("particle_offset", (double)this.particleXOffset);
                    this.particleYOffset = (float)configuration.getDouble("particle_offset", (double)this.particleYOffset);
                    this.particleZOffset = (float)configuration.getDouble("particle_offset", (double)this.particleZOffset);
                }
                this.particleXOffset = (float)configuration.getDouble("particle_offset_x", (double)this.particleXOffset);
                this.particleYOffset = (float)configuration.getDouble("particle_offset_y", (double)this.particleYOffset);
                this.particleZOffset = (float)configuration.getDouble("particle_offset_z", (double)this.particleZOffset);
                this.particleCount = configuration.getInt("particle_count", this.particleCount);
                this.arrivalTime = configuration.getInt("particle_arrival_time", this.arrivalTime);
                this.particleSize = (float)configuration.getDouble("particle_size", (double)this.particleSize);
            }
        }
        if ((visibilityType = configuration.getString("visibility")) != null) {
            try {
                this.visibility = Visibility.valueOf(visibilityType.toUpperCase());
            }
            catch (Exception ex) {
                this.warn("Invalid visibility type: " + visibilityType);
            }
        }
        this.setLocationType(configuration.getString("location", "origin"));
        this.requireEntity = configuration.getBoolean("requires_entity", false);
        this.requireTargetEntity = configuration.getBoolean("requires_entity_target", false);
        this.noTargetEntity = configuration.getBoolean("requires_no_entity_target", false);
        this.sourceLocation = new SourceLocation(configuration);
        this.targetLocation = new SourceLocation(configuration, "target_location", false);
        this.sampleTarget = configuration.getString("sample", "").equalsIgnoreCase("target");
    }

    public void load(Plugin plugin, ConfigurationSection configuration, Logger logger, String logContext, ConfigurationSection parameterMap) {
        this.logContext = logContext;
        this.logger = logger;
        this.parameterMap = parameterMap;
        if (!(configuration instanceof TranslatingConfigurationSection)) {
            configuration = TranslatingConfigurationSection.getWrapped(configuration);
        }
        ((TranslatingConfigurationSection)((Object)configuration)).setParameterMap(parameterMap);
        this.load(plugin, (ConfigurationSection)configuration);
        ((TranslatingConfigurationSection)((Object)configuration)).setParameterMap(null);
    }

    public void setLocationType(String locationType) {
        this.originIsSelection = false;
        this.playAtAllTargets = false;
        this.playAtOrigin = false;
        this.playAtTarget = false;
        if (locationType.equals("target")) {
            this.playAtTarget = true;
        } else if (locationType.equals("origin") || locationType.equals("source")) {
            this.playAtOrigin = true;
        } else if (locationType.equals("both")) {
            this.playAtTarget = true;
            this.playAtOrigin = true;
        } else if (locationType.equals("targets")) {
            this.playAtTarget = true;
            this.playAtAllTargets = true;
        } else if (locationType.equals("selection") || locationType.equals("selection_to_origin")) {
            this.playAtTarget = true;
            this.targetIsSelection = true;
        } else if (locationType.equals("origin_to_selection") || locationType.equals("source_to_selection")) {
            this.playAtOrigin = true;
            this.targetIsSelection = true;
        } else if (locationType.equals("target_to_selection")) {
            this.playAtTarget = true;
            this.originIsSelection = true;
        } else if (locationType.equals("selection_to_target")) {
            this.playAtOrigin = true;
            this.originIsSelection = true;
        }
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Random rand = new Random();
        if (color1 == null) {
            color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (color2 == null) {
            color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    @Override
    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void setEntityEffect(EntityEffect entityEffect) {
        this.entityEffect = entityEffect;
    }

    public void setParticleType(Particle particleType) {
        this.particleType = particleType;
    }

    @Override
    public void setParticleOverride(String particleType) {
        if (particleType == null || particleType.isEmpty()) {
            this.particleOverride = null;
            return;
        }
        try {
            this.particleOverride = Particle.valueOf((String)particleType.toUpperCase());
        }
        catch (Exception ex) {
            this.warn("Error setting particle override: " + ex.getMessage());
            this.particleOverride = null;
        }
    }

    @Override
    public void setEffectData(int data) {
        this.effectData = data;
    }

    protected com.elmakers.mine.bukkit.block.MaterialAndData getWorkingMaterial() {
        Location target = this.getTarget();
        if (target != null && !CompatibilityLib.getCompatibilityUtils().isChunkLoaded(target)) {
            target = null;
        }
        if (this.sampleTarget && target != null) {
            return new com.elmakers.mine.bukkit.block.MaterialAndData(target.getBlock().getType(), target.getBlock().getData());
        }
        if (this.material1 != null) {
            return this.material1;
        }
        com.elmakers.mine.bukkit.block.MaterialAndData result = this.material;
        Location origin = this.getOrigin();
        if (result == null && target != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(target.getBlock().getType(), target.getBlock().getData());
        } else if (result == null && origin != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(origin.getBlock().getType(), origin.getBlock().getData());
        } else if (result == null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
        }
        return result;
    }

    protected void playEffect() {
        this.playEffect(this.getDynamicOrigin(), this.getDynamicTarget());
    }

    protected void playEffect(DynamicLocation origin, DynamicLocation target) {
        if (this.requireTargetEntity && (target == null || target.getEntity() == null)) {
            return;
        }
        if (this.noTargetEntity && target != null && target.getEntity() != null) {
            return;
        }
        if (this.probability < 1.0 && Math.random() > this.probability) {
            return;
        }
        if (this.playAtOrigin && origin != null) {
            this.performEffects(origin, target);
        }
        if (this.playAtTarget && target != null) {
            this.performEffects(target, origin);
        }
    }

    @Override
    public void validate() {
        if (effectLib != null && this.effectLibConfig != null) {
            ((TranslatingConfigurationSection)this.effectLibConfig).setParameterMap(this.parameterMap);
            effectLib.validate(this.effectLibConfig, this, null, null, this.parameterMap, this.logContext);
            ((TranslatingConfigurationSection)this.effectLibConfig).setParameterMap(null);
        }
    }

    public static void displayParticle(Particle particle, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount, float size, Color color, Material material, byte materialData, double range) {
        effectLib.displayParticle(particle, center, offsetX, offsetY, offsetZ, speed, amount, size, color, material, materialData, range);
    }

    public void displayParticle(Particle particle, ParticleOptions options, Location center, double range) {
        List<Player> targetPlayers = this.getObservers();
        if (targetPlayers == null) {
            Player targetPlayer = null;
            switch (this.getVisibility()) {
                case TARGET: {
                    if (this.target != null && this.target.getEntity() instanceof Player) {
                        targetPlayer = (Player)this.target.getEntity();
                    }
                    if (targetPlayer != null) break;
                    return;
                }
                case ORIGIN: {
                    if (this.origin != null && this.origin.getEntity() instanceof Player) {
                        targetPlayer = (Player)this.origin.getEntity();
                    }
                    if (targetPlayer != null) break;
                    return;
                }
            }
            if (targetPlayer != null) {
                targetPlayers = new ArrayList<Player>();
                targetPlayers.add(targetPlayer);
            }
        }
        effectLib.displayParticle(particle, options, center, range, targetPlayers);
    }

    public Particle overrideParticle(Particle particle) {
        return this.useParticleOverride != null && !this.useParticleOverride.isEmpty() && this.particleOverride != null ? this.particleOverride : particle;
    }

    public String getParticleOverrideName() {
        return this.useParticleOverride;
    }

    public String getColorOverrideName() {
        return this.useColorOverride;
    }

    public String getRadiusOverrideName() {
        return this.radiusOverride;
    }

    public double getDistance(Location location1, Location location2) {
        if (location1 == null || location2 == null) {
            return 0.0;
        }
        if (!location1.getWorld().equals((Object)location2.getWorld())) {
            location1 = location1.clone();
            location1.setWorld(location2.getWorld());
        }
        return location1.distance(location2);
    }

    public double getRadius() {
        if (this.targetIsSelection || this.originIsSelection) {
            if (this.selection == null) {
                return 0.0;
            }
            if (this.originIsSelection) {
                if (this.target == null) {
                    return 0.0;
                }
                return this.getDistance(this.selection.getLocation(), this.target.getLocation());
            }
            if (this.origin == null) {
                return 0.0;
            }
            return this.getDistance(this.selection.getLocation(), this.origin.getLocation());
        }
        if (this.origin == null || this.target == null) {
            return 0.0;
        }
        return this.getDistance(this.origin.getLocation(), this.target.getLocation());
    }

    public void setParticleData(float effectData) {
        this.particleData = effectData;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    public void setParticleOffset(float xOffset, float yOffset, float zOffset) {
        this.particleXOffset = xOffset;
        this.particleYOffset = yOffset;
        this.particleZOffset = zOffset;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void setSound(Sound sound) {
        this.sound = new SoundEffect(sound);
    }

    @Override
    public void setSound(Sound sound, float volume, float pitch) {
        this.sound = new SoundEffect(sound);
        this.sound.setVolume(volume);
        this.sound.setPitch(pitch);
    }

    @Override
    public void setDelayTicks(int ticks) {
        this.delayTicks = ticks;
    }

    @Override
    public void start(Entity originEntity, Entity targetEntity) {
        this.startEffects(new DynamicLocation(originEntity), new DynamicLocation(targetEntity));
    }

    @Override
    public void start(Location origin, Entity originEntity, Location target, Entity targetEntity) {
        this.startEffects(new DynamicLocation(origin, originEntity), new DynamicLocation(target, targetEntity));
    }

    @Override
    public void start(Location origin, Entity originEntity, Location target, Entity targetEntity, Collection<Entity> targets) {
        if (this.playsAtAllTargets()) {
            this.start(origin, originEntity, targets);
        } else {
            this.start(origin, originEntity, target, targetEntity);
        }
    }

    public void start(Location origin, Entity originEntity, Collection<Entity> targets) {
        if (targets == null || targets.size() == 0) {
            return;
        }
        DynamicLocation source = new DynamicLocation(origin, originEntity);
        for (Entity targetEntity : targets) {
            if (targetEntity == null) continue;
            DynamicLocation target = new DynamicLocation(targetEntity);
            this.startEffects(source, target);
        }
    }

    @Override
    public void start(Location origin, Location target) {
        this.startEffects(new DynamicLocation(origin), new DynamicLocation(target));
    }

    @Override
    public void start(EffectContext context) {
        context.trackEffects(this);
        Location source = this.getSourceLocation(context);
        Location target = this.getSourceLocation(context);
        this.setColor(context.getEffectColor());
        this.setParticleOverride(context.getEffectParticle());
        this.start(source, context.getEntity(), target, context.getTargetEntity());
    }

    public void startEffects(DynamicLocation origin, DynamicLocation target) {
        Location originLocation;
        Location targetLocation = target == null ? null : target.getLocation();
        Location location = originLocation = origin == null ? null : origin.getLocation();
        if (targetLocation != null && originLocation != null && !originLocation.getWorld().equals((Object)targetLocation.getWorld())) {
            targetLocation.setWorld(originLocation.getWorld());
        }
        this.origin = origin == null || origin.getLocation() == null ? null : origin;
        DynamicLocation dynamicLocation = this.target = target == null || target.getLocation() == null ? null : target;
        if (this.originRelativeOffset != null && this.origin != null) {
            this.origin.addRelativeOffset(this.originRelativeOffset);
        }
        if (this.targetRelativeOffset != null && this.target != null) {
            this.target.addRelativeOffset(this.targetRelativeOffset);
        }
        this.fireworkEffect = this.hasFirework ? this.getFireworkEffect(this.getColor1(), this.getColor2(), this.fireworkType, this.fireworkFlicker, false) : null;
        if (this.delayTicks > 0 && this.plugin != null) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, (Runnable)new PlayEffectTask(this), (long)this.delayTicks);
        } else {
            this.startPlay();
        }
    }

    protected void checkLocations() {
        if (this.origin != null && this.originOffset != null) {
            this.origin.addOffset(this.originOffset);
        }
        if (this.target != null && this.targetOffset != null) {
            this.target.addOffset(this.targetOffset);
        }
    }

    public void startPlay() {
        this.checkLocations();
        this.play();
    }

    protected Vector getDirection() {
        Location origin = this.getOrigin();
        Location target = this.getTarget();
        if (origin == null) {
            return new Vector(0, 1, 0);
        }
        Vector direction = target == null ? origin.getDirection() : target.toVector().subtract(origin.toVector());
        return direction.normalize();
    }

    @Override
    public void setMaterial(MaterialAndData material) {
        this.material = material == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(material);
    }

    @Override
    public void setMaterial(Block block) {
        this.material = block == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(block);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Nullable
    public Color getColor1() {
        return this.useColor ? (this.color1 != null ? this.color1 : this.color) : null;
    }

    @Nullable
    public Color getColor2() {
        return this.useColor ? (this.color2 != null ? this.color2 : this.color) : null;
    }

    public abstract void play();

    @Nullable
    public Location getOrigin() {
        DynamicLocation origin = this.getDynamicOrigin();
        return origin == null ? null : origin.getLocation();
    }

    @Nullable
    public Location getTarget() {
        DynamicLocation target = this.getDynamicTarget();
        return target == null ? null : target.getLocation();
    }

    public DynamicLocation getDynamicTarget() {
        if (this.targetIsSelection) {
            return this.selection;
        }
        return this.target;
    }

    public DynamicLocation getDynamicOrigin() {
        if (this.originIsSelection) {
            return this.selection;
        }
        return this.origin;
    }

    @Nullable
    public Location getSelection() {
        return this.selection == null ? null : this.selection.getLocation();
    }

    public void setOrigin(Location location) {
        if (location == null) {
            this.origin = null;
            return;
        }
        if (this.origin == null) {
            this.origin = new DynamicLocation(location);
        } else {
            Location originLocation = this.origin.getLocation();
            originLocation.setX(location.getX());
            originLocation.setY(location.getY());
            originLocation.setZ(location.getZ());
        }
    }

    public void setTarget(Location location) {
        if (location == null) {
            this.target = null;
            return;
        }
        if (this.target == null) {
            this.target = new DynamicLocation(location);
        } else {
            Location targetLocation = this.target.getLocation();
            targetLocation.setX(location.getX());
            targetLocation.setY(location.getY());
            targetLocation.setZ(location.getZ());
        }
    }

    @Override
    public void setSelection(Location location) {
        if (location == null) {
            this.selection = null;
            return;
        }
        this.selection = new DynamicLocation(location);
    }

    @Nullable
    public Entity getOriginEntity() {
        return this.origin == null ? null : this.origin.getEntity();
    }

    @Nullable
    public Entity getTargetEntity() {
        return this.target == null ? null : this.target.getEntity();
    }

    @Override
    public void cancel() {
        if (this.currentEffects != null) {
            Iterator<EffectPlay> iterator = this.currentEffects.iterator();
            while (iterator.hasNext()) {
                EffectPlay play = iterator.next();
                if (!play.isPlayer(this)) continue;
                play.cancel();
                iterator.remove();
            }
        }
    }

    protected void performEffects(DynamicLocation source, DynamicLocation target) {
        Material material;
        Entity sourceEntity;
        Location sourceLocation;
        Location location = sourceLocation = source == null ? null : source.getLocation();
        if (sourceLocation == null) {
            return;
        }
        Entity entity = sourceEntity = source == null ? null : source.getEntity();
        if (this.requireEntity && sourceEntity == null) {
            return;
        }
        List<Player> observers = this.getObservers();
        if (effectLib != null && this.effectLibConfig != null) {
            EffectLibPlay play = effectLib.play(this.effectLibConfig, this, source, target, this.parameterMap, this.logContext, observers);
            if (this.currentEffects != null && play != null) {
                play.setPlayer(this);
                this.currentEffects.add(play);
            }
        }
        if (this.effect != null) {
            int data;
            int n = data = this.effectData == null ? 0 : this.effectData;
            if (this.effect == Effect.STEP_SOUND && this.effectData == null) {
                material = this.getWorkingMaterial().getMaterial();
                if (!material.isSolid()) {
                    return;
                }
                sourceLocation.getWorld().playEffect(sourceLocation, this.effect, (Object)material);
            } else {
                sourceLocation.getWorld().playEffect(sourceLocation, this.effect, data);
            }
        }
        if (this.entityEffect != null && sourceEntity != null) {
            sourceEntity.playEffect(this.entityEffect);
        }
        if (this.sound != null) {
            if (observers != null) {
                this.sound.play(this.plugin, this.getLogger(), sourceLocation, observers);
            } else if (this.broadcastSound) {
                this.sound.play(this.plugin, this.getLogger(), sourceLocation);
            } else if (sourceEntity != null) {
                this.sound.play(this.plugin, this.getLogger(), sourceEntity);
            }
        }
        if (this.fireworkEffect != null) {
            EffectUtils.spawnFireworkEffect(this.plugin.getServer(), sourceLocation, this.fireworkEffect, this.fireworkPower, this.fireworkSilent);
        }
        if (this.particleType != null) {
            Particle useEffect = this.overrideParticle(this.particleType);
            material = this.getWorkingMaterial().getMaterial();
            Short data = this.getWorkingMaterial().getData();
            ParticleOptions options = new ParticleOptions(this.particleXOffset, this.particleYOffset, this.particleZOffset, this.particleData, this.particleCount, this.particleSize, this.getColor1(), this.getColor2(), this.arrivalTime, material, data == null ? (byte)0 : (byte)data.shortValue());
            options.target = target;
            this.displayParticle(useEffect, options, sourceLocation, PARTICLE_RANGE);
        }
    }

    @Override
    public void setEffectPlayList(Collection<EffectPlay> plays) {
        this.currentEffects = plays;
    }

    @Override
    @Nullable
    public Location getSourceLocation(@Nonnull EffectContext context) {
        return this.sourceLocation.getLocation(context);
    }

    @Override
    @Nullable
    public Location getTargetLocation(@Nonnull EffectContext context) {
        return this.targetLocation.getLocation(context);
    }

    @Override
    @Deprecated
    public void setParameterMap(Map<String, String> map) {
        this.parameterMap = ConfigurationUtils.toStringConfiguration(map);
    }

    @Override
    public void setParameterMap(ConfigurationSection map) {
        this.parameterMap = map;
    }

    @Override
    public boolean playsAtOrigin() {
        return this.playAtOrigin;
    }

    @Override
    public boolean playsAtTarget() {
        return this.playAtTarget;
    }

    @Override
    public boolean playsAtAllTargets() {
        return this.playAtAllTargets;
    }

    @Override
    public boolean originIsSelection() {
        return this.originIsSelection;
    }

    @Override
    public boolean targetIsSelection() {
        return this.targetIsSelection;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    @Deprecated
    public boolean shouldUseBlockLocation() {
        return this.targetLocation.shouldUseBlockLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseHitLocation() {
        return this.targetLocation.shouldUseHitLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseWandLocation() {
        return this.sourceLocation.shouldUseWandLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseCastLocation() {
        return this.sourceLocation.shouldUseCastLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseEyeLocation() {
        return this.sourceLocation.shouldUseEyeLocation();
    }

    @Override
    public void setObserverIds(Collection<UUID> players) {
        this.observers = players;
    }

    public List<Player> getObservers() {
        ArrayList<Player> players = null;
        if (this.observers != null) {
            players = new ArrayList<Player>();
            for (UUID uuid : this.observers) {
                Player player = this.plugin.getServer().getPlayer(uuid);
                if (player == null) continue;
                players.add(player);
            }
        }
        return players;
    }
}

