/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.block.BlockBanner;
import com.elmakers.mine.bukkit.block.BlockCommand;
import com.elmakers.mine.bukkit.block.BlockMobSpawner;
import com.elmakers.mine.bukkit.block.BlockSkull;
import com.elmakers.mine.bukkit.block.BlockTileEntity;
import com.elmakers.mine.bukkit.block.ColoredData;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.EnchantmentData;
import com.elmakers.mine.bukkit.block.LeatherArmorData;
import com.elmakers.mine.bukkit.block.MaterialExtraData;
import com.elmakers.mine.bukkit.block.PotionData;
import com.elmakers.mine.bukkit.block.WrittenBookData;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SkullLoadedCallback;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.elmakers.mine.bukkit.utility.WordUtils;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;

public class MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialAndData {
    protected static Gson gson;
    protected Material material;
    protected Short data;
    protected int customModelData;
    protected MaterialExtraData extraData;
    protected String blockData;
    protected boolean isValid = true;
    protected boolean isTargetValid = true;
    public static final Material DEFAULT_MATERIAL;

    public MaterialAndData() {
        this.material = DEFAULT_MATERIAL;
        this.data = 0;
    }

    public MaterialAndData(Material material) {
        this.material = material;
        this.data = 0;
    }

    public MaterialAndData(Material material, String blockData) {
        this.material = material;
        this.blockData = blockData;
    }

    public MaterialAndData(Material material, short data) {
        this(material, (Short)data);
    }

    public MaterialAndData(Material material, Short data) {
        this.material = material;
        this.data = data;
    }

    public MaterialAndData(ItemStack item) {
        EnchantmentStorageMeta enchantStorage;
        Map enchants;
        ItemMeta meta;
        this.material = item.getType();
        this.data = CompatibilityLib.getDeprecatedUtils().getItemDamage(item);
        if (DefaultMaterials.isPlayerSkull(this)) {
            SkullMeta skullMeta;
            PlayerProfile profile;
            ItemMeta meta2 = item.getItemMeta();
            if (meta2 instanceof SkullMeta && (profile = (skullMeta = (SkullMeta)meta2).getOwnerProfile()) != null) {
                this.extraData = new BlockSkull(profile);
            }
        } else if (DefaultMaterials.isBanner(this.material)) {
            ItemMeta meta3 = item.getItemMeta();
            if (meta3 != null && meta3 instanceof BannerMeta) {
                BannerMeta banner = (BannerMeta)meta3;
                this.extraData = new BlockBanner(banner.getPatterns());
            }
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS || this.material.name().equals("LEATHER_HORSE_ARMOR")) {
            ItemMeta meta4 = item.getItemMeta();
            if (meta4 != null && meta4 instanceof LeatherArmorMeta) {
                this.extraData = new LeatherArmorData(((LeatherArmorMeta)meta4).getColor());
            }
        } else if (this.material == Material.POTION || this.material == Material.TIPPED_ARROW) {
            ItemMeta meta5 = item.getItemMeta();
            if (meta5 != null && meta5 instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta5;
                Color color = CompatibilityLib.getCompatibilityUtils().getColor(potionMeta);
                this.extraData = new PotionData(color, potionMeta.getCustomEffects());
            }
        } else if (this.material == DefaultMaterials.getFireworkStar()) {
            FireworkEffect effect;
            ItemMeta meta6 = item.getItemMeta();
            if (meta6 != null && meta6 instanceof FireworkEffectMeta && (effect = ((FireworkEffectMeta)meta6).getEffect()) != null && !effect.getColors().isEmpty()) {
                this.extraData = new ColoredData((Color)effect.getColors().get(0));
            }
        } else if (this.material == Material.WRITTEN_BOOK) {
            ItemMeta meta7 = item.getItemMeta();
            if (meta7 != null && meta7 instanceof BookMeta) {
                this.extraData = new WrittenBookData((BookMeta)meta7);
            }
        } else if (this.material == Material.ENCHANTED_BOOK && (meta = item.getItemMeta()) != null && meta instanceof EnchantmentStorageMeta && (enchants = (enchantStorage = (EnchantmentStorageMeta)meta).getStoredEnchants()) != null && !enchants.isEmpty()) {
            this.extraData = new EnchantmentData(enchants);
        }
        if (item.hasItemMeta()) {
            item = CompatibilityLib.getItemUtils().makeReal(item);
            this.customModelData = CompatibilityLib.getItemUtils().getCustomModelData(item);
        }
    }

    public MaterialAndData(Block block) {
        this.updateFrom(block);
    }

    public MaterialAndData(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.updateFrom(other);
    }

    public MaterialAndData(String materialKey) {
        this();
        this.update(materialKey);
    }

    public void copyTo(MaterialAndData other) {
        other.material = this.material;
        other.data = this.data;
        other.customModelData = this.customModelData;
        other.extraData = this.extraData;
        other.blockData = this.blockData;
        other.isValid = this.isValid;
        other.isTargetValid = this.isTargetValid;
    }

    private static Gson getGson() {
        if (gson == null) {
            gson = new Gson();
        }
        return gson;
    }

    public void update(String materialKey) {
        Material material;
        Short data;
        MaterialExtraData extraData;
        String blockData;
        block76: {
            String[] pieces;
            block75: {
                MaterialAndData skullData;
                if (materialKey == null || ((String)materialKey).length() == 0) {
                    this.isValid = false;
                    return;
                }
                String originalKey = materialKey;
                blockData = null;
                String[] blockPieces = StringUtils.split((String)materialKey, "?");
                if (blockPieces.length > 1) {
                    materialKey = blockPieces[0];
                    blockData = blockPieces[1];
                }
                extraData = null;
                int jsonStart = ((String)materialKey).indexOf(123);
                if (jsonStart > 0) {
                    String fullKey = materialKey;
                    materialKey = fullKey.substring(0, jsonStart);
                    String json = fullKey.substring(jsonStart);
                    int jsonEnd = json.lastIndexOf(125);
                    if (jsonEnd != json.length() - 1) {
                        materialKey = (String)materialKey + json.substring(jsonEnd + 1);
                        json = json.substring(0, jsonEnd + 1);
                    }
                    if (!json.contains(":")) {
                        try {
                            this.customModelData = Integer.parseInt(json.substring(1, json.length() - 1));
                        }
                        catch (Exception ex) {
                            Bukkit.getLogger().warning("[Magic] Error parsing item custom model data: " + json + " : " + ex.getMessage());
                        }
                    } else {
                        try {
                            JsonReader reader = new JsonReader((Reader)new StringReader(json));
                            reader.setLenient(true);
                            Map tags = (Map)MaterialAndData.getGson().fromJson(reader, Map.class);
                            CompatibilityLib.getNBTUtils().convertIntegers(tags);
                            block39: for (Map.Entry entry : tags.entrySet()) {
                                String key = (String)entry.getKey();
                                Object value = entry.getValue();
                                switch (key) {
                                    case "custom_model_data": 
                                    case "CustomModelData": {
                                        if (value instanceof Integer) {
                                            this.customModelData = (Integer)value;
                                            continue block39;
                                        }
                                        Bukkit.getLogger().info("[Magic] [" + originalKey + "] Unsupported CustomModelData value: " + String.valueOf(value));
                                        continue block39;
                                    }
                                    case "Potion": {
                                        try {
                                            PotionEffectType effectType = PotionEffectType.getByName((String)value.toString().toUpperCase());
                                            PotionEffect effect = new PotionEffect(effectType, 1200, 0);
                                            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                                            effects.add(effect);
                                            extraData = new PotionData(null, effects);
                                        }
                                        catch (Exception ignore) {
                                            Bukkit.getLogger().info("[Magic] [" + originalKey + "] Error parsing potion effect data: " + String.valueOf(value));
                                        }
                                        continue block39;
                                    }
                                    case "Color": {
                                        ColorHD color = new ColorHD(value.toString());
                                        extraData = new ColoredData(color.getColor());
                                        continue block39;
                                    }
                                }
                                Bukkit.getLogger().info("[Magic] [" + originalKey + "] Custom NBT tags on items are no longer supported. Unknown tag key: " + key);
                            }
                        }
                        catch (Throwable ex) {
                            Bukkit.getLogger().warning("[Magic] Error parsing item json: " + json + " : " + ex.getMessage());
                        }
                    }
                }
                pieces = MaterialAndData.splitMaterialKey((String)materialKey);
                data = 0;
                material = null;
                materialKey = pieces[0];
                if ((((String)materialKey).equalsIgnoreCase("skull") || ((String)materialKey).equalsIgnoreCase("skull_item")) && (skullData = DefaultMaterials.getPlayerSkullItem()) != null) {
                    material = skullData.material;
                    data = skullData.data;
                }
                if (material == null) {
                    try {
                        if (pieces.length <= 0 || ((String)materialKey).equals("*")) break block75;
                        try {
                            Integer id = Integer.parseInt((String)materialKey);
                            material = CompatibilityLib.getCompatibilityUtils().getMaterial(id);
                        }
                        catch (Exception ex) {
                            materialKey = ((String)materialKey).toUpperCase();
                            material = Material.getMaterial((String)materialKey);
                            if (material != null) break block75;
                            byte legacyData = 0;
                            if (pieces.length > 1) {
                                try {
                                    legacyData = Byte.parseByte(pieces[1]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (legacyData > 0 && (material = Material.getMaterial((String)("LEGACY_" + ((String)materialKey).toUpperCase()))) != null && (material = CompatibilityLib.getCompatibilityUtils().migrateMaterial(material, legacyData)).getMaxDurability() == 0) {
                                pieces = Arrays.copyOfRange(pieces, 0, 1);
                            }
                            if (material == null) {
                                material = CompatibilityLib.getCompatibilityUtils().getLegacyMaterial((String)materialKey);
                            }
                        }
                    }
                    catch (Exception ex) {
                        material = null;
                    }
                }
            }
            try {
                ItemMeta colorPieces;
                if (pieces.length <= 1) break block76;
                String dataString = pieces[1];
                if (dataString.equals("*")) {
                    data = null;
                    break block76;
                }
                if (DefaultMaterials.isMobSpawner(material)) {
                    extraData = new BlockMobSpawner(dataString);
                    break block76;
                }
                if (DefaultMaterials.isSkull(material)) {
                    if (dataString.contains(":")) {
                        SkullMeta skullMeta;
                        PlayerProfile playerProfile;
                        data = 3;
                        this.material = material;
                        this.data = data;
                        ItemStack item = this.getItemStack(1);
                        item = CompatibilityLib.getInventoryUtils().setSkullURL(item, dataString);
                        ItemMeta itemMeta = item.getItemMeta();
                        if (itemMeta instanceof SkullMeta && (playerProfile = (skullMeta = (SkullMeta)itemMeta).getOwnerProfile()) != null) {
                            extraData = new BlockSkull(playerProfile);
                        }
                    } else {
                        try {
                            data = Short.parseShort(dataString);
                        }
                        catch (Exception ex) {
                            data = 3;
                            extraData = new BlockSkull(dataString);
                        }
                    }
                    break block76;
                }
                if (material == Material.LEATHER_BOOTS || material == Material.LEATHER_CHESTPLATE || material == Material.LEATHER_HELMET || material == Material.LEATHER_LEGGINGS || material.name().equals("LEATHER_HORSE_ARMOR")) {
                    for (String piece : colorPieces = StringUtils.split(dataString, ',')) {
                        if (piece.startsWith("#")) {
                            Color color = ConfigurationUtils.toColor(piece);
                            if (color == null) continue;
                            extraData = new LeatherArmorData(color);
                            continue;
                        }
                        try {
                            data = Short.parseShort(dataString);
                        }
                        catch (Exception ex) {
                            data = 0;
                        }
                    }
                    break block76;
                }
                if (material == Material.POTION || material == Material.TIPPED_ARROW) {
                    colorPieces = StringUtils.split(dataString, ',');
                    Color color = Color.WHITE;
                    ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                    PotionEffectType effectType = null;
                    Integer amplifier = null;
                    Integer duration = null;
                    for (ItemMeta piece : colorPieces) {
                        if (piece.startsWith("#")) {
                            color = ConfigurationUtils.toColor(piece);
                            continue;
                        }
                        if (effectType == null) {
                            try {
                                effectType = PotionEffectType.getByName((String)piece.toUpperCase());
                            }
                            catch (Exception ignore) {
                                effectType = null;
                            }
                            continue;
                        }
                        if (duration == null) {
                            try {
                                duration = Integer.parseInt((String)piece) / 50;
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (amplifier != null) continue;
                        try {
                            amplifier = Integer.parseInt((String)piece);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (effectType != null) {
                        effects.add(new PotionEffect(effectType, duration == null ? 1200 : duration, amplifier == null ? 0 : amplifier));
                    }
                    extraData = new PotionData(color, effects);
                    break block76;
                }
                if (material == DefaultMaterials.getFireworkStar()) {
                    Color color = ConfigurationUtils.toColor(dataString);
                    extraData = new ColoredData(color);
                    break block76;
                }
                if (material == Material.ENCHANTED_BOOK) {
                    String[] list;
                    HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
                    for (String enchantKey : list = StringUtils.split(dataString, ",")) {
                        Enchantment enchantment;
                        int level = 1;
                        String[] enchantPieces = StringUtils.split(enchantKey, ":");
                        if (enchantPieces.length > 1) {
                            try {
                                enchantKey = enchantPieces[0];
                                level = Integer.parseInt(enchantPieces[1]);
                            }
                            catch (Exception ex) {
                                level = 1;
                            }
                        }
                        if ((enchantment = CompatibilityLib.getCompatibilityUtils().getEnchantmentByKey(enchantKey)) == null) continue;
                        enchants.put(enchantment, level);
                    }
                    if (!enchants.isEmpty()) {
                        extraData = new EnchantmentData(enchants);
                    }
                    break block76;
                }
                try {
                    data = Short.parseShort(dataString);
                }
                catch (Exception ex) {
                    data = 0;
                }
            }
            catch (Exception ex) {
                material = null;
            }
        }
        if (material == null) {
            this.setMaterial(null, null);
            this.isValid = false;
        } else {
            this.setMaterial(material, data);
        }
        if (this.isValid) {
            this.extraData = extraData;
            this.blockData = blockData;
        }
    }

    public int hashCode() {
        return (this.material == null ? -1 : this.material.ordinal() << 16) | (this.data == null ? -1 : (int)this.data.shortValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof com.elmakers.mine.bukkit.api.block.MaterialAndData)) {
            return false;
        }
        com.elmakers.mine.bukkit.api.block.MaterialAndData other = (com.elmakers.mine.bukkit.api.block.MaterialAndData)obj;
        return Objects.equal((Object)other.getData(), (Object)this.data) && other.getMaterial() == this.material && this.customModelData == other.getCustomModelData();
    }

    @Override
    public void updateFrom(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.material = other.getMaterial();
        this.data = other.getData();
        if (other instanceof MaterialAndData) {
            MaterialAndData o = (MaterialAndData)other;
            this.extraData = o.extraData != null ? o.extraData.clone() : null;
            this.blockData = o.blockData;
            this.isValid = o.isValid;
            this.isTargetValid = o.isTargetValid;
            this.customModelData = o.customModelData;
        }
    }

    @Override
    public void updateFrom(Block block) {
        this.updateFromBlock(block, null);
    }

    @Override
    public void setMaterial(Material material, short data) {
        this.setMaterial(material, (Short)data);
    }

    public void setMaterial(Material material, Short data) {
        this.material = material;
        this.data = data;
        this.extraData = null;
        this.blockData = null;
        if (material != null && CompatibilityLib.isLegacy(material)) {
            short convertData = this.data == null ? (short)0 : this.data;
            this.material = material = CompatibilityLib.getCompatibilityUtils().migrateMaterial(material, (byte)convertData);
        } else if (material != null && data != null && CompatibilityLib.hasLegacyMaterials() && material.getMaxDurability() == 0) {
            this.data = 0;
        }
        this.isValid = material != null;
        this.isTargetValid = true;
    }

    @Override
    public void setMaterial(Material material) {
        this.setMaterial(material, (short)0);
    }

    public void setMaterialId(int id) {
        this.material = CompatibilityLib.getCompatibilityUtils().getMaterial(id);
    }

    public void updateFromBlock(Block block, @Nullable MaterialSet restrictedMaterials) {
        Material blockMaterial;
        if (block == null) {
            this.isValid = false;
            return;
        }
        if (!CompatibilityLib.getCompatibilityUtils().checkChunk(block.getLocation())) {
            return;
        }
        if (restrictedMaterials != null && restrictedMaterials.testBlock(block)) {
            this.isValid = false;
            return;
        }
        this.extraData = null;
        this.material = blockMaterial = block.getType();
        this.data = block.getData();
        try {
            BlockState blockState = block.getState();
            if (this.material == Material.FLOWER_POT || blockState instanceof InventoryHolder || blockState instanceof Sign || blockState instanceof Jukebox) {
                this.extraData = new BlockTileEntity(CompatibilityLib.getCompatibilityUtils().getTileEntityData(block.getLocation()));
            } else if (blockState instanceof CommandBlock) {
                CommandBlock command = (CommandBlock)blockState;
                this.extraData = new BlockCommand(command.getCommand(), command.getName());
            } else if (blockState instanceof Skull) {
                Skull skull = (Skull)blockState;
                this.data = CompatibilityLib.getDeprecatedUtils().getSkullType(skull);
                PlayerProfile playerProfile = skull.getOwnerProfile();
                this.extraData = new BlockSkull(playerProfile, skull.getRotation());
            } else if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                this.extraData = new BlockMobSpawner(spawner.getCreatureTypeName());
            } else if (DefaultMaterials.isBanner(blockMaterial) && blockState != null && blockState instanceof Banner) {
                Banner banner = (Banner)blockState;
                this.extraData = new BlockBanner(banner.getPatterns());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.blockData = CompatibilityLib.getCompatibilityUtils().getBlockData(block);
        if (this.blockData != null) {
            this.data = 0;
            if (!this.blockData.contains("[")) {
                this.blockData = null;
            }
        }
        this.isValid = true;
        this.isTargetValid = true;
    }

    public static boolean shouldClearItemsIn(@Nonnull BlockState block) {
        return block instanceof InventoryHolder || block instanceof Jukebox || block.getType() == Material.FLOWER_POT;
    }

    public static void clearItems(BlockState block) {
        if (block != null && MaterialAndData.shouldClearItemsIn(block)) {
            CompatibilityLib.getCompatibilityUtils().clearItems(block.getLocation());
        }
    }

    public void modifyFast(Block block) {
        short data;
        Material material = this.material == null ? block.getType() : this.material;
        short s = data = this.data == null ? block.getData() : this.data.shortValue();
        if (material != block.getType() || data != block.getData()) {
            CompatibilityLib.getCompatibilityUtils().setBlockFast(block, material, data);
        }
    }

    @Override
    public void modify(Block block) {
        this.modify(block, false);
    }

    @Override
    public void modify(Block block, ModifyType modifyType) {
        switch (modifyType) {
            case FAST: {
                this.modifyFast(block);
                break;
            }
            case NORMAL: {
                this.modify(block, true);
                break;
            }
            case NO_PHYSICS: {
                this.modify(block, false);
            }
        }
    }

    @Override
    public void modify(Block block, boolean applyPhysics) {
        if (!this.isValid || !this.isTargetValid) {
            return;
        }
        try {
            BlockState blockState = block.getState();
            if (this.material != null) {
                Material currentMaterial = block.getType();
                byte blockData = this.data != null ? (byte)this.data.shortValue() : block.getData();
                Object extendedBlockData = this.blockData;
                if (this.data == null && extendedBlockData == null) {
                    extendedBlockData = CompatibilityLib.getCompatibilityUtils().getBlockData(block);
                }
                MaterialAndData.clearItems(blockState);
                CompatibilityLib.getDeprecatedUtils().setTypeAndData(block, this.material, blockData, applyPhysics);
                if (extendedBlockData != null) {
                    String currentBlockData;
                    if (currentMaterial != this.material && (currentBlockData = CompatibilityLib.getCompatibilityUtils().getBlockData(block)) != null) {
                        String[] currentData = StringUtils.split(currentBlockData, "[", 2);
                        String[] newData = StringUtils.split((String)extendedBlockData, "[", 2);
                        if (newData.length > 1) {
                            extendedBlockData = currentData[0] + "[" + newData[1];
                        }
                    }
                    CompatibilityLib.getCompatibilityUtils().setBlockData(block, (String)extendedBlockData);
                }
                blockState = block.getState();
            }
            if (blockState != null && blockState instanceof CommandBlock && this.extraData != null && this.extraData instanceof BlockCommand) {
                CommandBlock command = (CommandBlock)blockState;
                BlockCommand commandData = (BlockCommand)this.extraData;
                command.setCommand(commandData.command);
                if (commandData.customName != null) {
                    command.setName(commandData.customName);
                }
                command.update();
            } else if (this.extraData != null && this.extraData instanceof BlockTileEntity) {
                if (this.allowContainers() || this.material != Material.FLOWER_POT && !(blockState instanceof InventoryHolder)) {
                    CompatibilityLib.getCompatibilityUtils().setTileEntityData(block.getLocation(), ((BlockTileEntity)this.extraData).data);
                }
            } else if (blockState != null && DefaultMaterials.isBanner(this.material) && this.extraData != null && this.extraData instanceof BlockBanner) {
                if (blockState instanceof Banner) {
                    BlockBanner bannerData = (BlockBanner)this.extraData;
                    Banner banner = (Banner)blockState;
                    if (bannerData.patterns != null) {
                        banner.setPatterns(bannerData.patterns);
                    }
                }
                blockState.update(true, false);
            } else if (blockState != null && blockState instanceof Skull && this.extraData != null && this.extraData instanceof BlockSkull) {
                BlockFace rotation;
                Skull skull = (Skull)blockState;
                BlockSkull skullData = (BlockSkull)this.extraData;
                if (this.data != null && this.data != 0) {
                    CompatibilityLib.getDeprecatedUtils().setSkullType(skull, this.data);
                }
                if ((rotation = skullData.getRotation()) != null && rotation != BlockFace.SELF) {
                    skull.setRotation(rotation);
                }
                PlayerProfile profile = skullData.getProfile();
                String playerName = skullData.getPlayerName();
                if (profile != null) {
                    skull.setOwnerProfile(profile);
                    skull.update(true, false);
                } else if (playerName != null) {
                    CompatibilityLib.getDeprecatedUtils().setOwner(skull, playerName);
                }
            } else if (blockState != null && blockState instanceof CreatureSpawner && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
                BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
                if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setCreatureTypeByName(spawnerData.mobName);
                    spawner.update();
                }
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("[Magic] Error updating block state");
            ex.printStackTrace();
        }
    }

    @Override
    public Short getData() {
        return this.data;
    }

    @Override
    @Nullable
    public Byte getBlockData() {
        return this.data == null ? null : Byte.valueOf((byte)this.data.shortValue());
    }

    @Override
    @Nullable
    public String getModernBlockData() {
        return this.blockData;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getKey() {
        return this.getKey(this.data);
    }

    public String getKey(Short data) {
        Object materialKey;
        Object object = materialKey = this.material == null ? "*" : this.material.name().toLowerCase();
        if (data == null) {
            materialKey = (String)materialKey + ":*";
        } else if (DefaultMaterials.isPlayerSkull(this) && this.extraData != null && this.extraData instanceof BlockSkull) {
            BlockSkull skullData = (BlockSkull)this.extraData;
            String playerName = skullData.getPlayerName();
            if (playerName != null) {
                materialKey = (String)materialKey + ":" + playerName;
            } else {
                URL skinURL;
                PlayerProfile profile = skullData.getProfile();
                URL uRL = skinURL = profile == null ? null : profile.getTextures().getSkin();
                if (skinURL != null) {
                    materialKey = (String)materialKey + ":" + skinURL.toString();
                }
            }
        } else if (DefaultMaterials.isMobSpawner(this.material) && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
            BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
            if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                materialKey = (String)materialKey + ":" + spawnerData.mobName;
            }
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS || this.material.name().equals("LEATHER_HORSE_ARMOR")) {
            if (data != 0) {
                materialKey = (String)materialKey + ":" + data;
            }
            if (this.extraData != null && this.extraData instanceof LeatherArmorData) {
                Color color = ((LeatherArmorData)this.extraData).getColor();
                materialKey = data != 0 ? (String)materialKey + ",#" + TextUtils.toHexString(color.asRGB()) : (String)materialKey + ":#" + TextUtils.toHexString(color.asRGB());
            }
        } else if (this.material == Material.POTION || this.material == Material.TIPPED_ARROW || this.material == DefaultMaterials.getFireworkStar()) {
            Color color;
            if (this.extraData != null && this.extraData instanceof ColoredData && (color = ((ColoredData)this.extraData).getColor()) != null) {
                materialKey = (String)materialKey + ":" + TextUtils.toHexString(color.asRGB());
            }
        } else if (this.extraData != null && this.extraData instanceof EnchantmentData) {
            Map<Enchantment, Integer> enchants = ((EnchantmentData)this.extraData).getEnchantments();
            if (!enchants.isEmpty()) {
                ArrayList<String> enchantKeys = new ArrayList<String>();
                for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
                    Object enchantKey = CompatibilityLib.getCompatibilityUtils().getEnchantmentKey(entry.getKey());
                    int level = entry.getValue();
                    if (level != 1) {
                        enchantKey = (String)enchantKey + "|" + level;
                    }
                    enchantKeys.add((String)enchantKey);
                }
                materialKey = (String)materialKey + ":" + StringUtils.join(enchantKeys, ",");
            }
        } else if (data != 0) {
            materialKey = (String)materialKey + ":" + data;
        }
        if (this.blockData != null) {
            materialKey = (String)materialKey + "?" + this.blockData;
        }
        if (this.customModelData != 0) {
            materialKey = (String)materialKey + "{" + this.customModelData + "}";
        }
        return materialKey;
    }

    public String getWildDataKey() {
        return this.getKey(null);
    }

    @Override
    public boolean is(Block block) {
        if (CompatibilityLib.isCurrentVersion()) {
            return this.material == block.getType();
        }
        return this.material == block.getType() && this.data.shortValue() == block.getData();
    }

    @Override
    public boolean isDifferent(Material blockMaterial) {
        return this.material != null && blockMaterial != this.material;
    }

    @Override
    public boolean isDifferent(Block block) {
        String currentData;
        Material blockMaterial = block.getType();
        if (this.material != null && blockMaterial != this.material) {
            return true;
        }
        if (!CompatibilityLib.isCurrentVersion()) {
            byte blockData = block.getData();
            if (this.data != null && blockData != this.data) {
                return true;
            }
        }
        if (DefaultMaterials.isBanner(this.material)) {
            return true;
        }
        if (!(this.blockData == null || (currentData = CompatibilityLib.getCompatibilityUtils().getBlockData(block)) != null && this.blockData.equals(currentData))) {
            return true;
        }
        return this.extraData != null;
    }

    @Override
    public boolean isDifferent(ItemStack itemStack) {
        if (this.getMaterial() != itemStack.getType()) {
            return true;
        }
        if (this.getData().shortValue() != CompatibilityLib.getDeprecatedUtils().getItemDamage(itemStack)) {
            return true;
        }
        int itemModelData = CompatibilityLib.getItemUtils().getCustomModelData(itemStack);
        return this.customModelData != itemModelData;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount) {
        return this.getItemStack(amount, null);
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount, ItemUpdatedCallback callback) {
        if (this.material == null) {
            if (callback != null) {
                callback.updated(null);
            }
            return null;
        }
        Material material = this.convertToItemStackMaterial();
        MaterialAndData item = this;
        if (material != this.material) {
            item = new MaterialAndData(this);
            item.material = material;
        }
        ItemStack stack = CompatibilityLib.getDeprecatedUtils().createItemStack(material, amount, this.data == null ? (short)0 : this.data);
        stack = item.applyToItem(stack, callback);
        return stack;
    }

    private Material convertToItemStackMaterial() {
        return DefaultMaterials.blockToItem(this.material);
    }

    @Override
    public ItemStack applyToItem(ItemStack stack) {
        return this.applyToItem(stack, null);
    }

    @Override
    public ItemStack applyToItem(ItemStack stack, final ItemUpdatedCallback callback) {
        boolean asynchronous = false;
        stack.setType(this.material);
        if (this.data != null) {
            CompatibilityLib.getDeprecatedUtils().setItemDamage(stack, this.data);
        }
        if (this.customModelData != 0) {
            CompatibilityLib.getItemUtils().setCustomModelData(stack, this.customModelData);
        }
        if (DefaultMaterials.isPlayerSkull(this)) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof SkullMeta && this.extraData != null && this.extraData instanceof BlockSkull) {
                BlockSkull skullData = (BlockSkull)this.extraData;
                PlayerProfile profile = skullData.getProfile();
                String playerName = skullData.getPlayerName();
                if (profile != null) {
                    SkullMeta skullMeta = (SkullMeta)meta;
                    skullMeta.setOwnerProfile(profile);
                    stack.setItemMeta(meta);
                } else if (playerName != null) {
                    asynchronous = true;
                    SkullLoadedCallback skullCallback = null;
                    if (callback != null) {
                        skullCallback = new SkullLoadedCallback(){

                            @Override
                            public void updated(ItemStack itemStack) {
                                callback.updated(itemStack);
                            }
                        };
                    }
                    CompatibilityLib.getDeprecatedUtils().setSkullOwner(stack, playerName, skullCallback);
                }
            }
        } else if (DefaultMaterials.isBanner(this.material)) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof BannerMeta && this.extraData != null && this.extraData instanceof BlockBanner) {
                BannerMeta banner = (BannerMeta)meta;
                BlockBanner bannerData = (BlockBanner)this.extraData;
                if (bannerData.patterns != null) {
                    banner.setPatterns(bannerData.patterns);
                }
                stack.setItemMeta(meta);
            }
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS || this.material.name().equals("LEATHER_HORSE_ARMOR")) {
            ItemMeta meta = stack.getItemMeta();
            if (this.extraData != null && this.extraData instanceof LeatherArmorData && meta != null && meta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)meta).setColor(((LeatherArmorData)this.extraData).getColor());
                stack.setItemMeta(meta);
            }
        } else if (this.material == Material.POTION || this.material == Material.TIPPED_ARROW) {
            ItemMeta meta = stack.getItemMeta();
            if (this.extraData != null && this.extraData instanceof PotionData && meta != null && meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                PotionData potionData = (PotionData)this.extraData;
                Color potionColor = potionData.getColor();
                if (potionColor != null) {
                    CompatibilityLib.getCompatibilityUtils().setColor(potionMeta, potionData.getColor());
                }
                potionMeta.clearCustomEffects();
                for (PotionEffect effect : potionData.getEffects()) {
                    potionMeta.addCustomEffect(effect, true);
                }
                stack.setItemMeta(meta);
            } else if (this.extraData != null && this.extraData instanceof ColoredData && meta != null && meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                ColoredData colorData = (ColoredData)this.extraData;
                Color potionColor = colorData.getColor();
                if (potionColor != null) {
                    CompatibilityLib.getCompatibilityUtils().setColor(potionMeta, colorData.getColor());
                }
                stack.setItemMeta(meta);
            }
        } else if (this.extraData != null && this.extraData instanceof EnchantmentData) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof EnchantmentStorageMeta) {
                EnchantmentData enchantmentData = (EnchantmentData)this.extraData;
                EnchantmentStorageMeta enchantmentStorage = (EnchantmentStorageMeta)meta;
                for (Map.Entry<Enchantment, Integer> entry : enchantmentData.getEnchantments().entrySet()) {
                    enchantmentStorage.addStoredEnchant(entry.getKey(), entry.getValue().intValue(), true);
                }
                stack.setItemMeta(meta);
            }
        } else if (this.material == DefaultMaterials.getFireworkStar()) {
            ItemMeta meta = stack.getItemMeta();
            if (this.extraData != null && this.extraData instanceof ColoredData && meta != null && meta instanceof FireworkEffectMeta) {
                FireworkEffectMeta effectMeta = (FireworkEffectMeta)meta;
                ColoredData coloredData = (ColoredData)this.extraData;
                FireworkEffect existingEffect = effectMeta.getEffect();
                if (existingEffect != null) {
                    FireworkEffect.Type existingType = existingEffect.getType();
                    FireworkEffect fireworkEffect = FireworkEffect.builder().withColor(coloredData.getColor()).flicker(existingEffect.hasFlicker()).trail(existingEffect.hasTrail()).with(existingType == null ? FireworkEffect.Type.BALL : existingType).build();
                    effectMeta.setEffect(fireworkEffect);
                } else {
                    effectMeta.setEffect(FireworkEffect.builder().withColor(coloredData.getColor()).build());
                }
                stack.setItemMeta(meta);
            }
        } else if (this.material == Material.WRITTEN_BOOK) {
            ItemMeta meta = stack.getItemMeta();
            if (this.extraData != null && this.extraData instanceof WrittenBookData && meta != null && meta instanceof BookMeta) {
                BookMeta book = (BookMeta)meta;
                WrittenBookData data = (WrittenBookData)this.extraData;
                data.applyTo(book);
                stack.setItemMeta(meta);
            }
        }
        if (!asynchronous && callback != null) {
            callback.updated(stack);
        }
        return stack;
    }

    public static String[] splitMaterialKey(String materialKey) {
        if (materialKey.contains("|")) {
            return StringUtils.split(materialKey, "|", 2);
        }
        if (materialKey.contains(":")) {
            return StringUtils.split(materialKey, ":", 2);
        }
        return new String[]{materialKey};
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static String getMaterialName(ItemStack item, Messages messages) {
        MaterialAndData material = new MaterialAndData(item);
        return material.getName(messages);
    }

    public static String getMaterialName(Block block, Messages messages) {
        MaterialAndData material = new MaterialAndData(block);
        return material.getName(messages);
    }

    @Override
    @Nullable
    public String getBaseName() {
        if (this.material == null) {
            return null;
        }
        return this.material.name().toLowerCase().replace('_', ' ');
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    @Nonnull
    public String getName(@Nullable Messages messages) {
        String localizedName;
        Object materialName;
        if (!this.isValid()) {
            return "";
        }
        boolean localized = false;
        Object object = materialName = this.material == null ? "?" : this.material.name();
        if (messages != null && this.material != null && !(localizedName = messages.get("materials." + this.material.name().toLowerCase(), "")).isEmpty()) {
            materialName = localizedName;
            localized = true;
        }
        if (this.data == null && messages != null) {
            materialName = (String)materialName + messages.get("materials.wildcard");
        }
        if (!localized) {
            materialName = ((String)materialName).toLowerCase().replace('_', ' ');
            materialName = WordUtils.capitalize((String)materialName);
        }
        return materialName;
    }

    @Override
    public void setCustomName(String customName) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).customName = customName;
        } else {
            this.extraData = new BlockCommand(null, customName);
        }
    }

    @Override
    public void setCommandLine(String command) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).command = command;
        } else {
            this.extraData = new BlockCommand(command);
        }
    }

    @Override
    @Nullable
    public String getCommandLine() {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            return ((BlockCommand)this.extraData).command;
        }
        return null;
    }

    @Override
    public void setData(Short data) {
        this.data = data;
        if (data == null) {
            this.extraData = null;
            this.blockData = null;
        }
    }

    @Override
    public void setRawData(Object data) {
        this.extraData = new BlockTileEntity(data);
    }

    public boolean matches(Material material, short data) {
        return !(this.material != null && this.material != material || this.data != null && this.data != data);
    }

    @Override
    @Nullable
    public Map<String, Object> getTags() {
        return null;
    }

    @Override
    public int getCustomModelData() {
        return this.customModelData;
    }

    public String toString() {
        return this.isValid() ? String.valueOf(this.material) + (String)(this.data != null && this.data != 0 ? "@" + this.data : "") : "invalid";
    }

    protected boolean allowContainers() {
        return true;
    }

    static {
        DEFAULT_MATERIAL = Material.AIR;
    }
}

