/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class ModifyBlockAction
extends BaseSpellAction {
    private boolean spawnFallingBlocks;
    private boolean fallingBlocksHurt;
    private double fallingBlockSpeed;
    private Vector fallingBlockDirection;
    private float fallingBlockFallDamage;
    private int fallingBlockMaxDamage;
    private double fallingProbability;
    private double breakable = 0.0;
    private double backfireChance = 0.0;
    private boolean applyPhysics = false;
    private boolean commit = false;
    private boolean consumeBlocks = false;
    private boolean consumeVariants = true;
    private boolean checkChunk = false;
    private boolean autoBlockState = false;
    private boolean replaceSame = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.spawnFallingBlocks = parameters.getBoolean("falling", false);
        this.applyPhysics = parameters.getBoolean("physics", false);
        this.autoBlockState = parameters.getBoolean("auto_block_state", false);
        this.commit = parameters.getBoolean("commit", false);
        this.breakable = parameters.getDouble("breakable", 0.0);
        this.backfireChance = parameters.getDouble("reflect_chance", 0.0);
        this.fallingBlockSpeed = parameters.getDouble("speed", 0.0);
        this.fallingProbability = parameters.getDouble("falling_probability", 1.0);
        this.consumeBlocks = parameters.getBoolean("consume", false);
        this.consumeVariants = parameters.getBoolean("consume_variants", true);
        this.fallingBlocksHurt = parameters.getBoolean("falling_hurts", false);
        this.checkChunk = parameters.getBoolean("check_chunk", true);
        this.replaceSame = parameters.getBoolean("replace_same", false);
        this.fallingBlockDirection = null;
        if (this.spawnFallingBlocks && parameters.contains("direction") && !parameters.getString("direction").isEmpty()) {
            if (this.fallingBlockSpeed == 0.0) {
                this.fallingBlockSpeed = 1.0;
            }
            this.fallingBlockDirection = ConfigurationUtils.getVector(parameters, "direction");
        }
        int damage = parameters.getInt("damage", 0);
        this.fallingBlockFallDamage = (float)parameters.getDouble("fall_damage", (double)damage);
        this.fallingBlockMaxDamage = parameters.getInt("max_damage", damage);
    }

    @Override
    public SpellResult perform(CastContext context) {
        boolean spawnFalling;
        MaterialBrush brush = context.getBrush();
        if (brush == null) {
            return SpellResult.FAIL;
        }
        if (this.checkChunk && !CompatibilityLib.getCompatibilityUtils().checkChunk(context.getTargetLocation())) {
            context.addWork(100);
            return SpellResult.PENDING;
        }
        Block block = context.getTargetBlock();
        if (brush.isErase() ? !context.hasBreakPermission(block) : !context.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.commit ? !context.areAnyDestructible(block) : !context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        BlockData blockData = block.getBlockData();
        Material fallingMaterial = block.getType();
        Mage mage = context.getMage();
        brush.update(mage, context.getTargetSourceLocation());
        if (!brush.isReady()) {
            brush.prepare();
            return SpellResult.PENDING;
        }
        if (!brush.isValid()) {
            return SpellResult.FAIL;
        }
        if (!brush.isTargetValid()) {
            return SpellResult.NO_TARGET;
        }
        if (!this.replaceSame && !brush.isDifferent(block)) {
            return SpellResult.NO_TARGET;
        }
        if (this.consumeBlocks && !context.isConsumeFree() && !brush.isErase()) {
            UndoList undoList = context.getUndoList();
            if (undoList != null) {
                undoList.setConsumed(true);
            }
            if (!mage.consumeBlock(brush, this.consumeVariants)) {
                String requiresMessage = context.getMessage("insufficient_resources");
                context.sendMessageKey("insufficient_resources", requiresMessage.replace("$cost", brush.getName()));
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
        }
        if ((spawnFalling = this.spawnFallingBlocks) && this.fallingProbability < 1.0) {
            boolean bl = spawnFalling = context.getRandom().nextDouble() < this.fallingProbability;
        }
        if (!spawnFalling || brush.isErase()) {
            UndoList undoList;
            if (!this.commit) {
                context.registerForUndo(block);
                if (brush.isErase() && !DefaultMaterials.isAir(block.getType())) {
                    context.clearAttachables(block);
                }
            }
            if ((undoList = context.getUndoList()) != null) {
                undoList.setApplyPhysics(this.applyPhysics);
            }
            BlockState prior = block.getState();
            brush.modify(block, this.applyPhysics);
            if (undoList != null && !undoList.isScheduled()) {
                context.getController().logBlockChange(context.getMage(), prior, block.getState());
            }
            if (this.autoBlockState) {
                Location targetLocation = context.getTargetLocation();
                Block hitBlock = targetLocation.getBlock();
                BlockFace direction = hitBlock.getFace(block);
                if (direction == BlockFace.SELF) {
                    direction = BlockFace.UP;
                }
                CompatibilityLib.getCompatibilityUtils().setAutoBlockState(block, targetLocation, direction, this.applyPhysics, context.getMage().getPlayer());
            }
        }
        boolean bl = spawnFalling = spawnFalling && !DefaultMaterials.isAir(fallingMaterial);
        if (spawnFalling) {
            Location blockLocation = block.getLocation();
            Location blockCenter = new Location(blockLocation.getWorld(), blockLocation.getX() + 0.5, blockLocation.getY() + 0.5, blockLocation.getZ() + 0.5);
            Vector fallingBlockVelocity = null;
            if (this.fallingBlockSpeed > 0.0) {
                Location source = context.getTargetCenterLocation();
                fallingBlockVelocity = blockCenter.clone().subtract(source).toVector();
                fallingBlockVelocity.normalize();
                if (this.fallingBlockDirection != null) {
                    fallingBlockVelocity.add(this.fallingBlockDirection).normalize();
                }
                fallingBlockVelocity.multiply(this.fallingBlockSpeed);
            }
            if (fallingBlockVelocity != null && (Double.isNaN(fallingBlockVelocity.getX()) || Double.isNaN(fallingBlockVelocity.getY()) || Double.isNaN(fallingBlockVelocity.getZ()) || Double.isInfinite(fallingBlockVelocity.getX()) || Double.isInfinite(fallingBlockVelocity.getY()) || Double.isInfinite(fallingBlockVelocity.getZ()))) {
                fallingBlockVelocity = null;
            }
            FallingBlock falling = blockCenter.getWorld().spawnFallingBlock(blockCenter, blockData);
            falling.setDropItem(false);
            if (fallingBlockVelocity != null) {
                SafetyUtils.setVelocity((Entity)falling, fallingBlockVelocity);
            }
            if (this.fallingBlockMaxDamage > 0 && this.fallingBlockFallDamage > 0.0f) {
                CompatibilityLib.getCompatibilityUtils().setFallingBlockDamage(falling, this.fallingBlockFallDamage, this.fallingBlockMaxDamage);
            } else {
                falling.setHurtEntities(this.fallingBlocksHurt);
            }
            context.registerForUndo((Entity)falling);
        }
        if (this.breakable > 0.0) {
            context.registerBreakable(block, this.breakable);
        }
        if (this.backfireChance > 0.0) {
            context.registerReflective(block, this.backfireChance);
        }
        if (this.commit) {
            com.elmakers.mine.bukkit.api.block.BlockData undoBlockData = context.getUndoList().get(block);
            undoBlockData.commit();
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("falling");
        parameters.add("speed");
        parameters.add("direction");
        parameters.add("reflect_chance");
        parameters.add("breakable");
        parameters.add("physics");
        parameters.add("commit");
        parameters.add("hurts");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("falling") || parameterKey.equals("physics") || parameterKey.equals("commit") || parameterKey.equals("falling_hurts")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("speed") || parameterKey.equals("breakable")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("direction")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("reflect_chance")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean usesBrush() {
        return true;
    }
}

