/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.spawn.builtin;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.spawn.SpawnOption;
import com.elmakers.mine.bukkit.world.spawn.SpawnOptionParser;
import com.elmakers.mine.bukkit.world.spawn.SpawnResult;
import com.elmakers.mine.bukkit.world.spawn.SpawnRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class ReplaceRule
extends SpawnRule {
    protected SpawnOption replaceWith;
    protected Deque<WeightedPair<SpawnOption>> replaceProbability;
    protected int yOffset;
    protected boolean atHighestBlock;

    @Override
    public void finalizeLoad(String worldName) {
        String replaceDescription;
        if (!this.parameters.contains("type")) {
            this.parameters.set("type", this.parameters.get("replace_type"));
        }
        if (!this.parameters.contains("sub_type")) {
            this.parameters.set("sub_type", this.parameters.get("replace_sub_type"));
        }
        ConfigurationSection section = this.parameters.getConfigurationSection("type");
        SpawnOptionParser parser = SpawnOptionParser.getInstance(this.controller);
        if (section == null) {
            this.replaceWith = parser.parse(this.parameters.getString("type"));
        } else {
            this.replaceProbability = new ArrayDeque<WeightedPair<SpawnOption>>();
            RandomUtils.populateProbabilityMap(parser, this.replaceProbability, section);
        }
        if (this.replaceProbability == null && (this.replaceWith == null || this.replaceWith.getType() == null)) {
            this.controller.getLogger().warning("Error reading in configuration for custom mob in " + worldName + " for rule " + this.key);
            return;
        }
        if (this.replaceWith != null) {
            replaceDescription = this.replaceWith.describe();
        } else {
            ArrayList<String> names = new ArrayList<String>();
            for (WeightedPair<SpawnOption> option : this.replaceProbability) {
                names.add(option.getValue().describe());
            }
            replaceDescription = StringUtils.join(names, (String)",");
        }
        replaceDescription = ChatColor.stripColor((String)replaceDescription);
        this.atHighestBlock = this.parameters.getBoolean("highest_block", false);
        this.yOffset = this.parameters.getInt("y_offset");
        this.logSpawnRule("Replacing " + this.getTargetEntityTypeName() + " in " + worldName + " with " + replaceDescription);
    }

    @Override
    @Nonnull
    public SpawnResult onProcess(Plugin plugin, LivingEntity entity) {
        if (this.replaceWith == null && this.replaceProbability == null) {
            return SpawnResult.SKIP;
        }
        SpawnOption option = this.replaceWith;
        if (this.replaceProbability != null) {
            option = (SpawnOption)RandomUtils.weightedRandom(this.replaceProbability);
        }
        if (option == null) {
            return SpawnResult.SKIP;
        }
        if (option.getType() == SpawnResult.REPLACE) {
            EntityData replacement = option.getReplacement();
            if (entity.getType() == replacement.getType()) {
                replacement.modify((Entity)entity);
                return SpawnResult.STOP;
            }
            Location location = entity.getLocation();
            if (this.atHighestBlock) {
                location.setY((double)location.getWorld().getHighestBlockYAt(location));
            }
            location.setY(location.getY() + (double)this.yOffset);
            Entity spawned = replacement.spawn(location);
            if (spawned == null) {
                return SpawnResult.SKIP;
            }
        }
        return option.getType();
    }
}

