/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.platform.EntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.platform.EntityUtils;
import com.elmakers.mine.bukkit.utility.platform.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.PaperUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SchematicUtils;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import com.elmakers.mine.bukkit.utility.platform.SpigotUtils;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public abstract class PlatformBase
implements Platform {
    private final Logger logger;
    private final Plugin plugin;
    @Nonnull
    protected final CompatibilityUtils compatibilityUtils;
    @Nonnull
    protected final DeprecatedUtils deprecatedUtils;
    @Nonnull
    protected final InventoryUtils inventoryUtils;
    @Nonnull
    protected final ItemUtils itemUtils;
    @Nonnull
    protected final NBTUtils nbtUtils;
    @Nonnull
    protected final SchematicUtils schematicUtils;
    @Nonnull
    protected final SkinUtils skinUtils;
    @Nonnull
    protected final EntityUtils entityUtils;
    protected final PaperUtils paperUtils;
    protected final SpigotUtils spigotUtils;
    @Nonnull
    protected final EntityMetadataUtils entityMetadataUtils;
    protected final boolean valid;

    public PlatformBase(Plugin plugin, Logger logger) {
        this.plugin = plugin;
        this.logger = logger;
        this.valid = this.initialize();
        if (this.valid) {
            this.compatibilityUtils = this.createCompatibilityUtils();
            this.deprecatedUtils = this.createDeprecatedUtils();
            this.inventoryUtils = this.createInventoryUtils();
            this.itemUtils = this.createItemUtils();
            this.nbtUtils = this.createNBTUtils();
            this.schematicUtils = this.createSchematicUtils();
            this.skinUtils = this.createSkinUtils();
            this.paperUtils = this.createPaperUtils();
            this.spigotUtils = this.createSpigotUtils();
            this.entityMetadataUtils = this.createEntityMetadataUtils();
            this.entityUtils = this.createEntityUtils();
        } else {
            this.compatibilityUtils = null;
            this.deprecatedUtils = null;
            this.inventoryUtils = null;
            this.itemUtils = null;
            this.nbtUtils = null;
            this.schematicUtils = null;
            this.skinUtils = null;
            this.paperUtils = null;
            this.spigotUtils = null;
            this.entityMetadataUtils = null;
            this.entityUtils = null;
        }
    }

    protected boolean initialize() {
        return true;
    }

    @Override
    public void registerEvents(MageController controller, PluginManager pm) {
        if (this.paperUtils != null) {
            this.paperUtils.registerEvents(controller, pm);
        }
    }

    protected EntityMetadataUtils createEntityMetadataUtils() {
        throw new IllegalStateException("Platform does not implement createEntityMetadataUtils");
    }

    protected EntityUtils createEntityUtils() {
        throw new IllegalStateException("Platform does not implement createEntityUtils");
    }

    protected PaperUtils createPaperUtils() {
        try {
            World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Consumer.class);
            this.logger.info("Async chunk loading API found");
            return new com.elmakers.mine.bukkit.utility.paper.PaperUtils();
        }
        catch (Throwable throwable) {
            return this.paperUtils;
        }
    }

    protected SpigotUtils createSpigotUtils() {
        try {
            Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            Class<?> bungeeColor = Class.forName("net.md_5.bungee.api.ChatColor");
            bungeeColor.getMethod("of", String.class);
            this.logger.info("Chat component API found");
            return new com.elmakers.mine.bukkit.utility.spigot.SpigotUtils(this);
        }
        catch (Throwable throwable) {
            return this.spigotUtils;
        }
    }

    protected SkinUtils createSkinUtils() {
        throw new IllegalStateException("Platform does not implement createSkinUtils");
    }

    protected SchematicUtils createSchematicUtils() {
        throw new IllegalStateException("Platform does not implement createSchematicUtils");
    }

    protected NBTUtils createNBTUtils() {
        throw new IllegalStateException("Platform does not implement createNBTUtils");
    }

    protected ItemUtils createItemUtils() {
        throw new IllegalStateException("Platform does not implement createItemUtils");
    }

    protected InventoryUtils createInventoryUtils() {
        throw new IllegalStateException("Platform does not implement createInventoryUtils");
    }

    protected CompatibilityUtils createCompatibilityUtils() {
        throw new IllegalStateException("Platform does not implement createCompatibilityUtils");
    }

    protected DeprecatedUtils createDeprecatedUtils() {
        throw new IllegalStateException("Platform does not implement createDeprecatedUtils");
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public boolean isCurrentVersion() {
        return true;
    }

    @Override
    public boolean hasStatistics() {
        return true;
    }

    @Override
    public boolean hasEntityTransformEvent() {
        return true;
    }

    @Override
    public boolean hasTimeSkipEvent() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public CompatibilityUtils getCompatibilityUtils() {
        return this.compatibilityUtils;
    }

    @Override
    public DeprecatedUtils getDeprecatedUtils() {
        return this.deprecatedUtils;
    }

    @Override
    public InventoryUtils getInventoryUtils() {
        return this.inventoryUtils;
    }

    @Override
    public ItemUtils getItemUtils() {
        return this.itemUtils;
    }

    @Override
    public NBTUtils getNBTUtils() {
        return this.nbtUtils;
    }

    @Override
    public SchematicUtils getSchematicUtils() {
        return this.schematicUtils;
    }

    @Override
    public SkinUtils getSkinUtils() {
        return this.skinUtils;
    }

    @Override
    @Nullable
    public PaperUtils getPaperUtils() {
        return this.paperUtils;
    }

    @Override
    @Nullable
    public SpigotUtils getSpigotUtils() {
        return this.spigotUtils;
    }

    @Override
    public EntityMetadataUtils getEnityMetadataUtils() {
        return this.entityMetadataUtils;
    }

    @Override
    public EntityUtils getEntityUtils() {
        return this.entityUtils;
    }

    @Override
    public boolean hasChatComponents() {
        return this.spigotUtils != null;
    }

    @Override
    public boolean hasEntityLoadEvent() {
        return false;
    }

    @Override
    public boolean hasDeferredEntityLoad() {
        return false;
    }
}

