/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.utility.help.Help;
import com.elmakers.mine.bukkit.utility.help.HelpTopic;
import com.elmakers.mine.bukkit.utility.help.SearchFactors;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class HelpTopicKeywordMatch {
    public static final int MIN_WHOLE_WORD_LENGTH = 4;
    public static final double HIGHLIGHT_CUTOFF = 0.6;
    private final String keyword;
    private final String word;
    private final double relevance;
    private final double similarity;
    private final double countWeight;

    private HelpTopicKeywordMatch(Help help, String keyword, String word, double countRatio, double similarity) {
        this.keyword = keyword.trim();
        this.word = word;
        this.similarity = Math.pow(similarity, SearchFactors.SIMILARITY_FACTOR);
        this.countWeight = Math.pow(countRatio, SearchFactors.COUNT_FACTOR);
        double wordWeight = help.getWeight(word);
        wordWeight *= Math.pow(wordWeight, SearchFactors.WORD_FACTOR);
        double totalWeight = SearchFactors.COUNT_WEIGHT + SearchFactors.WORD_WEIGHT;
        double relevance = (this.countWeight * SearchFactors.COUNT_WEIGHT + wordWeight * SearchFactors.WORD_WEIGHT) / totalWeight;
        this.relevance = relevance * similarity;
    }

    public String getDebugText(Help help) {
        double wordWeight = help.getWeight(this.word);
        return "Matched " + this.word + ": " + ChatUtils.printPercentage(this.similarity) + " x (Count: " + ChatUtils.printPercentage(this.countWeight) + "x" + (int)SearchFactors.COUNT_WEIGHT + " + Word: " + ChatUtils.printPercentage(Math.pow(wordWeight, SearchFactors.WORD_FACTOR)) + "x" + (int)SearchFactors.WORD_WEIGHT + ") [" + help.getDebugText(this.word) + "]";
    }

    @Nullable
    public static HelpTopicKeywordMatch match(String keyword, Set<String> words, HelpTopic topic, Help help) {
        if (!help.isValidWord(keyword)) {
            return null;
        }
        if (words.contains(keyword = keyword.trim())) {
            return new HelpTopicKeywordMatch(help, keyword, keyword, 1.0, 1.0);
        }
        double maxSimilarity = 0.0;
        String bestMatch = null;
        for (String word : words) {
            double similarity = ChatUtils.getSimilarity(keyword, word);
            if (!(similarity > maxSimilarity) || !(similarity >= SearchFactors.MIN_SIMILARITY)) continue;
            bestMatch = word;
            maxSimilarity = similarity;
        }
        if (bestMatch == null || !help.isValidWord(bestMatch)) {
            return null;
        }
        return new HelpTopicKeywordMatch(help, keyword, bestMatch, 1.0, maxSimilarity);
    }

    @Nullable
    public static HelpTopicKeywordMatch match(String keyword, HelpTopic topic, Help help) {
        if (!help.isValidWord(keyword)) {
            return null;
        }
        Integer count = topic.words.get(keyword = keyword.trim());
        if (count != null) {
            double countWeight = (double)count.intValue() / (double)topic.maxCount;
            return new HelpTopicKeywordMatch(help, keyword, keyword, countWeight, 1.0);
        }
        double maxSimilarity = 0.0;
        String bestMatch = null;
        for (Map.Entry<String, Integer> entry : topic.words.entrySet()) {
            String word = entry.getKey();
            double similarity = ChatUtils.getSimilarity(keyword, word);
            if (!(similarity > maxSimilarity) || !(similarity >= SearchFactors.MIN_SIMILARITY)) continue;
            count = entry.getValue();
            bestMatch = word;
            maxSimilarity = similarity;
        }
        if (bestMatch == null || !help.isValidWord(bestMatch)) {
            return null;
        }
        double countWeight = Math.min((double)count.intValue(), SearchFactors.COUNT_MAX) / SearchFactors.COUNT_MAX;
        return new HelpTopicKeywordMatch(help, keyword, bestMatch, countWeight, maxSimilarity);
    }

    public String getWord() {
        return this.word;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public boolean allowHighlight(HelpTopic topic) {
        if (this.similarity < 0.6) {
            return false;
        }
        return this.keyword.length() >= 4 || topic.words.containsKey(this.keyword);
    }
}

