/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.item.Icon;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.MacroExpansion;
import com.elmakers.mine.bukkit.utility.help.Help;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Messages
implements com.elmakers.mine.bukkit.api.magic.Messages {
    private static String PARAMETER_PATTERN_STRING = "\\$([a-zA-Z0-9]+)";
    private static Pattern PARAMETER_PATTERN = Pattern.compile(PARAMETER_PATTERN_STRING);
    private static Random random = new Random();
    public static DecimalFormat RANGE_FORMATTER = new DecimalFormat("0.#");
    public static DecimalFormat HOURS_FORMATTER = new DecimalFormat("0");
    public static DecimalFormat MINUTES_FORMATTER = new DecimalFormat("0");
    public static DecimalFormat SECONDS_FORMATTER = new DecimalFormat("0");
    public static DecimalFormat MOMENT_MILLISECONDS_FORMATTER = new DecimalFormat("0");
    public static DecimalFormat MOMENT_SECONDS_FORMATTER = new DecimalFormat("0.##");
    private Map<String, String> macros = new HashMap<String, String>();
    private Map<String, String> messageMap = new HashMap<String, String>();
    private Map<String, List<String>> listMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> randomized = new HashMap<String, List<String>>();
    private Map<Integer, String> spaceAmounts = new HashMap<Integer, String>();
    private List<Integer> negativeSpace = new ArrayList<Integer>();
    private List<Integer> positiveSpace = new ArrayList<Integer>();
    private Map<String, Icon> icons;
    private NumberFormat formatter = new DecimalFormat("#0.00");
    private static final Pattern macroSpacesPattern = Pattern.compile("\" ([a-zA-Z0-9])");
    private static final Pattern macroEqualsPattern = Pattern.compile("([a-zA-Z0-9])\\=\"");
    private final Gson gson = new Gson();
    private final Help help = new Help(this);

    public void load(ConfigurationSection messages, Map<String, Icon> icons) {
        this.help.reset();
        this.icons = icons;
        ConfigurationSection spaceSection = messages.getConfigurationSection("glyphs.space");
        Set spaceKeys = spaceSection.getKeys(false);
        for (String spaceKey : spaceKeys) {
            try {
                Integer spaceAmount = Integer.parseInt(spaceKey);
                if (spaceAmount == 0) continue;
                if (spaceAmount < 0) {
                    this.negativeSpace.add(spaceAmount);
                } else {
                    this.positiveSpace.add(spaceAmount);
                }
                this.spaceAmounts.put(spaceAmount, spaceSection.getString(spaceKey));
            }
            catch (Exception exception) {}
        }
        Collections.sort(this.negativeSpace);
        Collections.sort(this.positiveSpace);
        Collections.reverse(this.positiveSpace);
        this.load(messages);
    }

    public void load(ConfigurationSection messages) {
        ConfigurationSection macros = messages.getConfigurationSection("macros");
        if (macros != null) {
            messages.set("macros", null);
            for (String macroKey : macros.getKeys(true)) {
                this.macros.put(macroKey, macros.getString(macroKey));
            }
        }
        this.help.loadMessages(messages);
        Set keys = messages.getKeys(true);
        for (String key : keys) {
            if (key.equals("randomized")) {
                ConfigurationSection randomSection = messages.getConfigurationSection(key);
                Set randomKeys = randomSection.getKeys(false);
                for (String randomKey : randomKeys) {
                    this.randomized.put(randomKey, randomSection.getStringList(randomKey));
                }
                continue;
            }
            if (messages.isString(key)) {
                String value = messages.getString(key);
                value = this.processMacros(value);
                value = CompatibilityLib.getCompatibilityUtils().translateColors(StringEscapeUtils.unescapeHtml((String)value));
                this.messageMap.put(key, value);
                continue;
            }
            if (!messages.isList(key)) continue;
            this.listMap.put(key, messages.getStringList(key));
        }
    }

    @Nonnull
    public Help getHelp() {
        return this.help;
    }

    private String processMacros(String message) {
        return this.expandMacros(message).getText();
    }

    @Nonnull
    public MacroExpansion expandMacros(String message) {
        if (!message.contains("`<")) {
            return new MacroExpansion(message);
        }
        String title = null;
        String tags = null;
        Object[] pieces = StringUtils.splitPreserveAllTokens((String)message, (String)"`");
        boolean leftoverDelimiter = false;
        for (int i = 0; i < pieces.length; ++i) {
            String piece;
            String defaultReplace = piece = pieces[i];
            if (leftoverDelimiter) {
                defaultReplace = "`" + defaultReplace;
            }
            leftoverDelimiter = true;
            if (!piece.startsWith("<") && !piece.endsWith(">")) {
                pieces[i] = defaultReplace;
                continue;
            }
            piece = piece.substring(1, piece.length() - 1);
            StringBuffer json = new StringBuffer();
            Matcher m = macroEqualsPattern.matcher(piece);
            while (m.find()) {
                m.appendReplacement(json, m.group(1) + ":\"");
            }
            m.appendTail(json);
            piece = json.toString();
            int firstSpace = piece.indexOf(" ");
            int firstColon = piece.indexOf(":");
            if (firstSpace < 0 && firstColon < 0) {
                piece = "macro:\"" + piece + "\"";
            } else if (firstColon < 0 || firstColon > firstSpace) {
                piece = "macro:\"" + piece.substring(0, firstSpace) + "\"" + piece.substring(firstSpace);
            }
            json = new StringBuffer();
            m = macroSpacesPattern.matcher(piece);
            while (m.find()) {
                m.appendReplacement(json, "\"," + Matcher.quoteReplacement(m.group(1)));
            }
            m.appendTail(json);
            piece = json.toString();
            piece = "{" + piece + "}";
            try {
                String macro;
                block22: {
                    String glyph;
                    JsonReader reader = new JsonReader((Reader)new StringReader(piece));
                    reader.setLenient(true);
                    Map mapped = (Map)this.gson.fromJson(reader, Map.class);
                    Object macroKey = mapped.get("macro");
                    if (macroKey == null || !(macroKey instanceof String)) {
                        pieces[i] = defaultReplace;
                        continue;
                    }
                    macro = this.macros.get((String)macroKey);
                    if (macro == null) {
                        pieces[i] = defaultReplace;
                        continue;
                    }
                    leftoverDelimiter = false;
                    if (macroKey.equals("icon")) {
                        Object iconKey = mapped.get("key");
                        Icon icon = iconKey == null || !(iconKey instanceof String) ? null : this.icons.get((String)iconKey);
                        String string = glyph = icon == null ? null : icon.getGlyph();
                        if (glyph == null) {
                            pieces[i] = "";
                            continue;
                        }
                        macro = macro.replace("$glyph", glyph);
                    } else {
                        if (macroKey.equals("space")) {
                            Object widthValue = mapped.get("width");
                            try {
                                int width = Integer.parseInt(widthValue.toString());
                                glyph = this.getSpace(width);
                                macro = macro.replace("$glyph", glyph);
                                break block22;
                            }
                            catch (Exception ex) {
                                pieces[i] = defaultReplace;
                                continue;
                            }
                        }
                        boolean isTitle = macroKey.equals("title");
                        boolean isTags = macroKey.equals("tags");
                        for (Map.Entry entry : mapped.entrySet()) {
                            String macroParameter = (String)entry.getKey();
                            if (macroParameter.equals("macro")) continue;
                            String value = entry.getValue().toString();
                            if (isTitle && macroParameter.equals("text")) {
                                title = value;
                            }
                            if (isTags && macroParameter.equals("text")) {
                                tags = value;
                            }
                            macro = macro.replace("$" + macroParameter, value);
                        }
                    }
                }
                pieces[i] = macro;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return new MacroExpansion(StringUtils.join((Object[])pieces), title, tags);
    }

    @Override
    @Nullable
    public List<String> getAll(String path) {
        return this.listMap.get(path);
    }

    @Override
    @Nonnull
    public Collection<String> getAllKeys() {
        ArrayList<String> allKeys = new ArrayList<String>();
        allKeys.addAll(this.listMap.keySet());
        allKeys.addAll(this.messageMap.keySet());
        return allKeys;
    }

    public void reset() {
        this.messageMap.clear();
        this.listMap.clear();
    }

    @Override
    public boolean containsKey(String key) {
        return this.messageMap.containsKey(key) || this.listMap.containsKey(key);
    }

    @Override
    @Nonnull
    public String get(String key, String defaultValue) {
        String value = this.getIfSet(key, defaultValue == null ? "" : defaultValue);
        return value == null ? defaultValue : value;
    }

    @Override
    @Nonnull
    public String get(String key) {
        return this.get(key, key);
    }

    @Nullable
    private String getIfSet(String key, String defaultValue) {
        if (this.messageMap.containsKey(key)) {
            return this.messageMap.get(key);
        }
        if (defaultValue == null) {
            return defaultValue;
        }
        return CompatibilityLib.getCompatibilityUtils().translateColors(defaultValue);
    }

    @Override
    @Nullable
    public String getIfSet(String key) {
        return this.getIfSet(key, null);
    }

    @Override
    public String getParameterized(String key, String paramName, String paramValue) {
        return this.get(key, key).replace(paramName, paramValue);
    }

    @Override
    public String getParameterized(String key, String paramName1, String paramValue1, String paramName2, String paramValue2) {
        return this.get(key, key).replace(paramName1, paramValue1).replace(paramName2, paramValue2);
    }

    @Override
    @Nullable
    public String getRandomized(String key) {
        if (!this.randomized.containsKey(key)) {
            return null;
        }
        List<String> options = this.randomized.get(key);
        if (options.size() == 0) {
            return "";
        }
        return options.get(random.nextInt(options.size()));
    }

    @Override
    public String escape(String source) {
        Matcher matcher = PARAMETER_PATTERN.matcher(source);
        String result = source;
        while (matcher.find()) {
            String randomized;
            String key = matcher.group(1);
            if (key == null || (randomized = this.getRandomized(key)) == null) continue;
            result = result.replace("$" + key, randomized);
        }
        return result;
    }

    @Override
    @Nonnull
    public String describeItem(ItemStack item) {
        ItemMeta meta;
        if (item == null) {
            return "?";
        }
        String displayName = null;
        if (item.hasItemMeta() && ((displayName = (meta = item.getItemMeta()).getDisplayName()) == null || displayName.isEmpty()) && meta instanceof BookMeta) {
            BookMeta book = (BookMeta)meta;
            displayName = book.getTitle();
        }
        if (displayName == null || displayName.isEmpty()) {
            MaterialAndData material = new MaterialAndData(item);
            displayName = material.getName(this);
        }
        return displayName;
    }

    @Override
    public String describeCurrency(double amount) {
        VaultController vault = VaultController.getInstance();
        if (vault == null) {
            return Integer.toString((int)amount);
        }
        String formatted = vault.format(amount);
        if (!VaultController.hasEconomy()) {
            formatted = this.get("currency.currency.amount").replace("$amount", formatted);
        }
        return formatted;
    }

    @Override
    public String getCurrency() {
        VaultController vault = VaultController.getInstance();
        if (VaultController.hasEconomy()) {
            return vault.getCurrency();
        }
        return this.get("currency.currency.name_singular");
    }

    @Override
    public String getCurrencyPlural() {
        VaultController vault = VaultController.getInstance();
        if (VaultController.hasEconomy()) {
            return vault.getCurrencyPlural();
        }
        return this.get("currency.currency.name");
    }

    @Override
    public String formatList(String basePath, Collection<String> nodes, String nameKey) {
        StringBuilder buffer = new StringBuilder();
        for (String node : nodes) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            String path = node;
            if (basePath != null) {
                path = basePath + "." + path;
            }
            if (nameKey != null) {
                path = path + "." + nameKey;
            }
            node = this.get(path, node);
            buffer.append(node);
        }
        return buffer.toString();
    }

    @Override
    public String getLevelString(String templateName, float amount) {
        return this.getLevelString(templateName, amount, 1.0f);
    }

    @Override
    public String getLevelString(String templateName, float amount, float max) {
        String templateString = this.get(templateName, "");
        return this.formatLevelString(templateString, amount, max);
    }

    @Override
    public String getPropertyString(String templateName, float amount, float max, String propertyTemplateName) {
        String templateString = this.get(templateName, "");
        String propertyTemplateString = this.get(propertyTemplateName, "");
        return this.formatPropertyString(templateString, amount, max, propertyTemplateString);
    }

    @Override
    public String formatLevelString(String message, float amount) {
        return this.formatLevelString(message, amount, 1.0f);
    }

    @Override
    public String formatLevelString(String message, float amount, float max) {
        return this.formatPropertyString(message, amount, max, null);
    }

    @Override
    public String formatPropertyString(String message, float amount, float max, @Nullable String propertyTemplate) {
        String valueString;
        if (message.contains("$roman")) {
            String property;
            if (max != 1.0f && max != 0.0f) {
                amount /= max;
            }
            String string = property = max == 0.0f ? this.getRomanLevelString((int)Math.ceil(amount)) : this.getRomanString(amount);
            if (propertyTemplate != null) {
                property = propertyTemplate.replace("$property", property);
            }
            message = message.replace("$roman", property);
        }
        String string = valueString = Math.floor(amount) == (double)amount ? Integer.toString((int)Math.floor(amount)) : this.formatter.format(amount);
        if (propertyTemplate != null) {
            valueString = propertyTemplate.replace("$property", valueString);
        }
        String amountString = Integer.toString(Math.round(amount));
        if (propertyTemplate != null) {
            amountString = propertyTemplate.replace("$property", amountString);
        }
        String percentString = Integer.toString((int)Math.round(100.0 * (double)amount));
        if (propertyTemplate != null) {
            percentString = propertyTemplate.replace("$property", percentString);
        }
        return message.replace("$amount", amountString).replace("$value", valueString).replace("$percent", percentString);
    }

    @Override
    public String getPercentageString(String templateName, float amount) {
        String templateString = this.get(templateName, "");
        return templateString.replace("$amount", Integer.toString((int)(amount * 100.0f)));
    }

    private String getRomanString(float amount) {
        String roman = "";
        boolean negative = false;
        if (amount < 0.0f) {
            amount = -amount;
            negative = true;
        }
        roman = amount > 1.0f ? this.get("wand.enchantment_level_max") : (amount > 0.8f ? this.get("wand.enchantment_level_5") : (amount > 0.6f ? this.get("wand.enchantment_level_4") : (amount > 0.4f ? this.get("wand.enchantment_level_3") : (amount > 0.2f ? this.get("wand.enchantment_level_2") : this.get("wand.enchantment_level_1")))));
        if (negative) {
            roman = "-" + roman;
        }
        return roman;
    }

    private String getRomanLevelString(int level) {
        String roman = "";
        boolean negative = false;
        if (level < 0) {
            level = -level;
            negative = true;
        }
        if (level > 5) {
            roman = this.get("wand.enchantment_level_max");
        } else {
            if (level == 0) {
                level = 1;
            }
            roman = this.get("wand.enchantment_level_" + level);
        }
        if (negative) {
            roman = "-" + roman;
        }
        return roman;
    }

    private String getWithFallback(String key, String path, String fallbackPath) {
        if (fallbackPath == null || fallbackPath.isEmpty()) {
            return this.get(path + "." + key);
        }
        return this.get(path + "." + key, this.get(fallbackPath + "." + key));
    }

    @Override
    @Nonnull
    public String getTimeDescription(long time) {
        return this.getTimeDescription(time, "description", null);
    }

    @Override
    @Nonnull
    public String getTimeDescription(long time, @Nonnull String descriptionType) {
        return this.getTimeDescription(time, descriptionType, null);
    }

    @Override
    @Nonnull
    public String getTimeDescription(long time, @Nonnull String descriptionType, @Nullable String messagesPath) {
        if (time > 0L) {
            double timeInSeconds = (double)time / 1000.0;
            if (timeInSeconds >= 3600.0) {
                double hours = timeInSeconds / 3600.0;
                if ((long)Math.floor(hours) == 1L) {
                    return this.getWithFallback(descriptionType + "_hour", "time", messagesPath).replace("$hours", HOURS_FORMATTER.format(hours));
                }
                return this.getWithFallback(descriptionType + "_hours", "time", messagesPath).replace("$hours", HOURS_FORMATTER.format(hours));
            }
            if (timeInSeconds >= 60.0) {
                double minutes = timeInSeconds / 60.0;
                if ((long)Math.floor(minutes) == 1L) {
                    return this.getWithFallback(descriptionType + "_minute", "time", messagesPath).replace("$minutes", MINUTES_FORMATTER.format(minutes));
                }
                return this.getWithFallback(descriptionType + "_minutes", "time", messagesPath).replace("$minutes", MINUTES_FORMATTER.format(minutes));
            }
            if (timeInSeconds >= 2.0) {
                return this.getWithFallback(descriptionType + "_seconds", "time", messagesPath).replace("$seconds", SECONDS_FORMATTER.format(timeInSeconds));
            }
            if (timeInSeconds >= 1.0) {
                return this.getWithFallback(descriptionType + "_second", "time", messagesPath).replace("$seconds", SECONDS_FORMATTER.format(timeInSeconds));
            }
            String timeDescription = this.getWithFallback(descriptionType + "_moment", "time", messagesPath);
            timeDescription = timeDescription.replace("$milliseconds", MOMENT_MILLISECONDS_FORMATTER.format(timeInSeconds * 1000.0)).replace("$seconds", MOMENT_SECONDS_FORMATTER.format(timeInSeconds));
            return timeDescription;
        }
        return "0";
    }

    @Override
    @Nonnull
    public String getRangeDescription(double range, @Nonnull String messagesKey) {
        return this.get(messagesKey).replace("$range", RANGE_FORMATTER.format(range));
    }

    @Override
    @Nonnull
    public String getSpace(int pixels) {
        if (pixels == 0) {
            return "";
        }
        if (this.spaceAmounts.containsKey(pixels)) {
            return this.spaceAmounts.get(pixels);
        }
        int totalPixels = pixels;
        int absPixels = Math.abs(pixels);
        List<Integer> spaceValues = pixels > 0 ? this.positiveSpace : this.negativeSpace;
        StringBuilder output = new StringBuilder();
        for (Integer spaceValue : spaceValues) {
            int absValue = Math.abs(spaceValue);
            if (absPixels < absValue) continue;
            String entryGlyph = this.spaceAmounts.get(spaceValue);
            int amount = absPixels / absValue;
            for (int i = 0; i < amount; ++i) {
                output.append(entryGlyph);
            }
            absPixels = Math.abs(pixels -= amount * spaceValue);
            if (absPixels != 0) continue;
            break;
        }
        String result = output.toString();
        this.spaceAmounts.put(totalPixels, result);
        return result;
    }

    public void loadMeta(InputStream inputStream) throws Exception {
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
        Map meta = (Map)this.gson.fromJson(reader, Map.class);
        this.help.loadMetaActions((Map)meta.get("actions"));
        this.help.loadMetaEffects((Map)meta.get("effectlib_effects"));
    }
}

