/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.configuration.MagicConfiguration;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.MagicLogger;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigurationLoadTask
implements Runnable {
    private final MagicController controller;
    private final File configFolder;
    private final Plugin plugin;
    private final CommandSender sender;
    private boolean verboseLogging;
    private static final String[] CONFIG_FILES = new String[]{"messages", "materials", "attributes", "effects", "spells", "paths", "classes", "wands", "items", "kits", "crafting", "mobs", "blocks", "modifiers", "worlds", "arenas", "icons"};
    private static final ImmutableSet<String> DEFAULT_ON = ImmutableSet.of((Object)"messages", (Object)"materials");
    private final Map<String, ConfigurationSection> loadedConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> mainConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> spellConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> baseSpellConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> exampleConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, String> exampleKeyNames = new HashMap<String, String>();
    private final Map<String, ConfigurationSection> builtinConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> loadedConfigurationFiles = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> addDisabled = new HashMap<String, ConfigurationSection>();
    private static final Object loadLock = new Object();
    private boolean allPvpRestricted = false;
    private boolean noPvpRestricted = false;
    private boolean saveDefaultConfigs = true;
    private boolean spellUpgradesEnabled = true;
    private String exampleDefaults = null;
    private String languageOverride = null;
    private List<String> addExamples = null;
    private Set<String> allExamples = new HashSet<String>();
    private final ConfigurationSection helpTopics;
    private ConfigurationSection mainConfiguration;
    private Set<String> resolvingKeys = new LinkedHashSet<String>();
    private boolean success;

    public ConfigurationLoadTask(MagicController controller, CommandSender sender) {
        this.controller = controller;
        this.sender = sender;
        this.plugin = controller.getPlugin();
        this.configFolder = controller.getConfigFolder();
        this.helpTopics = ConfigurationUtils.newConfigurationSection();
    }

    private Logger getLogger() {
        return this.controller.getLogger();
    }

    private void loadInitialProperties(ConfigurationSection properties) {
        this.spellUpgradesEnabled = properties.getBoolean("enable_spell_upgrades", true);
        this.allPvpRestricted = properties.getBoolean("pvp_restricted", false);
        this.noPvpRestricted = properties.getBoolean("allow_pvp_restricted", false);
        this.saveDefaultConfigs = properties.getBoolean("save_default_configs", true);
        this.exampleDefaults = properties.getString("example", this.exampleDefaults);
        this.addExamples = ConfigurationUtils.getStringList(properties, "add_examples");
        if (this.addExamples == null || this.addExamples.isEmpty()) {
            this.addExamples = ConfigurationUtils.getStringList(properties, "examples");
        }
        this.languageOverride = properties.getString("language");
    }

    private void info(String message) {
        if (this.verboseLogging) {
            this.controller.info(message);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verboseLogging = verbose;
    }

    @Nonnull
    private ConfigurationSection loadExampleConfiguration(String examplesPrefix, String exampleKey) {
        return this.loadExampleConfiguration(examplesPrefix, exampleKey, true);
    }

    @Nonnull
    private ConfigurationSection loadExampleConfiguration(String examplesPrefix, String exampleKey, boolean processMessages) {
        ConfigurationSection exampleConfig = this.exampleConfigurations.get(examplesPrefix);
        if (exampleConfig == null) {
            InputStream input;
            File metaFile;
            boolean isMainConfig = examplesPrefix.endsWith("config");
            boolean isMessagesConfig = examplesPrefix.endsWith("messages");
            String examplesFileName = examplesPrefix + ".yml";
            File externalFolder = new File(this.plugin.getDataFolder(), examplesPrefix);
            File externalFile = new File(this.plugin.getDataFolder(), examplesFileName);
            if (externalFile.exists()) {
                try {
                    exampleConfig = this.loadConfiguration(examplesPrefix, externalFile);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + examplesFileName);
                }
            }
            if (externalFolder.exists()) {
                try {
                    if (exampleConfig == null) {
                        exampleConfig = ConfigurationUtils.newConfigurationSection();
                    }
                    exampleConfig = this.loadConfigFolder(examplesPrefix, exampleConfig, externalFolder);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + examplesFileName);
                }
            }
            if (isMainConfig && (metaFile = new File(this.plugin.getDataFolder(), "examples/" + exampleKey + "/example.yml")).exists()) {
                try {
                    YamlConfiguration exampleMetadata = new YamlConfiguration();
                    exampleMetadata.load(metaFile);
                    String name = exampleMetadata.getString("name", exampleKey);
                    if (!name.equalsIgnoreCase(exampleKey)) {
                        this.exampleKeyNames.put(exampleKey, name);
                    }
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading external example meta file: " + metaFile.getPath());
                }
            }
            if (exampleConfig == null && (input = this.plugin.getResource(examplesFileName)) != null) {
                try {
                    exampleConfig = CompatibilityLib.getCompatibilityUtils().loadConfiguration(input, examplesFileName);
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.SEVERE, "Error loading: " + examplesFileName + " from builtin resources", ex);
                }
            }
            if (exampleConfig == null) {
                exampleConfig = ConfigurationUtils.newConfigurationSection();
            } else if (isMessagesConfig && processMessages) {
                this.processMessageExample(exampleConfig, exampleConfig.getBoolean("example_override", false));
            }
            this.exampleConfigurations.put(examplesPrefix, exampleConfig);
        }
        return ConfigurationUtils.cloneConfiguration(exampleConfig);
    }

    private ConfigurationSection loadMainConfiguration() throws InvalidConfigurationException, IOException {
        ConfigurationSection configuration = this.loadMainConfiguration("config");
        this.loadInitialProperties(configuration);
        boolean reloadConfig = false;
        if (this.addExamples != null && this.addExamples.size() > 0) {
            this.allExamples.addAll(this.addExamples);
            this.info("Adding examples: " + StringUtils.join(this.addExamples, (String)","));
            reloadConfig = true;
        }
        if (this.exampleDefaults != null && this.exampleDefaults.length() > 0) {
            this.allExamples.add(this.exampleDefaults);
            this.info("Overriding configuration with example: " + this.exampleDefaults);
            reloadConfig = true;
        }
        if (reloadConfig) {
            configuration = this.loadMainConfiguration("config");
        }
        return configuration;
    }

    private ConfigurationSection loadMainConfiguration(String fileName) throws InvalidConfigurationException, IOException {
        YamlConfiguration config;
        ConfigurationSection overrides = this.loadOverrides(fileName);
        if (overrides != null && !overrides.contains("add_resource_pack")) {
            overrides.set("add_resource_pack", overrides.get("resource_pack"));
        }
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFilePrefix = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        try {
            config = CompatibilityLib.getCompatibilityUtils().loadBuiltinConfiguration(defaultsFileName);
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading file: " + defaultsFileName);
            throw ex;
        }
        this.info(" Based on defaults " + defaultsFileName);
        String listsFilename = "defaults/lists.defaults.yml";
        YamlConfiguration listConfig = null;
        try {
            listConfig = CompatibilityLib.getCompatibilityUtils().loadBuiltinConfiguration(listsFilename);
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)listConfig);
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading file: " + listsFilename);
            throw ex;
        }
        this.info(" Added lists from " + listsFilename);
        if (usingExample) {
            ConfigurationSection exampleConfig = this.loadExampleConfiguration(examplesFilePrefix, this.exampleDefaults);
            try {
                this.info(" Using " + examplesFilePrefix);
                this.processInheritance(this.exampleDefaults, exampleConfig, fileName, exampleConfig);
                this.mainConfigurations.put(this.exampleDefaults, exampleConfig);
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig);
            }
            catch (Exception exception) {
                this.getLogger().severe("Error loading: " + examplesFilePrefix);
                throw exception;
            }
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String string : this.addExamples) {
                examplesFilePrefix = "examples/" + string + "/" + fileName;
                ConfigurationSection exampleConfig = this.loadExampleConfiguration(examplesFilePrefix, string);
                try {
                    boolean override = exampleConfig.getBoolean("example_override", false);
                    exampleConfig.set("example_override", null);
                    this.info(" Adding " + examplesFilePrefix + (override ? ", allowing overrides" : ""));
                    this.processInheritance(string, exampleConfig, fileName, exampleConfig);
                    this.mainConfigurations.put(string, exampleConfig);
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig, override);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + examplesFilePrefix);
                    throw ex;
                }
            }
        }
        ArrayList<String> requirements = new ArrayList<String>();
        for (Map.Entry<String, ConfigurationSection> entry : this.mainConfigurations.entrySet()) {
            List<String> requires = ConfigurationUtils.getStringList(entry.getValue(), "require");
            if (requires == null) continue;
            String exampleKey = entry.getKey();
            for (String require : requires) {
                boolean isMainConfig;
                boolean bl = isMainConfig = this.exampleDefaults != null && this.exampleDefaults.equals(exampleKey);
                if (isMainConfig) {
                    this.info("Switching main example from " + exampleKey + " to required example " + require + "");
                    this.exampleDefaults = require;
                    this.addExamples.remove(require);
                    this.addExamples.add(exampleKey);
                }
                if (this.mainConfigurations.containsKey(require)) continue;
                requirements.add(require);
                if (!isMainConfig) {
                    this.addExamples.add(0, require);
                }
                this.info("Force-loading " + require + " because it is required by " + exampleKey);
            }
        }
        for (String example : requirements) {
            examplesFilePrefix = "examples/" + example + "/" + fileName;
            ConfigurationSection exampleConfig = this.loadExampleConfiguration(examplesFilePrefix, example);
            try {
                boolean override = exampleConfig.getBoolean("example_override", false);
                exampleConfig.set("example_override", null);
                this.info(" Adding " + examplesFilePrefix + (override ? ", allowing overrides" : ""));
                this.processInheritance(example, exampleConfig, fileName, exampleConfig);
                this.mainConfigurations.put(example, exampleConfig);
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig, override);
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading: " + examplesFilePrefix);
                throw ex;
            }
        }
        this.addVersionConfigs((ConfigurationSection)config, fileName);
        ConfigurationUtils.addConfigurations((ConfigurationSection)config, overrides);
        File file = new File(this.configFolder, fileName);
        this.loadConfigFolder(fileName, (ConfigurationSection)config, file);
        if (this.saveDefaultConfigs) {
            try {
                this.plugin.saveResource(defaultsFileName, true);
                this.plugin.saveResource(listsFilename, true);
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't write defaults file: " + defaultsFileName);
            }
        } else {
            this.deleteDefaults(defaultsFileName);
        }
        return config;
    }

    private void processInheritance(String exampleKey, ConfigurationSection exampleConfig, String fileName, ConfigurationSection mainConfiguration) {
        this.processInheritance(exampleKey, exampleConfig, fileName, mainConfiguration, null);
    }

    private void processInheritance(String exampleKey, ConfigurationSection exampleConfig, String fileName, ConfigurationSection mainConfiguration, Set<String> inherited) {
        boolean isMainConfig;
        if (mainConfiguration.contains("example")) {
            mainConfiguration.set("inherit", mainConfiguration.get("example"));
            mainConfiguration.set("example", null);
        }
        boolean isUnkeyedConfig = (isMainConfig = fileName.equals("config")) || fileName.equals("messages") || fileName.equals("materials");
        inherited = inherited == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(inherited);
        inherited.add(exampleKey);
        List<String> inherits = ConfigurationUtils.getStringList(mainConfiguration, "inherit");
        if (inherits != null) {
            boolean include;
            List<String> skipList = ConfigurationUtils.getStringList(mainConfiguration, "skip_inherited");
            List<String> includeList = ConfigurationUtils.getStringList(mainConfiguration, "include_inherited");
            boolean skip = skipList != null && skipList.contains(fileName);
            boolean bl = include = includeList == null || includeList.contains(fileName);
            if (!skip && include) {
                for (String inheritFrom : inherits) {
                    String inheritFilePrefix = "examples/" + inheritFrom + "/" + fileName;
                    ConfigurationSection inheritedConfig = this.loadExampleConfiguration(inheritFilePrefix, inheritFrom);
                    if (isMainConfig) {
                        this.mainConfigurations.put(inheritFrom, ConfigurationUtils.cloneConfiguration(inheritedConfig));
                        inheritedConfig.set("disable_inherited", null);
                        inheritedConfig.set("skip_inherited", null);
                        inheritedConfig.set("include_inherited", null);
                        inheritedConfig.set("example", null);
                        inheritedConfig.set("inherit", null);
                    }
                    try {
                        if (inherited.contains(inheritFrom)) {
                            this.getLogger().log(Level.WARNING, "    Circular dependency detected in configuration inheritance: " + StringUtils.join(inherited, (String)" -> ") + " -> " + inheritFrom);
                        } else {
                            this.processInheritance(inheritFrom, inheritedConfig, fileName, this.getMainConfiguration(inheritFrom), inherited);
                        }
                        List<String> disable = ConfigurationUtils.getStringList(mainConfiguration, "disable_inherited");
                        if (!isUnkeyedConfig && disable != null && disable.contains(fileName)) {
                            this.addDisabled(inheritFrom, inheritedConfig);
                            this.info("   Example " + exampleKey + " inheriting from disabled " + inheritFrom);
                            continue;
                        }
                        ConfigurationUtils.addConfigurations(exampleConfig, inheritedConfig, false);
                        this.info("   Example " + exampleKey + " inheriting from " + inheritFrom);
                    }
                    catch (Exception ex) {
                        this.getLogger().severe("Error loading file: " + inheritFilePrefix);
                        throw ex;
                    }
                }
            }
        }
    }

    @Nonnull
    private ConfigurationSection getBuiltin(String fileType) {
        ConfigurationSection builtin = this.builtinConfigurations.get(fileType);
        if (builtin == null) {
            File targetFile = new File(this.controller.getPlugin().getDataFolder(), "defaults/" + fileType + ".defaults.yml");
            if (!targetFile.exists()) {
                this.controller.getLogger().warning("Missing builtin default file for " + fileType);
                return ConfigurationUtils.newConfigurationSection();
            }
            try {
                YamlConfiguration newFile = new YamlConfiguration();
                newFile.load(targetFile);
                builtin = newFile;
                this.builtinConfigurations.put(fileType, builtin);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error loading defaults file: " + targetFile.getAbsolutePath(), ex);
                return ConfigurationUtils.newConfigurationSection();
            }
        }
        return builtin;
    }

    private void checkBuiltin(String fileType, File file, ConfigurationSection config) {
        if (!(config instanceof YamlConfiguration)) {
            return;
        }
        YamlConfiguration yaml = (YamlConfiguration)config;
        String header = yaml.options().header();
        if (header == null || !header.contains("file is merged from the files")) {
            return;
        }
        this.controller.getLogger().info("Note: You have a " + fileType + " at " + file.getAbsolutePath() + " that was copied from the defaults, will ignore anything that is set to the same as defaults to avoid unintentionally overriding loaded examples");
        ConfigurationSection builtinConfig = this.getBuiltin(fileType);
        Set keys = config.getKeys(false);
        for (String key : keys) {
            Object builtinValue;
            Object configValue = config.get(key);
            if (!Objects.equals(configValue, builtinValue = builtinConfig.get(key))) continue;
            config.set(key, null);
        }
    }

    private ConfigurationSection loadConfiguration(String fileType, File configFile) throws IOException, InvalidConfigurationException {
        String path = configFile.getAbsolutePath();
        ConfigurationSection config = this.loadedConfigurationFiles.get(path);
        if (config == null) {
            config = CompatibilityLib.getCompatibilityUtils().loadConfiguration(configFile);
            this.checkBuiltin(fileType, configFile, config);
            this.loadedConfigurationFiles.put(path, config);
        }
        return config;
    }

    private ConfigurationSection loadOverrides(String fileName) throws IOException, InvalidConfigurationException {
        ConfigurationSection results;
        String configFileName = fileName + ".yml";
        File configFile = new File(this.configFolder, configFileName);
        if (!configFile.exists()) {
            this.info("Saving template " + configFileName + ", edit to customize configuration.");
            this.plugin.saveResource(configFileName, false);
        }
        this.info("Loading " + configFile.getName());
        try {
            results = this.loadConfiguration(fileName, configFile);
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading: " + configFileName);
            throw ex;
        }
        return results;
    }

    private ConfigurationSection loadConfigFile(String fileName, ConfigurationSection mainConfiguration) throws IOException, InvalidConfigurationException {
        boolean loadAllDefaults = mainConfiguration.getBoolean("load_default_configs", true);
        if (DEFAULT_ON.contains((Object)fileName)) {
            loadAllDefaults = true;
        }
        boolean isUnkeyedConfig = fileName.equals("config") || fileName.equals("messages") || fileName.equals("materials");
        boolean loadDefaults = mainConfiguration.getBoolean("load_default_" + fileName, loadAllDefaults);
        boolean disableDefaults = mainConfiguration.getBoolean("disable_default_" + fileName, false);
        ConfigurationSection mainSection = mainConfiguration.getConfigurationSection(fileName);
        ConfigurationSection overrides = this.loadOverrides(fileName);
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFilePrefix = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        YamlConfiguration config = new YamlConfiguration();
        YamlConfiguration defaultConfig = null;
        try {
            defaultConfig = CompatibilityLib.getCompatibilityUtils().loadBuiltinConfiguration(defaultsFileName);
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading file: " + defaultsFileName);
            throw ex;
        }
        String header = defaultConfig.options().header();
        if (loadDefaults) {
            this.info(" Based on defaults " + defaultsFileName);
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)defaultConfig);
        }
        if (usingExample && loadDefaults) {
            ConfigurationSection exampleConfig = this.loadExampleConfiguration(examplesFilePrefix, this.exampleDefaults);
            try {
                this.processInheritance(this.exampleDefaults, exampleConfig, fileName, this.getMainConfiguration(this.exampleDefaults));
                if (disableDefaults) {
                    this.addDisabled(this.exampleDefaults, exampleConfig);
                    this.info(" Using disabled " + examplesFilePrefix);
                } else {
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig);
                    this.info(" Using " + examplesFilePrefix);
                }
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading file: " + examplesFilePrefix);
                throw ex;
            }
        }
        if (mainSection != null) {
            ConfigurationUtils.addConfigurations(overrides, mainSection);
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                examplesFilePrefix = "examples/" + example + "/" + fileName;
                ConfigurationSection exampleConfig = this.loadExampleConfiguration(examplesFilePrefix, example);
                try {
                    this.processInheritance(example, exampleConfig, fileName, this.getMainConfiguration(example));
                    boolean override = exampleConfig.getBoolean("example_override", false);
                    exampleConfig.set("example_override", null);
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig, !isUnkeyedConfig || override);
                    this.info(" Added " + examplesFilePrefix + (override ? ", allowing overrides" : ""));
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading file: " + examplesFilePrefix);
                    throw ex;
                }
            }
        }
        this.addVersionConfigs((ConfigurationSection)config, fileName);
        boolean isMessages = fileName.equals("messages");
        if (isMessages) {
            this.processHelpTopics((ConfigurationSection)config);
        }
        if (isMessages && this.languageOverride != null && !this.languageOverride.isEmpty() && !this.languageOverride.equalsIgnoreCase("EN")) {
            String languageFilePrefix = "examples/localizations/messages." + this.languageOverride;
            ConfigurationSection languageConfig = this.loadExampleConfiguration(languageFilePrefix, "localizations", false);
            try {
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, languageConfig);
                this.info(" Using " + languageFilePrefix);
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading file: " + languageFilePrefix);
                throw ex;
            }
        }
        ConfigurationUtils.addConfigurations((ConfigurationSection)config, overrides, true, false, true);
        File configSubFolder = new File(this.configFolder, fileName);
        this.loadConfigFolder(fileName, (ConfigurationSection)config, configSubFolder);
        this.resolveDisabled((ConfigurationSection)config);
        File savedDefaults = new File(this.configFolder, defaultsFileName);
        if (this.saveDefaultConfigs) {
            try {
                config.options().header(header);
                config.save(savedDefaults);
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't write defaults file: " + defaultsFileName);
            }
        } else {
            this.deleteDefaults(defaultsFileName);
        }
        return config;
    }

    private void processHelpTopics(ConfigurationSection messagesConfig) {
        ConfigurationSection mainHelp = messagesConfig.getConfigurationSection("help");
        if (mainHelp == null) {
            mainHelp.set("help", (Object)this.helpTopics);
            return;
        }
        ConfigurationUtils.mergeText(mainHelp, this.helpTopics);
    }

    private void processMessageExample(ConfigurationSection example, boolean override) {
        ConfigurationSection exampleHelp = example.getConfigurationSection("help");
        if (exampleHelp == null) {
            return;
        }
        if (override) {
            ConfigurationUtils.addConfigurations(this.helpTopics, exampleHelp, true);
        } else {
            ConfigurationUtils.mergeText(this.helpTopics, exampleHelp);
        }
        example.set("help", null);
    }

    private ConfigurationSection loadLegacyConfigFile(String fileName, String modernFilename, ConfigurationSection mainConfiguration) {
        boolean loadAllDefaults = mainConfiguration.getBoolean("load_default_configs", true);
        boolean loadDefaults = mainConfiguration.getBoolean("load_default_" + modernFilename, loadAllDefaults);
        boolean disableDefaults = mainConfiguration.getBoolean("disable_default_" + modernFilename, false);
        ConfigurationSection mainSection = mainConfiguration.getConfigurationSection(fileName);
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFilePrefix = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName : null;
        YamlConfiguration config = new YamlConfiguration();
        if (usingExample && loadDefaults) {
            ConfigurationSection exampleConfig = this.loadExampleConfiguration(examplesFilePrefix, this.exampleDefaults);
            try {
                this.processInheritance(this.exampleDefaults, exampleConfig, fileName, this.getMainConfiguration(this.exampleDefaults));
                if (disableDefaults) {
                    this.addDisabled(this.exampleDefaults, exampleConfig);
                    this.info(" Using disabled " + examplesFilePrefix);
                } else {
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig);
                    this.info(" Using " + examplesFilePrefix);
                }
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading file: " + examplesFilePrefix);
                throw ex;
            }
        }
        if (mainSection != null) {
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, mainSection);
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                examplesFilePrefix = "examples/" + example + "/" + fileName;
                ConfigurationSection exampleConfig = this.loadExampleConfiguration(examplesFilePrefix, example);
                try {
                    this.processInheritance(example, exampleConfig, fileName, this.getMainConfiguration(example));
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig, false);
                    this.info(" Added " + examplesFilePrefix);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading file: " + examplesFilePrefix);
                    throw ex;
                }
            }
        }
        return config;
    }

    private void addVersionConfigs(ConfigurationSection config, String fileName) throws InvalidConfigurationException, IOException {
        int[] serverVersion = CompatibilityLib.getServerVersion(this.plugin);
        int majorVersion = serverVersion[0];
        int minorVersion = serverVersion[1];
        String versionExample = majorVersion + "." + minorVersion;
        String versionFileName = "examples/versions/" + versionExample + "/" + fileName + ".yml";
        InputStream versionInput = this.plugin.getResource(versionFileName);
        if (versionInput != null) {
            try {
                YamlConfiguration versionConfig = CompatibilityLib.getCompatibilityUtils().loadConfiguration(versionInput, versionFileName);
                if (fileName.equals("config")) {
                    this.mainConfigurations.put(versionExample, (ConfigurationSection)versionConfig);
                }
                this.processInheritance(versionExample, (ConfigurationSection)versionConfig, fileName, this.getMainConfiguration(versionExample));
                ConfigurationUtils.addConfigurations(config, (ConfigurationSection)versionConfig, true, true);
                this.getLogger().info(" Using compatibility configs: " + versionFileName);
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading file: " + versionFileName);
                throw ex;
            }
        } else {
            ConfigurationSection versionConfig = ConfigurationUtils.newConfigurationSection();
            this.processInheritance(versionExample, versionConfig, fileName, this.getMainConfiguration(versionExample));
            if (!versionConfig.getKeys(false).isEmpty()) {
                ConfigurationUtils.addConfigurations(config, versionConfig, true, true);
                this.getLogger().info(" Using inherited compatibility configs for: " + versionFileName);
            }
        }
    }

    private void deleteDefaults(String defaultsFileName) {
        File savedDefaults = new File(this.configFolder, defaultsFileName);
        if (savedDefaults.exists()) {
            try {
                savedDefaults.delete();
                this.getLogger().info("Deleting defaults file: " + defaultsFileName + ", save_default_configs is false");
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't delete defaults file: " + defaultsFileName + ", contents may be outdated");
            }
        }
    }

    private void resolveDisabled(ConfigurationSection config) {
        for (ConfigurationSection disableConfigs : this.addDisabled.values()) {
            Set keys = disableConfigs.getKeys(false);
            for (String key : keys) {
                ConfigurationSection existing;
                ConfigurationSection disableConfig = disableConfigs.getConfigurationSection(key);
                if (disableConfig == null || (existing = config.getConfigurationSection(key)) != null) continue;
                disableConfig.set("enabled", (Object)false);
                config.set(key, (Object)disableConfig);
            }
        }
        this.addDisabled.clear();
    }

    private void addDisabled(String exampleKey, ConfigurationSection configuration) {
        this.addDisabled.put(exampleKey, configuration);
    }

    private ConfigurationSection loadConfigFolder(String fileType, ConfigurationSection config, File configSubFolder) throws IOException, InvalidConfigurationException {
        if (configSubFolder.exists()) {
            ArrayList<File> priorityFiles = new ArrayList<File>();
            File[] files = configSubFolder.listFiles();
            for (File file : files) {
                if (file.getName().startsWith(".")) continue;
                if (file.isDirectory()) {
                    config = this.loadConfigFolder(fileType, config, file);
                    continue;
                }
                if (!file.getName().endsWith(".yml")) continue;
                if (file.getName().startsWith("_")) {
                    priorityFiles.add(file);
                    continue;
                }
                try {
                    ConfigurationSection fileOverrides = this.loadConfiguration(fileType, file);
                    this.info(" Loading " + file.getName());
                    config = ConfigurationUtils.addConfigurations(config, fileOverrides, true, false, true);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + file.getName());
                    throw ex;
                }
            }
            for (File file : priorityFiles) {
                try {
                    ConfigurationSection fileOverrides = CompatibilityLib.getCompatibilityUtils().loadConfiguration(file);
                    this.info(" Loading " + file.getName());
                    config = ConfigurationUtils.addConfigurations(config, fileOverrides, true, false, true);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + file.getName());
                    throw ex;
                }
            }
        } else {
            configSubFolder.mkdir();
        }
        return config;
    }

    private ConfigurationSection mapSpells(ConfigurationSection spellConfiguration) {
        ConfigurationSection spellConfigs = ConfigurationUtils.newConfigurationSection();
        if (spellConfiguration == null) {
            return spellConfigs;
        }
        this.spellConfigurations.clear();
        this.baseSpellConfigurations.clear();
        Set spellKeys = spellConfiguration.getKeys(false);
        for (String key : spellKeys) {
            if (key.equals("default") || key.equals("override")) continue;
            ConfigurationSection spellNode = this.getSpellConfig(key, spellConfiguration);
            if (this.noPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)false);
            } else if (this.allPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)true);
            }
            spellConfigs.set(key, (Object)spellNode);
        }
        return spellConfigs;
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config) {
        return this.getSpellConfig(key, config, true);
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config, boolean addInherited) {
        this.resolvingKeys.clear();
        return this.getSpellConfig(key, config, addInherited, this.resolvingKeys);
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config, boolean addInherited, Set<String> resolving) {
        boolean processInherited;
        ConfigurationSection built;
        if (resolving.contains(key)) {
            this.getLogger().log(Level.WARNING, "Circular dependency detected in spell configs: " + StringUtils.join(resolving, (String)" -> ") + " -> " + key);
            return config;
        }
        resolving.add(key);
        if (addInherited ? (built = this.spellConfigurations.get(key)) != null : (built = this.baseSpellConfigurations.get(key)) != null) {
            return built;
        }
        ConfigurationSection spellNode = config.getConfigurationSection(key);
        if (spellNode == null) {
            this.getLogger().warning("Could not resolve spell " + key + " from inheritance path: " + StringUtils.join(resolving, (String)" -> "));
            return null;
        }
        spellNode = ConfigurationUtils.cloneConfiguration(spellNode);
        SpellKey spellKey = new SpellKey(key);
        String inheritFrom = spellNode.getString("inherit");
        if (inheritFrom != null && inheritFrom.equalsIgnoreCase("false")) {
            inheritFrom = null;
        }
        String upgradeInheritsFrom = null;
        if (spellKey.isVariant()) {
            if (!this.spellUpgradesEnabled) {
                return null;
            }
            int level = spellKey.getLevel();
            upgradeInheritsFrom = spellKey.getBaseKey();
            if (level != 2) {
                upgradeInheritsFrom = upgradeInheritsFrom + "|" + (level - 1);
            }
        }
        boolean bl = processInherited = addInherited && inheritFrom != null;
        if (processInherited || upgradeInheritsFrom != null) {
            if (processInherited && key.equals(inheritFrom)) {
                this.getLogger().warning("Spell " + key + " inherits from itself");
            } else if (processInherited) {
                ConfigurationSection inheritConfig = this.getSpellConfig(inheritFrom, config, true, resolving);
                if (inheritConfig != null) {
                    Boolean enabled = spellNode.contains("enabled") ? Boolean.valueOf(spellNode.getBoolean("enabled")) : null;
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, inheritConfig, false);
                    spellNode.set("enabled", (Object)enabled);
                } else {
                    this.getLogger().warning("Spell " + key + " inherits from unknown ancestor " + inheritFrom);
                }
            }
            if (upgradeInheritsFrom != null) {
                if (config.contains(upgradeInheritsFrom)) {
                    ConfigurationSection baseInheritConfig = this.getSpellConfig(upgradeInheritsFrom, config, inheritFrom == null, resolving);
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, baseInheritConfig, inheritFrom != null);
                } else {
                    this.getLogger().warning("Spell upgrade " + key + " inherits from unknown level " + upgradeInheritsFrom);
                }
            }
        } else {
            ConfigurationSection defaults = config.getConfigurationSection("default");
            if (defaults != null) {
                spellNode = ConfigurationUtils.addConfigurations(spellNode, defaults, false);
            }
        }
        if (addInherited) {
            this.spellConfigurations.put(key, spellNode);
        } else {
            this.baseSpellConfigurations.put(key, spellNode);
        }
        ConfigurationSection override = config.getConfigurationSection("override");
        if (override != null) {
            spellNode = ConfigurationUtils.addConfigurations(spellNode, override, true);
        }
        return spellNode;
    }

    private void run(boolean synchronous) {
        this.success = true;
        MagicLogger logger = this.controller.getLogger();
        try {
            this.mainConfiguration = new MagicConfiguration(this.controller, this.loadMainConfiguration(), "config");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading config.yml", ex);
            this.success = false;
            this.mainConfiguration = ConfigurationUtils.newConfigurationSection();
        }
        this.mainConfigurations.put("", this.mainConfiguration);
        this.loadedConfigurations.clear();
        for (String configurationFile : CONFIG_FILES) {
            try {
                ConfigurationSection configuration = this.loadConfigFile(configurationFile, this.mainConfiguration);
                if (configurationFile.equals("blocks")) {
                    ConfigurationSection legacyConfig = this.loadLegacyConfigFile("automata", "blocks", this.mainConfiguration);
                    configuration = ConfigurationUtils.addConfigurations(configuration, legacyConfig, false);
                }
                if (configurationFile.equals("spells")) {
                    configuration = this.mapSpells(configuration);
                }
                this.loadedConfigurations.put(configurationFile, configuration);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error loading " + configurationFile, ex);
                this.loadedConfigurations.put(configurationFile, ConfigurationUtils.newConfigurationSection());
                this.success = false;
            }
        }
        if (synchronous) {
            this.controller.finalizeLoad(this, this.sender);
        } else {
            MagicPlugin plugin = this.controller.getPlugin();
            final ConfigurationLoadTask result = this;
            plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    ConfigurationLoadTask.this.controller.finalizeLoad(result, ConfigurationLoadTask.this.sender);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = loadLock;
        synchronized (object) {
            this.run(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow() {
        Object object = loadLock;
        synchronized (object) {
            this.run(true);
        }
    }

    public ConfigurationSection getMainConfiguration() {
        return this.mainConfiguration;
    }

    @Nonnull
    public ConfigurationSection getMainConfiguration(String exampleKey) {
        ConfigurationSection mainConfig = this.mainConfigurations.get(exampleKey);
        if (mainConfig == null) {
            mainConfig = ConfigurationUtils.newConfigurationSection();
            this.mainConfigurations.put(exampleKey, mainConfig);
        }
        return mainConfig;
    }

    public ConfigurationSection getMessages() {
        return this.loadedConfigurations.get("messages");
    }

    public ConfigurationSection getMaterials() {
        return this.loadedConfigurations.get("materials");
    }

    public ConfigurationSection getWands() {
        return this.loadedConfigurations.get("wands");
    }

    public ConfigurationSection getPaths() {
        return this.loadedConfigurations.get("paths");
    }

    public ConfigurationSection getCrafting() {
        return this.loadedConfigurations.get("crafting");
    }

    public ConfigurationSection getMobs() {
        return this.loadedConfigurations.get("mobs");
    }

    public ConfigurationSection getItems() {
        return this.loadedConfigurations.get("items");
    }

    public ConfigurationSection getClasses() {
        return this.loadedConfigurations.get("classes");
    }

    public ConfigurationSection getModifiers() {
        return this.loadedConfigurations.get("modifiers");
    }

    public ConfigurationSection getAttributes() {
        return this.loadedConfigurations.get("attributes");
    }

    public ConfigurationSection getBlocks() {
        ConfigurationSection legacyConfig = this.loadedConfigurations.get("automata");
        ConfigurationSection newConfig = this.loadedConfigurations.get("blocks");
        return ConfigurationUtils.addConfigurations(newConfig, legacyConfig, false);
    }

    public ConfigurationSection getEffects() {
        return this.loadedConfigurations.get("effects");
    }

    public ConfigurationSection getSpells() {
        return this.loadedConfigurations.get("spells");
    }

    public ConfigurationSection getWorlds() {
        return this.loadedConfigurations.get("worlds");
    }

    public ConfigurationSection getKits() {
        return this.loadedConfigurations.get("kits");
    }

    public ConfigurationSection getArenas() {
        return this.loadedConfigurations.get("arenas");
    }

    public ConfigurationSection getIcons() {
        return this.loadedConfigurations.get("icons");
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public String getExampleDefaults() {
        return this.exampleDefaults;
    }

    public Collection<String> getAddExamples() {
        return this.addExamples;
    }

    public Map<String, String> getExampleKeyNames() {
        return this.exampleKeyNames;
    }
}

