/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.effect.EffectContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageContext;
import com.elmakers.mine.bukkit.slikey.effectlib.util.MathUtils;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class SourceLocation {
    private LocationType locationType;
    private boolean orientToTarget;
    private boolean isSource;

    @Nullable
    public static SourceLocation tryCreate(Object locationType, boolean isSource) {
        if (locationType instanceof String) {
            return SourceLocation.tryCreate((String)locationType, isSource);
        }
        return null;
    }

    @Nullable
    public static SourceLocation tryCreate(String locationTypeString, boolean isSource) {
        if (locationTypeString != null && !locationTypeString.isEmpty()) {
            try {
                LocationType locationType = LocationType.valueOf(locationTypeString.toUpperCase());
                return new SourceLocation(locationType, isSource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected SourceLocation(LocationType locationType, boolean isSource) {
        this.locationType = locationType;
        this.isSource = isSource;
    }

    public SourceLocation(ConfigurationSection configuration) {
        this(configuration, "source_location", true);
    }

    public SourceLocation(String locationTypeString, boolean isSource) {
        this.isSource = isSource;
        if (!locationTypeString.isEmpty()) {
            try {
                this.locationType = LocationType.valueOf(locationTypeString.toUpperCase());
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid location type specified in source_location parameter: " + locationTypeString);
            }
        }
    }

    public SourceLocation(ConfigurationSection configuration, String sourceKey, boolean isSource) {
        this(configuration.getString(sourceKey, ""), isSource);
        if (this.locationType == null) {
            if (configuration.getBoolean("use_block_location", false)) {
                this.locationType = LocationType.BLOCK;
            } else if (configuration.getBoolean("use_eye_location", false)) {
                this.locationType = LocationType.EYES;
            } else if (configuration.getBoolean("use_cast_location", false)) {
                this.locationType = LocationType.CAST;
            } else if (isSource) {
                if (configuration.getBoolean("use_hit_location", false)) {
                    this.locationType = LocationType.HIT;
                } else if (configuration.getBoolean("use_wand_location", true)) {
                    this.locationType = LocationType.WAND;
                } else if (configuration.getBoolean("use_eye_location", true)) {
                    this.locationType = LocationType.EYES;
                }
            } else if (configuration.getBoolean("use_wand_location", false)) {
                this.locationType = LocationType.WAND;
            } else if (configuration.getBoolean("use_hit_location", true)) {
                this.locationType = LocationType.HIT;
            } else if (configuration.getBoolean("use_eye_location", true)) {
                this.locationType = LocationType.EYES;
            }
            if (this.locationType == null) {
                this.locationType = LocationType.FEET;
            }
        }
        this.orientToTarget = configuration.getBoolean("use_target_location", configuration.getBoolean("orient", isSource));
        if (configuration.getBoolean("reorient", false)) {
            this.orientToTarget = false;
        }
    }

    @Nullable
    public Block getBlock(EffectContext context) {
        Location location = this.getLocation(context);
        return location == null ? null : location.getBlock();
    }

    @Nullable
    public Location getLocation(EffectContext context) {
        Vector direction;
        Entity entity;
        Location blockLocation;
        Location feetLocation;
        Location eyeLocation;
        Mage mage;
        if (this.isSource) {
            mage = context instanceof MageContext ? ((MageContext)context).getMage() : null;
            eyeLocation = context.getEyeLocation();
            feetLocation = context.getLocation();
            blockLocation = context.getLocation();
        } else {
            blockLocation = context.getTargetLocation();
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity == null) {
                mage = null;
                feetLocation = context.getTargetLocation();
                eyeLocation = context.getTargetLocation();
            } else {
                mage = context.getController().getRegisteredMage(targetEntity);
                feetLocation = targetEntity.getLocation();
                Location location = eyeLocation = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).getEyeLocation() : targetEntity.getLocation();
            }
        }
        if (mage == null && (this.locationType == LocationType.CAST || this.locationType == LocationType.WAND)) {
            this.locationType = LocationType.EYES;
        }
        Location location = null;
        switch (this.locationType) {
            case CAST: {
                if (this.isSource) {
                    location = context.getCastLocation();
                    break;
                }
                location = mage.getCastLocation();
                break;
            }
            case HEAD: 
            case EYES: {
                location = eyeLocation;
                break;
            }
            case FEET: {
                location = feetLocation;
                break;
            }
            case WAND: {
                if (this.isSource) {
                    location = context.getWandLocation();
                    break;
                }
                location = mage.getWandLocation();
                break;
            }
            case BODY: {
                if (eyeLocation == null || feetLocation == null) break;
                location = eyeLocation.clone().add(feetLocation).multiply(0.5);
                break;
            }
            case HIT: {
                location = context.getTargetLocation();
                break;
            }
            case BLOCK: {
                if (blockLocation == null) break;
                location = blockLocation.getBlock().getLocation();
                break;
            }
            case BLOCK_CENTER: {
                if (blockLocation == null) break;
                location = blockLocation.getBlock().getLocation().add(0.5, 0.5, 0.5);
            }
        }
        if (location == null) {
            location = feetLocation;
        }
        Location targetLocation = this.isSource ? context.getTargetLocation() : context.getLocation();
        boolean doOrient = this.orientToTarget;
        if (doOrient && CompatibilityConstants.USE_METADATA_LOCATIONS && mage != null && (entity = mage.getEntity()) != null && entity.hasMetadata("head.pos")) {
            doOrient = false;
        }
        if (doOrient && targetLocation != null && location != null && MathUtils.isFinite((direction = targetLocation.toVector().subtract(location.toVector()).normalize()).getX()) && MathUtils.isFinite(direction.getY()) && MathUtils.isFinite(direction.getZ())) {
            location.setDirection(direction);
        }
        return location;
    }

    public boolean shouldUseWandLocation() {
        return this.locationType == LocationType.WAND;
    }

    public boolean shouldUseCastLocation() {
        return this.locationType == LocationType.CAST;
    }

    public boolean shouldUseEyeLocation() {
        return this.locationType == LocationType.EYES || this.locationType == LocationType.HEAD;
    }

    public boolean shouldUseHitLocation() {
        return this.locationType == LocationType.HIT;
    }

    public boolean shouldUseBlockLocation() {
        return this.locationType == LocationType.BLOCK;
    }

    public static enum LocationType {
        CAST,
        EYES,
        HEAD,
        FEET,
        WAND,
        BODY,
        HIT,
        BLOCK,
        BLOCK_CENTER;

    }
}

