/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.event.AddSpellEvent;
import com.elmakers.mine.bukkit.api.event.SpellUpgradeEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandLevel;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public abstract class CasterProperties
extends BaseMagicConfigurable
implements com.elmakers.mine.bukkit.api.magic.CasterProperties {
    protected static int LEGACY_VERSION = 6;
    protected static int CURRENT_VERSION = 7;
    public static final float DEFAULT_SPELL_COLOR_MIX_WEIGHT = 1.0E-4f;
    private float effectColorSpellMixWeight = 1.0E-4f;
    protected float effectiveManaMax = 0.0f;
    protected float effectiveManaRegeneration = 0.0f;
    private Map<PotionEffectType, Integer> potionEffects = new HashMap<PotionEffectType, Integer>();
    private ColorHD effectColor = null;

    public static void setLegacyVersion() {
        CURRENT_VERSION = LEGACY_VERSION;
    }

    public CasterProperties(MagicPropertyType type, MageController controller) {
        super(type, controller);
    }

    public boolean hasOwnMana() {
        MagicPropertyType propertyType = (MagicPropertyType)((Object)this.propertyRoutes.get("mana"));
        return propertyType == null || propertyType == this.type;
    }

    @Override
    public int getManaRegeneration() {
        ManaController manaController = this.getManaController();
        if (manaController != null && this.isPlayer()) {
            return (int)Math.ceil(manaController.getManaRegen(this.getPlayer()));
        }
        return this.getInt("mana_regeneration", this.getInt("xp_regeneration"));
    }

    @Override
    public int getManaMax() {
        ManaController manaController = this.getManaController();
        if (manaController != null && this.isPlayer()) {
            return (int)Math.ceil(manaController.getMaxMana(this.getPlayer()));
        }
        return this.getInt("mana_max", this.getInt("xp_max"));
    }

    @Override
    public void setMana(float mana) {
        if (this.isCostFree()) {
            this.setProperty("mana", null);
        } else {
            ManaController manaController = this.getManaController();
            if (manaController != null && this.isPlayer()) {
                manaController.setMana(this.getPlayer(), mana);
                return;
            }
            this.setProperty("mana", Float.valueOf(Math.max(0.0f, mana)));
        }
    }

    @Override
    @Deprecated
    public void setManaMax(int manaMax) {
        this.setManaMax((float)manaMax);
    }

    @Override
    public void setManaMax(float manaMax) {
        this.setProperty("mana_max", Float.valueOf(Math.max(0.0f, manaMax)));
    }

    @Override
    @Deprecated
    public void setManaRegeneration(int manaRegeneration) {
        this.setManaRegeneration((float)manaRegeneration);
    }

    @Override
    public void setManaRegeneration(float manaRegeneration) {
        this.setProperty("mana_regeneration", Float.valueOf(Math.max(0.0f, manaRegeneration)));
    }

    @Override
    public float getMana() {
        ManaController manaController = this.getManaController();
        if (manaController != null && this.isPlayer()) {
            return (float)manaController.getMana(this.getPlayer());
        }
        return this.getFloat("mana", this.getFloat("xp"));
    }

    @Override
    public void removeMana(float amount) {
        ManaController manaController = this.getManaController();
        if (manaController != null && this.isPlayer()) {
            manaController.removeMana(this.getPlayer(), amount);
            return;
        }
        this.setMana(this.getMana() - amount);
    }

    public float getManaRegenerationBoost() {
        return this.getFloat("mana_regeneration_boost", this.getFloat("xp_regeneration_boost"));
    }

    public float getManaMaxBoost() {
        return this.getFloat("mana_max_boost", this.getFloat("xp_max_boost"));
    }

    @Override
    public boolean isCostFree() {
        return this.getFloat("cost_reduction") > 1.0f;
    }

    @Override
    public boolean isCooldownFree() {
        return this.getFloat("cooldown_reduction") > 1.0f;
    }

    @Override
    public boolean isConsumeFree() {
        return this.getFloat("consume_reduction") > 1.0f;
    }

    @Override
    public int getEffectiveManaMax() {
        ManaController manaController = this.getManaController();
        if (manaController != null && this.isPlayer()) {
            return (int)Math.ceil(manaController.getMaxMana(this.getPlayer()));
        }
        return (int)Math.ceil(this.effectiveManaMax);
    }

    @Override
    public int getEffectiveManaRegeneration() {
        ManaController manaController = this.getManaController();
        if (manaController != null && this.isPlayer()) {
            return (int)Math.ceil(manaController.getManaRegen(this.getPlayer()));
        }
        return (int)Math.ceil(this.effectiveManaRegeneration);
    }

    protected long getLastManaRegeneration() {
        return this.getLong("mana_timestamp");
    }

    public void passiveEffectsUpdated() {
    }

    public boolean updateMaxMana(Mage mage) {
        if (!this.usesMana()) {
            return false;
        }
        float currentMana = this.effectiveManaMax;
        float currentManaRegen = this.effectiveManaRegeneration;
        this.effectiveManaMax = this.getManaMax();
        this.effectiveManaRegeneration = this.getManaRegeneration();
        if (mage != null && this.getBoolean("boostable", true)) {
            this.effectiveManaMax = (int)(this.effectiveManaMax * mage.getManaMaxMultiplier());
            this.effectiveManaRegeneration = (int)(this.effectiveManaRegeneration * mage.getManaRegenerationMultiplier());
        }
        return currentMana != this.effectiveManaMax || this.effectiveManaRegeneration != currentManaRegen;
    }

    public boolean usesMana() {
        if (this.isCostFree()) {
            return false;
        }
        return this.getManaMax() > 0;
    }

    public boolean tickMana() {
        boolean updated = false;
        if (this.usesMana() && this.hasOwnMana()) {
            long now = System.currentTimeMillis();
            if (!this.getMage().isManaRegenerationDisabled()) {
                int effectiveManaRegeneration = this.getEffectiveManaRegeneration();
                long lastManaRegeneration = this.getLastManaRegeneration();
                if (lastManaRegeneration > 0L && effectiveManaRegeneration > 0) {
                    long delta = now - lastManaRegeneration;
                    int effectiveManaMax = this.getEffectiveManaMax();
                    int manaMax = this.getManaMax();
                    float mana = this.getMana();
                    if (effectiveManaMax == 0 && manaMax > 0) {
                        effectiveManaMax = manaMax;
                    }
                    this.setMana(Math.min((float)effectiveManaMax, mana + (float)effectiveManaRegeneration * (float)delta / 1000.0f));
                    updated = true;
                }
            }
            this.setProperty("mana_timestamp", now);
        }
        return updated;
    }

    public void tick() {
        this.tickMana();
    }

    @Override
    @Deprecated
    public boolean setSpelLLevel(String spellKey, int level) {
        return this.setSpellLevel(spellKey, level);
    }

    @Override
    public boolean setSpellLevel(String spellKey, int level) {
        BaseMagicConfigurable storage = this.getStorage("spell_levels");
        if (storage != this && storage != null && storage instanceof com.elmakers.mine.bukkit.api.magic.CasterProperties) {
            return ((com.elmakers.mine.bukkit.api.magic.CasterProperties)((Object)storage)).setSpellLevel(spellKey, level);
        }
        if (!this.hasSpell(spellKey)) {
            return false;
        }
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Integer existingLevel = spellLevels.get(spellKey);
        boolean modified = false;
        if (existingLevel == null || level != existingLevel) {
            modified = true;
            spellLevels.put(spellKey, level);
            this.setProperty("spell_levels", spellLevels);
        }
        return modified;
    }

    @Override
    public boolean addSpell(String spellKey) {
        int maxSpells = this.getMaxSpells();
        if (maxSpells > 0 && this.getSpells().size() >= maxSpells) {
            return false;
        }
        return this.forceAddSpell(spellKey);
    }

    @Override
    public boolean forceAddSpell(String spellKey) {
        BaseMagicConfigurable storage = this.getStorage("spells");
        if (storage != this && storage != null) {
            return storage.addSpell(spellKey);
        }
        SpellTemplate template = this.controller.getSpellTemplate(spellKey);
        if (template == null) {
            this.controller.getLogger().warning("Tried to add unknown spell: " + spellKey);
            return false;
        }
        spellKey = template.getKey();
        this.preUpdate();
        Set<String> spells = this.getBaseSpells();
        SpellKey key = new SpellKey(spellKey);
        SpellTemplate currentSpell = this.getSpellTemplate(spellKey);
        boolean modified = spells.add(key.getBaseKey());
        if (modified) {
            this.setProperty("spells", new ArrayList<String>(spells));
        }
        boolean levelModified = false;
        if (key.getLevel() > 1) {
            levelModified = this.upgradeSpellLevel(key.getBaseKey(), key.getLevel());
        }
        if (!modified && !levelModified) {
            return false;
        }
        Collection<SpellKey> spellsToRemove = template.getSpellsToRemove();
        for (SpellKey removeKey : spellsToRemove) {
            this.removeSpell(removeKey.getBaseKey());
        }
        Mage mage = this.getMage();
        if (mage != null) {
            if (currentSpell != null) {
                String levelDescription = template.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = template.getName();
                }
                this.sendLevelMessage("spell_upgraded", currentSpell.getName(), levelDescription);
                String upgradeDescription = template.getUpgradeDescription().replace("$name", currentSpell.getName());
                if (!upgradeDescription.isEmpty()) {
                    mage.sendMessage(this.controller.getMessages().get("spell.upgrade_description_prefix"), upgradeDescription);
                }
                if (!mage.isLoading()) {
                    SpellUpgradeEvent upgradeEvent = new SpellUpgradeEvent(mage, this.getWand(), currentSpell, template);
                    Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
                }
            } else {
                if (mage.getActiveGUI() == null && !template.isQuiet()) {
                    this.sendAddMessage("spell_added", template.getName());
                }
                if (!mage.isLoading()) {
                    AddSpellEvent addEvent = new AddSpellEvent(mage, this.getWand(), template);
                    Bukkit.getPluginManager().callEvent((Event)addEvent);
                }
            }
        }
        this.updated();
        return true;
    }

    @Override
    public boolean addBrush(String brushKey) {
        BaseMagicConfigurable storage = this.getStorage("brushes");
        if (storage != this && storage != null) {
            return storage.addBrush(brushKey);
        }
        this.preUpdate();
        Collection brushes = this.getBrushes();
        boolean modified = brushes.add(brushKey);
        if (modified) {
            this.setProperty("brushes", new ArrayList(brushes));
        }
        Mage mage = this.getMage();
        if (modified && mage != null) {
            Messages messages = this.controller.getMessages();
            String materialName = MaterialBrush.getMaterialName(messages, brushKey);
            if (materialName == null) {
                mage.getController().getLogger().warning("Invalid material: " + brushKey);
                materialName = brushKey;
            }
            this.sendAddMessage("brush_added", materialName);
        }
        if (modified) {
            this.updated();
        }
        return modified;
    }

    public boolean removeSpell(String spellKey) {
        this.preUpdate();
        Set<String> spells = this.getBaseSpells();
        SpellKey key = new SpellKey(spellKey);
        boolean modified = spells.remove(key.getBaseKey());
        if (modified) {
            this.setProperty("spells", new ArrayList<String>(spells));
            Map<String, Integer> spellLevels = this.getSpellLevels();
            if (spellLevels.remove(key.getBaseKey()) != null) {
                this.setProperty("spell_levels", spellLevels);
            }
            this.updated();
        }
        return modified;
    }

    public boolean removeBrush(String brushKey) {
        this.preUpdate();
        Collection brushes = this.getBrushes();
        boolean modified = brushes.remove(brushKey);
        if (modified) {
            this.setProperty("brushes", new ArrayList(brushes));
            this.updated();
        }
        return modified;
    }

    @Override
    public int getSpellLevel(String spellKey) {
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Integer level = spellLevels.get(spellKey);
        return level == null ? 1 : level;
    }

    @Override
    @Nullable
    public SpellTemplate getSpellTemplate(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        Set<String> spells = this.getBaseSpells();
        if (!spells.contains(key.getBaseKey())) {
            return null;
        }
        SpellKey baseKey = new SpellKey(key.getBaseKey(), this.getSpellLevel(key.getBaseKey()));
        return this.controller.getSpellTemplate(baseKey.getKey());
    }

    public void updateMana() {
    }

    @Override
    public boolean hasBrush(String key) {
        return !this.getBrushes().contains(key);
    }

    @Override
    public boolean hasSpell(String key) {
        SpellKey spellKey = new SpellKey(key);
        if (!this.getBaseSpells().contains(spellKey.getBaseKey())) {
            return false;
        }
        int level = this.getSpellLevel(spellKey.getBaseKey());
        return level >= spellKey.getLevel();
    }

    public Set<String> getBaseSpells() {
        Object existingSpells = this.getObject("spells");
        HashSet<String> spells = new HashSet<String>();
        if (existingSpells != null) {
            if (!(existingSpells instanceof List)) {
                this.controller.getLogger().warning("Spell list in " + (Object)((Object)this.type) + " is " + existingSpells.getClass().getName() + ", expected List");
            } else {
                List existingList = (List)existingSpells;
                spells.addAll(existingList);
            }
        }
        return spells;
    }

    public Set<String> getSpells() {
        HashSet<String> spellSet = new HashSet<String>();
        Set<String> spells = this.getBaseSpells();
        Map<String, Integer> spellLevels = this.getSpellLevels();
        for (String key : spells) {
            Integer level = spellLevels.get(key);
            if (level != null) {
                spellSet.add(new SpellKey(key, level).getKey());
                continue;
            }
            spellSet.add(key);
        }
        return spellSet;
    }

    @Override
    @Nullable
    public Spell getSpell(String spellKey) {
        Mage mage = this.getMage();
        if (mage == null) {
            return null;
        }
        SpellKey key = new SpellKey(spellKey);
        spellKey = key.getBaseKey();
        Set<String> spells = this.getBaseSpells();
        if (!spells.contains(spellKey)) {
            return null;
        }
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Integer level = spellLevels.get(spellKey);
        if (level != null) {
            spellKey = new SpellKey(spellKey, level).getKey();
        }
        return mage.getSpell(spellKey);
    }

    public Set<String> getBrushes() {
        Object existingBrushes = this.getObject("brushes");
        HashSet<String> brushes = new HashSet<String>();
        if (existingBrushes != null) {
            if (!(existingBrushes instanceof List)) {
                this.controller.getLogger().warning("Brush list in " + (Object)((Object)this.type) + " is " + existingBrushes.getClass().getName() + ", expected List");
            } else {
                List existingList = (List)existingBrushes;
                brushes.addAll(existingList);
            }
        }
        return brushes;
    }

    @Override
    @Nullable
    public ProgressionPath getPath() {
        String pathKey = this.getString("path");
        if (pathKey != null && !pathKey.isEmpty()) {
            return this.controller.getPath(pathKey);
        }
        return null;
    }

    @Override
    public void setPath(String path) {
        this.setProperty("path", path);
    }

    @Override
    public int getLevel() {
        return this.getInt("level", 1);
    }

    @Override
    public boolean canProgress() {
        ProgressionPath path = this.getPath();
        return path != null && path.canProgress(this);
    }

    protected float stackPassiveProperty(float property, float stackProperty) {
        boolean stack = this.getBoolean("stack");
        if (!stack && stackProperty != 0.0f) {
            property = Math.max(property, stackProperty);
        }
        return property;
    }

    @Override
    protected boolean upgradeInternal(String key, Object value) {
        if (key.equals("path")) {
            ProgressionPath path = this.getPath();
            if (path != null && path.hasPath(value.toString())) {
                return false;
            }
            this.setProperty(key, value);
            return true;
        }
        return super.upgradeInternal(key, value);
    }

    @Override
    @Nullable
    public Double getAttribute(String attributeKey) {
        MagicAttribute defaultSetting;
        Double value;
        ConfigurationSection attributes = this.getConfigurationSection("attributes");
        Double d = value = attributes == null || !attributes.contains(attributeKey) ? null : Double.valueOf(attributes.getDouble(attributeKey));
        if (value == null && (defaultSetting = this.controller.getAttribute(attributeKey)) != null) {
            value = defaultSetting.getDefault();
        }
        return value;
    }

    @Override
    public void setAttribute(String attributeKey, Double attributeValue) {
        this.preUpdate();
        ConfigurationSection attributes = this.getConfigurationSection("attributes");
        if (attributes == null) {
            if (attributeValue == null) {
                return;
            }
            attributes = ConfigurationUtils.newConfigurationSection();
        }
        attributes.set(attributeKey, (Object)attributeValue);
        this.setProperty("attributes", attributes);
        Mage mage = this.getMage();
        if (mage != null) {
            mage.attributesUpdated();
        }
        this.updated();
    }

    protected void cleanSlottedUpgradeConfig(ConfigurationSection upgradeConfig) {
        this.cleanUpgradeConfig(upgradeConfig, true);
    }

    protected void cleanUpgradeConfig(ConfigurationSection upgradeConfig) {
        this.cleanUpgradeConfig(upgradeConfig, false);
    }

    protected void cleanUpgradeConfig(ConfigurationSection upgradeConfig, boolean slotted) {
        upgradeConfig.set("id", null);
        upgradeConfig.set("indestructible", null);
        upgradeConfig.set("upgrade", null);
        upgradeConfig.set("icon", null);
        upgradeConfig.set("upgrade_icon", null);
        upgradeConfig.set("legacy_icon", null);
        upgradeConfig.set("legacy_upgrade_icon", null);
        upgradeConfig.set("template", null);
        upgradeConfig.set("description", null);
        upgradeConfig.set("name", null);
        upgradeConfig.set("lore", null);
        if (slotted) {
            upgradeConfig.set("mana", null);
        }
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand wandUpgrade) {
        if (!(wandUpgrade instanceof Wand)) {
            return false;
        }
        Wand wand = (Wand)wandUpgrade;
        ConfigurationSection upgradeConfig = ConfigurationUtils.cloneConfiguration(wand.getEffectiveConfiguration());
        this.cleanUpgradeConfig(upgradeConfig);
        return this.upgrade(upgradeConfig);
    }

    @Override
    public boolean addItem(ItemStack item) {
        CurrencyAmount currency;
        if (Wand.isAbsorbable(item)) {
            if (Wand.isSpell(item) && !Wand.isSkill(item)) {
                String spell = Wand.getSpell(item);
                SpellKey spellKey = new SpellKey(spell);
                Integer spellLevel = null;
                if (this.hasSpell(spellKey.getBaseKey())) {
                    spellLevel = this.getSpellLevel(spellKey.getBaseKey());
                }
                if ((spellLevel == null || spellLevel < spellKey.getLevel()) && this.addSpell(spell)) {
                    return true;
                }
            } else if (Wand.isBrush(item)) {
                String materialKey = Wand.getBrush(item);
                Collection materials = this.getBrushes();
                if (!materials.contains(materialKey) && this.addBrush(materialKey)) {
                    return true;
                }
            }
        }
        if (Wand.isUpgrade(item)) {
            Wand wand = this.controller.getWand(item);
            return this.add(wand);
        }
        Mage mage = this.getMage();
        if (mage != null && (currency = CompatibilityLib.getInventoryUtils().getCurrencyAmount(item)) != null && !mage.isAtMaxCurrency(currency.getType())) {
            int amount = (int)Math.floor(mage.getEarnMultiplier(currency.getType()) * (double)currency.getAmount() * (double)item.getAmount());
            mage.addCurrency(currency.getType(), amount);
            return true;
        }
        return false;
    }

    protected void sendLevelMessage(String messageKey, String nameParam, String level) {
        Mage mage = this.getMage();
        if (mage == null || nameParam == null || nameParam.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$name", nameParam).replace("$level", level);
        mage.sendMessage(message);
    }

    @Override
    protected void sendAddMessage(String messageKey, String nameParam) {
        Mage mage = this.getMage();
        if (mage == null || nameParam == null || nameParam.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$name", nameParam);
        mage.sendMessage(message);
    }

    @Override
    protected void sendMessage(String messageKey) {
        Mage mage = this.getMage();
        if (mage == null || messageKey == null || messageKey.isEmpty()) {
            return;
        }
        mage.sendMessage(this.getMessage(messageKey));
    }

    @Override
    public void sendMessageKey(String messageKey, String ... parameters) {
        Mage mage = this.getMage();
        if (mage == null || messageKey == null || messageKey.isEmpty()) {
            return;
        }
        String message = this.getMessage(messageKey);
        if (parameters != null) {
            for (int i = 0; i < parameters.length - 1; ++i) {
                message = message.replace(parameters[i], parameters[i + 1]);
            }
        }
        mage.sendMessage(message);
    }

    @Override
    protected void sendDebug(String debugMessage) {
        Mage mage = this.getMage();
        if (mage != null) {
            mage.sendDebugMessage(debugMessage);
        }
    }

    @Nullable
    protected Wand getWand() {
        return null;
    }

    public abstract boolean isPlayer();

    @Nullable
    public abstract Player getPlayer();

    @Override
    @Nullable
    public abstract Mage getMage();

    @Override
    public MageController getController() {
        return this.controller;
    }

    protected void migrateBrushes(ConfigurationSection configuration) {
        Object brushesRaw;
        Object brushInventoryRaw = configuration.get("brush_inventory");
        if (brushInventoryRaw != null) {
            Map<String, Object> brushInventory = null;
            HashMap<String, Integer> newBrushInventory = new HashMap<String, Integer>();
            if (brushInventoryRaw instanceof Map) {
                brushInventory = (Map<String, Object>)brushInventoryRaw;
            } else if (brushInventoryRaw instanceof ConfigurationSection) {
                brushInventory = CompatibilityLib.getCompatibilityUtils().getMap((ConfigurationSection)brushInventoryRaw);
            }
            if (brushInventory != null) {
                for (Map.Entry brushEntry : brushInventory.entrySet()) {
                    Object slot = brushEntry.getValue();
                    if (slot == null || !(slot instanceof Integer)) continue;
                    String materialKey = (String)brushEntry.getKey();
                    materialKey = CompatibilityLib.getCompatibilityUtils().migrateMaterial(materialKey);
                    newBrushInventory.put(materialKey, (Integer)slot);
                }
                configuration.set("brush_inventory", newBrushInventory);
            }
        }
        if ((brushesRaw = this.getObject("brushes", this.getObject("materials"))) != null) {
            List<String> brushes = null;
            if (brushesRaw instanceof String) {
                String[] brushNames = StringUtils.split((String)((String)brushesRaw), (char)',');
                brushes = Arrays.asList(brushNames);
            } else if (brushesRaw instanceof Collection) {
                brushes = (List<String>)brushesRaw;
            }
            if (brushes != null) {
                configuration.set("brushes", new ArrayList<String>(brushes));
            }
        }
    }

    protected void migrate(int version, ConfigurationSection configuratoin) {
        if (version <= 6) {
            this.migrateBrushes(configuratoin);
        }
        configuratoin.set("version", (Object)CURRENT_VERSION);
    }

    @Override
    public void load(@Nullable ConfigurationSection configuration) {
        int version = configuration.getInt("version", 0);
        if (version < CURRENT_VERSION) {
            this.migrate(version, configuration);
        }
        super.load(configuration);
    }

    @Override
    public boolean upgradesAllowed() {
        return true;
    }

    @Override
    public boolean checkAndUpgrade(boolean quiet) {
        ProgressionPath nextPath;
        ProgressionPath path = this.getPath();
        ProgressionPath progressionPath = nextPath = path != null ? path.getNextPath() : null;
        if (nextPath == null) {
            return true;
        }
        if (this.canProgress()) {
            return true;
        }
        if (!path.checkUpgradeRequirements(this.getWand(), quiet ? null : this.getMage())) {
            return false;
        }
        path.upgrade(this.getMage(), this.getWand());
        return true;
    }

    public String getName() {
        return "";
    }

    @Override
    public int randomize(int totalLevels, boolean addSpells) {
        Mage mage = this.getMage();
        Wand wand = this instanceof Wand ? (Wand)this : (mage == null ? null : mage.getActiveWand());
        ProgressionPath checkPath = this.getPath();
        if (checkPath == null || !(checkPath instanceof WandUpgradePath)) {
            if (mage != null && addSpells) {
                mage.sendMessage(this.getMessage("no_path").replace("$wand", this.getName()));
            }
            return 0;
        }
        WandUpgradePath path = (WandUpgradePath)checkPath;
        int minLevel = path.getMinLevel();
        if (totalLevels < minLevel) {
            if (mage != null && addSpells) {
                String levelMessage = this.getMessage("need_more_levels");
                levelMessage = levelMessage.replace("$levels", Integer.toString(minLevel));
                mage.sendMessage(levelMessage);
            }
            return 0;
        }
        int maxLevel = path.getMaxLevel();
        totalLevels = Math.min(totalLevels, maxLevel * 50);
        int addLevels = Math.min(totalLevels, maxLevel);
        int levels = 0;
        boolean modified = true;
        while (addLevels >= minLevel && modified) {
            WandUpgradePath nextPath;
            boolean hasUpgrade = path.hasUpgrade();
            WandLevel level = path.getLevel(addLevels);
            if (!path.canProgress(this) && (path.hasSpells() || path.hasMaterials())) {
                nextPath = path.getUpgrade();
                if (nextPath != null) {
                    if (!path.checkUpgradeRequirements(this, !addSpells) || wand == null && mage == null) break;
                    path.upgrade((com.elmakers.mine.bukkit.api.wand.Wand)wand, mage);
                    break;
                }
                if (mage == null || !addSpells) break;
                mage.sendMessage(this.getMessage("fully_enchanted").replace("$wand", this.getName()));
                break;
            }
            modified = level.randomize(mage, this, hasUpgrade, addSpells);
            totalLevels -= maxLevel;
            if (modified) {
                if (mage != null) {
                    path.enchanted(mage);
                }
                levels += addLevels;
                nextPath = path.getUpgrade();
                if (nextPath != null && path.checkUpgradeRequirements(this, true) && !path.canProgress(this)) {
                    path.upgrade((com.elmakers.mine.bukkit.api.wand.Wand)wand, mage);
                    path = nextPath;
                }
            } else if (path.canProgress(this)) {
                if (mage != null && levels == 0 && addSpells) {
                    String message = this.getMessage("require_more_levels");
                    mage.sendMessage(message);
                }
            } else if (hasUpgrade) {
                if (path.checkUpgradeRequirements(this, !addSpells)) {
                    if (wand != null || mage != null) {
                        path.upgrade((com.elmakers.mine.bukkit.api.wand.Wand)wand, mage);
                    }
                    levels += addLevels;
                }
            } else if (mage != null && addSpells) {
                mage.sendMessage(this.getMessage("fully_enchanted").replace("$wand", this.getName()));
            }
            addLevels = Math.min(totalLevels, maxLevel);
        }
        return levels;
    }

    @Nullable
    public Map<String, String> getOverrides() {
        Object overridesGeneric;
        HashMap<String, String> castOverrides = null;
        if (this.hasProperty("overrides") && (overridesGeneric = this.getObject("overrides")) != null) {
            castOverrides = new HashMap<String, String>();
            if (overridesGeneric instanceof String) {
                String overrides = (String)overridesGeneric;
                if (!overrides.isEmpty()) {
                    String[] pairs;
                    overrides = overrides.replaceAll("[\\]\\[]", "");
                    for (String override : pairs = StringUtils.split((String)overrides, (char)',')) {
                        this.parseOverride(override, castOverrides);
                    }
                }
            } else if (overridesGeneric instanceof List) {
                List overrideList = (List)overridesGeneric;
                for (String override : overrideList) {
                    this.parseOverride(override, castOverrides);
                }
            } else if (overridesGeneric instanceof ConfigurationSection) {
                ConfigurationSection overridesSection = (ConfigurationSection)overridesGeneric;
                Set keys = overridesSection.getKeys(true);
                for (String key : keys) {
                    Object leaf = overridesSection.get(key);
                    if (leaf instanceof ConfigurationSection || leaf instanceof Map) continue;
                    castOverrides.put(key, leaf.toString());
                }
            } else if (overridesGeneric instanceof Map) {
                Map cast = (Map)overridesGeneric;
                castOverrides.putAll(cast);
            }
        }
        return castOverrides;
    }

    private void parseOverride(String override, Map<String, String> castOverrides) {
        String[] keyValue = StringUtils.split((String)(override = override.replace("\\|", ",")), (String)" ", (int)2);
        if (keyValue.length > 0) {
            String value = keyValue.length > 1 ? keyValue[1] : "";
            castOverrides.put(keyValue[0], value);
        }
    }

    public void setOverrides(Map<String, String> overrides) {
        overrides = overrides != null && overrides.isEmpty() ? null : overrides;
        this.setProperty("overrides", overrides);
        this.updated();
    }

    public void removeOverride(String key) {
        Map<String, String> castOverrides = this.getOverrides();
        if (castOverrides != null) {
            castOverrides.remove(key);
            this.setOverrides(castOverrides);
        }
    }

    public void setOverride(String key, String value) {
        Map<String, String> castOverrides = this.getOverrides();
        if (castOverrides == null) {
            castOverrides = new HashMap<String, String>();
        }
        if (value == null || value.length() == 0) {
            castOverrides.remove(key);
        } else {
            castOverrides.put(key, value);
        }
        this.setOverrides(castOverrides);
    }

    @Override
    public boolean addOverride(String key, String value) {
        Map<String, String> castOverrides = this.getOverrides();
        if (castOverrides == null) {
            castOverrides = new HashMap<String, String>();
        }
        boolean modified = false;
        if (value == null || value.length() == 0) {
            modified = castOverrides.containsKey(key);
            castOverrides.remove(key);
        } else {
            String current = castOverrides.get(key);
            modified = current == null || !current.equals(value);
            castOverrides.put(key, value);
        }
        if (modified) {
            this.setOverrides(castOverrides);
        }
        return modified;
    }

    @Override
    public void loadProperties() {
        super.loadProperties();
        this.potionEffects.clear();
        if (this.hasProperty("potion_effects")) {
            ConfigurationSection effectConfig = this.getConfigurationSection("potion_effects");
            if (effectConfig != null) {
                this.addPotionEffects(this.potionEffects, effectConfig);
            } else {
                List<String> effectList = this.getStringList("potion_effects");
                if (effectList != null && !effectList.isEmpty()) {
                    this.addPotionEffects(this.potionEffects, effectList);
                } else {
                    this.addPotionEffects(this.potionEffects, this.getString("potion_effects"));
                }
            }
        }
        if (this.hasProperty("effect_color")) {
            this.setEffectColor(this.getString("effect_color"));
        }
    }

    public Map<PotionEffectType, Integer> getPotionEffects() {
        return this.potionEffects;
    }

    @Override
    @Nullable
    public String getEffectParticleName() {
        return this.getString("effect_particle");
    }

    public void setEffectColor(String hexColor) {
        if (hexColor == null || hexColor.length() == 0 || hexColor.equals("none")) {
            this.effectColor = null;
            return;
        }
        if (hexColor.contains(".")) {
            hexColor = hexColor.substring(0, hexColor.indexOf(46));
        }
        this.effectColor = new ColorHD(hexColor);
        if (hexColor.equals("random")) {
            this.setProperty("effect_color", this.effectColor.toString());
        }
    }

    @Override
    @Nullable
    public Color getEffectColor() {
        return this.effectColor == null ? null : this.effectColor.getColor();
    }

    protected void onCast(SpellTemplate spell) {
        Color spellColor = spell.getColor();
        if (spellColor != null && this.effectColor != null) {
            this.effectColor = this.effectColor.mixColor(spellColor, (double)this.effectColorSpellMixWeight);
            this.setProperty("effect_color", this.effectColor.toString());
        }
    }

    protected void discoverRecipes(String listKey) {
        List<String> recipes = this.getStringList(listKey);
        Mage mage = this.getMage();
        if (mage != null) {
            mage.discoverRecipes(recipes);
        }
    }

    @Override
    public void updated() {
        super.updated();
        Mage mage = this.getMage();
        if (mage != null) {
            mage.updatePassiveEffects();
        }
    }

    public boolean isPassive() {
        return this.getBoolean("passive");
    }

    @Nullable
    public ConfigurationSection getPathConfigurationSection(String key) {
        ConfigurationSection config = this.getPathPropertyConfiguration(key);
        return config == null ? null : config.getConfigurationSection(key);
    }

    @Nullable
    public ConfigurationSection getPathPropertyConfiguration(String key) {
        ConfigurationSection pathProperties;
        if (key.equals("path")) {
            return null;
        }
        ProgressionPath path = this.getPath();
        if (path != null && (pathProperties = path.getProperties()) != null && pathProperties.contains(key)) {
            return pathProperties;
        }
        return null;
    }

    @Override
    @Nonnull
    public ConfigurationSection getPropertyConfiguration(String key) {
        ConfigurationSection pathConfiguration = this.getPathPropertyConfiguration(key);
        if (pathConfiguration != null) {
            return pathConfiguration;
        }
        return super.getPropertyConfiguration(key);
    }

    @Override
    public boolean hasOwnProperty(String key) {
        ConfigurationSection pathProperties;
        ProgressionPath path;
        if (!key.equals("path") && this.getStorage("path") == this && (path = this.getPath()) != null && (pathProperties = path.getProperties()) != null && pathProperties.contains(key)) {
            return true;
        }
        return super.hasOwnProperty(key);
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties, @Nullable Set<String> overriddenProperties) {
        ConfigurationSection pathProperties;
        super.describe(sender, ignoreProperties, overriddenProperties);
        ProgressionPath path = this.getPath();
        if (path != null && (pathProperties = path.getProperties()) != null) {
            sender.sendMessage(ChatColor.GOLD + "Path Properties Override:");
            Set keys = pathProperties.getKeys(false);
            for (String key : keys) {
                Object value = pathProperties.get(key);
                if (value == null || ignoreProperties != null && ignoreProperties.contains(key)) continue;
                ChatColor propertyColor = ChatColor.YELLOW;
                sender.sendMessage(propertyColor.toString() + key + ChatColor.GRAY + ": " + ChatColor.WHITE + CasterProperties.describeProperty(value));
            }
        }
    }

    @Override
    public int getMaxSpells() {
        return this.getInt("max_spells");
    }

    private ManaController getManaController() {
        String manaClass = null;
        BaseMagicConfigurable storage = this.getStorage("mana_max");
        if (storage == null) {
            storage = this;
        }
        if (storage instanceof MageClass) {
            manaClass = ((MageClass)storage).getKey();
        }
        return this.controller.getManaController(manaClass);
    }

    public String getLevelString(String templateName, float amount) {
        return this.controller.getMessages().getLevelString(this.getMessageKey(templateName), amount);
    }

    public String getLevelString(String templateName, float amount, float max) {
        return this.controller.getMessages().getLevelString(this.getMessageKey(templateName), amount, max);
    }

    protected String getPropertyString(String templateName, float value) {
        return this.getPropertyString(templateName, value, 1.0f, false);
    }

    protected String getPropertyString(String templateName, float value, float max, boolean defaultStack) {
        String propertyTemplate;
        String string = propertyTemplate = this.getBoolean("stack", defaultStack) ? "property_stack" : "property_value";
        if (value < 0.0f) {
            propertyTemplate = propertyTemplate + "_negative";
        }
        return this.controller.getMessages().getPropertyString(this.getMessageKey(templateName), value, max, this.getMessageKey(propertyTemplate));
    }

    protected String formatPropertyString(String message, float value, float max) {
        String propertyTemplate;
        String string = propertyTemplate = this.getBoolean("stack") ? "property_stack" : "property_value";
        if (value < 0.0f) {
            propertyTemplate = propertyTemplate + "_negative";
        }
        return this.controller.getMessages().formatPropertyString(message, value, max, this.getMessage(propertyTemplate));
    }

    protected void addDamageTypeLore(String property, String propertyType, double amount, List<String> lore) {
        this.addDamageTypeLore(property, propertyType, amount, 1.0, lore);
    }

    protected void addDamageTypeLore(String property, String propertyType, double amount, double max, List<String> lore) {
        this.addDamageTypeLore(property, propertyType, amount, max, lore, null);
    }

    protected void addDamageTypeLore(String property, String propertyType, double amount, double max, List<String> lore, String unknownDefault) {
        if (amount != 0.0) {
            String template;
            String prefix = this.getMessageKey("prefixes." + property);
            prefix = this.controller.getMessages().get(prefix, "");
            String templateKey = this.getMessageKey(property + "." + propertyType);
            if (this.controller.getMessages().containsKey(templateKey)) {
                template = this.controller.getMessages().get(templateKey);
            } else {
                templateKey = this.getMessageKey(property + ".unknown");
                template = this.controller.getMessages().get(templateKey);
                String pretty = propertyType.substring(0, 1).toUpperCase() + propertyType.substring(1);
                template = template.replace("$type", pretty);
                if (unknownDefault != null && !unknownDefault.isEmpty()) {
                    unknownDefault = WordUtils.capitalize((String)unknownDefault.toLowerCase().replace("_", " "));
                    template = template.replace("$name", unknownDefault);
                }
            }
            template = this.formatPropertyString(prefix + template, (float)amount, (float)max);
            ConfigurationUtils.addIfNotEmpty(template, lore);
        }
    }

    public void addPropertyLore(List<String> lore) {
        this.addPropertyLore(lore, false);
    }

    public void addPropertyLore(List<String> lore, boolean isSingleSpell) {
        String template;
        ConfigurationSection configurationSection;
        ConfigurationSection strengthConfig;
        ConfigurationSection weaknessConfig;
        boolean superProtected;
        float power;
        float cooldownReduction;
        float f;
        float consumeReduction;
        float earnMultiplier;
        float manaRegenerationBoost;
        if (this.usesMana() && this.effectiveManaMax > 0.0f) {
            float manaPerDamage;
            int manaMax = this.getManaMax();
            if (this.effectiveManaMax != (float)manaMax) {
                String fullMessage = this.getLevelString("mana_amount_boosted", manaMax, this.controller.getMaxMana());
                ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString((int)Math.ceil(this.effectiveManaMax))), lore);
            } else {
                ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_amount", manaMax, this.controller.getMaxMana()), lore);
            }
            int manaRegeneration = this.getManaRegeneration();
            if (manaRegeneration > 0 && this.effectiveManaRegeneration > 0.0f) {
                if (this.effectiveManaRegeneration != (float)manaRegeneration) {
                    String fullMessage = this.getLevelString("mana_regeneration_boosted", manaRegeneration, this.controller.getMaxManaRegeneration());
                    ConfigurationUtils.addIfNotEmpty(fullMessage.replace("$mana", Integer.toString((int)Math.ceil(this.effectiveManaRegeneration))), lore);
                } else {
                    ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_regeneration", manaRegeneration, this.controller.getMaxManaRegeneration()), lore);
                }
            }
            if ((manaPerDamage = this.getFloat("mana_per_damage")) > 0.0f) {
                ConfigurationUtils.addIfNotEmpty(this.getLevelString("mana_per_damage", manaPerDamage, this.controller.getMaxManaRegeneration()), lore);
            }
        }
        float blockChance = this.getFloat("block_chance");
        float blockReflectChance = this.getFloat("block_reflect_chance");
        if (blockReflectChance > 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("reflect_chance", blockReflectChance), lore);
        } else if (blockChance != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("block_chance", blockChance), lore);
        }
        float manaMaxBoost = this.getManaMaxBoost();
        if (manaMaxBoost != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("mana_boost", manaMaxBoost, 1.0f, true), lore);
        }
        if ((manaRegenerationBoost = this.getManaRegenerationBoost()) != 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("mana_regeneration_boost", manaRegenerationBoost, 1.0f, true), lore);
        }
        if ((earnMultiplier = this.getFloat("earn_multiplier", this.getFloat("sp_multiplier", 1.0f))) > 1.0f) {
            Object earnDescription = this.getPropertyString("earn_multiplier", earnMultiplier - 1.0f);
            String string = this.getController().getMessages().get("currency.sp.name_short", "SP");
            earnDescription = ((String)earnDescription).replace("$type", string);
            ConfigurationUtils.addIfNotEmpty((String)earnDescription, lore);
        }
        for (Map.Entry entry : this.getPotionEffects().entrySet()) {
            ConfigurationUtils.addIfNotEmpty(this.describePotionEffect((PotionEffectType)entry.getKey(), (Integer)entry.getValue()), lore);
        }
        if (this.getBoolean("ignored_by_mobs")) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("ignored_by_mobs"), lore);
        }
        if ((consumeReduction = this.getFloat("consume_reduction")) != 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("consume_reduction", consumeReduction), lore);
        }
        if ((f = this.getFloat("cost_reduction")) != 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("cost_reduction", f), lore);
        }
        if ((cooldownReduction = this.getFloat("cooldown_reduction")) != 0.0f && !isSingleSpell) {
            ConfigurationUtils.addIfNotEmpty(this.getPropertyString("cooldown_reduction", cooldownReduction), lore);
        }
        if ((power = this.getFloat("power")) > 0.0f) {
            ConfigurationUtils.addIfNotEmpty(this.getLevelString("power", power), lore);
        }
        if (superProtected = this.getBoolean("protected")) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("super_protected"), lore);
        } else {
            HashMap<String, Double> protection = null;
            ConfigurationSection protectionConfig = this.getConfigurationSection("protection");
            if (protectionConfig != null) {
                protection = new HashMap<String, Double>();
                for (String string : protectionConfig.getKeys(false)) {
                    protection.put(string, protectionConfig.getDouble(string));
                }
            }
            if (protection != null) {
                for (Map.Entry entry : protection.entrySet()) {
                    String protectionType = (String)entry.getKey();
                    double amount = (Double)entry.getValue();
                    this.addDamageTypeLore("protection", protectionType, amount, lore);
                }
            }
        }
        boolean superPowered = this.getBoolean("powered");
        if (superPowered) {
            ConfigurationUtils.addIfNotEmpty(this.getMessage("super_powered"), lore);
        }
        if ((weaknessConfig = this.getConfigurationSection("weakness")) != null) {
            Set keys = weaknessConfig.getKeys(false);
            for (Object key : keys) {
                this.addDamageTypeLore("weakness", (String)key, weaknessConfig.getDouble((String)key), lore);
            }
        }
        if ((strengthConfig = this.getConfigurationSection("strength")) != null) {
            Set set = strengthConfig.getKeys(false);
            for (String key : set) {
                this.addDamageTypeLore("strength", key, strengthConfig.getDouble(key), lore);
            }
        }
        if ((configurationSection = this.getConfigurationSection("attributes")) != null && !(template = this.getMessage("attributes")).isEmpty()) {
            Set keys = configurationSection.getKeys(false);
            for (String key : keys) {
                Double maxValue;
                String label = this.controller.getMessages().get("attributes." + key + ".name", key);
                int value = configurationSection.getInt(key);
                if (value == 0) continue;
                float max = 1.0f;
                MagicAttribute attribute = this.controller.getAttribute(key);
                if (attribute != null && (maxValue = attribute.getMax()) != null) {
                    max = (float)maxValue.doubleValue();
                }
                label = this.getPropertyString("attributes", value, max, true).replace("$attribute", label);
                lore.add(label);
            }
        }
    }
}

