/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.arena;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import org.bukkit.configuration.ConfigurationSection;

public class ArenaMobSpawner {
    private EntityData entity;
    private int count;

    public ArenaMobSpawner(EntityData entity, int count) {
        this.entity = entity;
        this.count = count;
    }

    public ArenaMobSpawner(MageController controller, ConfigurationSection configuration) {
        String mobType = configuration.getString("type");
        this.entity = controller.getMob(mobType);
        if (this.entity == null) {
            controller.getLogger().warning("Invalid mob type in arena config: " + mobType);
        }
        this.count = configuration.getInt("count", 1);
    }

    public void save(ConfigurationSection configuration) {
        if (this.entity != null) {
            configuration.set("type", (Object)this.entity.getKey());
        }
        configuration.set("count", (Object)this.count);
    }

    public EntityData getEntity() {
        return this.entity;
    }

    public void setEntity(EntityData entity) {
        this.entity = entity;
    }

    public boolean isValid() {
        return this.entity != null;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

