/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.kit.Kit;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MagicConfigurable;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.warp.Warp;
import com.elmakers.mine.bukkit.item.Cost;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SelectorAction
extends CompoundAction
implements GUIAction {
    private static final String[] _DEFAULT_COST_FALLBACKS = new String[]{"currency", "item"};
    private static final List<String> DEFAULT_COST_FALLBACKS = Arrays.asList(_DEFAULT_COST_FALLBACKS);
    private static final int MAX_INVENTORY_SLOTS = 54;
    protected SelectorConfiguration defaultConfiguration;
    protected ItemData confirmFillMaterial;
    protected CastContext context;
    private Map<Integer, SelectorOption> showingItems;
    private int itemCount;
    private int numSlots;
    private int has = 0;
    private String title;
    private String confirmTitle;
    private String confirmUnlockTitle;
    private String titleKey;
    private String confirmTitleKey;
    private String confirmUnlockTitleKey;
    private Location chestLocation;
    private UUID ownerId;
    private boolean isActive = false;
    private SpellResult finalResult = null;
    private Inventory displayInventory = null;

    public SelectorConfiguration getSelectorOption(ConfigurationSection section) {
        return new SelectorConfiguration(section);
    }

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("slot");
        }
        this.isActive = false;
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    protected String getMessage(String key) {
        return this.context.getMessage(key, this.getDefaultMessage(this.context, key));
    }

    protected String getDefaultMessage(CastContext context, String key) {
        String messageSection = this.getDefaultMessageSection();
        String defaultMessage = context.getController().getMessages().getIfSet(messageSection + "." + key);
        if (defaultMessage == null && !messageSection.equals("selector")) {
            defaultMessage = context.getController().getMessages().get("selector." + key);
        }
        return defaultMessage;
    }

    protected String getDefaultMessageSection() {
        return "selector";
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        Mage mage = this.context.getMage();
        Player player = mage.getPlayer();
        if (player != null && event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) {
            player.getInventory().setItemInOffHand(player.getInventory().getItemInOffHand());
        }
        if (item == null || !CompatibilityLib.getNBTUtils().containsTag(item, "slot")) {
            if (this.defaultConfiguration.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        int slotIndex = Integer.parseInt(CompatibilityLib.getNBTUtils().getString(item, "slot"));
        MageController controller = this.context.getController();
        SelectorOption option = this.showingItems.get(slotIndex);
        if (option == null || option.isPlaceholder()) {
            return;
        }
        String unpurchasableMessage = CompatibilityLib.getNBTUtils().getString(item, "unpurchasable");
        if (unpurchasableMessage != null && !unpurchasableMessage.isEmpty()) {
            this.context.showMessage(unpurchasableMessage);
            if (option.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        if (!option.checkChestLocation(false)) {
            this.context.showMessage(this.getMessage("nostock"));
            if (option.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        Cost required = option.getRequiredCost(this.context);
        if (required != null) {
            String baseMessage = this.getMessage("insufficient");
            String costDescription = required.getFullDescription(controller.getMessages());
            costDescription = baseMessage.replace("$cost", costDescription);
            this.context.showMessage(costDescription);
        } else {
            String itemName = option.getName();
            if (CompatibilityLib.getNBTUtils().containsTag(item, "confirm")) {
                String inventoryTitle = this.getConfirmTitle(option).replace("$item", itemName);
                Inventory confirmInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, 9, inventoryTitle);
                CompatibilityLib.getNBTUtils().removeMeta(item, "confirm");
                for (int i = 0; i < 9; ++i) {
                    if (i != 4) {
                        ItemMeta meta;
                        ItemStack filler;
                        ItemStack itemStack = filler = this.confirmFillMaterial == null ? null : this.confirmFillMaterial.getItemStack(1);
                        if (filler == null) {
                            filler = new ItemStack(Material.AIR);
                        }
                        if ((meta = filler.getItemMeta()) != null) {
                            meta.setDisplayName(ChatColor.DARK_GRAY + (i < 4 ? "-->" : "<--"));
                            filler.setItemMeta(meta);
                        }
                        confirmInventory.setItem(i, filler);
                        continue;
                    }
                    confirmInventory.setItem(i, item);
                }
                mage.deactivateGUI();
                this.isActive = true;
                mage.activateGUI(this, confirmInventory);
                return;
            }
            this.finalResult = option.give(this.context);
            if (this.finalResult.isSuccess() && this.finalResult != SpellResult.NO_TARGET) {
                this.context.showMessage(option.getSelectedMessage());
            }
        }
        if (option.autoClose || this.finalResult != SpellResult.CAST) {
            if (this.isActive) {
                mage.deactivateGUI();
            }
        } else {
            mage.continueGUI(this, this.getInventory(this.context));
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        Block block;
        BlockState state;
        ConfigurationSection addOptions;
        this.context = context;
        this.defaultConfiguration = new SelectorConfiguration(parameters);
        String fillerKey = parameters.getString("confirm_filler");
        if (fillerKey != null && !fillerKey.isEmpty()) {
            this.confirmFillMaterial = context.getController().getOrCreateItem(fillerKey);
        }
        this.title = parameters.getString("title");
        if (this.title != null) {
            this.title = StringEscapeUtils.unescapeJava((String)this.title);
        }
        this.confirmTitle = parameters.getString("confirm_title");
        this.confirmUnlockTitle = parameters.getString("unlock_confirm_title");
        this.titleKey = parameters.getString("title_key", "title");
        this.confirmTitleKey = parameters.getString("confirm_title_key", "confirm_title");
        this.confirmUnlockTitleKey = parameters.getString("unlock_confirm_title_key", "unlock_confirm_title");
        this.chestLocation = ConfigurationUtils.getLocation(parameters, "chest_location");
        String idString = parameters.getString("owner_uuid");
        if (idString != null && !idString.isEmpty()) {
            try {
                this.ownerId = UUID.fromString(idString);
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid owner_uuid: " + idString);
            }
        }
        this.finalResult = null;
        this.isActive = false;
        this.numSlots = 0;
        this.showingItems = new HashMap<Integer, SelectorOption>();
        this.has = 0;
        List optionConfigs = parameters.getList("options");
        if (optionConfigs != null) {
            this.loadOptions(optionConfigs, parameters);
        }
        if ((addOptions = parameters.getConfigurationSection("add_options")) != null) {
            ArrayList<ConfigurationSection> addOptionConfigs = new ArrayList<ConfigurationSection>();
            Set keys = addOptions.getKeys(false);
            for (String key : keys) {
                addOptionConfigs.add(addOptions.getConfigurationSection(key));
            }
            this.loadOptions(addOptionConfigs, parameters);
        }
        if (this.chestLocation != null && (state = (block = this.chestLocation.getBlock()).getState()) instanceof Container) {
            Container container = (Container)state;
            ArrayList<ConfigurationSection> items = new ArrayList<ConfigurationSection>();
            for (ItemStack item : container.getInventory()) {
                ConfigurationSection itemConfig = ConfigurationUtils.newConfigurationSection();
                if (CompatibilityLib.getItemUtils().isEmpty(item)) {
                    itemConfig.set("placeholder", (Object)true);
                } else {
                    String key = context.getController().getItemKey(item);
                    key = key + "@" + item.getAmount();
                    itemConfig.set("item", (Object)key);
                }
                items.add(itemConfig);
            }
            this.loadOptions(items);
        }
        super.prepare(context, parameters);
    }

    protected void addOption(Object option, List<SelectorOption> options, ConfigurationSection configRoot) {
        if (option instanceof Map) {
            option = ConfigurationUtils.toConfigurationSection(configRoot, (Map)option);
        }
        if (option instanceof ConfigurationSection) {
            SelectorOption newOption = new SelectorOption(this.defaultConfiguration, (ConfigurationSection)option, this.context);
            if (newOption.hasLimit() && newOption.has(this.context)) {
                ++this.has;
            }
            options.add(newOption);
        }
        if (option instanceof String) {
            boolean newRow;
            String optionString = (String)option;
            boolean bl = newRow = optionString.equalsIgnoreCase("newrow") || optionString.equalsIgnoreCase("nextrow");
            if (newRow || optionString.equalsIgnoreCase("none") || optionString.equalsIgnoreCase("nothing") || optionString.equalsIgnoreCase("placeholder")) {
                int count = 1;
                if (newRow) {
                    count = 9 - options.size() % 9;
                }
                for (int i = 0; i < count; ++i) {
                    ConfigurationSection placeholderConfig = ConfigurationUtils.newConfigurationSection();
                    placeholderConfig.set("placeholder", (Object)true);
                    SelectorOption newOption = new SelectorOption(this.defaultConfiguration, placeholderConfig, this.context);
                    options.add(newOption);
                }
            } else {
                ConfigurationSection placeholderConfig = ConfigurationUtils.newConfigurationSection();
                placeholderConfig.set("item", (Object)optionString);
                SelectorOption newOption = new SelectorOption(this.defaultConfiguration, placeholderConfig, this.context);
                options.add(newOption);
            }
        }
    }

    protected void loadOptions(Collection<? extends Object> optionConfigs) {
        this.loadOptions(optionConfigs, null);
    }

    protected void loadOptions(Collection<? extends Object> optionConfigs, ConfigurationSection configRoot) {
        ArrayList<SelectorOption> options = new ArrayList<SelectorOption>();
        for (Object object : optionConfigs) {
            this.addOption(object, options, configRoot);
        }
        this.addOptions(options);
    }

    protected void addOptions(List<SelectorOption> options) {
        for (SelectorOption option : options) {
            Integer targetSlot;
            int slot;
            if (option.isUnavailable() && !option.showIfUnavailable() || (slot = (targetSlot = option.getSlot()) == null ? this.numSlots : targetSlot) >= 54) continue;
            if (!option.isPlaceholder()) {
                ++this.itemCount;
            }
            option.slot = slot;
            this.showingItems.put(slot, option);
            this.numSlots = Math.max(slot + 1, this.numSlots);
        }
    }

    public SpellResult showItems(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.isActive = true;
        this.finalResult = SpellResult.NO_ACTION;
        Inventory displayInventory = this.getInventory(context);
        mage.activateGUI(this, displayInventory);
        return SpellResult.CAST;
    }

    protected String getInventoryTitle() {
        if (this.title != null && !this.title.isEmpty()) {
            return this.title;
        }
        return this.getMessage(this.titleKey);
    }

    protected String getConfirmTitle(SelectorOption option) {
        if (option.isUnlock()) {
            if (this.confirmUnlockTitle != null && !this.confirmUnlockTitle.isEmpty()) {
                return this.confirmUnlockTitle;
            }
            return this.getMessage(this.confirmUnlockTitleKey);
        }
        if (this.confirmTitle != null && !this.confirmTitle.isEmpty()) {
            return this.confirmTitle;
        }
        return this.getMessage(this.confirmTitleKey);
    }

    protected String getBalanceDescription(CastContext context) {
        Mage mage = context.getMage();
        if (this.defaultConfiguration.free) {
            return "";
        }
        String costType = this.defaultConfiguration.getCostType();
        MageController controller = context.getController();
        Cost cost = new Cost(controller, costType, 1.0);
        if (this.defaultConfiguration.costOverride != null) {
            cost.convert(controller, this.defaultConfiguration.costOverride);
        }
        cost.checkSupported(controller, this.defaultConfiguration.getCostTypeFallbacks());
        cost.setAmount(cost.getBalance(mage, context.getWand()));
        return cost.getFullDescription(controller.getMessages());
    }

    protected Inventory getInventory(CastContext context) {
        String pathName;
        String inventoryTitle = this.getInventoryTitle();
        String balanceDescription = this.getBalanceDescription(context);
        inventoryTitle = inventoryTitle.replace("$balance", balanceDescription);
        inventoryTitle = context.parameterize(inventoryTitle);
        ProgressionPath path = context.getMage().getActiveProperties().getPath();
        String string = pathName = path == null ? null : path.getName();
        if (pathName == null) {
            pathName = "";
        }
        inventoryTitle = inventoryTitle.replace("$path", pathName);
        int invSize = (int)Math.ceil((float)this.numSlots / 9.0f) * 9;
        this.displayInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, invSize, inventoryTitle);
        for (Map.Entry<Integer, SelectorOption> entry : this.showingItems.entrySet()) {
            ItemStack icon = entry.getValue().getIcon();
            CompatibilityLib.getNBTUtils().setString(icon, "slot", Integer.toString(entry.getKey()));
            this.displayInventory.setItem(entry.getKey().intValue(), icon);
        }
        return this.displayInventory;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("confirm");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("auto_upgrade");
        parameters.add("require_wand");
        parameters.add("permission");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        MageController controller = spell.getController();
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(controller.getWandPathKeys());
        } else if (parameterKey.equals("require_wand") || parameterKey.equals("confirm") || parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public void finish(CastContext context) {
        this.isActive = false;
        this.finalResult = null;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.isActive = false;
        this.finalResult = null;
    }

    public RequirementsResult checkDefaultRequirements(CastContext context) {
        return this.defaultConfiguration.checkRequirements(context);
    }

    @Override
    public SpellResult start(CastContext context) {
        RequirementsResult check = this.checkDefaultRequirements(context);
        if (!check.result.isSuccess()) {
            context.sendMessageKey(check.result.name(), check.message);
            return check.result;
        }
        if (this.itemCount == 0) {
            context.showMessage("no_items", this.getDefaultMessage(context, "no_items"));
            return SpellResult.NO_ACTION;
        }
        return this.showItems(context);
    }

    @Override
    public SpellResult step(CastContext context) {
        this.context = context;
        if (this.isActive) {
            return SpellResult.PENDING;
        }
        return this.finalResult == null ? SpellResult.NO_ACTION : this.finalResult;
    }

    @Nullable
    protected ItemStack parseItem(String itemKey) {
        if (itemKey == null || itemKey.isEmpty() || itemKey.equalsIgnoreCase("none")) {
            return null;
        }
        ItemStack item = this.context.getController().createItem(itemKey, this.context.getMage());
        if (item == null) {
            this.context.getLogger().warning("Failed to create item in selector: " + itemKey);
        }
        return item;
    }

    protected int getNumSlots() {
        return this.numSlots;
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
    }

    static /* synthetic */ List access$000() {
        return DEFAULT_COST_FALLBACKS;
    }

    protected class SelectorConfiguration {
        @Nullable
        protected ItemStack icon;
        @Nullable
        protected String iconKey;
        @Nullable
        protected String iconDisabledKey;
        @Nullable
        protected String iconPlaceholderKey;
        @Nullable
        protected List<ItemStack> items;
        @Nullable
        protected List<Cost> costs = null;
        @Nonnull
        protected String costType = "currency";
        @Nonnull
        protected String earnType = "currency";
        @Nullable
        protected String costOverride = null;
        @Nonnull
        protected List<String> costTypeFallbacks = SelectorAction.access$000();
        @Nullable
        protected String castSpell = null;
        @Nullable
        protected String warpKey = null;
        @Nullable
        protected ConfigurationSection castSpellParameters = null;
        @Nullable
        protected String unlockClass = null;
        @Nullable
        protected List<String> lockClasses = null;
        @Nullable
        protected String selectedMessage = null;
        @Nullable
        protected String selectedFreeMessage = null;
        @Nullable
        protected String unlockKey = null;
        protected boolean unlockEarns = false;
        @Nullable
        protected String actions = null;
        @Nonnull
        protected String unlockSection = "unlocked";
        @Nullable
        protected Collection<Requirement> requirements;
        @Nullable
        protected List<String> commands;
        @Nonnull
        protected CommandSourceType commandSourceType = CommandSourceType.CONSOLE;
        @Nullable
        protected List<CostModifier> costModifiers;
        @Nullable
        protected List<CostModifier> earnModifiers;
        @Nullable
        protected List<Cost> earns = null;
        @Nullable
        protected Map<String, String> alternateSpellTags;
        @Nonnull
        protected String effects = "selected";
        @Nullable
        protected String attributeKey = null;
        @Nullable
        protected String kitKey;
        protected boolean allowAttributeReduction = false;
        protected int attributeAmount = 0;
        protected boolean isSell = false;
        protected boolean applyToWand = false;
        protected boolean applyToCaster = false;
        protected MagicPropertyType applyTo = null;
        @Nullable
        protected String applyToClass = null;
        protected boolean showConfirmation = false;
        protected boolean showUnavailable = false;
        protected boolean switchClass = false;
        protected boolean putInHand = true;
        protected boolean free = false;
        protected boolean removeLore = false;
        protected boolean applyLoreToItem = false;
        protected boolean applyNameToItem = false;
        protected boolean nameIcon = true;
        protected boolean allowDroppedItems = true;
        protected double costScale = 1.0;
        protected double earnScale = 1.0;
        protected boolean autoClose = true;
        protected boolean showFree = true;
        protected boolean unbreakableIcon = true;
        protected int iconHideFlags = 63;
        protected int limit = 0;
        @Nullable
        protected String[] allCostTypes = null;
        @Nullable
        protected String[] fallbackCostTypes = null;

        public SelectorConfiguration(ConfigurationSection configuration) {
            this.parseOverrides(configuration);
            this.parseIcon(configuration);
            this.parse(configuration);
        }

        protected SelectorConfiguration() {
        }

        protected void parseOverrides(ConfigurationSection configuration) {
            this.isSell = configuration.getBoolean("sell", this.isSell);
            if (this.isSell) {
                this.convertToSell(configuration);
            }
        }

        protected void parseIcon(ConfigurationSection configuration) {
            this.iconPlaceholderKey = configuration.getString("placeholder_icon", this.iconPlaceholderKey);
            this.iconKey = configuration.getString("icon");
            this.iconDisabledKey = configuration.getString("icon_disabled");
        }

        protected void convertToSell(ConfigurationSection configuration) {
        }

        protected void parse(ConfigurationSection configuration) {
            ConfigurationSection altTags;
            List itemList;
            String commandSourceTypeString;
            String applyToString;
            this.applyToWand = configuration.getBoolean("apply_to_wand", this.applyToWand);
            this.applyToCaster = configuration.getBoolean("apply_to_caster", this.applyToCaster);
            this.applyToClass = Strings.emptyToNull((String)configuration.getString("apply_to_class", this.applyToClass));
            this.putInHand = configuration.getBoolean("put_in_hand", this.putInHand);
            this.warpKey = configuration.getString("warp", this.warpKey);
            this.castSpell = configuration.getString("cast_spell", this.castSpell);
            this.castSpellParameters = configuration.isConfigurationSection("cast_spell_parameters") ? configuration.getConfigurationSection("cast_spell_parameters") : this.castSpellParameters;
            this.unlockClass = Strings.emptyToNull((String)configuration.getString("unlock_class", this.unlockClass));
            this.lockClasses = ConfigurationUtils.getStringList(configuration, "lock_classes", this.lockClasses);
            String lockClass = configuration.getString("lock_class");
            if (lockClass != null && !lockClass.isEmpty()) {
                if (this.lockClasses == null) {
                    this.lockClasses = new ArrayList<String>();
                }
                this.lockClasses.add(lockClass);
            }
            if (this.lockClasses != null && this.unlockClass != null) {
                this.lockClasses = new ArrayList<String>(this.lockClasses);
                this.lockClasses.remove(this.unlockClass);
            }
            this.kitKey = configuration.getString("kit");
            this.nameIcon = configuration.getBoolean("apply_name_to_icon", this.nameIcon);
            this.autoClose = configuration.getBoolean("auto_close", this.autoClose);
            this.showFree = configuration.getBoolean("show_free", this.showFree);
            this.allowAttributeReduction = configuration.getBoolean("allow_attribute_reduction", this.allowAttributeReduction);
            if (configuration.contains("switch_class")) {
                this.switchClass = true;
                this.unlockClass = Strings.emptyToNull((String)configuration.getString("switch_class"));
            }
            if ((applyToString = configuration.getString("apply_to", this.applyTo == null ? null : this.applyTo.name())) != null && !applyToString.isEmpty()) {
                try {
                    this.applyTo = MagicPropertyType.valueOf(applyToString.toUpperCase());
                }
                catch (Exception ex) {
                    SelectorAction.this.context.getLogger().warning("Invalid apply_to: " + applyToString);
                }
            } else {
                this.applyTo = null;
            }
            this.attributeAmount = configuration.getInt("attribute_amount", this.attributeAmount);
            this.attributeKey = configuration.getString("attribute", this.attributeKey);
            this.limit = configuration.getInt("limit", this.limit);
            this.unlockKey = configuration.getString("unlock", this.unlockKey);
            this.unlockEarns = configuration.getBoolean("unlock_earns", false);
            this.unlockSection = configuration.getString("unlock_section", this.unlockSection);
            this.showConfirmation = configuration.getBoolean("confirm", this.showConfirmation);
            this.costType = configuration.getString("cost_type", this.costType);
            this.costOverride = configuration.getString("cost_override", this.costOverride);
            this.earnType = configuration.getString("earn_type", this.earnType);
            this.allCostTypes = null;
            this.costTypeFallbacks = ConfigurationUtils.getStringList(configuration, "cost_type_fallback", this.costTypeFallbacks);
            this.costTypeFallbacks = ConfigurationUtils.getStringList(configuration, "cost_type_fallbacks", this.costTypeFallbacks);
            this.actions = configuration.getString("actions", this.actions);
            this.showUnavailable = configuration.getBoolean("show_unavailable", this.showUnavailable);
            this.commands = ConfigurationUtils.getStringList(configuration, "commands");
            String command = configuration.getString("command");
            if (command != null && !command.isEmpty()) {
                if (this.commands == null) {
                    this.commands = new ArrayList<String>();
                }
                this.commands.add(command);
            }
            if ((commandSourceTypeString = configuration.getString("command_source")) != null && !commandSourceTypeString.isEmpty()) {
                try {
                    this.commandSourceType = CommandSourceType.valueOf(commandSourceTypeString.toUpperCase());
                }
                catch (Exception ex) {
                    SelectorAction.this.context.getLogger().warning("Invalid command_source in selector option: " + commandSourceTypeString);
                }
            }
            this.free = configuration.getBoolean("free", this.free);
            this.costScale = configuration.getDouble("scale", this.costScale);
            if (configuration.contains("earn_scale")) {
                this.earnScale = configuration.getDouble("earn_scale", this.earnScale);
            } else if (configuration.contains("scale")) {
                this.earnScale = this.costScale;
            }
            this.effects = configuration.getString("effects", this.effects);
            this.removeLore = configuration.getBoolean("remove_lore", this.removeLore);
            this.applyLoreToItem = configuration.getBoolean("apply_lore_to_item", this.applyLoreToItem);
            this.applyNameToItem = configuration.getBoolean("apply_name_to_item", this.applyNameToItem);
            this.allowDroppedItems = configuration.getBoolean("allow_dropped_items", this.allowDroppedItems);
            this.iconHideFlags = configuration.getInt("icon_hide_flags", this.iconHideFlags);
            this.unbreakableIcon = configuration.getBoolean("icon_unbreakable", this.unbreakableIcon);
            if (this.costType.isEmpty() || this.costType.equalsIgnoreCase("none")) {
                this.free = true;
            }
            this.selectedMessage = configuration.getString("selected", this.selectedMessage);
            this.selectedFreeMessage = configuration.getString("selected_free", this.selectedFreeMessage);
            this.requirements = ConfigurationUtils.getRequirements(configuration);
            if (configuration.contains("item")) {
                this.items = new ArrayList<ItemStack>();
                ItemStack item = SelectorAction.this.parseItem(configuration.getString("item"));
                if (item != null) {
                    this.items.add(item);
                }
            }
            if (configuration.contains("items") && (itemList = configuration.getStringList("items")).size() > 0) {
                this.items = new ArrayList<ItemStack>();
                for (String itemKey : itemList) {
                    ItemStack item = SelectorAction.this.parseItem(itemKey);
                    if (item == null) continue;
                    this.items.add(item);
                }
            }
            if ((altTags = ConfigurationUtils.getConfigurationSection(configuration, "cast_for_tags")) != null) {
                this.alternateSpellTags = new HashMap<String, String>();
                for (String key : altTags.getKeys(false)) {
                    this.alternateSpellTags.put(key, altTags.getString(key));
                }
            }
            if (this.actions != null && !this.actions.isEmpty()) {
                SelectorAction.this.addHandler(SelectorAction.this.context.getSpell(), this.actions);
            }
            if (this.items != null && this.items.isEmpty()) {
                this.items = null;
            }
            MageController controller = SelectorAction.this.context.getController();
            this.costModifiers = this.parseCostModifiers(configuration, "cost_modifiers");
            this.earnModifiers = this.parseCostModifiers(configuration, "earn_modifiers");
            if (!this.free) {
                Kit kit;
                this.costs = this.parseCosts(ConfigurationUtils.getConfigurationSection(configuration, "costs"));
                double cost = configuration.getDouble("cost");
                if (cost > 0.0) {
                    if (this.costs == null) {
                        this.costs = new ArrayList<Cost>();
                    }
                    Cost optionCost = new Cost(SelectorAction.this.context.getController(), this.costType, cost);
                    if (this.costOverride != null) {
                        optionCost.convert(controller, this.costOverride);
                    }
                    optionCost.checkSupported(controller, this.getCostTypeFallbacks());
                    optionCost.scale(controller.getWorthBase());
                    optionCost.scale(this.costScale);
                    this.costs.add(optionCost);
                } else if (configuration.isString("cost")) {
                    if (this.costs == null) {
                        this.costs = new ArrayList<Cost>();
                    }
                    this.costs.add(new Cost(SelectorAction.this.context.getController(), configuration.getString("cost"), 1.0));
                }
                if (this.costs == null && this.items != null) {
                    this.costs = new ArrayList<Cost>();
                    for (ItemStack item : this.items) {
                        Cost itemCost = null;
                        String spellKey = controller.getSpell(item);
                        if (spellKey == null) {
                            Double worth = controller.getWorth(item, this.costType);
                            if (worth != null && worth > 0.0) {
                                itemCost = new Cost(SelectorAction.this.context.getController(), this.costType, worth);
                            }
                        } else {
                            SpellTemplate spell = controller.getSpellTemplate(spellKey);
                            itemCost = (Cost)spell.getCost();
                        }
                        if (itemCost == null) continue;
                        if (this.costOverride != null) {
                            itemCost.convert(controller, this.costOverride);
                            itemCost.checkSupported(controller, this.getCostTypeFallbacks());
                        } else {
                            itemCost.checkSupported(controller, this.getAllCostTypes());
                        }
                        itemCost.scale(controller.getWorthBase());
                        itemCost.scale(this.costScale);
                        this.costs.add(itemCost);
                    }
                }
                if (this.costs == null && this.kitKey != null && (kit = controller.getKit(this.kitKey)) != null) {
                    Cost kitCost = new Cost(SelectorAction.this.context.getController(), this.costType, kit.getWorth());
                    if (this.costOverride != null) {
                        kitCost.convert(controller, this.costOverride);
                        kitCost.checkSupported(controller, this.getCostTypeFallbacks());
                    } else {
                        kitCost.checkSupported(controller, this.getAllCostTypes());
                    }
                    kitCost.scale(controller.getWorthBase());
                    kitCost.scale(this.costScale);
                    this.costs = new ArrayList<Cost>();
                    this.costs.add(kitCost);
                }
            }
            if ((this.applyNameToItem || this.applyLoreToItem) && this.items != null) {
                for (ItemStack item : this.items) {
                    List lore;
                    ItemMeta meta = item.getItemMeta();
                    String customName = configuration.getString("name");
                    if (this.applyNameToItem && customName != null && !customName.isEmpty()) {
                        meta.setDisplayName(CompatibilityLib.getCompatibilityUtils().translateColors(customName));
                    }
                    item.setItemMeta(meta);
                    List list = lore = configuration.contains("lore") ? configuration.getStringList("lore") : null;
                    if (!this.applyLoreToItem || lore == null) continue;
                    CompatibilityLib.getCompatibilityUtils().setLore(item, lore);
                }
            }
            this.earns = this.parseCosts(ConfigurationUtils.getConfigurationSection(configuration, "earns"));
            double earn = configuration.getDouble("earn");
            if (earn > 0.0) {
                if (this.earns == null) {
                    this.earns = new ArrayList<Cost>();
                }
                Cost earnCost = new Cost(SelectorAction.this.context.getController(), this.earnType, earn);
                earnCost.checkSupported(controller, this.getAllCostTypes());
                earnCost.scale(controller.getWorthBase());
                earnCost.scale(this.earnScale);
                this.earns.add(earnCost);
            }
        }

        @Nullable
        protected List<Cost> parseCosts(ConfigurationSection node) {
            return Cost.parseCosts(node, SelectorAction.this.context.getController());
        }

        @Nullable
        protected List<CostModifier> parseCostModifiers(ConfigurationSection configuration, String section) {
            List<ConfigurationSection> modifierConfigs = ConfigurationUtils.getNodeList(configuration, section);
            if (modifierConfigs == null) {
                return null;
            }
            ArrayList<CostModifier> modifiers = new ArrayList<CostModifier>();
            for (ConfigurationSection modifierConfig : modifierConfigs) {
                modifiers.add(new CostModifier(modifierConfig));
            }
            return modifiers;
        }

        public boolean hasLimit() {
            return this.limit > 0;
        }

        public String getCostType() {
            return this.costType;
        }

        public String[] getAllCostTypes() {
            if (this.allCostTypes == null) {
                this.allCostTypes = new String[this.costTypeFallbacks.size() + 1];
                for (int i = 0; i < this.costTypeFallbacks.size(); ++i) {
                    this.allCostTypes[i + 1] = this.costTypeFallbacks.get(i);
                }
            }
            this.allCostTypes[0] = this.costType;
            return this.allCostTypes;
        }

        public String[] getCostTypeFallbacks() {
            if (this.fallbackCostTypes == null) {
                this.fallbackCostTypes = new String[this.costTypeFallbacks.size()];
                this.fallbackCostTypes = this.costTypeFallbacks.toArray(this.fallbackCostTypes);
            }
            return this.fallbackCostTypes;
        }

        public boolean has(CastContext context) {
            Mage mage = context.getMage();
            return this.unlockClass != null && mage.hasClassUnlocked(this.unlockClass);
        }

        public RequirementsResult checkRequirements(CastContext context) {
            String message;
            MageController controller = context.getController();
            Mage mage = context.getMage();
            Player player = mage.getPlayer();
            if (player == null) {
                return new RequirementsResult(SpellResult.PLAYER_REQUIRED);
            }
            if (this.limit > 0 && SelectorAction.this.has >= this.limit) {
                return new RequirementsResult(SpellResult.NO_TARGET, SelectorAction.this.getMessage("at_limit").replace("$limit", Integer.toString(this.limit)));
            }
            if (this.unlockClass != null && mage.hasClassUnlocked(this.unlockClass)) {
                return new RequirementsResult(SpellResult.NO_TARGET, SelectorAction.this.getMessage("has_class").replace("$class", this.unlockClass));
            }
            if (this.requirements != null && (message = controller.checkRequirements(context, this.requirements)) != null) {
                return new RequirementsResult(SpellResult.NO_TARGET, message);
            }
            return new RequirementsResult(SpellResult.CAST);
        }

        public boolean isUnlock() {
            return this.unlockKey != null && !this.unlockKey.isEmpty();
        }

        public boolean showIfUnavailable() {
            return this.showUnavailable;
        }
    }

    protected class SelectorOption
    extends SelectorConfiguration {
        protected Integer slot = null;
        protected String name = null;
        protected String description = null;
        protected List<String> lore = null;
        protected String unavailableMessage;
        protected boolean placeholder;
        protected boolean unavailable;
        protected SelectorConfiguration defaults;
        protected Double startingAttributeValue;

        public SelectorOption(SelectorConfiguration defaults, ConfigurationSection configuration, CastContext context) {
            Warp warp;
            String template;
            MagicAttribute attribute;
            Kit kit;
            this.defaults = defaults;
            this.selectedMessage = defaults.selectedMessage;
            this.selectedFreeMessage = defaults.selectedFreeMessage;
            this.items = defaults.items;
            this.costs = defaults.costs;
            this.earnScale = defaults.earnScale;
            this.costScale = defaults.costScale;
            this.isSell = defaults.isSell;
            this.warpKey = defaults.warpKey;
            this.castSpell = defaults.castSpell;
            this.castSpellParameters = defaults.castSpellParameters;
            this.applyToWand = defaults.applyToWand;
            this.applyToCaster = defaults.applyToCaster;
            this.applyTo = defaults.applyTo;
            this.applyToClass = defaults.applyToClass;
            this.attributeKey = defaults.attributeKey;
            this.attributeAmount = defaults.attributeAmount;
            this.allowAttributeReduction = defaults.allowAttributeReduction;
            this.unlockClass = defaults.unlockClass;
            this.lockClasses = defaults.lockClasses;
            this.kitKey = defaults.kitKey;
            this.switchClass = defaults.switchClass;
            this.putInHand = defaults.putInHand;
            this.limit = defaults.limit;
            this.unlockKey = defaults.unlockKey;
            this.unlockEarns = defaults.unlockEarns;
            this.unlockSection = defaults.unlockSection;
            this.showConfirmation = defaults.showConfirmation;
            this.unbreakableIcon = defaults.unbreakableIcon;
            this.iconHideFlags = defaults.iconHideFlags;
            this.costType = defaults.costType;
            this.costTypeFallbacks = defaults.costTypeFallbacks;
            this.earnType = defaults.earnType;
            this.showUnavailable = defaults.showUnavailable;
            this.commands = defaults.commands;
            this.commandSourceType = defaults.commandSourceType;
            this.actions = defaults.actions;
            this.free = defaults.free;
            this.costOverride = defaults.costOverride;
            this.effects = defaults.effects;
            this.removeLore = defaults.removeLore;
            this.applyLoreToItem = defaults.applyLoreToItem;
            this.applyNameToItem = defaults.applyNameToItem;
            this.nameIcon = defaults.nameIcon;
            this.allowDroppedItems = defaults.allowDroppedItems;
            this.iconKey = defaults.iconKey;
            this.iconPlaceholderKey = defaults.iconPlaceholderKey;
            this.iconDisabledKey = defaults.iconDisabledKey;
            this.autoClose = defaults.autoClose;
            this.showFree = defaults.showFree;
            this.lore = configuration.contains("lore") ? configuration.getStringList("lore") : new ArrayList();
            this.parseOverrides(configuration);
            this.parseIcon(configuration);
            boolean bl = this.placeholder = configuration.getBoolean("placeholder") || configuration.getString("item", "").equals("none") || this.iconKey != null && (this.iconKey.equals("none") || this.iconKey.equals("air"));
            if (this.placeholder) {
                this.makePlaceholder();
                return;
            }
            this.parse(configuration);
            if (!this.showFree && (this.costs == null || this.costs.isEmpty())) {
                this.makePlaceholder();
                return;
            }
            if (defaults.requirements != null) {
                if (this.requirements == null) {
                    this.requirements = defaults.requirements;
                } else {
                    this.requirements.addAll(defaults.requirements);
                }
            }
            if (configuration.contains("slot")) {
                this.slot = configuration.getInt("slot");
            }
            this.name = "";
            String nameKey = configuration.getString("name_key");
            if (nameKey != null && !nameKey.isEmpty()) {
                this.name = context.getMessage(nameKey);
            }
            this.name = configuration.getString("name", this.name);
            MageController controller = context.getController();
            if (this.name.isEmpty() && this.unlockClass != null) {
                MageClassTemplate mageClass = controller.getMageClassTemplate(this.unlockClass);
                this.name = SelectorAction.this.getMessage("unlock_class");
                if (mageClass != null) {
                    this.name = this.name.replace("$class", mageClass.getName());
                } else {
                    controller.getLogger().warning("Unknown class in selector config: " + this.unlockClass);
                }
            }
            if (this.name.isEmpty() && this.kitKey != null && !this.kitKey.isEmpty() && (kit = controller.getKit(this.kitKey)) != null) {
                this.name = kit.getName();
            }
            String castSpell = this.getCastSpell(context.getWand());
            if (this.name.isEmpty() && castSpell != null && !castSpell.isEmpty()) {
                SpellTemplate spell = controller.getSpellTemplate(castSpell);
                this.name = SelectorAction.this.getMessage("cast_spell");
                if (spell != null) {
                    this.name = this.name.replace("$spell", spell.getName());
                } else {
                    controller.getLogger().warning("Unknown spell in selector config: " + castSpell);
                }
            }
            MagicAttribute magicAttribute = attribute = this.attributeKey == null ? null : controller.getAttribute(this.attributeKey);
            if (this.name.isEmpty() && attribute != null) {
                this.name = attribute.getName(controller.getMessages());
                if (this.attributeAmount != 0) {
                    String template2 = this.attributeAmount < 0 ? SelectorAction.this.getMessage("decrease_attribute") : SelectorAction.this.getMessage("increase_attribute");
                    this.name = template2.replace("$attribute", this.name).replace("$amount", Integer.toString(Math.abs(this.attributeAmount)));
                }
            }
            if (this.attributeKey != null) {
                this.startingAttributeValue = context.getAttribute(this.attributeKey);
            }
            if (this.name.isEmpty() && this.items != null) {
                ItemStack item = (ItemStack)this.items.get(0);
                this.name = controller.describeItem(item);
                if (item.getAmount() > 1) {
                    template = SelectorAction.this.getMessage("item_amount");
                    this.name = template.replace("$name", this.name).replace("$amount", Integer.toString(item.getAmount()));
                }
            }
            if (this.name.isEmpty() && this.warpKey != null && (warp = controller.getMagicWarp(this.warpKey)) != null) {
                this.name = warp.getName();
            }
            if (this.name.isEmpty() && this.iconKey != null) {
                ItemStack icon = SelectorAction.this.parseItem(this.iconKey);
                if (icon != null) {
                    this.name = controller.describeItem(icon);
                    if (icon.getAmount() > 1) {
                        template = SelectorAction.this.getMessage("item_amount");
                        this.name = template.replace("$name", this.name).replace("$amount", Integer.toString(icon.getAmount()));
                    }
                } else {
                    controller.getLogger().warning("Invalid icon in selector: " + this.iconKey);
                }
            }
            this.name = CompatibilityLib.getCompatibilityUtils().translateColors(this.name);
            this.description = configuration.getString("description");
            if (this.description == null) {
                Kit kit2;
                if (this.unlockClass != null && !this.unlockClass.isEmpty()) {
                    MageClassTemplate mageClass = controller.getMageClassTemplate(this.unlockClass);
                    if (mageClass != null) {
                        this.description = mageClass.getDescription();
                    } else {
                        controller.getLogger().warning("Unknown class in selector config: " + this.unlockClass);
                    }
                } else if (castSpell != null && !castSpell.isEmpty()) {
                    SpellTemplate spell = controller.getSpellTemplate(castSpell);
                    if (spell == null) {
                        controller.getLogger().warning("Unknown spell in selector config: " + castSpell);
                    } else {
                        this.description = spell.getDescription();
                    }
                } else if (attribute != null && this.attributeAmount == 0) {
                    this.description = attribute.getDescription(controller.getMessages());
                } else if (this.warpKey != null) {
                    warp = controller.getMagicWarp(this.warpKey);
                    if (warp != null) {
                        this.description = warp.getDescription();
                    }
                } else if (this.kitKey != null && (kit2 = controller.getKit(this.kitKey)) != null) {
                    this.description = kit2.getDescription();
                }
            }
            this.updateIcon(context);
        }

        @Override
        protected void convertToSell(ConfigurationSection configuration) {
            String itemName;
            if (configuration.contains("scale") && !configuration.contains("earn_scale")) {
                configuration.set("earn_scale", configuration.get("scale"));
                configuration.set("scale", null);
            }
            if (!configuration.contains("selected")) {
                configuration.set("selected", (Object)SelectorAction.this.context.getController().getMessages().get("shops.sold"));
            }
            if ((itemName = configuration.getString("item")) == null || itemName.equalsIgnoreCase("none")) {
                return;
            }
            configuration.set("item", null);
            configuration.set("icon", (Object)itemName);
            ItemStack item = SelectorAction.this.parseItem(itemName);
            if (item == null) {
                return;
            }
            Object costs = configuration.get("cost");
            if (costs != null) {
                configuration.set("earn", costs);
                configuration.set("cost", null);
            } else {
                Double worth = SelectorAction.this.context.getController().getEarns(item, SelectorAction.this.defaultConfiguration.earnType);
                if (worth != null && worth > 0.0) {
                    configuration.set("earn", (Object)worth);
                }
            }
            ConfigurationSection costSection = configuration.createSection("costs");
            CurrencyAmount currency = CompatibilityLib.getInventoryUtils().getCurrencyAmount(item);
            if (currency != null) {
                costSection.set(currency.getType(), (Object)currency.getAmount());
            } else {
                costSection.set(itemName, (Object)item.getAmount());
            }
        }

        private void makePlaceholder() {
            this.placeholder = true;
            String placeholderKey = this.iconKey == null || this.iconKey.isEmpty() ? this.iconPlaceholderKey : this.iconKey;
            this.icon = SelectorAction.this.parseItem(placeholderKey);
            if (CompatibilityLib.getItemUtils().isEmpty(this.icon)) {
                this.icon = new ItemStack(Material.AIR);
            } else {
                this.icon = CompatibilityLib.getItemUtils().makeReal(this.icon);
                CompatibilityLib.getItemUtils().makeUnbreakable(this.icon);
                CompatibilityLib.getItemUtils().hideFlags(this.icon, 63);
                ItemMeta meta = this.icon.getItemMeta();
                meta.setDisplayName(" ");
                this.icon.setItemMeta(meta);
            }
        }

        public void updateIcon(CastContext context) {
            ItemMeta meta;
            ItemStack iconDisabled;
            Kit kit;
            ItemData iconData;
            String iconKey;
            MageClassTemplate mageClass;
            MagicAttribute attribute;
            String costHeading;
            boolean locked;
            Mage mage;
            ConfigurationSection unlocks;
            MageController controller = context.getController();
            this.unavailable = false;
            this.icon = SelectorAction.this.parseItem(this.iconKey);
            ArrayList<String> lore = new ArrayList<String>();
            if (this.lore != null) {
                for (String loreString : lore) {
                    lore.add(context.parameterize(loreString));
                }
            }
            if (this.description != null && !this.description.isEmpty()) {
                String escapedDescription = context.parameterize(this.description);
                CompatibilityLib.getInventoryUtils().wrapText(escapedDescription, lore);
            }
            boolean unlocked = false;
            if (this.unlockKey != null && !this.unlockKey.isEmpty() && (unlocks = (mage = context.getMage()).getData().getConfigurationSection(this.unlockSection)) != null && unlocks.getBoolean(this.unlockKey, false)) {
                unlocked = true;
                this.costs = null;
                this.showConfirmation = false;
                String unlockedMessage = SelectorAction.this.getMessage("unlocked_lore");
                CompatibilityLib.getInventoryUtils().wrapText(unlockedMessage, lore);
            }
            if (!unlocked) {
                RequirementsResult check = this.checkRequirements(context);
                if (!check.result.isSuccess() && !this.hasAltTags(context.getWand())) {
                    this.unavailable = true;
                    this.unavailableMessage = check.message;
                    if (this.unavailableMessage != null && !this.unavailableMessage.isEmpty()) {
                        CompatibilityLib.getInventoryUtils().wrapText(check.message, lore);
                    }
                }
            }
            boolean bl = locked = this.unlockKey != null && !this.unlockKey.isEmpty() && !unlocked;
            if (this.costs != null && !this.unavailable) {
                costHeading = SelectorAction.this.getMessage("cost_heading");
                if (!costHeading.isEmpty()) {
                    CompatibilityLib.getInventoryUtils().wrapText(costHeading, lore);
                }
                String costKey = this.unlockKey != null && !this.unlockKey.isEmpty() ? "unlock_cost_lore" : "cost_lore";
                String requiredKey = this.unlockKey != null && !this.unlockKey.isEmpty() ? "required_unlock_cost_lore" : "required_cost_lore";
                String costString = SelectorAction.this.getMessage(costKey);
                String requiredCostString = SelectorAction.this.getMessage(requiredKey);
                for (Cost cost : this.costs) {
                    if (this.costModifiers != null) {
                        for (CostModifier modifier : this.costModifiers) {
                            modifier.modify(cost);
                        }
                    }
                    Object costDescription = cost.has(context.getMage(), context.getWand()) ? costString : requiredCostString;
                    costDescription = ((String)costDescription).replace("$cost", cost.getFullDescription(context.getController().getMessages()));
                    CompatibilityLib.getInventoryUtils().wrapText((String)costDescription, lore);
                }
            } else if (locked && (this.earns == null || !this.unlockEarns)) {
                this.unavailable = true;
                String lockedMessage = SelectorAction.this.getMessage("locked");
                if (!lockedMessage.isEmpty()) {
                    CompatibilityLib.getInventoryUtils().wrapText(lockedMessage, lore);
                    if (this.unavailableMessage == null) {
                        this.unavailableMessage = lockedMessage;
                    }
                }
            }
            if (this.earns != null && (locked || !this.unlockEarns)) {
                costHeading = SelectorAction.this.getMessage("earn_heading");
                if (!costHeading.isEmpty()) {
                    CompatibilityLib.getInventoryUtils().wrapText(costHeading, lore);
                }
                String earnString = SelectorAction.this.getMessage("earn_lore");
                for (Cost earn : this.earns) {
                    if (this.earnModifiers != null) {
                        for (CostModifier modifier : this.earnModifiers) {
                            modifier.modify(earn);
                        }
                    }
                    earnString = earnString.replace("$earn", earn.getFullDescription(context.getController().getMessages()));
                    CompatibilityLib.getInventoryUtils().wrapText(earnString, lore);
                }
            }
            if (this.icon == null && this.items != null) {
                List<String> iconLore;
                this.icon = CompatibilityLib.getItemUtils().getCopy((ItemStack)this.items.get(0));
                if (this.applyLoreToItem && this.lore != null && !this.lore.isEmpty()) {
                    ItemMeta meta2 = this.icon.getItemMeta();
                    meta2.setLore(null);
                    this.icon.setItemMeta(meta2);
                } else if ((this.applyToWand || this.applyToCaster) && controller.isWandUpgrade(this.icon) && (iconLore = CompatibilityLib.getCompatibilityUtils().getRawLore(this.icon)) != null && !iconLore.isEmpty()) {
                    iconLore.remove(iconLore.size() - 1);
                    CompatibilityLib.getCompatibilityUtils().setRawLore(this.icon, iconLore);
                }
            }
            if (this.icon == null && this.castSpell != null && !this.castSpell.isEmpty()) {
                String spellToCast = this.getCastSpell(context.getWand());
                SpellTemplate spellTemplate = context.getController().getSpellTemplate(spellToCast);
                if (spellTemplate != null) {
                    if (this.unavailable && spellTemplate.getDisabledIcon() != null) {
                        this.icon = spellTemplate.getDisabledIcon().getItemStack(1);
                    }
                    if (this.icon == null && spellTemplate.getIcon() != null) {
                        this.icon = spellTemplate.getIcon().getItemStack(1);
                    }
                    if (this.icon == null && this.unavailable && spellTemplate.getDisabledIconURL() != null) {
                        this.icon = controller.getURLSkull(spellTemplate.getDisabledIconURL());
                    }
                    if (this.icon == null && spellTemplate.getIconURL() != null) {
                        this.icon = controller.getURLSkull(spellTemplate.getIconURL());
                    }
                }
            }
            if (this.icon == null && this.warpKey != null && !this.warpKey.isEmpty()) {
                ItemData itemData;
                String icon;
                Warp warp = controller.getMagicWarp(this.warpKey);
                String string = icon = warp == null ? null : warp.getIcon();
                if (icon != null && !icon.isEmpty() && (itemData = controller.getOrCreateItem(icon)) != null) {
                    this.icon = itemData.getItemStack();
                }
            }
            MagicAttribute magicAttribute = attribute = this.attributeKey == null ? null : controller.getAttribute(this.attributeKey);
            if (this.icon == null && attribute != null) {
                ItemData iconData2;
                String iconKey2;
                if (this.iconDisabledKey == null) {
                    this.iconDisabledKey = attribute.getIconDisabledKey();
                }
                if ((iconKey2 = attribute.getIconKey()) != null && !iconKey2.isEmpty() && (iconData2 = controller.getOrCreateItem(iconKey2)) != null) {
                    this.icon = iconData2.getItemStack();
                }
            }
            if (this.icon != null && attribute != null) {
                int amount = 1;
                CasterProperties caster = this.getCaster(context);
                Double currentAmount = caster.getAttribute(this.attributeKey);
                if (currentAmount != null) {
                    if (this.attributeAmount == 0) {
                        amount = (int)Math.floor(currentAmount);
                    } else {
                        double newValue = (double)this.attributeAmount + currentAmount;
                        boolean allowed = attribute.inRange(newValue);
                        if (!this.allowAttributeReduction && this.startingAttributeValue != null && newValue < this.startingAttributeValue) {
                            allowed = false;
                        }
                        if (!allowed) {
                            this.unavailable = true;
                            String template = this.attributeAmount < 0 ? SelectorAction.this.getMessage("attribute_min") : SelectorAction.this.getMessage("attribute_max");
                            this.unavailableMessage = template.replace("$attribute", attribute.getName(context.getController().getMessages()));
                        }
                    }
                }
                this.icon.setAmount(Math.max(1, amount));
            }
            if (this.icon == null && this.unlockClass != null && (mageClass = controller.getMageClassTemplate(this.unlockClass)) != null) {
                if (this.iconDisabledKey == null) {
                    this.iconDisabledKey = mageClass.getIconDisabledKey();
                }
                if ((iconKey = mageClass.getIconKey()) != null && !iconKey.isEmpty() && (iconData = controller.getOrCreateItem(iconKey)) != null) {
                    this.icon = iconData.getItemStack();
                }
            }
            if (this.icon == null && this.kitKey != null && !this.kitKey.isEmpty() && (kit = controller.getKit(this.kitKey)) != null) {
                if (this.iconDisabledKey == null) {
                    this.iconDisabledKey = kit.getIconDisabledKey();
                }
                if ((iconKey = kit.getIconKey()) != null && !iconKey.isEmpty() && (iconData = controller.getOrCreateItem(iconKey)) != null) {
                    this.icon = iconData.getItemStack();
                }
            }
            if (this.unavailable && this.iconDisabledKey != null && (iconDisabled = context.getController().createDisabledItem(this.iconDisabledKey, context.getMage())) != null) {
                this.icon = iconDisabled;
            }
            if (this.icon == null && this.defaults.icon != null) {
                this.icon = CompatibilityLib.getItemUtils().getCopy(this.defaults.icon);
            }
            ItemMeta itemMeta = meta = this.icon == null ? null : this.icon.getItemMeta();
            if (this.icon == null || meta == null) {
                this.icon = controller.getURLSkull("http://textures.minecraft.net/texture/1adaf6e6e387bc18567671bb82e948488bbacff97763ee5985442814989f5d");
                meta = this.icon.getItemMeta();
                if (meta == null) {
                    this.icon = new ItemStack(Wand.DefaultUpgradeMaterial);
                    meta = this.icon.getItemMeta();
                }
                if (this.name.isEmpty()) {
                    this.name = SelectorAction.this.getMessage("invalid_item");
                    meta.setDisplayName(this.name);
                }
            }
            if (this.nameIcon) {
                Double value;
                String name = this.name;
                if (this.attributeKey != null && this.attributeAmount == 0 && (value = context.getAttribute(this.attributeKey)) != null) {
                    String template = SelectorAction.this.getMessage("attribute");
                    name = template.replace("$attribute", name).replace("$amount", Integer.toString((int)value.doubleValue()));
                }
                name = context.parameterize(name);
                meta.setDisplayName(name);
            }
            if (this.removeLore) {
                meta.setLore(new ArrayList());
            }
            if (!lore.isEmpty()) {
                ArrayList<String> itemLore = meta.getLore();
                if (itemLore == null) {
                    itemLore = new ArrayList<String>();
                }
                for (String line : lore) {
                    itemLore.add(CompatibilityLib.getCompatibilityUtils().translateColors(line));
                }
                meta.setLore(itemLore);
            }
            this.icon.setItemMeta(meta);
            this.icon = CompatibilityLib.getItemUtils().makeReal(this.icon);
            if (this.unbreakableIcon) {
                CompatibilityLib.getItemUtils().makeUnbreakable(this.icon);
            }
            CompatibilityLib.getItemUtils().hideFlags(this.icon, this.iconHideFlags);
            if (this.unavailable) {
                if (this.unavailableMessage != null && !this.unavailableMessage.isEmpty()) {
                    CompatibilityLib.getNBTUtils().setString(this.icon, "unpurchasable", this.unavailableMessage);
                } else {
                    this.showUnavailable = false;
                }
            }
            if (this.showConfirmation) {
                CompatibilityLib.getNBTUtils().setString(this.icon, "confirm", "true");
            }
        }

        @Nullable
        protected String getCastSpell(com.elmakers.mine.bukkit.api.wand.Wand wand) {
            if (this.alternateSpellTags != null && wand != null) {
                for (String key : this.alternateSpellTags.keySet()) {
                    if (!wand.hasTag(key)) continue;
                    return (String)this.alternateSpellTags.get(key);
                }
            }
            return this.castSpell;
        }

        protected boolean hasAltTags(com.elmakers.mine.bukkit.api.wand.Wand wand) {
            if (this.alternateSpellTags == null || wand == null) {
                return false;
            }
            for (String key : this.alternateSpellTags.keySet()) {
                if (!wand.hasTag(key)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        protected Cost takeCosts(CastContext context) {
            Cost required = this.getRequiredCost(context);
            if (required != null) {
                return required;
            }
            boolean messaged = false;
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    cost.deduct(context.getMage(), context.getWand());
                    if (SelectorAction.this.ownerId == null || !context.getController().isVaultCurrencyEnabled() || !cost.isVaultCurrency()) continue;
                    OfflinePlayer targetPlayer = context.getPlugin().getServer().getOfflinePlayer(SelectorAction.this.ownerId);
                    if (targetPlayer == null) {
                        context.getLogger().warning("Couldn't look up player with uuid " + SelectorAction.this.ownerId + " for shop payment");
                        continue;
                    }
                    double scaledAmount = cost.getAmount();
                    scaledAmount = Math.ceil(scaledAmount * this.earnScale);
                    context.getController().depositVaultCurrency(targetPlayer, scaledAmount);
                    if (messaged) continue;
                    messaged = true;
                    String message = SelectorAction.this.getMessage("paid").replace("$owner", targetPlayer.getName());
                    context.showMessage(message);
                }
            }
            return null;
        }

        @Nullable
        public Cost getRequiredCost(CastContext context) {
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (cost.has(context.getMage(), context.getWand())) continue;
                    return cost;
                }
            }
            return null;
        }

        public SpellResult give(CastContext context) {
            Cost required;
            String castSpell;
            Mage mage = context.getMage();
            com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
            MageController controller = context.getController();
            if (this.placeholder) {
                return SpellResult.NO_ACTION;
            }
            if (this.unlockClass != null) {
                if (mage.hasClassUnlocked(this.unlockClass)) {
                    String hasClassMessage = SelectorAction.this.getMessage("has_class").replace("$class", this.name);
                    context.showMessage(hasClassMessage);
                    return SpellResult.NO_TARGET;
                }
                MageClass activeClass = mage.getActiveClass();
                if (this.switchClass && activeClass != null) {
                    mage.lockClass(activeClass.getKey());
                }
                mage.unlockClass(this.unlockClass);
                if (this.lockClasses != null) {
                    for (Object lockClass : this.lockClasses) {
                        if (lockClass == null || ((String)lockClass).isEmpty()) continue;
                        mage.lockClass((String)lockClass);
                    }
                }
                if (this.switchClass) {
                    mage.setActiveClass(this.unlockClass);
                    wand = SelectorAction.this.actionContext.checkWand();
                }
            } else if (this.lockClasses != null) {
                for (String lockClass : this.lockClasses) {
                    if (lockClass == null || lockClass.isEmpty()) continue;
                    mage.lockClass(lockClass);
                }
            }
            if (this.kitKey != null && !this.kitKey.isEmpty()) {
                Kit kit = controller.getKit(this.kitKey);
                if (this.kitKey != null) {
                    if (!kit.isAllowed(mage)) {
                        return SpellResult.NO_TARGET;
                    }
                    kit.give(mage);
                }
            }
            CasterProperties caster = this.getCaster(context);
            if (this.applyToWand && caster == null) {
                context.showMessage("no_wand", SelectorAction.this.getDefaultMessage(context, "no_wand"));
                return SpellResult.NO_TARGET;
            }
            if (caster != null && this.items != null) {
                boolean anyApplied = false;
                for (ItemStack item : this.items) {
                    anyApplied = caster.addItem(item) || anyApplied;
                }
                if (!anyApplied) {
                    String inapplicable = SelectorAction.this.getMessage("not_applicable").replace("$item", this.name);
                    context.showMessage(inapplicable);
                    return SpellResult.NO_TARGET;
                }
            }
            if (caster != null && this.attributeKey != null && !this.attributeKey.isEmpty()) {
                MagicAttribute attributeDefinition = context.getController().getAttribute(this.attributeKey);
                Double amount = caster.getAttribute(this.attributeKey);
                if (amount != null && attributeDefinition != null) {
                    double newValue = amount + (double)this.attributeAmount;
                    if (!attributeDefinition.inRange(newValue)) {
                        return SpellResult.NO_TARGET;
                    }
                    caster.setAttribute(this.attributeKey, newValue);
                    if (!this.autoClose && SelectorAction.this.displayInventory != null) {
                        for (Map.Entry entry : SelectorAction.this.showingItems.entrySet()) {
                            SelectorOption option = (SelectorOption)entry.getValue();
                            if (option.isPlaceholder()) continue;
                            option.updateIcon(context);
                            ItemStack icon = option.getIcon();
                            CompatibilityLib.getNBTUtils().setString(icon, "slot", Integer.toString((Integer)entry.getKey()));
                            SelectorAction.this.displayInventory.setItem(((Integer)entry.getKey()).intValue(), icon);
                        }
                    }
                } else {
                    context.getLogger().warning("Invalid attribute: " + this.attributeKey);
                }
            }
            if ((castSpell = this.getCastSpell(context.getWand())) != null && !castSpell.isEmpty()) {
                MageSpell spell = null;
                spell = mage.getSpell(castSpell);
                if (this.autoClose) {
                    mage.deactivateGUI();
                }
                if (spell == null || !spell.cast(this.castSpellParameters)) {
                    context.showMessage("cast_fail", SelectorAction.this.getDefaultMessage(context, "cast_fail"));
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.warpKey != null && !this.warpKey.isEmpty()) {
                Entity entity;
                Location location = controller.getWarp(this.warpKey);
                if (location == null) {
                    context.showMessage("warp_fail", SelectorAction.this.getDefaultMessage(context, "warp_fail"));
                    return SpellResult.NO_TARGET;
                }
                if (location.getWorld() == null) {
                    String worldName;
                    Warp magicWarp = controller.getMagicWarp(this.warpKey);
                    if (magicWarp != null && (worldName = magicWarp.getWorldName()) != null) {
                        controller.createWorld(worldName);
                        location = magicWarp.getLocation();
                    }
                    if (location.getWorld() == null) {
                        context.showMessage("warp_fail", SelectorAction.this.getDefaultMessage(context, "warp_fail"));
                        return SpellResult.NO_TARGET;
                    }
                }
                if ((entity = mage.getEntity()) != null) {
                    entity.teleport(location);
                }
            }
            if (this.unlockKey != null && !this.unlockKey.isEmpty()) {
                ConfigurationSection unlocks = mage.getData().getConfigurationSection(this.unlockSection);
                if (unlocks != null && !unlocks.getBoolean(this.unlockKey)) {
                    String unlockMessage = this.unlockEarns ? SelectorAction.this.getMessage("unlocked_earn") : SelectorAction.this.getMessage("unlocked");
                    context.showMessage(this.getCostsMessage(unlockMessage));
                }
                if (unlocks == null) {
                    unlocks = mage.getData().createSection(this.unlockSection);
                }
                unlocks.set(this.unlockKey, (Object)true);
            }
            if (this.items != null && caster == null) {
                boolean gave = false;
                for (ItemStack item : this.items) {
                    ItemStack copy = CompatibilityLib.getItemUtils().getCopy(item);
                    if (this.allowDroppedItems) {
                        mage.giveItem(copy, this.putInHand);
                        gave = true;
                        continue;
                    }
                    gave = mage.tryGiveItem(copy, this.putInHand) || gave;
                }
                if (!gave) {
                    context.showMessage(SelectorAction.this.getMessage("full"));
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.commands != null && !this.commands.isEmpty()) {
                for (String command : this.commands) {
                    String execute = context.parameterize(command);
                    boolean shouldOp = false;
                    ConsoleCommandSender commandSender = null;
                    switch (this.commandSourceType) {
                        case PLAYER: {
                            commandSender = mage.getPlayer();
                            break;
                        }
                        case OPPED_PLAYER: {
                            commandSender = mage.getPlayer();
                            shouldOp = true;
                            break;
                        }
                        case CONSOLE: {
                            commandSender = Bukkit.getConsoleSender();
                        }
                    }
                    if (commandSender == null) continue;
                    boolean wasOpped = commandSender.isOp();
                    if (!wasOpped && shouldOp) {
                        commandSender.setOp(true);
                    }
                    try {
                        controller.getPlugin().getServer().dispatchCommand((CommandSender)commandSender, execute);
                    }
                    catch (Exception ex) {
                        context.getLogger().log(Level.SEVERE, "Error executing command: " + execute, ex);
                    }
                    if (wasOpped || !shouldOp) continue;
                    commandSender.setOp(false);
                }
            }
            if (this.earns != null) {
                boolean givenAny = false;
                for (Cost cost : this.earns) {
                    givenAny = cost.give(mage, wand) || givenAny;
                }
                if (!givenAny) {
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.actions != null) {
                SelectorAction.this.startActions(this.actions);
            }
            if ((required = this.takeCosts(context)) != null) {
                String baseMessage = SelectorAction.this.getMessage("insufficient");
                String costDescription = required.getFullDescription(controller.getMessages());
                costDescription = baseMessage.replace("$cost", costDescription);
                context.showMessage(costDescription);
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
            if (!this.checkChestLocation(true)) {
                context.showMessage(SelectorAction.this.getMessage("nostock"));
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
            if (!this.effects.isEmpty()) {
                context.playEffects(this.effects);
            }
            return SpellResult.CAST;
        }

        private boolean checkChestLocation(boolean take) {
            if (SelectorAction.this.chestLocation == null) {
                return true;
            }
            if (this.slot == null) {
                return false;
            }
            if (this.items == null || this.items.size() != 1) {
                return false;
            }
            Block block = SelectorAction.this.chestLocation.getBlock();
            BlockState state = block.getState();
            if (state instanceof Container) {
                Container container = (Container)state;
                ItemStack containerItem = container.getInventory().getItem(this.slot.intValue());
                if (CompatibilityLib.getItemUtils().isEmpty(containerItem)) {
                    return false;
                }
                ItemStack giveItem = (ItemStack)this.items.get(0);
                if (giveItem.getAmount() != containerItem.getAmount()) {
                    return false;
                }
                if (SelectorAction.this.context.getController().itemsAreEqual(giveItem, containerItem)) {
                    if (take) {
                        container.getInventory().setItem(this.slot.intValue(), new ItemStack(Material.AIR));
                    }
                    return true;
                }
            }
            return false;
        }

        @Nullable
        public CasterProperties getCaster(CastContext context) {
            Mage mage = context.getMage();
            com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
            CasterProperties caster = null;
            if (this.applyTo != null) {
                MagicConfigurable properties = mage.getProperties().getStorage(this.applyTo);
                if (properties instanceof CasterProperties) {
                    caster = (CasterProperties)properties;
                }
            } else if (this.applyToClass != null) {
                caster = mage.getClass(this.applyToClass);
            } else if (this.applyToWand) {
                caster = wand;
            } else if (this.applyToCaster) {
                caster = mage.getActiveProperties();
            }
            return caster;
        }

        public Integer getSlot() {
            return this.slot;
        }

        public boolean isPlaceholder() {
            return this.placeholder;
        }

        public boolean isUnavailable() {
            return this.unavailable;
        }

        @Nullable
        public ItemStack getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public String getSelectedMessage() {
            CompatibilityUtils compatibilityUtils = CompatibilityLib.getCompatibilityUtils();
            String message = this.costs == null ? (this.selectedFreeMessage != null ? compatibilityUtils.translateColors(this.selectedFreeMessage) : (this.selectedMessage != null ? compatibilityUtils.translateColors(this.selectedMessage) : SelectorAction.this.getMessage("selected_free"))) : (this.selectedMessage != null ? compatibilityUtils.translateColors(this.selectedMessage) : SelectorAction.this.getMessage("selected"));
            return this.getCostsMessage(message);
        }

        public String getCostsMessage(String baseMessage) {
            String costString = "";
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (!costString.isEmpty()) {
                        costString = costString + ", ";
                    }
                    costString = costString + cost.getFullDescription(SelectorAction.this.context.getController().getMessages());
                }
            }
            if (costString.isEmpty()) {
                costString = SelectorAction.this.getMessage("nothing");
            }
            String earnString = "";
            if (this.earns != null) {
                for (Cost earn : this.earns) {
                    if (!earnString.isEmpty()) {
                        earnString = earnString + ", ";
                    }
                    earnString = earnString + earn.getFullDescription(SelectorAction.this.context.getController().getMessages());
                }
            }
            if (earnString.isEmpty()) {
                earnString = SelectorAction.this.getMessage("nothing");
            }
            return baseMessage.replace("$item", this.name).replace("$name", this.name).replace("$cost", costString).replace("$earn", earnString);
        }
    }

    protected class RequirementsResult {
        public final SpellResult result;
        public final String message;

        public RequirementsResult(SpellResult result, String message) {
            this.result = result;
            this.message = message;
        }

        public RequirementsResult(SpellResult result) {
            this(result, this$0.context.getMessage(result.name().toLowerCase()));
        }

        public String toString() {
            return this.result.toString() + " " + this.message;
        }
    }

    protected class CostModifier {
        private ModifierType type;
        private String equation;
        private String property;
        private double defaultValue;

        public CostModifier(ConfigurationSection configuration) {
            String typeString = configuration.getString("type");
            try {
                this.type = ModifierType.valueOf(typeString.toUpperCase());
            }
            catch (Exception ex) {
                SelectorAction.this.context.getLogger().warning("Invalid modifier type in selector config: " + typeString);
                this.type = null;
                return;
            }
            this.defaultValue = configuration.getDouble("default");
            this.equation = configuration.getString("scale");
            this.property = this.type == ModifierType.ATTRIBUTE ? configuration.getString("attribute") : configuration.getString("property");
        }

        public void modify(Cost cost) {
            if (this.type == null) {
                return;
            }
            Mage mage = SelectorAction.this.context.getMage();
            double value = this.defaultValue;
            switch (this.type) {
                case MAGE: {
                    value = mage.getProperties().getProperty(this.property, value);
                    break;
                }
                case ATTRIBUTE: {
                    Double attribute = SelectorAction.this.context.getAttribute(this.property);
                    if (attribute == null) break;
                    value = attribute;
                    break;
                }
                case CLASS: {
                    MageClass activeClass = mage.getActiveClass();
                    if (activeClass == null) break;
                    value = activeClass.getProperty(this.property, value);
                    break;
                }
                case WAND: {
                    com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
                    if (wand == null) break;
                    value = wand.getProperty(this.property, value);
                }
            }
            EquationTransform transform = EquationStore.getInstance().getTransform(this.equation);
            transform.setVariable("x", value);
            double scale = transform.get();
            cost.scale(scale);
        }
    }

    protected static enum CommandSourceType {
        PLAYER,
        CONSOLE,
        OPPED_PLAYER;

    }

    protected static enum ModifierType {
        WAND,
        MAGE,
        CLASS,
        ATTRIBUTE;

    }
}

