/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RegisterTask
implements Runnable {
    private static final Object registerLock = new Object();
    private final Logger logger;
    private final File registerFile;
    private final String playerId;
    private final String playerName;
    private final String code;
    private final String skinURL;

    public RegisterTask(Plugin plugin, Player player, String code) {
        this.logger = plugin.getLogger();
        File dataFolder = new File(plugin.getDataFolder(), "data");
        this.registerFile = new File(dataFolder, "registered.yml");
        this.playerId = player.getUniqueId().toString();
        this.playerName = player.getName();
        this.skinURL = CompatibilityLib.getSkinUtils().getOnlineSkinURL(this.playerName);
        this.code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = registerLock;
        synchronized (object) {
            this.register();
        }
    }

    private void register() {
        this.registerFile.getParentFile().mkdirs();
        YamlConfiguration registered = new YamlConfiguration();
        if (this.registerFile.exists()) {
            try {
                registered.load(this.registerFile);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error reading " + this.registerFile, ex);
                return;
            }
        }
        ConfigurationSection playerSection = registered.createSection(this.playerId);
        playerSection.set("name", (Object)this.playerName);
        playerSection.set("code", (Object)this.code);
        playerSection.set("skin_url", (Object)this.skinURL);
        try {
            registered.save(this.registerFile);
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "Error saving " + this.registerFile, ex);
            return;
        }
    }
}

