/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MagicGiveCommandExecutor
extends MagicTabExecutor {
    public MagicGiveCommandExecutor(MagicAPI api) {
        super(api, "mgive");
    }

    public boolean onCommand(final CommandSender sender, Command command, String label, String[] args) {
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0 || args.length > 3) {
            sender.sendMessage("Usage: mgive [player] <item> [count]");
            return true;
        }
        String playerName = null;
        String itemName = null;
        String countString = null;
        if (args.length == 1) {
            itemName = args[0];
        } else if (args.length == 3) {
            playerName = args[0];
            itemName = args[1];
            countString = args[2];
        } else {
            playerName = args[0];
            Player testPlayer = CompatibilityLib.getDeprecatedUtils().getPlayer(playerName);
            if (testPlayer == null && !playerName.startsWith("@")) {
                itemName = args[0];
                countString = args[1];
                playerName = null;
            } else {
                itemName = args[1];
            }
        }
        int count = 1;
        if (countString != null) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (Exception ex) {
                sender.sendMessage("Error parsing count: " + countString + ", should be an integer.");
                return true;
            }
        }
        if (!this.api.hasPermission(sender, "magic.create." + itemName) && !this.api.hasPermission(sender, "magic.create.*")) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to create " + itemName);
            return true;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        if (playerName != null && sender.hasPermission("magic.commands.mgive.others")) {
            List<Entity> targets = CompatibilityLib.getCompatibilityUtils().selectEntities(sender, playerName);
            if (targets != null) {
                for (Entity entity : targets) {
                    if (!(entity instanceof Player)) continue;
                    players.add((Player)entity);
                }
            } else {
                Player player = CompatibilityLib.getDeprecatedUtils().getPlayer(playerName);
                if (player == null) {
                    sender.sendMessage("No players matched: " + playerName);
                    return true;
                }
                players.add(player);
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Console usage: mgive <player> <item> [count]");
                return true;
            }
            players.add((Player)sender);
        }
        Set<String> customCosts = this.controller.getCurrencyKeys();
        for (Player player : players) {
            Mage mage;
            if (itemName.equalsIgnoreCase("xp")) {
                this.api.giveExperienceToPlayer(player, count);
                sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + count + ChatColor.AQUA + " experience to " + ChatColor.GOLD + player.getName());
                continue;
            }
            if (itemName.equalsIgnoreCase("sp")) {
                mage = this.controller.getMage(player);
                mage.addSkillPoints(count);
                sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + count + ChatColor.AQUA + " spell points to " + ChatColor.GOLD + player.getName());
                continue;
            }
            if (customCosts.contains(itemName)) {
                mage = this.controller.getMage(player);
                mage.addCurrency(itemName, count);
                sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + count + ChatColor.AQUA + " " + this.controller.getMessages().get("currency." + itemName + ".name", itemName) + " to " + ChatColor.GOLD + player.getName());
                continue;
            }
            mage = this.controller.getMage(player);
            final int itemCount = count;
            final String itemKey = itemName = ItemData.cleanMinecraftItemName(itemName);
            this.api.getController().createItem(itemName, mage, false, new ItemUpdatedCallback(){

                @Override
                public void updated(@Nullable ItemStack itemStack) {
                    if (itemStack == null) {
                        sender.sendMessage(ChatColor.RED + "Unknown item type " + ChatColor.DARK_RED + itemKey);
                        return;
                    }
                    itemStack.setAmount(itemCount);
                    String displayName = MagicGiveCommandExecutor.this.api.describeItem(itemStack);
                    sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + itemCount + " " + ChatColor.LIGHT_PURPLE + displayName + ChatColor.AQUA + " to " + ChatColor.GOLD + mage.getName());
                    mage.giveItem(itemStack, true, true);
                }
            });
        }
        return true;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        HashSet<String> options = new HashSet<String>();
        if (!sender.hasPermission("magic.commands.mgive")) {
            return options;
        }
        if (args.length == 1 && sender.hasPermission("magic.commands.mgive.others")) {
            options.addAll(this.api.getPlayerNames());
        }
        if (args.length == 1 || args.length == 2) {
            Collection<SpellTemplate> spellList = this.api.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
            for (SpellTemplate spellTemplate : spellList) {
                this.addIfPermissible(sender, options, "magic.create.", spellTemplate.getKey());
            }
            Collection<String> allWands = this.api.getWandKeys();
            for (String wandKey : allWands) {
                this.addIfPermissible(sender, options, "magic.create.", wandKey);
            }
            for (Material material : Material.values()) {
                this.addIfPermissible(sender, options, "magic.create.", material.name().toLowerCase());
            }
            Set<String> set = this.api.getController().getItemKeys();
            for (String itemKey : set) {
                this.addIfPermissible(sender, options, "magic.create.", itemKey);
            }
            Set<String> currencies = this.api.getController().getCurrencyKeys();
            for (String string : currencies) {
                this.addIfPermissible(sender, options, "magic.create.", string);
            }
            Collection<String> recipes = this.controller.getRecipeKeys();
            for (String string : recipes) {
                this.addIfPermissible(sender, options, "magic.create.", "recipe:" + string);
            }
            Set<String> set2 = this.controller.getMageClassKeys();
            for (String magicClass : set2) {
                this.addIfPermissible(sender, options, "magic.create.", "recipes:" + magicClass);
            }
            Set<String> set3 = this.controller.getMobKeys();
            for (String mobKey : set3) {
                this.addIfPermissible(sender, options, "magic.create.", "egg:" + mobKey);
            }
            for (EntityType entityType : EntityType.values()) {
                String mobKey = entityType.name().toLowerCase();
                this.addIfPermissible(sender, options, "magic.create.", "egg:" + mobKey);
            }
            this.addIfPermissible(sender, options, "magic.create.", "recipe:*");
            this.addIfPermissible(sender, options, "magic.create.", "recipes:*");
            if (this.api.hasPermission(sender, "magic.create.book")) {
                options.add("book:all");
                options.add("book:categories");
            }
        }
        return options;
    }
}

