/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.magic.MagicController;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class MythicMobManager {
    private final MagicController controller;
    private final Plugin plugin;
    private MythicMobs api = null;

    public MythicMobManager(MagicController controller, Plugin plugin) {
        this.controller = controller;
        this.plugin = plugin;
    }

    public boolean initialize() {
        if (this.plugin == null || !(this.plugin instanceof MythicMobs)) {
            return false;
        }
        this.api = MythicMobs.inst();
        return this.api != null;
    }

    public boolean isEnabled() {
        return this.api != null;
    }

    @Nullable
    public Entity spawn(String key, Location location) {
        ActiveMob mob = this.api.getMobManager().spawnMob(key, location);
        if (mob == null) {
            this.controller.getLogger().warning("Unable to spawn mythic mob with id of " + key);
            return null;
        }
        return mob.getEntity().getBukkitEntity();
    }

    public Collection<String> getMobKeys() {
        return this.api.getMobManager().getMobNames();
    }

    public boolean isMobKey(String mobKey) {
        return this.api.getMobManager().getMobNames().contains(mobKey);
    }

    public void setMobLevel(Entity entity, double level) {
        if (entity == null) {
            return;
        }
        Optional mob = this.api.getMobManager().getActiveMob(entity.getUniqueId());
        if (!mob.isPresent()) {
            return;
        }
        ((ActiveMob)mob.get()).setLevel(level);
    }

    @Nullable
    public Double getMobLevel(Entity entity) {
        if (entity == null) {
            return null;
        }
        Optional mob = this.api.getMobManager().getActiveMob(entity.getUniqueId());
        if (!mob.isPresent()) {
            return null;
        }
        return ((ActiveMob)mob.get()).getLevel();
    }

    @Nullable
    public String getMobKey(Entity entity) {
        if (entity == null) {
            return null;
        }
        Optional mob = this.api.getMobManager().getActiveMob(entity.getUniqueId());
        if (!mob.isPresent()) {
            return null;
        }
        return ((ActiveMob)mob.get()).getMobType();
    }
}

