/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.magic;

import com.elmakers.mine.bukkit.api.automata.Automaton;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.magic.MagicBlockTemplate;
import com.elmakers.mine.bukkit.block.magic.Nearby;
import com.elmakers.mine.bukkit.block.magic.Spawner;
import com.elmakers.mine.bukkit.effect.EffectContext;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MagicBlock
implements Automaton,
com.elmakers.mine.bukkit.api.block.magic.MagicBlock {
    @Nonnull
    private final MagicController controller;
    @Nullable
    private MagicBlockTemplate template;
    @Nullable
    private ConfigurationSection parameters;
    private String templateKey;
    @Nonnull
    private Location location;
    private String worldName;
    private long createdAt;
    private String creatorId;
    private String creatorName;
    private String name;
    private long nextTick;
    private List<WeakReference<Entity>> spawned;
    private long lastSpawn;
    private EffectContext effectContext;
    private boolean pendingWorldLoad;
    private boolean isActive;
    private boolean enabled = true;
    private Mage mage;

    public MagicBlock(@Nonnull MagicController controller, @Nonnull ConfigurationSection node) {
        World world;
        this.controller = controller;
        this.enabled = node.getBoolean("enabled", true);
        this.templateKey = node.getString("template");
        this.parameters = ConfigurationUtils.getConfigurationSection(node, "parameters");
        if (this.templateKey != null) {
            this.setTemplate(controller.getMagicBlockTemplate(this.templateKey));
        }
        if (this.template == null) {
            controller.getLogger().warning("Automaton missing template: " + this.templateKey);
        }
        this.createdAt = node.getLong("created", 0L);
        this.creatorId = node.getString("creator");
        this.creatorName = node.getString("creator_name");
        this.name = node.getString("name");
        double x = node.getDouble("x");
        double y = node.getDouble("y");
        double z = node.getDouble("z");
        float yaw = (float)node.getDouble("yaw");
        float pitch = (float)node.getDouble("pitch");
        this.worldName = node.getString("world");
        if (this.worldName == null || this.worldName.isEmpty()) {
            this.worldName = "world";
            controller.getLogger().warning("Automaton missing world name, defaulting to 'world'");
        }
        if ((world = Bukkit.getWorld((String)this.worldName)) == null) {
            this.pendingWorldLoad = true;
            world = (World)Bukkit.getWorlds().iterator().next();
        }
        this.location = new Location(world, x, y, z, yaw, pitch);
    }

    public MagicBlock(@Nonnull MagicController controller, @Nonnull Location location, @Nonnull String templateKey, String creatorId, String creatorName, @Nullable ConfigurationSection parameters) {
        this.controller = controller;
        this.templateKey = templateKey;
        this.parameters = parameters;
        this.location = location;
        World world = this.location.getWorld();
        this.worldName = world == null ? null : world.getName();
        this.setTemplate(controller.getMagicBlockTemplate(templateKey));
        this.createdAt = System.currentTimeMillis();
        this.creatorId = creatorId;
        this.creatorName = creatorName;
    }

    private void setTemplate(MagicBlockTemplate template) {
        this.template = template;
        if (template != null) {
            if (this.parameters != null) {
                this.template = template.getVariant(this.parameters);
            }
            this.nextTick = 0L;
            this.lastSpawn = 0L;
        }
    }

    public void reload() {
        if (this.template != null) {
            this.setTemplate(this.controller.getMagicBlockTemplate(this.template.getKey()));
        }
    }

    public void save(ConfigurationSection node) {
        node.set("enabled", (Object)this.enabled);
        node.set("created", (Object)this.createdAt);
        node.set("creator", (Object)this.creatorId);
        node.set("creator_name", (Object)this.creatorName);
        node.set("template", (Object)this.templateKey);
        node.set("world", (Object)this.worldName);
        node.set("x", (Object)this.location.getX());
        node.set("y", (Object)this.location.getY());
        node.set("z", (Object)this.location.getZ());
        node.set("yaw", (Object)Float.valueOf(this.location.getYaw()));
        node.set("pitch", (Object)Float.valueOf(this.location.getPitch()));
        node.set("parameters", (Object)this.parameters);
        node.set("name", (Object)this.name);
    }

    public long getCreatedTime() {
        return this.createdAt;
    }

    @Override
    public void pause() {
        this.deactivate();
    }

    @Override
    public void resume() {
        if (this.template == null) {
            return;
        }
        this.tick();
    }

    public void activate() {
        Collection<EffectPlayer> effects;
        this.isActive = true;
        if (this.template != null && (effects = this.template.getEffects()) != null) {
            for (EffectPlayer player : effects) {
                player.start(this.getEffectContext());
            }
        }
    }

    public void deactivate() {
        Collection<EffectPlayer> effects;
        this.isActive = false;
        if (this.spawned != null) {
            for (WeakReference<Entity> mobReference : this.spawned) {
                Entity mob = (Entity)mobReference.get();
                if (mob == null || !mob.isValid()) continue;
                mob.remove();
            }
            this.spawned.clear();
        }
        this.lastSpawn = 0L;
        if (this.effectContext != null) {
            this.effectContext.cancelEffects();
            this.effectContext = null;
        }
        if (this.template != null && (effects = this.template.getEffects()) != null) {
            for (EffectPlayer player : effects) {
                player.cancel();
            }
        }
        if (this.mage != null) {
            Mage mage = this.mage;
            mage.deactivate();
            mage.undoScheduled();
            if (this.template != null && this.template.isUndoAll()) {
                UndoList undone = mage.undo();
                while (undone != null) {
                    undone = mage.undo();
                }
            }
            this.controller.forgetMage(mage);
            this.mage = null;
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.shouldBeActive()) {
            this.resume();
        }
    }

    @Override
    public void disable() {
        this.enabled = false;
        this.pause();
    }

    public boolean shouldBeActive() {
        return this.isAlwaysActive() || this.inActiveChunk();
    }

    public boolean inActiveChunk() {
        return CompatibilityLib.getCompatibilityUtils().isChunkLoaded(this.getLocation());
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
        World world = this.location.getWorld();
        this.worldName = world == null ? null : world.getName();
    }

    public void track(List<Entity> entities) {
        if (this.template == null) {
            return;
        }
        Spawner spawner = this.template.getSpawner();
        if (spawner == null || !spawner.isTracked()) {
            return;
        }
        if (this.spawned == null) {
            this.spawned = new ArrayList<WeakReference<Entity>>();
        }
        for (Entity entity : entities) {
            CompatibilityLib.getEntityMetadataUtils().setLong(entity, MagicMetaKeys.AUTOMATION, this.getId());
            this.spawned.add(new WeakReference<Entity>(entity));
        }
    }

    public void checkEntities() {
        double leashRangeSquared;
        if (this.spawned == null || this.template == null) {
            return;
        }
        Spawner spawner = this.template.getSpawner();
        double d = leashRangeSquared = spawner == null || !spawner.isLeashed() ? 0.0 : (double)spawner.getLimitRange();
        if (leashRangeSquared > 0.0) {
            leashRangeSquared *= leashRangeSquared;
        }
        Iterator<WeakReference<Entity>> iterator = this.spawned.iterator();
        while (iterator.hasNext()) {
            WeakReference<Entity> mobReference = iterator.next();
            Entity mob = (Entity)mobReference.get();
            if (mob == null || !mob.isValid()) {
                iterator.remove();
                continue;
            }
            if (!(leashRangeSquared > 0.0) || !(mob.getLocation().distanceSquared(this.location) > leashRangeSquared)) continue;
            mob.teleport(spawner.getSpawnLocation(this.location));
        }
    }

    public void onSpawnDeath() {
        this.lastSpawn = System.currentTimeMillis();
    }

    public void spawn() {
        if (this.template == null) {
            return;
        }
        Spawner spawner = this.template.getSpawner();
        if (spawner == null) {
            return;
        }
        List<Entity> entities = spawner.spawn(this);
        if (entities != null && !entities.isEmpty()) {
            this.lastSpawn = System.currentTimeMillis();
            this.track(entities);
        }
    }

    public void tick() {
        if (this.template == null || !this.enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextTick) {
            return;
        }
        this.template.tick(this);
        this.nextTick = now + (long)this.template.getInterval();
    }

    public boolean hasSpawner() {
        return this.template != null && this.template.getSpawner() != null;
    }

    public long getTimeToNextSpawn() {
        if (this.template == null) {
            return 0L;
        }
        Spawner spawner = this.template.getSpawner();
        if (spawner == null) {
            return 0L;
        }
        int spawnInterval = spawner.getInterval();
        if (spawnInterval == 0) {
            return 0L;
        }
        return Math.max(0L, this.lastSpawn + (long)spawnInterval - System.currentTimeMillis());
    }

    public int getSpawnLimit() {
        if (this.template == null) {
            return 0;
        }
        Spawner spawner = this.template.getSpawner();
        return spawner == null ? 0 : spawner.getLimit();
    }

    public int getSpawnMinPlayers() {
        if (this.template == null) {
            return 0;
        }
        Spawner spawner = this.template.getSpawner();
        return spawner == null ? 0 : spawner.getMinPlayers();
    }

    public long getId() {
        return BlockData.getBlockId(this.getLocation());
    }

    public boolean isPendingWorldLoad() {
        return this.pendingWorldLoad;
    }

    @Override
    @Nonnull
    public String getTemplateKey() {
        return this.templateKey == null ? "" : this.templateKey;
    }

    @Nullable
    public MagicBlockTemplate getTemplate() {
        return this.template;
    }

    public boolean isAlwaysActive() {
        return this.template != null && this.template.isAlwaysActive();
    }

    public boolean removeWhenBroken() {
        return this.template != null && this.template.removeWhenBroken();
    }

    @Nonnull
    private EffectContext getEffectContext() {
        if (this.effectContext == null) {
            this.effectContext = new EffectContext(this.controller, this.location);
        }
        return this.effectContext;
    }

    @Nullable
    public ConfigurationSection getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable ConfigurationSection parameters) {
        this.parameters = parameters;
    }

    @Nullable
    public String getCreatorName() {
        return this.creatorName;
    }

    @Override
    @Nonnull
    public Mage getMage() {
        if (this.mage == null) {
            String automatonId = UUID.randomUUID().toString();
            this.mage = this.controller.getBlockMage(automatonId, this.template == null ? "?" : this.template.getName());
            this.mage.setLocation(this.location);
        }
        return this.mage;
    }

    public int getSpawnedCount() {
        return this.spawned == null ? 0 : this.spawned.size();
    }

    @Nullable
    public Nearby getNearby() {
        if (this.template == null) {
            return null;
        }
        Spawner spawner = this.template.getSpawner();
        Nearby nearby = null;
        if (spawner != null && (nearby = spawner.getNearby(this)) != null && spawner.isTracked()) {
            nearby.mobs = this.spawned == null ? 0 : this.spawned.size();
        }
        return nearby;
    }

    @Nullable
    public Collection<WeakReference<Entity>> getSpawned() {
        return this.spawned;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name == null ? (this.template == null ? "(Unknown)" : this.template.getName()) : this.name;
    }

    @Nullable
    public String getDescription() {
        return this.template == null ? null : this.template.getDescription();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removed() {
        String dropWhenRemoved;
        if (this.template == null) {
            return;
        }
        if (this.template.removeWhenBroken()) {
            this.location.getBlock().setType(Material.AIR);
        }
        if ((dropWhenRemoved = this.template.getDropWhenRemoved()) != null && !dropWhenRemoved.isEmpty()) {
            ItemStack stack;
            ItemData item = this.controller.getOrCreateItem(dropWhenRemoved);
            ItemStack itemStack = stack = item == null ? null : item.getItemStack();
            if (CompatibilityLib.getItemUtils().isEmpty(stack)) {
                this.controller.getLogger().warning("Invalid item dropped in automaton " + this.template.getKey() + ": " + dropWhenRemoved);
            } else {
                this.location.getWorld().dropItemNaturally(this.location, stack);
            }
        }
    }

    public boolean onInteract(Player player) {
        if (this.template == null) {
            return false;
        }
        return this.template.interact(this, player);
    }
}

