/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.configuration.ConfigurationSection;

public class CastResultAction
extends BaseSpellAction {
    private SpellResult result = SpellResult.CANCELLED;
    private boolean endResult = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection configuration) {
        this.endResult = configuration.getBoolean("end_result", false);
        String spellResultString = configuration.getString("result");
        if (spellResultString != null && !spellResultString.isEmpty()) {
            try {
                this.result = SpellResult.valueOf(spellResultString.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid cast result: " + spellResultString);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        while (this.endResult && context != null) {
            context.setResult(this.result);
            context.setInitialResult(this.result);
            if (context == context.getBaseContext()) break;
            context = context.getBaseContext();
        }
        return this.result;
    }
}

