/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;

public abstract class CompoundLocationAction
extends CompoundAction {
    private List<Location> locations = new ArrayList<Location>();
    private int currentLocation = 0;

    public abstract void addLocations(CastContext var1, List<Location> var2);

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.currentLocation = 0;
    }

    @Override
    public SpellResult start(CastContext context) {
        this.locations.clear();
        this.addLocations(context, this.locations);
        context.addWork(10 + this.locations.size());
        return SpellResult.NO_TARGET;
    }

    @Override
    public boolean next(CastContext context) {
        ++this.currentLocation;
        return this.currentLocation < this.locations.size();
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.currentLocation < this.locations.size()) {
            Location location = this.locations.get(this.currentLocation);
            this.actionContext.setTargetLocation(location);
            return this.startActions();
        }
        return SpellResult.NO_ACTION;
    }

    @Override
    @Nullable
    public Object clone() {
        CompoundLocationAction action = (CompoundLocationAction)super.clone();
        if (action != null) {
            action.locations = new ArrayList<Location>(this.locations);
        }
        return action;
    }
}

