/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradeSlotTemplate;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class WandUpgradeSlot
extends WandUpgradeSlotTemplate {
    private boolean hasDefaultSlotted = false;
    private Wand slotted;

    public WandUpgradeSlot(MagicController controller, String slotType) {
        this(controller, slotType, null);
    }

    public WandUpgradeSlot(MagicController controller, String slotType, ConfigurationSection config) {
        super(slotType);
        WandUpgradeSlotTemplate template = controller.getWandSlotTemplate(slotType);
        if (template != null) {
            this.setTemplate(template);
        }
        this.load(controller, config);
    }

    protected void setTemplate(WandUpgradeSlotTemplate template) {
        this.hidden = template.hidden;
        this.swappable = template.swappable;
        this.replaceable = template.replaceable;
        this.defaultSlottedKey = template.defaultSlottedKey;
    }

    protected void load(MagicController controller, ConfigurationSection config) {
        if (config != null) {
            super.load(config);
        }
        if (this.defaultSlottedKey != null && !this.defaultSlottedKey.isEmpty() && this.slotted == null) {
            this.slotted = controller.createWand(this.defaultSlottedKey);
            this.hasDefaultSlotted = true;
        }
    }

    public boolean hasDefaultSlotted() {
        return this.hasDefaultSlotted;
    }

    public Wand getSlotted() {
        return this.slotted;
    }

    protected void setSlotted(Wand upgrade) {
        String slottedKey = upgrade.getKey();
        this.hasDefaultSlotted = this.defaultSlottedKey != null && this.defaultSlottedKey.equals(slottedKey);
        this.slotted = upgrade;
    }

    public boolean addSlotted(Wand upgrade, Mage mage) {
        String slotType = upgrade.getSlot();
        if (slotType == null || slotType.isEmpty() || this.slotType == null) {
            return false;
        }
        if (!slotType.equals(this.slotType)) {
            return false;
        }
        String slottedKey = upgrade.getKey();
        if (this.slotted != null && this.slotted.getKey().equals(slottedKey)) {
            return false;
        }
        if (this.slotted == null || this.replaceable) {
            this.setSlotted(upgrade);
            return true;
        }
        if (!this.swappable || mage == null) {
            return false;
        }
        mage.giveItem(this.slotted.getItem());
        this.setSlotted(upgrade);
        return true;
    }

    public void addInstructionLore(List<String> lore, Messages messages) {
        String instructions = messages.getIfSet("wand_slots." + this.slotType + ".lore_instructions");
        if (this.slotted != null) {
            instructions = this.slotted.getMessage("slotted_lore_instructions", instructions);
        }
        CompatibilityLib.getInventoryUtils().wrapText(instructions, lore);
    }

    public void showControlInstructions(Mage mage, Messages messages) {
        String instructions = messages.getIfSet("wand_slots." + this.slotType + ".control_instructions");
        if (this.slotted != null) {
            instructions = this.slotted.getMessage("slotted_control_instructions", instructions);
        }
        mage.sendMessage(instructions);
    }
}

