/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.kit.Kit;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MagicKitCommandExecutor
extends MagicTabExecutor {
    public MagicKitCommandExecutor(MagicAPI api) {
        super(api, "mkit");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0 || args.length > 2) {
            sender.sendMessage(this.controller.getMessages().get("commands.mkit.usage"));
            return true;
        }
        String playerName = null;
        String kitName = null;
        if (args.length == 1) {
            kitName = args[0];
        } else {
            playerName = args[0];
            Player testPlayer = CompatibilityLib.getDeprecatedUtils().getPlayer(playerName);
            if (testPlayer == null && !playerName.startsWith("@")) {
                kitName = args[0];
                playerName = null;
            } else {
                kitName = args[1];
            }
        }
        Kit kit = this.controller.getKit(kitName);
        if (kit == null) {
            sender.sendMessage(this.controller.getMessages().get("commands.mkit.unknown_kit"));
            return true;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        if (playerName != null && sender.hasPermission("magic.commands.mkit.others")) {
            List<Entity> targets = CompatibilityLib.getCompatibilityUtils().selectEntities(sender, playerName);
            if (targets != null) {
                for (Entity entity : targets) {
                    if (!(entity instanceof Player)) continue;
                    players.add((Player)entity);
                }
            } else {
                Player player = CompatibilityLib.getDeprecatedUtils().getPlayer(playerName);
                if (player == null) {
                    sender.sendMessage(this.controller.getMessages().get("commands.mkit.console_usage").replace("$player", playerName));
                    return true;
                }
                players.add(player);
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.controller.getMessages().get("commands.mkit.console_usage"));
                return true;
            }
            players.add((Player)sender);
        }
        for (Player player : players) {
            Mage mage = this.controller.getMage(player);
            long cooldownRemaining = kit.getRemainingCooldown(mage);
            if (cooldownRemaining > 0L) {
                String timeDescription = this.controller.getMessages().getTimeDescription(cooldownRemaining, "wait", "cooldown");
                String message = this.controller.getMessages().get("commands.mkit.cooldown");
                sender.sendMessage(message.replace("$time", timeDescription));
                continue;
            }
            if (!kit.isAllowed(mage)) {
                sender.sendMessage(this.controller.getMessages().get("commands.mkit.no_requirements"));
                continue;
            }
            kit.give(mage);
        }
        return true;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        HashSet<String> options = new HashSet<String>();
        if (!sender.hasPermission("magic.commands.mkit")) {
            return options;
        }
        if (args.length == 1 && sender.hasPermission("magic.commands.mkit.others")) {
            options.addAll(this.api.getPlayerNames());
        }
        Mage mage = this.controller.getMage(sender);
        if (args.length == 1 || args.length == 2) {
            for (String key : this.controller.getKitKeys()) {
                Kit kit = this.controller.getKit(key);
                if (kit == null || !kit.isAllowed(mage)) continue;
                options.add(key);
            }
        }
        return options;
    }
}

