/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.magic.command.config.ApplySessionCallback;
import com.elmakers.mine.bukkit.magic.command.config.AsyncProcessor;
import com.elmakers.mine.bukkit.magic.command.config.FetchExampleRunnable;
import com.elmakers.mine.bukkit.magic.command.config.GetSessionRequest;
import com.elmakers.mine.bukkit.magic.command.config.GetSessionRunnable;
import com.elmakers.mine.bukkit.magic.command.config.NewSessionCallback;
import com.elmakers.mine.bukkit.magic.command.config.NewSessionRequest;
import com.elmakers.mine.bukkit.magic.command.config.NewSessionRunnable;
import com.elmakers.mine.bukkit.magic.command.config.Session;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MagicConfigCommandExecutor
extends MagicTabExecutor {
    private static final String CUSTOM_FILE_NAME = "_customizations.yml";
    private static final String EXAMPLES_FILE_NAME = "_examples.yml";
    private static Set<String> exampleActions = ImmutableSet.of((Object)"add", (Object)"remove", (Object)"set", (Object)"list", (Object)"fetch", (Object)"help", (Object[])new String[]{"unfetch"});
    protected static Set<String> availableFiles = ImmutableSet.of((Object)"spells", (Object)"wands", (Object)"blocks", (Object)"classes", (Object)"config", (Object)"crafting", (Object[])new String[]{"effects", "items", "kits", "materials", "mobs", "paths", "attributes", "messages", "modifiers", "worlds", "arenas", "icons"});
    protected static final Map<String, String> availableFileMap = ImmutableMap.builder().put((Object)"spell", (Object)"spells").put((Object)"wand", (Object)"wands").put((Object)"block", (Object)"blocks").put((Object)"class", (Object)"classes").put((Object)"recipe", (Object)"crafting").put((Object)"effect", (Object)"effects").put((Object)"item", (Object)"items").put((Object)"kit", (Object)"kits").put((Object)"material", (Object)"materials").put((Object)"mob", (Object)"mobs").put((Object)"path", (Object)"paths").put((Object)"attribute", (Object)"attributes").put((Object)"message", (Object)"messages").put((Object)"modifier", (Object)"modifiers").put((Object)"world", (Object)"worlds").put((Object)"config", (Object)"config").put((Object)"arena", (Object)"arenas").put((Object)"icon", (Object)"icons").build();
    private final MagicController magic;
    private Gson gson;
    private final Map<String, String> sessions = new HashMap<String, String>();

    protected MagicConfigCommandExecutor(MagicAPI api, MagicController controller, String command) {
        super(api, command);
        this.magic = controller;
    }

    public MagicConfigCommandExecutor(MagicAPI api, MagicController controller) {
        this(api, controller, "mconfig");
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String subCommand;
        String fileType2;
        HashSet<String> options = new HashSet<String>();
        if (!sender.hasPermission("magic.commands.mconfig")) {
            return options;
        }
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "clean");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "disable");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "enable");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "configure");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "reset");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "editor");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "load");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "apply");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "example");
            this.addIfPermissible(sender, options, "magic.commands.mconfig.", "language");
            if (this.api.hasPermission(sender, "magic.commands.mconfig.configure")) {
                for (String fileType2 : availableFileMap.keySet()) {
                    options.add(fileType2);
                }
            }
        }
        if (availableFileMap.containsKey(subCommand = args[0]) || availableFiles.contains(subCommand)) {
            subCommand = "configure";
            args = (String[])ObjectArrays.concat((Object)"configure", (Object[])args);
        }
        if (subCommand.equals("example")) {
            args = Arrays.copyOfRange(args, 1, args.length);
            this.addExampleTabComplete(args, options);
            return options;
        }
        if (args.length == 2 && (subCommand.equals("disable") || subCommand.equals("enable") || subCommand.equals("configure") || subCommand.equals("editor") || subCommand.equals("reset"))) {
            options.addAll(availableFileMap.keySet());
            if (subCommand.equals("configure") || subCommand.equals("reset")) {
                options.add("config");
            }
            if (subCommand.equals("editor") || subCommand.equals("reset")) {
                options.remove("message");
                options.add("messages");
            }
        }
        if (args.length == 2 && subCommand.equals("language")) {
            options.addAll(this.controller.getLocalizations());
        }
        String string = fileType2 = args.length < 2 ? null : this.getFileParameter(args[1]);
        if (fileType2 == null) {
            return options;
        }
        if (subCommand.equals("configure")) {
            String spellName;
            SpellTemplate spell;
            if ((args.length == 4 || args.length == 5) && fileType2.equals("spells") && fileType2.equals("spells") && (spell = this.api.getSpellTemplate(spellName = args[2])) != null) {
                if (args.length == 4) {
                    ArrayList<String> parameters = new ArrayList<String>();
                    spell.getParameters(parameters);
                    for (String parameter : parameters) {
                        options.add("parameters." + parameter);
                    }
                    options.add("icon");
                    options.add("upgrade_required_path");
                    options.add("upgrade_required_casts");
                    options.add("icon_disabled");
                    options.add("color");
                    options.add("costs");
                    options.add("worth");
                    options.add("earns_sp");
                    options.add("earns_cooldown");
                    options.add("require_health_percentage");
                    options.add("quick_cast");
                    options.add("pvp_restricted");
                    options.add("passive");
                    options.add("cast_on_no_target");
                    options.add("undoable");
                } else {
                    String parameter = args[args.length - 2];
                    String prefix = "parameters.";
                    if (parameter.startsWith(prefix)) {
                        spell.getParameterOptions(options, parameter.substring(prefix.length()));
                    }
                }
            }
            if (args.length == 4 && fileType2.equals("wands")) {
                Wand.addParameterKeys(this.api.getController(), options);
            }
            if (args.length == 5 && fileType2.equals("wands")) {
                Wand.addParameterValues(this.api.getController(), args[3], options);
            }
            if (fileType2.equals("config") && args.length == 4 && args[2].equals("language")) {
                options.addAll(this.controller.getLocalizations());
            }
        }
        if (args.length == 3 && (subCommand.equals("disable") || subCommand.equals("configure") || subCommand.equals("editor") || subCommand.equals("reset"))) {
            if ((subCommand.equals("configure") || subCommand.equals("reset")) && fileType2.equals("config")) {
                options.add("language");
                File pluginFolder = this.api.getPlugin().getDataFolder();
                File defaultsFile = new File(pluginFolder, "defaults/config.defaults.yml");
                YamlConfiguration defaultConfig = null;
                try {
                    defaultConfig = new YamlConfiguration();
                    defaultConfig.load(defaultsFile);
                    options.addAll(defaultConfig.getKeys(false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (subCommand.equals("configure") && fileType2.equals("messages")) {
                options.addAll(this.controller.getMessages().getAllKeys());
            }
            if (fileType2.equals("worlds") && subCommand.equals("configure")) {
                for (World world : this.api.getPlugin().getServer().getWorlds()) {
                    options.add(world.getName());
                }
            }
            this.addConfigureOptions(fileType2, options);
        }
        return options;
    }

    protected void addExampleTabComplete(String[] args, Set<String> options) {
        if (args.length < 2) {
            options.addAll(exampleActions);
            return;
        }
        String operation = args[0];
        if (operation.equals("add")) {
            options.addAll(this.controller.getExamples());
        } else if (args.length > 2 && args[0].equals("set") && !args[1].equals("none")) {
            if (args.length == 3) {
                options.add("none");
            }
            options.addAll(this.controller.getExamples());
        } else if (args.length == 2) {
            if (operation.equals("fetch") || operation.equals("unfetch")) {
                options.addAll(this.controller.getExternalExamples());
            } else if (operation.equals("remove")) {
                options.addAll(this.controller.getLoadedExamples());
                options.add("all");
            } else if (operation.equals("set")) {
                options.add("none");
                options.addAll(this.controller.getExamples());
            }
        }
    }

    protected void addConfigureOptions(String fileType, Collection<String> options) {
        Collection<String> list;
        if (fileType.equals("worlds")) {
            File pluginFolder = this.api.getPlugin().getDataFolder();
            File defaultsFile = new File(pluginFolder, "defaults/worlds.defaults.yml");
            YamlConfiguration defaultConfig = null;
            try {
                defaultConfig = new YamlConfiguration();
                defaultConfig.load(defaultsFile);
                options.addAll(defaultConfig.getKeys(false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileType.equals("arenas")) {
            Collection<String> arenaKeys = this.api.getController().getArenaTemplateKeys();
            options.addAll(arenaKeys);
        }
        if (fileType.equals("icons")) {
            Set<String> iconKeys = this.api.getController().getIconKeys();
            options.addAll(iconKeys);
        }
        if (fileType.equals("spells")) {
            Collection<SpellTemplate> spellList = this.api.getController().getSpellTemplates(true);
            for (SpellTemplate spell : spellList) {
                options.add(spell.getKey());
            }
            options.add("default");
            options.add("override");
        }
        if (fileType.equals("wands")) {
            Collection<WandTemplate> wandList = this.api.getController().getWandTemplates();
            for (WandTemplate wand : wandList) {
                options.add(wand.getKey());
            }
        }
        if (fileType.equals("paths")) {
            Set<String> pathList = this.api.getController().getWandPathKeys();
            for (String path : pathList) {
                options.add(path);
            }
        }
        if (fileType.equals("modifiers")) {
            Collection<String> modifierList = this.api.getController().getModifierTemplateKeys();
            for (String modifier : modifierList) {
                options.add(modifier);
            }
        }
        if (fileType.equals("crafting")) {
            Collection<String> recipeList = this.api.getController().getRecipeKeys();
            for (String recipe : recipeList) {
                options.add(recipe);
            }
        }
        if (fileType.equals("mobs")) {
            Set<String> mobList = this.api.getController().getMobKeys(true);
            for (String mob : mobList) {
                options.add(mob);
            }
        }
        if (fileType.equals("items")) {
            Set<String> itemList = this.api.getController().getItemKeys();
            for (String item : itemList) {
                options.add(item);
            }
        }
        if (fileType.equals("blocks")) {
            list = this.api.getController().getMagicBlockTemplateKeys();
            for (String key : list) {
                options.add(key);
            }
        }
        if (fileType.equals("classes")) {
            list = this.api.getController().getMageClassKeys();
            for (String key : list) {
                options.add(key);
            }
        }
        if (fileType.equals("attributes")) {
            list = this.api.getController().getAttributes();
            for (String key : list) {
                options.add(key);
            }
        }
        if (fileType.equals("effects")) {
            list = this.api.getController().getEffectKeys();
            for (String key : list) {
                options.add(key);
            }
        }
        if (fileType.equals("kits")) {
            list = this.api.getController().getKitKeys();
            for (String key : list) {
                options.add(key);
            }
        }
        if (fileType.equals("materials")) {
            list = this.api.getController().getMaterialSetManager().getMaterialSets();
            for (String key : list) {
                if (key.startsWith("!")) continue;
                options.add(key);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String subCommand = args[0];
        if (availableFileMap.containsKey(subCommand) || availableFiles.contains(subCommand)) {
            subCommand = "configure";
            args = (String[])ObjectArrays.concat((Object)"configure", (Object[])args);
        }
        if (!this.api.hasPermission(sender, "magic.commands.mconfig." + subCommand)) {
            this.sendNoPermission(sender);
            return true;
        }
        if (subCommand.equals("clean")) {
            this.onMagicClean(sender, args.length > 1 ? args[1] : "");
            return true;
        }
        String[] parameters = Arrays.copyOfRange(args, 1, args.length);
        if (subCommand.equals("enable")) {
            this.onMagicEnable(sender, parameters);
            return true;
        }
        if (subCommand.equals("disable")) {
            this.onMagicDisable(sender, parameters);
            return true;
        }
        if (subCommand.equals("configure")) {
            this.onMagicConfigure(sender, parameters);
            return true;
        }
        if (subCommand.equals("language")) {
            this.onMagicLanguage(sender, parameters);
            return true;
        }
        if (subCommand.equals("reset")) {
            this.onReset(sender, parameters);
            return true;
        }
        if (subCommand.equals("editor")) {
            this.onStartEditor(sender, parameters);
            return true;
        }
        if (subCommand.equals("load")) {
            this.onApplyEdits(sender, parameters, "load", true);
            return true;
        }
        if (subCommand.equals("apply")) {
            this.onApplyEdits(sender, parameters, "apply", false);
            return true;
        }
        if (subCommand.equals("example")) {
            this.onExample(sender, parameters);
            return true;
        }
        return false;
    }

    protected String getFileParameter(String fileKey) {
        if (availableFiles.contains(fileKey)) {
            return fileKey;
        }
        return availableFileMap.get(fileKey);
    }

    protected String escapeMessage(String message, String type, String key) {
        return this.escapeMessage(message, type, key, ' ');
    }

    protected String escapeMessage(String message, String type, String key, char delimiter) {
        HashSet<String> options = new HashSet<String>(availableFileMap.keySet());
        options.add("config");
        return message.replace("$type", type).replace("$key", key).replace("$options", StringUtils.join(options, (char)delimiter));
    }

    @Nullable
    protected File getConfigFile(CommandSender sender, String command, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig." + command + ".usage"), "", "", '|'));
            return null;
        }
        String fileKey = this.getFileParameter(parameters[0]);
        if (fileKey == null) {
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig." + command + ".nokey"), "", "", ','));
            return null;
        }
        if (!fileKey.equals("config") && !fileKey.equals("messages") && parameters.length < 2) {
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig." + command + ".usage"), "", "", '|'));
            return null;
        }
        return this.getConfigFile(fileKey);
    }

    protected File getConfigFile(String fileKey) {
        return new File(this.magic.getPlugin().getDataFolder() + File.separator + fileKey, CUSTOM_FILE_NAME);
    }

    protected void trySave(String command, CommandSender sender, File configFile, YamlConfiguration configuration, String fileKey, String key) {
        try {
            configuration.save(configFile);
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig." + command + ".success"), fileKey, key));
        }
        catch (Exception ex) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.write_failed").replace("$file", configFile.getName()));
            this.magic.getLogger().log(Level.SEVERE, "Could not write to file " + configFile.getAbsoluteFile(), ex);
        }
    }

    protected void setPath(ConfigurationSection config, String path, Object value) {
        String[] pieces = StringUtils.split((String)path);
        for (int i = 0; i < pieces.length - 1; ++i) {
            config = config.createSection(pieces[i]);
        }
        config.set(pieces[pieces.length - 1], value);
    }

    protected void onMagicDisable(CommandSender sender, String[] parameters) {
        File configFile = this.getConfigFile(sender, "disable", parameters);
        if (configFile == null) {
            return;
        }
        String key = parameters[1];
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.setPath((ConfigurationSection)configuration, key + ".enabled", false);
        this.trySave("disable", sender, configFile, configuration, parameters[0], key);
    }

    protected void onMagicEnable(CommandSender sender, String[] parameters) {
        File configFile = this.getConfigFile(sender, "enable", parameters);
        if (configFile == null) {
            return;
        }
        String key = parameters[1];
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.setPath((ConfigurationSection)configuration, key + ".enabled", true);
        this.trySave("enable", sender, configFile, configuration, parameters[0], key);
    }

    protected Gson getGson() {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }

    protected void onStartEditor(final CommandSender sender, String[] parameters) {
        String editorType = "config";
        if (parameters.length > 0) {
            editorType = parameters[0];
        }
        if ((editorType = this.getFileParameter(editorType)) == null) {
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig.editor.usage"), "", "", '|'));
            return;
        }
        NewSessionRequest newSession = new NewSessionRequest(this.controller, editorType);
        if (sender instanceof Player) {
            newSession.setBukkitPlayer((Player)sender);
        }
        newSession.setLegacyIcons(this.magic.isLegacyIconsEnabled());
        newSession.setMagicVersion(this.getMagicVersion());
        newSession.setMinecraftVersion(CompatibilityLib.getServerVersion(this.api.getPlugin()));
        if ((editorType.equals("config") || editorType.equals("messages")) && parameters.length <= 1) {
            File pluginFolder = this.api.getPlugin().getDataFolder();
            File targetFile = new File(pluginFolder, editorType + ".yml");
            if (targetFile.exists()) {
                YamlConfiguration testConfig = new YamlConfiguration();
                try {
                    testConfig.load(targetFile);
                    if (testConfig.getKeys(false).isEmpty()) {
                        targetFile = null;
                    }
                }
                catch (Exception ex) {
                    sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.error"));
                    this.magic.getLogger().log(Level.WARNING, "Error loading customized file: " + targetFile.getAbsolutePath(), ex);
                    return;
                }
            }
            String defaultConfig = null;
            if (targetFile == null || !targetFile.exists()) {
                targetFile = new File(pluginFolder, "defaults/" + editorType + ".defaults.yml");
            }
            try {
                defaultConfig = new String(Files.readAllBytes(Paths.get(targetFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.error"));
                this.magic.getLogger().log(Level.WARNING, "Error loading customized file: " + targetFile.getAbsolutePath(), ex);
                return;
            }
            newSession.setContents(defaultConfig);
        } else if (parameters.length > 1) {
            String targetItem = parameters[1];
            newSession.setKey(targetItem);
            File pluginFolder = this.api.getPlugin().getDataFolder();
            File customFolder = new File(pluginFolder, editorType);
            File customFile = new File(customFolder, targetItem + ".yml");
            String existingConfig = null;
            if (customFile.exists()) {
                try {
                    existingConfig = new String(Files.readAllBytes(Paths.get(customFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
                }
                catch (Exception ex) {
                    sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.error"));
                    this.magic.getLogger().log(Level.WARNING, "Error loading customized file: " + customFile.getAbsolutePath(), ex);
                    return;
                }
            }
            File defaultsFile = new File(pluginFolder, "defaults/" + editorType + ".defaults.yml");
            YamlConfiguration defaultConfig = null;
            try {
                defaultConfig = new YamlConfiguration();
                defaultConfig.load(defaultsFile);
            }
            catch (Exception ex) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.error"));
                this.magic.getLogger().log(Level.WARNING, "Error loading default " + editorType + " file", ex);
                return;
            }
            Plugin plugin = this.controller.getPlugin();
            ConfigurationSection targetConfig = defaultConfig.getConfigurationSection(targetItem);
            boolean isInheritSet = false;
            if (targetConfig != null) {
                YamlConfiguration yaml = new YamlConfiguration();
                yaml.set(targetItem, (Object)targetConfig);
                Collection<String> examples = this.controller.getLoadedExamples();
                for (String example : examples) {
                    try {
                        InputStream resource = plugin.getResource("examples/" + example + "/" + editorType + ".yml");
                        List fullConfig = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                        StringBuilder testConfig = null;
                        StringBuilder header = new StringBuilder();
                        for (String line : fullConfig) {
                            if (testConfig == null) {
                                if (line.equals(targetItem + ":")) {
                                    testConfig = header;
                                    testConfig.append(line);
                                    continue;
                                }
                                if (line.startsWith("#")) {
                                    header.append(line);
                                    header.append("\n");
                                    continue;
                                }
                                header.setLength(0);
                                continue;
                            }
                            if (!line.isEmpty() && line.charAt(0) != ' ') break;
                            testConfig.append('\n');
                            testConfig.append(line);
                        }
                        if (testConfig == null) continue;
                        String testConfigString = testConfig.toString();
                        YamlConfiguration testMatch = new YamlConfiguration();
                        testMatch.loadFromString(testConfigString);
                        testMatch.options().header(null);
                        ConfigurationSection mainSection = testMatch.getConfigurationSection(targetItem);
                        boolean bl = isInheritSet = mainSection != null && mainSection.contains("inherit");
                        if (!testMatch.saveToString().equals(yaml.saveToString())) continue;
                        existingConfig = testConfigString;
                        break;
                    }
                    catch (Exception resource) {
                    }
                }
                if (existingConfig == null) {
                    ConfigurationSection mainSection = yaml.getConfigurationSection(targetItem);
                    isInheritSet = mainSection != null && mainSection.contains("inherit");
                    existingConfig = yaml.saveToString();
                }
                if (!(isInheritSet || editorType.equals("config") || editorType.equals("messages"))) {
                    ArrayList<String> newLines = new ArrayList<String>();
                    String[] lines = StringUtils.split((String)existingConfig, (String)"\n");
                    block14: for (int i = 0; i < lines.length; ++i) {
                        String line = lines[i];
                        newLines.add(line);
                        if (isInheritSet || line.isEmpty() || line.charAt(0) == ' ' || line.charAt(0) == '#') continue;
                        for (int j = i + 1; j < lines.length; ++j) {
                            String nextLine = lines[j];
                            if (nextLine.isEmpty() || nextLine.charAt(0) == '#') continue;
                            char[] characters = nextLine.toCharArray();
                            int indent = 0;
                            for (char character : characters) {
                                if (character != ' ') break;
                                ++indent;
                            }
                            newLines.add(nextLine.substring(0, indent) + "# This has been added automatically so that anything you remove here does not get inherited back in from the default configs");
                            newLines.add(nextLine.substring(0, indent) + "inherit: false");
                            isInheritSet = true;
                            continue block14;
                        }
                    }
                    existingConfig = StringUtils.join(newLines, (String)"\n");
                }
            } else {
                List listConfig = defaultConfig.getList(targetItem);
                if (listConfig != null) {
                    YamlConfiguration yaml = new YamlConfiguration();
                    yaml.set(targetItem, (Object)listConfig);
                    existingConfig = yaml.saveToString();
                }
            }
            if (existingConfig == null && editorType.equals("config")) {
                defaultsFile = new File(pluginFolder, "defaults/lists.defaults.yml");
                defaultConfig = null;
                try {
                    defaultConfig = new YamlConfiguration();
                    defaultConfig.load(defaultsFile);
                }
                catch (Exception ex) {
                    sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.error"));
                    this.magic.getLogger().log(Level.WARNING, "Error loading default config lists file", ex);
                    return;
                }
                List listConfig = defaultConfig.getList(targetItem);
                YamlConfiguration yaml = new YamlConfiguration();
                yaml.set(targetItem, (Object)listConfig);
                existingConfig = yaml.saveToString();
            }
            if (existingConfig == null) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.new_item").replace("$type", editorType).replace("$item", targetItem));
            } else {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.edit_item").replace("$type", editorType).replace("$item", targetItem));
                newSession.setContents(existingConfig);
            }
        }
        sender.sendMessage(this.magic.getMessages().get("commands.mconfig.editor.wait"));
        MagicPlugin plugin = this.magic.getPlugin();
        plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, (Runnable)new NewSessionRunnable(this.magic, this.getGson(), sender, newSession, new NewSessionCallback(){

            @Override
            public void success(String session) {
                MagicConfigCommandExecutor.this.setSession(sender, session);
            }
        }));
    }

    protected void setSession(final CommandSender sender, final String session) {
        MagicPlugin plugin = this.magic.getPlugin();
        plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                Mage mage = MagicConfigCommandExecutor.this.controller.getMage(sender);
                MagicConfigCommandExecutor.this.sessions.put(mage.getId(), session);
            }
        });
    }

    protected void onApplyEdits(final CommandSender sender, String[] parameters, final String command, final boolean load) {
        String sessionId = null;
        if (parameters.length > 0) {
            sessionId = parameters[0];
        } else {
            Mage mage = this.controller.getMage(sender);
            sessionId = this.sessions.get(mage.getId());
        }
        if (sessionId == null) {
            if (load) {
                this.magic.loadConfiguration(sender);
            } else {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig." + command + ".usage"));
            }
            return;
        }
        GetSessionRequest getSession = new GetSessionRequest(sessionId);
        sender.sendMessage(this.magic.getMessages().get("commands.mconfig." + command + ".wait"));
        MagicPlugin plugin = this.magic.getPlugin();
        final String finalSessionId = sessionId;
        ApplySessionCallback callback = new ApplySessionCallback(){

            @Override
            public void success(Session session) {
                MagicConfigCommandExecutor.this.applySession(finalSessionId, session, sender, command, load);
            }
        };
        plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, (Runnable)new GetSessionRunnable(this.magic, this.getGson(), sender, getSession, callback));
    }

    protected void applySession(final String sessionId, Session session, final CommandSender sender, String command, boolean load) {
        String message;
        File file;
        String contents;
        String missingMessage = this.magic.getMessages().get("commands.mconfig." + command + ".missing");
        String type = session.getType();
        if (type == null || type.isEmpty()) {
            missingMessage = missingMessage.replace("$field", "type");
            AsyncProcessor.fail(this.controller, sender, missingMessage);
            return;
        }
        boolean isMainConfiguration = type.equals("config");
        boolean isMessagesConfiguration = type.equals("messages");
        String key = session.getKey();
        if (!(isMainConfiguration || isMessagesConfiguration || key != null && !key.isEmpty())) {
            missingMessage = missingMessage.replace("$field", "key");
            AsyncProcessor.fail(this.controller, sender, missingMessage);
            return;
        }
        if (key != null && !key.isEmpty()) {
            isMainConfiguration = false;
            isMessagesConfiguration = false;
        }
        if ((contents = session.getContents()) == null || contents.isEmpty()) {
            missingMessage = missingMessage.replace("$field", "contents");
            AsyncProcessor.fail(this.controller, sender, missingMessage);
            return;
        }
        YamlConfiguration testLoad = new YamlConfiguration();
        try {
            testLoad.loadFromString(contents);
        }
        catch (InvalidConfigurationException e) {
            String message2 = this.magic.getMessages().get("commands.mconfig." + command + ".invalid");
            AsyncProcessor.fail(this.controller, sender, message2);
            return;
        }
        if (isMainConfiguration || isMessagesConfiguration) {
            file = new File(this.magic.getPlugin().getDataFolder(), type + ".yml");
        } else {
            String filename = key + ".yml";
            filename = filename.replace("|", "_");
            File typeFolder = new File(this.magic.getPlugin().getDataFolder(), type);
            if (!typeFolder.exists()) {
                typeFolder.mkdir();
            }
            file = new File(typeFolder, filename);
        }
        if (file.exists()) {
            message = this.magic.getMessages().get("commands.mconfig." + command + ".overwrote");
            AsyncProcessor.success(this.controller, sender, message.replace("$file", file.getName()));
        } else {
            message = this.magic.getMessages().get("commands.mconfig." + command + ".created");
            AsyncProcessor.success(this.controller, sender, message.replace("$file", file.getName()));
        }
        try {
            Object plugin;
            PrintWriter out = new PrintWriter(file, "UTF-8");
            out.print(contents);
            out.close();
            if (load) {
                plugin = this.controller.getPlugin();
                plugin.getServer().getScheduler().runTask(plugin, new Runnable(){

                    @Override
                    public void run() {
                        MagicConfigCommandExecutor.this.controller.loadConfigurationQuietly(sender);
                    }
                });
            } else {
                AsyncProcessor.success(this.controller, sender, this.magic.getMessages().get("commands.mconfig." + command + ".load_prompt"));
            }
            plugin = this.magic.getPlugin();
            plugin.getServer().getScheduler().runTask(plugin, new Runnable(){

                @Override
                public void run() {
                    Mage mage = MagicConfigCommandExecutor.this.controller.getMage(sender);
                    MagicConfigCommandExecutor.this.sessions.put(mage.getId(), sessionId);
                }
            });
        }
        catch (Exception ex) {
            String message3 = this.magic.getMessages().get("commands.mconfig." + command + ".error_saving");
            AsyncProcessor.fail(this.controller, sender, message3.replace("$file", file.getName()), "Error writing config file " + file.getAbsolutePath(), ex);
        }
    }

    protected void onExample(CommandSender sender, String[] parameters) {
        String action;
        String string = action = parameters.length == 0 ? null : parameters[0];
        if (action == null || !exampleActions.contains(action)) {
            String message = this.magic.getMessages().get("commands.mconfig.example.usage");
            message = message.replace("$actions", StringUtils.join(exampleActions, (char)'|'));
            sender.sendMessage(message);
            return;
        }
        parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
        if (action.equals("add")) {
            this.onAddExample(sender, parameters);
        } else if (action.equals("remove")) {
            this.onRemoveExample(sender, parameters);
        } else if (action.equals("set")) {
            this.onSetExample(sender, parameters);
        } else if (action.equals("fetch")) {
            this.onFetchExample(sender, parameters);
        } else if (action.equals("unfetch")) {
            this.onUnFetchExample(sender, parameters);
        } else if (action.equals("list")) {
            this.onListExamples(sender);
        } else if (action.equals("help")) {
            this.onExampleHelp(sender);
        } else {
            this.controller.getLogger().warning("Did not handle an example action that is in the set: " + action);
        }
    }

    protected void onExampleHelp(CommandSender sender) {
        this.magic.showExampleInstructions(sender);
    }

    protected void onListExamples(CommandSender sender) {
        String baseExample = this.controller.getExample();
        HashSet<String> examples = new HashSet<String>(this.controller.getLoadedExamples());
        if (baseExample != null && !baseExample.isEmpty()) {
            examples.remove(baseExample);
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.list.base").replace("$example", baseExample));
        }
        sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.list.header"));
        for (String example : examples) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.list.item").replace("$example", example));
        }
    }

    protected void onAddExample(CommandSender sender, String[] parameters) {
        if (parameters.length == 0) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.add.usage"));
            return;
        }
        LinkedHashSet<String> examples = new LinkedHashSet<String>(this.controller.getLoadedExamples());
        ArrayList<String> addExamples = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            addExamples.add(parameters[i]);
        }
        if (examples.containsAll(addExamples)) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.add.duplicate").replace("$examples", StringUtils.join(addExamples, (String)",")));
            return;
        }
        examples.addAll(addExamples);
        if (this.configureExamples(sender, examples, this.controller.getExample())) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.add.success").replace("$examples", StringUtils.join(addExamples, (String)",")));
        }
    }

    protected void onRemoveExample(CommandSender sender, String[] parameters) {
        if (parameters.length == 0) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.remove.usage"));
            return;
        }
        String example = parameters[0];
        if (example.equalsIgnoreCase("all")) {
            if (this.configureExamples(sender, new HashSet<String>(), null, false)) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.remove.all"));
            }
            return;
        }
        LinkedHashSet<String> examples = new LinkedHashSet<String>(this.controller.getLoadedExamples());
        if (!examples.contains(example)) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.remove.missing").replace("$example", example));
            return;
        }
        String currentExample = this.controller.getExample();
        examples.remove(example);
        if (currentExample != null && currentExample.equals(example)) {
            currentExample = null;
        }
        if (this.configureExamples(sender, examples, currentExample)) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.remove.success").replace("$example", example));
        }
    }

    protected void onFetchExample(CommandSender sender, String[] parameters) {
        String url;
        MagicPlugin plugin = this.magic.getPlugin();
        if (parameters.length < 1) {
            Set<String> externalKeys = this.magic.getDownloadedExternalExamples();
            if (externalKeys.isEmpty()) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.fetch.usage"));
                return;
            }
            this.magic.updateExternalExamples(sender);
            return;
        }
        String exampleKey = parameters[0];
        if (parameters.length < 2) {
            url = this.controller.getExternalExampleURL(exampleKey);
            if (url == null || url.isEmpty()) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.fetch.unknown").replace("$example", exampleKey));
                return;
            }
        } else {
            url = parameters[1];
        }
        sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.fetch.wait").replace("$url", url));
        plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, (Runnable)new FetchExampleRunnable(this.magic, sender, exampleKey, url));
    }

    protected void onUnFetchExample(CommandSender sender, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.unfetch.usage"));
            return;
        }
        String exampleKey = parameters[0];
        File examplesFolder = new File(this.controller.getPlugin().getDataFolder(), "examples");
        if (!(examplesFolder = new File(examplesFolder, exampleKey)).exists()) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.unfetch.fail").replace("$example", exampleKey));
            return;
        }
        File backupFolder = new File(examplesFolder.getPath() + ".bak");
        if (backupFolder.exists()) {
            ConfigurationUtils.deleteDirectory(backupFolder);
            examplesFolder.renameTo(backupFolder);
        }
        examplesFolder.renameTo(backupFolder);
        sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.unfetch.success").replace("$example", exampleKey).replace("$backup", backupFolder.getName()));
    }

    protected void onSetExample(CommandSender sender, String[] parameters) {
        LinkedHashSet<Object> examples;
        HashSet<String> loadedExamples = new HashSet<String>(this.controller.getLoadedExamples());
        if (parameters.length == 0 || parameters[0].equals("none")) {
            if (this.configureExamples(sender, loadedExamples, null)) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.set.clear"));
            }
            return;
        }
        String example = parameters[0];
        boolean setExamples = false;
        if (parameters.length == 1) {
            examples = new LinkedHashSet<String>(this.controller.getLoadedExamples());
            examples.remove(this.controller.getExample());
        } else {
            setExamples = true;
            examples = new LinkedHashSet();
            if (parameters.length > 2 || !parameters[1].equalsIgnoreCase("none")) {
                for (int i = 1; i < parameters.length; ++i) {
                    examples.add(parameters[i]);
                }
            }
        }
        if (this.configureExamples(sender, examples, example)) {
            if (setExamples) {
                if (examples.isEmpty()) {
                    sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.set.clear_added").replace("$example", example));
                } else {
                    sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.set.multiple").replace("$examples", StringUtils.join(examples, (String)",")).replace("$example", example));
                }
            } else {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.example.set.success").replace("$example", example));
            }
        }
    }

    protected boolean configureExamples(CommandSender sender, Set<String> examples, String example) {
        return this.configureExamples(sender, examples, example, true);
    }

    protected boolean configureExamples(CommandSender sender, Set<String> examples, String example, boolean reload) {
        if (example == null) {
            example = "";
        }
        examples.remove(example);
        File exampleFile = new File(this.magic.getPlugin().getDataFolder() + File.separator + "config", EXAMPLES_FILE_NAME);
        try {
            YamlConfiguration exampleConfig = new YamlConfiguration();
            if (exampleFile.exists()) {
                exampleConfig.load(exampleFile);
            }
            exampleConfig.set("example", (Object)example);
            exampleConfig.set("examples", new ArrayList<String>(examples));
            exampleConfig.set("add_examples", new ArrayList());
            exampleConfig.save(exampleFile);
            if (reload) {
                this.magic.loadConfigurationExamples(sender);
            }
        }
        catch (Exception ex) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.write_failed").replace("$file", exampleFile.getName()));
            this.magic.getLogger().log(Level.SEVERE, "Could not write to file " + exampleFile.getAbsoluteFile(), ex);
            return false;
        }
        return true;
    }

    protected void onReset(CommandSender sender, String[] parameters) {
        File configFile;
        String fileType;
        String string = fileType = parameters.length == 0 ? null : this.getFileParameter(parameters[0]);
        if (fileType == null) {
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig.reset.usage"), "", "", '|'));
            return;
        }
        if ((fileType.equals("config") || fileType.equals("messages")) && parameters.length == 1) {
            File pluginFolder = this.api.getPlugin().getDataFolder();
            File configFile2 = new File(pluginFolder, fileType + ".yml");
            boolean resetAny = false;
            if (configFile2.exists()) {
                boolean isEmpty = false;
                try {
                    YamlConfiguration configuration = new YamlConfiguration();
                    configuration.load(configFile2);
                    isEmpty = configuration.getKeys(false).isEmpty();
                }
                catch (Exception configuration) {
                    // empty catch block
                }
                if (!isEmpty && this.backupAndDelete(sender, configFile2)) {
                    resetAny = true;
                }
            }
            configFile2 = new File(pluginFolder, fileType);
            if ((configFile2 = new File(configFile2, CUSTOM_FILE_NAME)).exists() && this.backupAndDelete(sender, configFile2)) {
                resetAny = true;
            }
            if (fileType.equals("config")) {
                configFile2 = new File(pluginFolder, fileType);
                if ((configFile2 = new File(configFile2, EXAMPLES_FILE_NAME)).exists() && this.backupAndDelete(sender, configFile2)) {
                    resetAny = true;
                }
            }
            if (resetAny) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.reset.load_prompt"));
            } else {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.reset.none"));
            }
            return;
        }
        if (parameters.length < 2) {
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig.reset.usage"), "", "", '|'));
            return;
        }
        String key = parameters[1];
        File pluginFolder = this.api.getPlugin().getDataFolder();
        File customFolder = new File(pluginFolder, fileType);
        File customFile = new File(customFolder, key + ".yml");
        boolean deleted = false;
        boolean removed = false;
        if (customFile.exists()) {
            this.backupAndDelete(sender, customFile);
            deleted = true;
        }
        if ((configFile = this.getConfigFile(sender, "reset", parameters)) != null && configFile.exists()) {
            YamlConfiguration customizations = new YamlConfiguration();
            try {
                customizations.load(configFile);
                if (customizations.contains(key)) {
                    customizations.set(key, null);
                    customizations.save(configFile);
                    sender.sendMessage(this.magic.getMessages().get("commands.mconfig.reset.removed").replace("$key", key));
                    removed = true;
                }
            }
            catch (Exception ex) {
                sender.sendMessage(this.magic.getMessages().get("commands.mconfig.write_failed").replace("$file", configFile.getName()));
                this.magic.getLogger().log(Level.SEVERE, "Could not write to file " + configFile.getAbsoluteFile(), ex);
            }
        }
        if (deleted || removed) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.reset.load_prompt"));
        } else {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.reset.nothing").replace("$file", customFile.getName()).replace("$key", key));
        }
    }

    protected boolean backupAndDelete(CommandSender sender, File configFile) {
        File backupFile = new File(configFile.getAbsolutePath() + ".bak");
        boolean success = false;
        try {
            success = configFile.renameTo(backupFile);
        }
        catch (Exception ex) {
            success = false;
            this.magic.getLogger().log(Level.SEVERE, "Could not write to file " + backupFile.getAbsoluteFile(), ex);
        }
        if (!success) {
            sender.sendMessage(this.magic.getMessages().get("commands.mconfig.write_failed").replace("$file", backupFile.getName()));
            return false;
        }
        sender.sendMessage(this.magic.getMessages().get("commands.mconfig.reset.success").replace("$file", configFile.getName()));
        sender.sendMessage(this.magic.getMessages().get("commands.mconfig.reset.backup").replace("$backup", backupFile.getName()));
        return success;
    }

    protected void onMagicLanguage(CommandSender sender, String[] parameters) {
        String language = "";
        if (parameters.length > 0 && !parameters[0].equalsIgnoreCase("EN")) {
            language = parameters[0].toUpperCase();
        }
        String fileType = "config";
        File configFile = this.getConfigFile(fileType);
        String path = "language";
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.setPath((ConfigurationSection)configuration, path, ConfigurationUtils.convertProperty(language));
        this.trySave("configure", sender, configFile, configuration, fileType, path);
    }

    protected void onMagicConfigure(CommandSender sender, String[] parameters) {
        String fileType;
        File configFile = this.getConfigFile(sender, "configure", parameters);
        if (configFile == null) {
            return;
        }
        String string = fileType = parameters.length == 0 ? null : this.getFileParameter(parameters[0]);
        if (parameters.length < 3 || fileType == null) {
            sender.sendMessage(this.escapeMessage(this.magic.getMessages().get("commands.mconfig.configure.usage"), "", "", '|'));
            return;
        }
        if (fileType.equals("config") || fileType.equals("messages")) {
            String path = parameters[1];
            String value = "";
            if (parameters.length > 2) {
                value = StringUtils.join((Object[])Arrays.copyOfRange(parameters, 2, parameters.length), (char)' ');
            }
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
            this.setPath((ConfigurationSection)configuration, path, ConfigurationUtils.convertProperty(value));
            this.trySave("configure", sender, configFile, configuration, fileType, path);
            return;
        }
        String key = parameters[1];
        String path = key + "." + parameters[2];
        String value = "";
        if (parameters.length > 3) {
            value = StringUtils.join((Object[])Arrays.copyOfRange(parameters, 3, parameters.length), (char)' ');
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.setPath((ConfigurationSection)configuration, path, ConfigurationUtils.convertProperty(value));
        this.trySave("configure", sender, configFile, configuration, fileType, key);
    }

    protected void onMagicClean(CommandSender sender, String configName) {
        sender.sendMessage("This command is (temporarily?) disabled until it can be fixed.");
    }
}

