/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BoundingBox;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class BlockList
implements com.elmakers.mine.bukkit.api.block.BlockList {
    protected final Map<String, BoundingBox> areas = new HashMap<String, BoundingBox>();
    protected final Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> blockQueue = new LinkedHashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();

    public BlockList() {
    }

    public BlockList(BlockList other) {
        for (com.elmakers.mine.bukkit.api.block.BlockData block : other) {
            BlockData newBlock = new BlockData(block);
            this.add(newBlock);
        }
    }

    @Override
    public boolean add(Block block) {
        if (this.contains(block)) {
            return false;
        }
        BlockData newBlock = new BlockData(block);
        return this.add(newBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (!this.contain(blockData)) {
            return false;
        }
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            this.blockQueue.put(blockData.getId(), blockData);
        }
        return true;
    }

    @Nonnull
    protected com.elmakers.mine.bukkit.api.block.BlockData get(Block block) {
        long id = BlockData.getBlockId(block);
        this.add(block);
        return (com.elmakers.mine.bukkit.api.block.BlockData)Verify.verifyNotNull((Object)this.blockQueue.get(id));
    }

    @Override
    public void contain(Location location) {
        BoundingBox area = this.areas.get(location.getWorld().getName());
        if (area == null) {
            area = new BoundingBox(location.toVector(), location.toVector());
            this.areas.put(location.getWorld().getName(), area);
        } else {
            area.contain(location.toVector());
        }
    }

    @Override
    public boolean contain(com.elmakers.mine.bukkit.api.block.BlockData block) {
        if (this.contains(block)) {
            return false;
        }
        BoundingBox area = this.areas.get(block.getWorldName());
        if (area == null) {
            area = new BoundingBox(block.getPosition(), block.getPosition());
            this.areas.put(block.getWorldName(), area);
        } else {
            area.contain((Vector)block.getPosition());
        }
        return true;
    }

    @Override
    @Deprecated
    public void contain(Vector vector) {
        BoundingBox area = this.areas.values().iterator().next();
        if (area != null) {
            area.contain(vector);
        }
    }

    @Override
    public boolean addAll(Collection<? extends com.elmakers.mine.bukkit.api.block.BlockData> blocks) {
        boolean added = true;
        for (com.elmakers.mine.bukkit.api.block.BlockData blockData : blocks) {
            added = added && this.add(blockData);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            this.blockQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Block block) {
        boolean contains;
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            contains = this.blockQueue.containsKey(BlockData.getBlockId(block));
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        boolean contains;
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            contains = this.blockQueue.containsKey(blockData.getId());
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object arg0) {
        boolean contains;
        if (arg0 instanceof Block) {
            return this.contains((Block)arg0);
        }
        if (arg0 instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            return this.contains((com.elmakers.mine.bukkit.api.block.BlockData)arg0);
        }
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            contains = this.blockQueue.containsKey(arg0);
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> arg0) {
        boolean contains;
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            contains = this.blockQueue.keySet().containsAll(arg0);
        }
        return contains;
    }

    @Override
    @Deprecated
    public BoundingBox getArea() {
        return this.areas.values().iterator().next();
    }

    public Map<String, BoundingBox> getAreas() {
        return this.areas;
    }

    public Collection<com.elmakers.mine.bukkit.api.block.BlockData> getBlockList() {
        return this.blockQueue.values();
    }

    @Override
    public int size() {
        return this.blockQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.blockQueue.isEmpty();
    }

    @Override
    public Iterator<com.elmakers.mine.bukkit.api.block.BlockData> iterator() {
        return this.blockQueue.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object removeObject) {
        boolean removed = false;
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            if (removeObject instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
                removed = this.blockQueue.remove(((com.elmakers.mine.bukkit.api.block.BlockData)removeObject).getId()) != null;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> removeCollection) {
        boolean removed = false;
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            for (Object removeObject : removeCollection) {
                removed = this.remove(removeObject) || removed;
            }
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.blockQueue.values().retainAll(arg0);
    }

    @Override
    @Nullable
    public Object[] toArray() {
        return this.blockQueue.values().toArray();
    }

    @Override
    @Nullable
    public <T> T[] toArray(T[] arg0) {
        return this.blockQueue.values().toArray(arg0);
    }

    @Override
    public void load(ConfigurationSection node) {
        List blockData = node.getStringList("blocks");
        if (blockData != null) {
            for (String blockString : blockData) {
                BlockData deserialized = BlockData.fromString(blockString);
                if (deserialized == null) continue;
                this.add(deserialized);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ConfigurationSection node) {
        Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> map = this.blockQueue;
        synchronized (map) {
            if (!this.blockQueue.isEmpty()) {
                ArrayList<String> blockData = new ArrayList<String>();
                for (com.elmakers.mine.bukkit.api.block.BlockData block : this.blockQueue.values()) {
                    if (block.isFake()) continue;
                    blockData.add(block.toString());
                }
                node.set("blocks", blockData);
            }
        }
    }

    @Override
    @Nullable
    @Deprecated
    public String getWorldName() {
        return this.areas.keySet().iterator().next();
    }

    @Override
    @Nonnull
    public Set<Chunk> getChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (com.elmakers.mine.bukkit.api.block.BlockData block : this.blockQueue.values()) {
            chunks.add(block.getChunk());
        }
        return chunks;
    }
}

