/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BrushSelectAction
extends BaseSpellAction
implements GUIAction {
    private static int INVENTORY_ROWS = 6;
    private CastContext context;
    private List<ItemStack> schematics = new ArrayList<ItemStack>();
    private Map<Material, Collection<ItemStack>> variants = new HashMap<Material, Collection<ItemStack>>();
    private int page = 1;
    private boolean allowAbsorbing = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.allowAbsorbing = parameters.getBoolean("allow_absorbing", true);
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        InventoryAction action = event.getAction();
        if (this.context != null) {
            Mage mage = this.context.getMage();
            if (action == InventoryAction.NOTHING) {
                int direction = event.getClick() == ClickType.LEFT ? 1 : -1;
                this.page += direction;
                mage.deactivateGUI();
                this.perform(this.context);
                event.setCancelled(true);
                return;
            }
            ItemStack item = event.getCurrentItem();
            String set = CompatibilityLib.getNBTUtils().getString(item, "brush_set", (String)null);
            if (set != null) {
                if (set.equals("schematics")) {
                    String inventoryTitle = this.context.getMessage("schematics_title", "Schematics");
                    int invSize = (this.schematics.size() + 9) / 9 * 9;
                    Inventory displayInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, invSize, inventoryTitle);
                    for (ItemStack schematicItem : this.schematics) {
                        displayInventory.addItem(new ItemStack[]{schematicItem});
                    }
                    mage.deactivateGUI();
                    mage.activateGUI(this, displayInventory);
                    return;
                }
                if (set.equals("variants")) {
                    MaterialAndData baseMaterial = new MaterialAndData(CompatibilityLib.getNBTUtils().getString(item, "variant_key"));
                    String baseName = this.getBaseName(baseMaterial);
                    String inventoryTitle = this.context.getMessage("variants_title", "$variant Types").replace("$variant", baseName);
                    Collection<ItemStack> variantList = this.variants.get(baseMaterial.getMaterial());
                    int invSize = (variantList.size() + 9) / 9 * 9;
                    Inventory displayInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, invSize, inventoryTitle);
                    for (ItemStack variantItem : variantList) {
                        displayInventory.addItem(new ItemStack[]{variantItem});
                    }
                    mage.deactivateGUI();
                    mage.activateGUI(this, displayInventory);
                    return;
                }
            }
            mage.deactivateGUI();
            Currency blockCurrency = this.context.getController().getBlockExchangeCurrency();
            if (event.isRightClick() && blockCurrency != null && CompatibilityLib.getNBTUtils().getBoolean(item, "absorb", false) && !mage.isDead()) {
                String message;
                Messages messages = this.context.getController().getMessages();
                if (mage.isAtMaxCurrency(blockCurrency.getKey())) {
                    String limitMessage = messages.get("currency." + blockCurrency.getKey() + ".limit", messages.get("currency.default.limit"));
                    limitMessage = limitMessage.replace("$amount", Integer.toString((int)blockCurrency.getMaxValue()));
                    limitMessage = limitMessage.replace("$type", blockCurrency.getName(messages));
                    mage.sendMessage(limitMessage);
                    return;
                }
                Inventory inventory = mage.getInventory();
                ItemStack[] contents = inventory.getStorageContents();
                int count = 0;
                for (int i = 0; i < contents.length && !mage.isAtMaxCurrency(blockCurrency.getKey()); ++i) {
                    Double worth;
                    ItemStack itemStack = contents[i];
                    if (CompatibilityLib.getItemUtils().isEmpty(itemStack) || itemStack.hasItemMeta() || itemStack.getType() != item.getType() || (worth = this.context.getController().getWorth(itemStack, blockCurrency.getKey())) == null || worth <= 0.0) continue;
                    worth = worth * (double)itemStack.getAmount();
                    mage.addCurrency(blockCurrency.getKey(), worth);
                    contents[i] = null;
                    count += itemStack.getAmount();
                }
                inventory.setStorageContents(contents);
                if (count == 0) {
                    message = messages.get("brush.no_absorbed");
                    message = message.replace("$type", this.context.getController().describeItem(item));
                } else {
                    message = messages.get("brush.absorbed");
                    message = message.replace("$amount", Integer.toString(count));
                    message = message.replace("$type", this.context.getController().describeItem(item));
                }
                mage.sendMessage(message);
                return;
            }
            com.elmakers.mine.bukkit.api.wand.Wand wand = this.context.getWand();
            if (wand != null && Wand.isBrush(item)) {
                String brushKey = Wand.getBrush(item);
                wand.setActiveBrush(brushKey);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        MaterialAndData material;
        Mage mage = context.getMage();
        MageController controller = context.getController();
        com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
        this.schematics.clear();
        this.variants.clear();
        this.context = context;
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (wand == null) {
            return SpellResult.FAIL;
        }
        ArrayList<String> brushKeys = new ArrayList<String>(wand.getBrushes());
        Collections.sort(brushKeys);
        ArrayList<Object> brushes = new ArrayList<Object>();
        ArrayList<ItemStack> specials = new ArrayList<ItemStack>();
        MaterialAndData previous = null;
        for (String string : brushKeys) {
            Collection<ItemStack> variantList;
            ItemStack brushItem = controller.createBrushItem(string, context.getWand(), false);
            if (CompatibilityLib.getItemUtils().isEmpty(brushItem)) continue;
            if (MaterialBrush.isSchematic(string)) {
                this.schematics.add(brushItem);
                continue;
            }
            if (MaterialBrush.isSpecialMaterialKey(string)) {
                specials.add(brushItem);
                continue;
            }
            if (brushItem == null || mage.isRestricted(brushItem.getType())) continue;
            material = new MaterialAndData(string);
            Material baseVariant = DefaultMaterials.getBaseColor(material.getMaterial());
            if (baseVariant == null) {
                baseVariant = DefaultMaterials.getBaseVariant(material.getMaterial());
            }
            if (!context.isConsumeFree()) {
                this.addAbsorbInfo(brushItem);
            }
            if (previous != null && material.getMaterial() == previous.getMaterial()) {
                variantList = this.variants.get(material.getMaterial());
                if (variantList == null) {
                    ItemStack lastAdded = (ItemStack)brushes.get(brushes.size() - 1);
                    variantList = new LinkedHashSet<ItemStack>();
                    variantList.add(lastAdded);
                    brushes.remove(brushes.size() - 1);
                    this.variants.put(material.getMaterial(), variantList);
                }
                variantList.add(brushItem);
                continue;
            }
            if (baseVariant != null) {
                variantList = this.variants.get(baseVariant);
                if (variantList == null) {
                    variantList = new LinkedHashSet<ItemStack>();
                    this.variants.put(baseVariant, variantList);
                }
                variantList.add(brushItem);
                continue;
            }
            brushes.add(brushItem);
            previous = material;
        }
        for (Map.Entry entry : this.variants.entrySet()) {
            String key = ((Material)entry.getKey()).name();
            material = new MaterialBrush(key);
            Collection items = (Collection)entry.getValue();
            if (items.size() == 1) {
                brushes.add((ItemStack)items.iterator().next());
                continue;
            }
            String materialName = this.getBaseName(material);
            ItemStack category = ((MaterialBrush)material).getItem(context.getController(), false);
            category = CompatibilityLib.getItemUtils().makeReal(category);
            if (category == null) continue;
            ItemMeta meta = category.getItemMeta();
            String name = context.getMessage("variant_name", "" + ChatColor.AQUA + "$variant");
            meta.setDisplayName(name.replace("$variant", materialName));
            ArrayList<String> lore = new ArrayList<String>();
            String description = context.getMessage("variant_description", "Choose a type of $variant");
            lore.add(description.replace("$variant", materialName));
            meta.setLore(lore);
            category.setItemMeta(meta);
            CompatibilityLib.getNBTUtils().setString(category, "brush_set", "variants");
            CompatibilityLib.getNBTUtils().setString(category, "variant_key", key);
            brushes.add(category);
        }
        Collections.sort(brushes, (o1, o2) -> {
            String name1 = ChatColor.stripColor((String)o1.getItemMeta().getDisplayName());
            String name2 = ChatColor.stripColor((String)o2.getItemMeta().getDisplayName());
            return name1.compareToIgnoreCase(name2);
        });
        ItemStack schematicItem = null;
        if (this.schematics.size() == 1) {
            schematicItem = this.schematics.get(0);
        } else if (this.schematics.size() > 0) {
            Collections.sort(this.schematics, (o1, o2) -> {
                String name1 = ChatColor.stripColor((String)o1.getItemMeta().getDisplayName());
                String name2 = ChatColor.stripColor((String)o2.getItemMeta().getDisplayName());
                return name1.compareToIgnoreCase(name2);
            });
            schematicItem = CompatibilityLib.getItemUtils().getCopy(this.schematics.get(0));
            ItemMeta itemMeta = schematicItem.getItemMeta();
            itemMeta.setDisplayName(context.getMessage("schematics_name", "" + ChatColor.AQUA + "Schematics"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(context.getMessage("schematics_description", "Choose a schematic"));
            itemMeta.setLore(lore);
            schematicItem.setItemMeta(itemMeta);
            CompatibilityLib.getNBTUtils().setString(schematicItem, "brush_set", "schematics");
        }
        if (schematicItem != null) {
            brushes.add(schematicItem);
        }
        brushes.addAll(specials);
        if (brushes.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        int n = 9 * INVENTORY_ROWS;
        int numPages = (int)Math.ceil((float)brushes.size() / (float)n);
        if (this.page < 1) {
            this.page = numPages;
        } else if (this.page > numPages) {
            this.page = 1;
        }
        int pageIndex = this.page - 1;
        int startIndex = pageIndex * n;
        int maxIndex = (pageIndex + 1) * n - 1;
        ArrayList<ItemStack> showBrushes = new ArrayList<ItemStack>();
        for (int i = startIndex; i <= maxIndex && i < brushes.size(); ++i) {
            showBrushes.add((ItemStack)brushes.get(i));
        }
        String inventoryTitle = context.getMessage("title", "Brushes");
        if (numPages > 1) {
            inventoryTitle = inventoryTitle + " (" + this.page + "/" + numPages + ")";
        }
        int invSize = (int)Math.ceil((float)showBrushes.size() / 9.0f) * 9;
        Inventory displayInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, invSize, inventoryTitle);
        for (ItemStack brush : showBrushes) {
            displayInventory.addItem(new ItemStack[]{brush});
        }
        mage.activateGUI(this, displayInventory);
        return SpellResult.CAST;
    }

    private void addAbsorbInfo(ItemStack itemStack) {
        if (!this.allowAbsorbing) {
            return;
        }
        MageController controller = this.context.getController();
        Currency blockCurrency = controller.getBlockExchangeCurrency();
        if (blockCurrency == null) {
            return;
        }
        String message = this.context.getController().getMessages().get("brush.absorb");
        if (message.isEmpty()) {
            return;
        }
        ItemStack plain = new ItemStack(itemStack.getType());
        Double worth = controller.getWorth(plain, blockCurrency.getKey());
        if (worth == null || worth == 0.0) {
            return;
        }
        message = message.replace("$type", controller.describeItem(plain));
        ItemMeta meta = itemStack.getItemMeta();
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        CompatibilityLib.getInventoryUtils().wrapText(message, lore);
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        CompatibilityLib.getNBTUtils().setBoolean(itemStack, "absorb", true);
    }

    private String getBaseName(MaterialAndData material) {
        String materialName = material.getName(this.context == null ? null : this.context.getController().getMessages());
        materialName = materialName.replace("White ", "");
        materialName = materialName.replace("oak ", "");
        materialName = materialName.replace("cobblestone ", "");
        return materialName;
    }
}

