/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.boss.BossBarConfiguration;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BossBarAction
extends BaseSpellAction {
    private BossBarConfiguration barConfig;
    private boolean showTarget;
    private double progress;
    private boolean updateTitle;
    private BossBar bossBar;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.updateTitle = parameters.getBoolean("update_title");
        this.showTarget = parameters.getBoolean("show_target");
        this.progress = parameters.getDouble("bar_progress");
        this.barConfig = new BossBarConfiguration(context.getController(), parameters);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity;
        if (this.bossBar == null) {
            this.bossBar = this.barConfig.createBossBar(context);
        }
        if (this.updateTitle) {
            this.barConfig.updateTitle(this.bossBar, context);
        }
        this.bossBar.setProgress(Math.max(0.0, Math.min(1.0, this.progress)));
        Entity entity = targetEntity = this.showTarget ? context.getTargetEntity() : context.getEntity();
        if (targetEntity == null) {
            return SpellResult.NO_TARGET;
        }
        if (!(targetEntity instanceof Player)) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.bossBar.addPlayer((Player)targetEntity);
        return SpellResult.NO_ACTION;
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        if (this.bossBar != null) {
            this.bossBar.setVisible(false);
            this.bossBar.removeAll();
            this.bossBar = null;
        }
    }
}

