/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class AggroAction
extends BaseSpellAction {
    private boolean clearTarget;
    private boolean setPathfinder;
    private double speedModifier;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.clearTarget = parameters.getBoolean("clear_target", false);
        this.setPathfinder = parameters.getBoolean("set_pathfinder", true);
        this.speedModifier = parameters.getDouble("speed_modifier", 1.0);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity target = context.getTargetEntity();
        LivingEntity sourceEntity = context.getLivingEntity();
        if (!(target instanceof Creature)) {
            boolean result = false;
            if (this.setPathfinder) {
                result = CompatibilityLib.getCompatibilityUtils().setPathFinderTarget(target, (Entity)sourceEntity, this.speedModifier);
            }
            return result ? SpellResult.CAST : SpellResult.NO_TARGET;
        }
        Creature creatureTarget = (Creature)target;
        if (this.clearTarget) {
            LivingEntity current = creatureTarget.getTarget();
            if (current == null) {
                return SpellResult.NO_TARGET;
            }
            creatureTarget.setTarget(null);
            return SpellResult.CAST;
        }
        if (sourceEntity == null) {
            return SpellResult.NO_TARGET;
        }
        if (!(sourceEntity instanceof LivingEntity)) {
            return SpellResult.LIVING_ENTITY_REQUIRED;
        }
        LivingEntity source = sourceEntity;
        LivingEntity current = creatureTarget.getTarget();
        if (source == current) {
            return SpellResult.NO_ACTION;
        }
        ((Creature)target).setTarget(source);
        if (this.setPathfinder) {
            CompatibilityLib.getCompatibilityUtils().setPathFinderTarget(target, (Entity)source, this.speedModifier);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

