/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.utility.help.HelpTopicMatch;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ShowTopicsTask
implements Runnable {
    private static final int MAX_RESULTS = 10;
    private final List<HelpTopicMatch> matches;
    private final Mage mage;
    private final List<String> keywords;

    public ShowTopicsTask(Mage mage, List<String> keywords, List<HelpTopicMatch> matches) {
        this.keywords = keywords;
        this.mage = mage;
        this.matches = matches;
    }

    @Override
    public void run() {
        Messages messages = this.mage.getController().getMessages();
        if (this.matches.isEmpty()) {
            String topic = StringUtils.join(this.keywords, (String)" ");
            String unknownMessage = messages.get("commands.mhelp.unknown");
            this.mage.sendMessage(unknownMessage.replace("$topic", topic));
        } else {
            String foundMessage;
            int size = this.matches.size();
            if (size > 10) {
                foundMessage = messages.get("commands.mhelp.found_limit");
                this.mage.sendMessage(foundMessage.replace("$count", Integer.toString(size)).replace("$limit", Integer.toString(10)));
            } else {
                foundMessage = messages.get("commands.mhelp.found");
                this.mage.sendMessage(foundMessage.replace("$count", Integer.toString(size)));
            }
            int shown = 0;
            String template = messages.get("commands.mhelp.match");
            for (HelpTopicMatch topicMatch : this.matches) {
                String title = topicMatch.getTopic().getTitle();
                String summary = topicMatch.getSummary(this.keywords, title);
                String message = template.replace("$title", title).replace("$topic", topicMatch.getTopic().getKey()).replace("$summary", summary);
                this.mage.sendMessage(message);
                if (++shown < 10) continue;
                break;
            }
        }
        this.mage.sendMessage(messages.get("commands.mhelp.separator"));
    }
}

