/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.MacroExpansion;
import com.elmakers.mine.bukkit.utility.Messages;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public class HelpTopic {
    private final String key;
    private final String title;
    private final String text;
    private final String searchText;
    private final String[] lines;

    public HelpTopic(Messages messages, String key, String text) {
        this.key = key;
        MacroExpansion expansion = messages.expandMacros(text);
        text = expansion.getText();
        this.text = text = CompatibilityLib.getCompatibilityUtils().translateColors(StringEscapeUtils.unescapeHtml((String)text));
        String simpleText = ChatColor.stripColor((String)ChatUtils.getSimpleMessage(text, true));
        this.searchText = simpleText.toLowerCase();
        this.title = expansion.getTitle();
        String[] allLines = StringUtils.split((String)simpleText, (String)"\n");
        this.lines = !this.title.isEmpty() && allLines.length > 1 ? Arrays.copyOfRange(allLines, 1, allLines.length) : allLines;
    }

    @Nonnull
    public String getTitle() {
        if (this.title.isEmpty()) {
            return this.key;
        }
        return this.title;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public int match(Collection<String> keywords) {
        int matchCount = 0;
        for (String arg : keywords) {
            if (!this.key.contains(arg) && !this.searchText.contains(arg) && !this.title.contains(arg)) continue;
            ++matchCount;
        }
        return matchCount;
    }

    public String[] getWords() {
        return ChatUtils.getWords(this.searchText);
    }

    public String[] getLines() {
        return this.lines;
    }

    public String getKey() {
        return this.key;
    }
}

