/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.listener.ChunkLoadListener;
import org.bukkit.Chunk;
import org.bukkit.plugin.Plugin;

public class CheckChunkTask
implements Runnable {
    private final ChunkLoadListener listener;
    private final Chunk chunk;

    public CheckChunkTask(ChunkLoadListener listener, Chunk chunk) {
        this.listener = listener;
        this.chunk = chunk;
    }

    @Override
    public void run() {
        if (this.chunk.isLoaded()) {
            this.listener.onChunkLoad(this.chunk);
        }
    }

    public static void process(MagicController controller, ChunkLoadListener listener, Chunk chunk) {
        CheckChunkTask.defer((Plugin)controller.getPlugin(), listener, chunk);
    }

    private static void defer(Plugin plugin, ChunkLoadListener listener, Chunk chunk) {
        plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new CheckChunkTask(listener, chunk), 40L);
    }
}

