/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.item.Cost;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.wand.WandAction;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.magic.MagicBlock;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.SpellBlock;
import com.elmakers.mine.bukkit.tasks.DropActionTask;
import com.elmakers.mine.bukkit.tasks.GiveItemTask;
import com.elmakers.mine.bukkit.tasks.PlayerQuitTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.SpellUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerController
implements Listener {
    private static final int DEBUG_LEVEL = 199;
    private final MagicController controller;
    private final Map<Material, SpellBlock> spellBlocks = new HashMap<Material, SpellBlock>();
    private int clickCooldown = 150;
    private boolean cancelInteractOnLeftClick = true;
    private boolean cancelInteractOnRightClick = false;
    private boolean allowOffhandCasting = true;
    private boolean autoAbsorbSP = true;
    private long lastDropWarn = 0L;
    private int logoutDelay = 0;

    public PlayerController(MagicController controller) {
        this.controller = controller;
    }

    public void loadProperties(ConfigurationSection properties) {
        ConfigurationSection spellBlocks;
        MaterialAndData enchantBlockMaterial;
        this.logoutDelay = properties.getInt("logout_delay", 0);
        this.clickCooldown = properties.getInt("click_cooldown", 0);
        String enchantBlockKey = properties.getString("enchant_block", "enchantment_table");
        if (!enchantBlockKey.isEmpty() && (enchantBlockMaterial = new MaterialAndData(enchantBlockKey)).isValid()) {
            SpellBlock enchantBlock = new SpellBlock(properties.getString("enchant_click"), properties.getString("enchant_sneak_click"), properties.getBoolean("enchant_click_requires_wand", false));
            this.spellBlocks.put(enchantBlockMaterial.getMaterial(), enchantBlock);
        }
        if ((spellBlocks = properties.getConfigurationSection("spell_blocks")) != null) {
            Set keys = spellBlocks.getKeys(false);
            for (String key : keys) {
                MaterialAndData blockMaterial = new MaterialAndData(key);
                ConfigurationSection spellBlockConfiguration = spellBlocks.getConfigurationSection(key);
                if (!blockMaterial.isValid() || spellBlockConfiguration == null) continue;
                SpellBlock enchantBlock = new SpellBlock(spellBlockConfiguration);
                this.spellBlocks.put(blockMaterial.getMaterial(), enchantBlock);
            }
        }
        this.cancelInteractOnLeftClick = properties.getBoolean("cancel_interact_on_left_click", true);
        this.cancelInteractOnRightClick = properties.getBoolean("cancel_interact_on_right_click", false);
        this.allowOffhandCasting = properties.getBoolean("allow_offhand_casting", true);
        this.autoAbsorbSP = properties.getBoolean("auto_absorb_sp", true);
    }

    private void trigger(Player player, String trigger) {
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.trigger(trigger);
        }
    }

    @EventHandler
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        this.trigger(event.getPlayer(), event.isSneaking() ? "sneak" : "stop_sneak");
    }

    @EventHandler
    public void onPlayerSprint(PlayerToggleSprintEvent event) {
        this.trigger(event.getPlayer(), event.isSprinting() ? "sprint" : "stop_sprint");
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.experienceChanged();
        }
    }

    @EventHandler
    public void onPlayerToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        Mage mage = this.controller.getRegisteredMage(entity);
        if (mage != null && mage.isGlidingAllowed() && !event.isGliding() && !entity.isOnGround()) {
            event.setCancelled(true);
            Player player = mage.getPlayer();
            if (player != null) {
                this.controller.addFlightExemption(player, 5000);
            }
        } else if (mage != null) {
            mage.trigger(event.isGliding() ? "glide" : "stop_glide");
        }
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        ItemStack autoWand;
        boolean isQuickCast;
        if (!this.controller.isLoaded()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        Mage mage = this.controller.getMage(player);
        if (mage.getDebugLevel() >= 199) {
            mage.sendDebugMessage("EQUIP " + event.getNewSlot() + " from " + event.getPreviousSlot(), 199);
        }
        this.controller.updateOnEquip(next);
        ItemData itemData = this.controller.getItemByMaterial(next);
        if (itemData != null) {
            mage.discoverRecipes(itemData.getDiscoverRecipes());
        }
        if (Wand.isSelfDestructWand(next)) {
            mage.sendMessageKey("wand.self_destruct");
            inventory.setItem(event.getNewSlot(), null);
            mage.checkWand();
            return;
        }
        if (CompatibilityLib.getItemUtils().isTemporary(next) && !CompatibilityLib.getNBTUtils().getBoolean(next, "unmoveable", false)) {
            ItemStack replacement = CompatibilityLib.getItemUtils().getReplacement(next);
            inventory.setItem(event.getNewSlot(), replacement);
            mage.checkWand();
            return;
        }
        Wand activeWand = mage.getActiveWand();
        boolean isSkill = Wand.isSkill(next);
        if (isSkill && Wand.isQuickCastSkill(next)) {
            mage.useSkill(next);
            event.setCancelled(true);
            return;
        }
        boolean bl = isQuickCast = activeWand != null && activeWand.isQuickCast() && activeWand.isInventoryOpen();
        if (isQuickCast) {
            MageSpell spell = mage.getSpell(Wand.getSpell(next));
            if (spell != null) {
                activeWand.cast(spell);
            }
            event.setCancelled(true);
            return;
        }
        boolean isWand = Wand.isWand(next);
        if (!isWand && (autoWand = this.controller.getAutoWand(next)) != null) {
            next = autoWand;
            inventory.setItem(event.getNewSlot(), next);
            isWand = true;
        }
        if (activeWand != null && activeWand.isInventoryOpen()) {
            if (!isWand) {
                mage.activateIcon(activeWand, next);
                int previousSlot = event.getPreviousSlot();
                ItemStack previous = inventory.getItem(previousSlot);
                if (previous != null && previous.equals((Object)activeWand.getItem())) {
                    player.getInventory().setItem(previousSlot, activeWand.getItem());
                }
            }
            event.setCancelled(true);
        } else if (isWand || activeWand != null) {
            mage.setLastActivatedSlot(event.getPreviousSlot());
            mage.checkWandNextTick();
        }
        activeWand = mage.getActiveWand();
        if (activeWand == null && next != null && !isWand) {
            mage.setLastHeldItem(next);
        }
    }

    @EventHandler
    public void onPlayerSwapItem(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        ItemStack main = event.getMainHandItem();
        ItemStack offhand = event.getOffHandItem();
        if (mage.getDebugLevel() >= 199) {
            mage.sendDebugMessage("SWAP ITEM: " + (main == null ? "(Nothing)" : main.getType().name()) + " with " + (offhand == null ? "(Nothing)" : offhand.getType().name()), 199);
        }
        if (CompatibilityLib.getNBTUtils().getBoolean(offhand, "unswappable", false) || CompatibilityLib.getNBTUtils().getBoolean(main, "unswappable", false)) {
            event.setCancelled(true);
        }
        mage.trigger("swap");
        Wand activeWand = mage.getActiveWand();
        Wand offhandWand = mage.getOffhandWand();
        if (activeWand == null && offhandWand == null) {
            return;
        }
        if (activeWand != null) {
            boolean swappable = activeWand.isSwappable();
            if (swappable && activeWand.isInventoryOpen()) {
                swappable = !activeWand.performAction(activeWand.getSwapAction());
            } else if (!swappable) {
                activeWand.performAction(activeWand.getSwapAction());
            }
            if (!swappable) {
                event.setCancelled(true);
            } else if (activeWand.isInventoryOpen()) {
                activeWand.closeInventory();
                event.setCancelled(true);
            }
        }
        if (!event.isCancelled() && offhandWand != null && !offhandWand.isSwappable()) {
            event.setCancelled(true);
        }
        if (!event.isCancelled() && (activeWand != null || offhandWand != null || Wand.isWand(event.getMainHandItem()) || Wand.isWand(event.getOffHandItem()))) {
            boolean checkWand = false;
            if (activeWand != null && Wand.isWand(event.getOffHandItem())) {
                ItemStack activeItem = activeWand.getItem();
                ItemMeta activeMeta = activeItem.getItemMeta();
                ItemMeta offhandMeta = event.getOffHandItem().getItemMeta();
                if (offhandMeta != null && activeMeta != null && activeMeta.equals(offhandMeta)) {
                    activeWand.setItem(event.getOffHandItem());
                    activeWand.saveState();
                }
                checkWand = true;
            }
            if (offhandWand != null && Wand.isWand(event.getMainHandItem())) {
                ItemStack offhandItem = offhandWand.getItem();
                ItemMeta offhandMeta = offhandItem.getItemMeta();
                ItemMeta mainHandMeta = event.getMainHandItem().getItemMeta();
                if (mainHandMeta != null && offhandMeta != null && offhandMeta.equals(mainHandMeta)) {
                    offhandWand.setItem(event.getMainHandItem());
                    offhandWand.saveState();
                }
                checkWand = true;
            }
            if (checkWand) {
                mage.checkWandNextTick();
            }
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        boolean inSpellInventory;
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        if (mage.getDebugLevel() >= 199) {
            Item item = event.getItemDrop();
            ItemStack itemStack = item == null ? null : item.getItemStack();
            mage.sendDebugMessage("DROP ITEM: " + (itemStack == null ? "(Nothing)" : itemStack.getType().name()) + " at " + System.currentTimeMillis(), 199);
        }
        mage.checkLastClick(50L);
        if (mage.getActiveGUI() != null) {
            event.setCancelled(true);
            return;
        }
        mage.trigger("drop");
        Wand activeWand = mage.getActiveWand();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        boolean cancelEvent = false;
        ItemStack activeItem = activeWand == null ? null : activeWand.getItem();
        ItemMeta activeMeta = activeItem == null ? null : activeItem.getItemMeta();
        ItemMeta droppedMeta = droppedItem.getItemMeta();
        boolean droppedSpell = Wand.isSpell(droppedItem) || Wand.isBrush(droppedItem);
        String droppedName = droppedMeta == null ? null : droppedMeta.getDisplayName();
        String activeName = activeMeta == null ? null : activeMeta.getDisplayName();
        boolean droppedWand = droppedName != null && activeName != null && activeName.equals(droppedName);
        boolean bl = inSpellInventory = activeWand != null && activeWand.isInventoryOpen();
        if (droppedWand && activeWand.isUndroppable()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), (Runnable)new DropActionTask(activeWand));
            cancelEvent = true;
        } else if (activeWand != null) {
            if (droppedWand) {
                ItemMeta restoredMeta;
                ItemStack mainhandItem = player.getInventory().getItemInMainHand();
                activeWand.setItem(droppedItem);
                activeWand.deactivate();
                ItemStack restoredItem = player.getInventory().getItemInMainHand();
                ItemMeta itemMeta = restoredMeta = restoredItem == null ? null : restoredItem.getItemMeta();
                if (Wand.hasActiveWand(player) && restoredItem.getType() != Material.AIR && restoredMeta != null && activeMeta.equals(restoredMeta)) {
                    ItemStack newItem = player.getInventory().getItemInMainHand();
                    if (mainhandItem.getAmount() > 0) {
                        newItem.setAmount(mainhandItem.getAmount());
                        player.getInventory().setItemInMainHand(newItem);
                    } else {
                        player.getInventory().setItemInMainHand(new ItemStack(Material.AIR, 1));
                    }
                }
            } else if (inSpellInventory && droppedSpell) {
                if (!this.controller.isSpellDroppingEnabled()) {
                    cancelEvent = true;
                    boolean isInventoryFull = true;
                    PlayerInventory playerInventory = player.getInventory();
                    for (int i = 0; i < 36; ++i) {
                        ItemStack item = playerInventory.getItem(i);
                        if (item != null && item.getType() != Material.AIR) continue;
                        isInventoryFull = false;
                        break;
                    }
                    if (isInventoryFull) {
                        activeWand.addToInventory(droppedItem);
                    }
                } else {
                    this.controller.removeItemFromWand(activeWand, droppedItem);
                }
            }
        }
        if (!cancelEvent) {
            cancelEvent = CompatibilityLib.getNBTUtils().getBoolean(droppedItem, "undroppable", false);
        }
        if (cancelEvent) {
            if (!inSpellInventory || !droppedSpell) {
                boolean isFull = true;
                ItemStack[] items = player.getInventory().getStorageContents();
                for (int i = items.length - 1; i >= 0; --i) {
                    if (!CompatibilityLib.getItemUtils().isEmpty(items[i])) continue;
                    isFull = false;
                    break;
                }
                if (isFull) {
                    return;
                }
            }
            if (droppedWand) {
                activeWand.setItem(droppedItem);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Mage mage = this.controller.getRegisteredMage((Entity)event.getPlayer());
        if (mage == null) {
            return;
        }
        mage.onRespawn();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractArmorStand(PlayerArmorStandManipulateEvent event) {
        Wand wand;
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        if (mage.getDebugLevel() >= 199) {
            ItemStack playerItem = event.getPlayerItem();
            mage.sendDebugMessage("ENTITY ARMOR STAND with: " + event.getHand() + " at " + event.getRightClicked() + " with " + (playerItem == null ? "(Nothing)" : playerItem.getType().name()), 199);
        }
        if ((wand = mage.checkWand()) != null) {
            if (wand.isUndroppable()) {
                event.setCancelled(true);
                return;
            }
            wand.deactivate();
        } else {
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            ItemStack offhand = player.getInventory().getItemInOffHand();
            if (CompatibilityLib.getNBTUtils().getBoolean(mainHand, "undroppable", false) || CompatibilityLib.getItemUtils().isEmpty(mainHand) && CompatibilityLib.getNBTUtils().getBoolean(offhand, "undroppable", false)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Collection<Cost> costs;
        String permission;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity entity = event.getRightClicked();
        Mage mobMage = this.controller.getRegisteredMage(entity);
        if (mobMage != null) {
            mobMage.trigger("interact");
        }
        Player player = event.getPlayer();
        Mage playerMage = this.controller.getMage(player);
        playerMage.checkLastClick(0L);
        EntityData mob = this.controller.getMob(entity);
        if (mob == null) {
            return;
        }
        String interactSpell = mob.getInteractSpell();
        interactSpell = interactSpell != null && interactSpell.isEmpty() ? null : interactSpell;
        List<String> interactCommands = mob.getInteractCommands();
        List<String> list = interactCommands = interactCommands != null && interactCommands.isEmpty() ? null : interactCommands;
        if (interactSpell == null && interactCommands == null) {
            return;
        }
        event.setCancelled(true);
        if (playerMage.getDebugLevel() >= 199) {
            playerMage.sendDebugMessage("ENTITY AT INTERACT with: " + event.getHand() + " at " + entity + " : " + TextUtils.printVector(event.getClickedPosition()), 199);
        }
        if ((permission = mob.getInteractPermission()) != null && !permission.isEmpty() && !player.hasPermission(permission)) {
            String message = this.controller.getMessages().get("npc.no_permission");
            playerMage.sendMessage(message);
            return;
        }
        boolean requiresOwner = mob.getInteractRequiresOwner();
        if (requiresOwner) {
            if (!(entity instanceof Tameable)) {
                return;
            }
            Tameable tamed = (Tameable)entity;
            AnimalTamer tamer = tamed.getOwner();
            if (!tamer.getUniqueId().equals(player.getUniqueId())) {
                return;
            }
        }
        if ((costs = mob.getInteractCosts()) != null) {
            for (Cost cost : costs) {
                if (cost.has((com.elmakers.mine.bukkit.api.magic.Mage)playerMage, playerMage.getActiveWand(), null)) continue;
                String baseMessage = this.controller.getMessages().get("npc.insufficient");
                String costDescription = cost.getFullDescription(this.controller.getMessages(), null);
                costDescription = baseMessage.replace("$cost", costDescription);
                playerMage.sendMessage(costDescription);
                return;
            }
        }
        boolean success = false;
        if (interactSpell != null) {
            int level;
            ConfigurationSection parameters = mob.getInteractSpellParameters();
            parameters = parameters == null ? ConfigurationUtils.newConfigurationSection() : ConfigurationUtils.cloneConfiguration(parameters);
            com.elmakers.mine.bukkit.api.magic.Mage mage = SpellUtils.getCastSource(mob.getInteractSpellSource(), (Entity)player, entity, null, this.controller, " mob " + mob.getKey());
            SpellUtils.prepareParameters(mob.getInteractSpellTarget(), parameters, (Entity)player, entity, null, this.controller, " mob " + mob.getKey());
            if (!interactSpell.contains("|") && (level = mage.getActiveProperties().getSpellLevel(interactSpell)) > 1) {
                interactSpell = interactSpell + "|" + level;
            }
            success = this.controller.cast(mage, interactSpell, parameters, (CommandSender)player, mage.getEntity());
        }
        if (interactCommands != null) {
            Player executor = player;
            boolean opPlayer = false;
            EntityData.SourceType source = mob.getInteractCommandSource();
            switch (source) {
                case CONSOLE: {
                    executor = Bukkit.getConsoleSender();
                    break;
                }
                case PLAYER: {
                    executor = player;
                    break;
                }
                case OPPED_PLAYER: {
                    executor = player;
                    opPlayer = !player.isOp();
                    break;
                }
                case MOB: 
                case BLOCK: {
                    this.controller.getLogger().info("Invalid spell source on " + mob.getKey() + ": " + (Object)((Object)source) + ", will use CONSOLE instead");
                    executor = Bukkit.getConsoleSender();
                }
            }
            Location location = entity.getLocation();
            for (String command : interactCommands) {
                try {
                    if (opPlayer) {
                        executor.setOp(true);
                    }
                    String converted = TextUtils.parameterize(command, location, player);
                    this.controller.getPlugin().getServer().dispatchCommand((CommandSender)executor, converted);
                    success = true;
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "Error running command: " + command, ex);
                }
                finally {
                    if (opPlayer) {
                        executor.setOp(false);
                    }
                }
            }
        }
        if (costs != null && success) {
            String baseMessage = this.controller.getMessages().get("npc.deducted");
            for (Cost cost : costs) {
                cost.deduct((com.elmakers.mine.bukkit.api.magic.Mage)playerMage, playerMage.getActiveWand(), null);
                String costDescription = cost.getFullDescription(this.controller.getMessages(), null);
                costDescription = baseMessage.replace("$cost", costDescription);
                playerMage.sendMessage(costDescription);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        boolean isPlaceable;
        Entity clickedEntity = event.getRightClicked();
        EntityData mob = this.controller.getMob(clickedEntity);
        if (mob != null && mob.hasInteract()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        Wand wand = mage.checkWand();
        if (mage.getDebugLevel() >= 199) {
            mage.sendDebugMessage("ENTITY INTERACT with: " + event.getHand() + " at " + clickedEntity, 199);
        }
        boolean bl = isPlaceable = clickedEntity instanceof ItemFrame || clickedEntity instanceof ArmorStand;
        if (isPlaceable) {
            if (wand != null) {
                if (wand.isUndroppable()) {
                    event.setCancelled(true);
                    return;
                }
                wand.deactivate();
            } else {
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                ItemStack offhand = player.getInventory().getItemInOffHand();
                if (CompatibilityLib.getNBTUtils().getBoolean(mainHand, "undroppable", false) || CompatibilityLib.getItemUtils().isEmpty(mainHand) && CompatibilityLib.getNBTUtils().getBoolean(offhand, "undroppable", false)) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (this.controller.isNPC(event.getRightClicked())) {
            if (wand != null) {
                wand.closeInventory();
            }
            mage.checkLastClick(0L);
        } else {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerAnimate(PlayerAnimationEvent event) {
        Player player = event.getPlayer();
        if (event.getAnimationType() != PlayerAnimationType.ARM_SWING) {
            return;
        }
        if (!this.controller.useAnimationEvents(player)) {
            return;
        }
        Mage mage = this.controller.getMage(player);
        if (mage.getDebugLevel() >= 199) {
            mage.sendDebugMessage("ANIMATE: " + event.getAnimationType() + " at " + System.currentTimeMillis(), 199);
        }
        if (!mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        mage.trigger("left_click");
        Wand wand = mage.checkWand();
        if (wand == null) {
            return;
        }
        Messages messages = this.controller.getMessages();
        if (!this.controller.hasWandPermission(player)) {
            return;
        }
        if (!this.controller.hasWandPermission(player, wand)) {
            wand.deactivate();
            mage.sendMessage(messages.get("wand.no_permission").replace("$wand", wand.getName()));
            return;
        }
        if (wand.isUpgrade()) {
            return;
        }
        wand.playEffects("swing");
        wand.performAction(wand.getLeftClickAction());
    }

    private void onOffhandInteract(PlayerInteractEvent event) {
        if (!this.allowOffhandCasting) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.checkOffhandWand();
        if (wand == null || !this.canUse(mage, wand) || DefaultMaterials.isBow(wand.getIcon().getMaterial())) {
            return;
        }
        if (!mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        if (this.allowOffhandCasting && mage.offhandCast(wand) && this.cancelInteractOnLeftClick) {
            event.setCancelled(true);
        }
    }

    private boolean canUse(Mage mage, Wand wand) {
        if (wand == null) {
            return true;
        }
        Player player = mage.getPlayer();
        if (!this.controller.hasWandPermission(player)) {
            return false;
        }
        if (!this.controller.hasWandPermission(player, wand)) {
            Messages messages = this.controller.getMessages();
            wand.deactivate();
            mage.sendMessage(messages.get("wand.no_permission").replace("$wand", wand.getName()));
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        SpellBlock spellBlock;
        MagicBlock magicBlock;
        boolean isClickBlock;
        boolean isSpell;
        Wand offhandWand;
        boolean closingWand;
        boolean isRightClick;
        if (!this.controller.isLoaded()) {
            return;
        }
        Action action = event.getAction();
        boolean isLeftClick = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK;
        boolean bl = isRightClick = action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
        if (!isLeftClick && !isRightClick) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        Block clickedBlock = event.getClickedBlock();
        Mage mage = this.controller.getMage(player);
        if (mage.getDebugLevel() >= 199) {
            ItemStack item = event.getItem();
            mage.sendDebugMessage("INTERACT " + event.getAction() + " with " + event.getHand() + " using: " + (item == null ? "(Nothing)" : item.getType().name()) + ", block: " + (clickedBlock == null ? "(Nothing)" : clickedBlock.getType().name()) + " at " + System.currentTimeMillis(), 199);
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            this.onOffhandInteract(event);
            return;
        }
        if (!mage.canUse(itemInHand)) {
            mage.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", this.controller.describeItem(itemInHand)));
            event.setCancelled(true);
            return;
        }
        Wand wand = mage.checkWand();
        if (!this.canUse(mage, wand)) {
            return;
        }
        boolean bl2 = closingWand = isRightClick && wand != null && wand.getRightClickAction() == WandAction.TOGGLE && wand.isInventoryOpen();
        if (!closingWand) {
            boolean bl3 = closingWand = isLeftClick && wand != null && wand.getLeftClickAction() == WandAction.TOGGLE && wand.isInventoryOpen();
        }
        if (!closingWand && isRightClick && this.allowOffhandCasting && (offhandWand = mage.checkOffhandWand()) != null && offhandWand.getLeftClickAction() != WandAction.NONE) {
            if (this.cancelInteractOnLeftClick) {
                event.setCancelled(true);
            }
            return;
        }
        boolean isSkill = Wand.isSkill(itemInHand);
        boolean bl4 = isSpell = !isSkill && Wand.isSpell(itemInHand);
        if (!closingWand && (isSpell || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand))) {
            event.setCancelled(true);
            return;
        }
        boolean isOffhandSkill = false;
        ItemStack itemInOffhand = player.getInventory().getItemInOffHand();
        if (isRightClick && !closingWand) {
            boolean isOffhandSpell;
            isOffhandSkill = Wand.isSkill(itemInOffhand);
            boolean bl5 = isOffhandSpell = !isOffhandSkill && Wand.isSpell(itemInOffhand);
            if (isOffhandSpell || Wand.isBrush(itemInOffhand) || Wand.isUpgrade(itemInOffhand)) {
                event.setCancelled(true);
                return;
            }
        }
        if (isRightClick && !closingWand) {
            Currency currency;
            CurrencyAmount currencyAmount = CompatibilityLib.getInventoryUtils().getCurrencyAmount(itemInHand);
            Currency currency2 = currency = currencyAmount == null ? null : this.controller.getCurrency(currencyAmount.getType());
            if (currency != null) {
                Messages messages = this.controller.getMessages();
                currencyAmount.scale(itemInHand.getAmount());
                if (mage.isAtMaxCurrency(currencyAmount.getType())) {
                    String limitMessage = messages.get("currency." + currencyAmount.getType() + ".limit", messages.get("currency.default.limit"));
                    limitMessage = limitMessage.replace("$amount", currency.formatAmount(currency.getMaxValue(), messages));
                    limitMessage = limitMessage.replace("$type", currency.getName(messages));
                    mage.sendMessage(limitMessage);
                } else {
                    mage.addCurrency(currencyAmount.getType(), currencyAmount.getAmount(), true);
                    player.getInventory().setItemInMainHand(null);
                    String balanceMessage = messages.get("currency." + currencyAmount.getType() + ".deposited", messages.get("currency.default.deposited"));
                    balanceMessage = balanceMessage.replace("$amount", currency.formatAmount(currencyAmount.getAmount(), messages));
                    balanceMessage = balanceMessage.replace("$balance", currency.formatAmount(currency.getBalance(mage), messages));
                    balanceMessage = balanceMessage.replace("$type", currency.getName(messages));
                    mage.sendMessage(balanceMessage);
                }
                event.setCancelled(true);
                return;
            }
        }
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Material material = clickedBlock.getType();
            boolean isInteractible = wand != null ? wand.isInteractible(clickedBlock) : this.controller.isInteractible(clickedBlock);
            boolean bl6 = isRightClick = !isInteractible;
            if (wand != null && DefaultMaterials.isSign(material)) {
                wand.closeInventory();
            }
        }
        boolean bl7 = isClickBlock = action == Action.RIGHT_CLICK_BLOCK || action == Action.LEFT_CLICK_BLOCK;
        if (isClickBlock && !isLeftClick && !mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        if (closingWand) {
            mage.checkLastClick(this.clickCooldown);
        }
        if (isRightClick) {
            mage.trigger("right_click");
        }
        if (isOffhandSkill && wand != null && wand.getRightClickAction() != WandAction.NONE) {
            isOffhandSkill = false;
        }
        if (isRightClick && (isOffhandSkill || isSkill) && !closingWand) {
            if (isSkill) {
                mage.useSkill(itemInHand);
            } else {
                mage.useSkill(itemInOffhand);
            }
            event.setCancelled(true);
            return;
        }
        if (wand == null && !closingWand && itemInHand != null && isRightClick && this.controller.isWearable(itemInHand) && !DefaultMaterials.isSkull(itemInHand.getType())) {
            this.controller.onArmorUpdated(mage);
            return;
        }
        MagicBlock magicBlock2 = magicBlock = clickedBlock == null ? null : this.controller.getMagicBlockAt(clickedBlock.getLocation());
        if (magicBlock != null && magicBlock.onInteract(player)) {
            event.setCancelled(true);
            return;
        }
        SpellBlock spellBlock2 = spellBlock = clickedBlock == null ? null : this.spellBlocks.get(clickedBlock.getType());
        if (!(spellBlock == null || closingWand || wand == null && spellBlock.requiresWand() || spellBlock.requiresSpellProgression() && (wand == null || !wand.hasSpellProgression()))) {
            MageSpell spell;
            String spellKey = null;
            spellKey = player.isSneaking() ? spellBlock.getRightClickSneakSpell() : spellBlock.getRightClickSpell();
            MageSpell mageSpell = spell = spellKey != null ? mage.getSpell(spellKey) : null;
            if (spell != null) {
                boolean result = spell.cast();
                if (spellBlock.isCancelClick() && result) {
                    event.setCancelled(true);
                }
            }
            return;
        }
        ItemStack offhandItem = player.getInventory().getItemInOffHand();
        if (this.controller.isOffhandMaterial(offhandItem) && !closingWand) {
            return;
        }
        if (wand == null) {
            return;
        }
        if (isRightClick && wand.performAction(wand.getRightClickAction())) {
            if (this.cancelInteractOnRightClick) {
                event.setCancelled(true);
            } else {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        } else if (isRightClick) {
            if (wand.tryToWear(mage)) {
                event.setCancelled(true);
                player.getInventory().setItemInMainHand(null);
                mage.checkWand();
            } else {
                this.controller.onArmorUpdated(mage);
            }
        }
        if (isLeftClick) {
            if (!this.controller.useAnimationEvents(player)) {
                wand.playEffects("swing");
                if (!wand.isUpgrade() && wand.performAction(wand.getLeftClickAction()) && this.cancelInteractOnLeftClick) {
                    event.setCancelled(true);
                }
            } else if (!wand.isUpgrade() && wand.getLeftClickAction() != WandAction.NONE && this.cancelInteractOnLeftClick) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        this.controller.onPreLogin(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        mage.setUnloading(false);
        this.controller.checkVanished(player);
        if (player.hasPermission("magic.migrate")) {
            this.controller.checkForMigration((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerKick(PlayerKickEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    protected void handlePlayerQuitEvent(PlayerEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.onPlayerQuit(event);
            if (this.logoutDelay > 0) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.controller.getPlugin(), (Runnable)new PlayerQuitTask(this.controller, mage), (long)((int)Math.ceil((double)this.logoutDelay * 20.0 / 1000.0)));
            } else {
                this.controller.playerQuit(mage);
            }
        }
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (int i = 0; i < armor.length; ++i) {
            ItemStack replacement;
            ItemStack currentItem = armor[i];
            if (!CompatibilityLib.getItemUtils().isTemporary(currentItem)) continue;
            armor[i] = replacement = CompatibilityLib.getItemUtils().getReplacement(currentItem);
            player.getInventory().setArmorContents(armor);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (this.controller.isNPC((Entity)player)) {
            return;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        if ((event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL || event.getCause() == PlayerTeleportEvent.TeleportCause.END_GATEWAY) && mage.isOnPortalCooldown()) {
            event.setCancelled(true);
            return;
        }
        mage.onTeleport(event);
    }

    @EventHandler
    public void onPlayerPortal(PlayerPortalEvent event) {
        Mage mage = this.controller.getRegisteredMage((Entity)event.getPlayer());
        if (mage != null && mage.isOnPortalCooldown()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.controller.isNPC((Entity)player)) {
            return;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.onChangeWorld();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            return;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.onGameModeChange(player.getGameMode(), event.getNewGameMode());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        if (player.isDead()) {
            this.controller.info("Player picking up item while dead? " + player.getName() + ", cancelling", 5);
            event.setCancelled(true);
            return;
        }
        Mage mage = this.controller.getMage(player);
        mage.trigger("pickup");
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            if (mage.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
                mage.playSoundEffect(Wand.itemPickupSound);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerPrePickupItem(PlayerPickupItemEvent event) {
        Item item = event.getItem();
        ItemStack pickup = item.getItemStack();
        if (CompatibilityLib.getItemUtils().isTemporary(pickup) || CompatibilityLib.getEntityMetadataUtils().getBoolean((Entity)item, MagicMetaKeys.TEMPORARY)) {
            item.remove();
            event.setCancelled(true);
            return;
        }
        boolean isWand = Wand.isWand(pickup);
        UndoList undoList = this.controller.getEntityUndo((Entity)item);
        if (undoList != null) {
            undoList.remove((Entity)item);
        }
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        if (isWand) {
            Wand wand = this.controller.getWand(pickup);
            if (!wand.canUse(player)) {
                mage.messageNoUse(wand);
                event.setCancelled(true);
                return;
            }
            this.controller.removeLostWand(wand.getId());
        }
        if (this.autoAbsorbSP && Wand.isSP(pickup) && mage.getActiveProperties().addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        Wand activeWand = mage.getActiveWand();
        if (activeWand != null && activeWand.isAutoAbsorb() && activeWand.isModifiable() && (Wand.isSpell(pickup) || Wand.isBrush(pickup) || Wand.isUpgrade(pickup)) && activeWand.addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        if (!mage.hasStoredInventory() && isWand) {
            mage.checkWandNextTick();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent event) {
        MageSpell spell;
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        mage.trigger("consume");
        ItemStack originalItem = event.getItem();
        if (!originalItem.hasItemMeta()) {
            return;
        }
        ItemStack item = CompatibilityLib.getItemUtils().makeReal(originalItem);
        String consumeSpell = this.controller.getWandProperty(item, "consume_spell", "");
        if (!consumeSpell.isEmpty() && (spell = mage.getSpell(consumeSpell)) != null) {
            boolean success;
            if (Wand.isWand(item)) {
                Wand wand = Wand.createWand(this.controller, item);
                success = wand.cast(spell);
            } else {
                success = spell.cast();
            }
            if (!success) {
                event.setCancelled(true);
            } else {
                boolean creative;
                event.setItem(new ItemStack(Material.AIR));
                item = originalItem;
                boolean bl = creative = player.getGameMode() == GameMode.CREATIVE;
                if (item.getAmount() > 1 || creative) {
                    ItemStack offhandItem = player.getInventory().getItemInOffHand();
                    boolean offhand = item.equals((Object)offhandItem);
                    if (!creative) {
                        item.setAmount(item.getAmount() - 1);
                    }
                    MagicPlugin plugin = this.controller.getPlugin();
                    plugin.getServer().getScheduler().runTask((Plugin)plugin, (Runnable)new GiveItemTask(player, item, offhand));
                }
            }
        }
    }
}

