/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MagicTabExecutor
implements TabExecutor {
    protected final MagicAPI api;
    protected final MageController controller;
    private final String[] commands;

    public MagicTabExecutor(MagicAPI api, String command) {
        this.api = api;
        this.controller = api.getController();
        this.commands = new String[]{command};
    }

    public MagicTabExecutor(MagicAPI api, String[] commands) {
        this.api = api;
        this.controller = api.getController();
        this.commands = commands;
    }

    protected void register(JavaPlugin plugin, String command) {
        plugin.getCommand(command).setExecutor((CommandExecutor)this);
        plugin.getCommand(command).setTabCompleter((TabCompleter)this);
    }

    public void register(JavaPlugin plugin) {
        for (String command : this.commands) {
            this.register(plugin, command);
        }
    }

    public abstract Collection<String> onTabComplete(CommandSender var1, String var2, String[] var3);

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String completeCommand = args.length > 0 ? args[args.length - 1] : "";
        completeCommand = completeCommand.toLowerCase();
        Collection<String> allOptions = this.onTabComplete(sender, command.getName(), args);
        ArrayList<String> options = new ArrayList<String>();
        for (String option : allOptions) {
            String lowercase = option.toLowerCase();
            if (!lowercase.startsWith(completeCommand)) continue;
            options.add(option);
        }
        Collections.sort(options);
        return options;
    }

    public String getMagicVersion() {
        return this.api.getPlugin().getDescription().getVersion();
    }

    protected void sendNoPermission(CommandSender sender) {
        if (sender != null) {
            sender.sendMessage(this.controller.getMessages().get("commands.no_permission"));
        }
    }

    protected void addIfPermissible(CommandSender sender, Collection<String> options, String permissionPrefix, String option) {
        if (this.api.hasPermission(sender, permissionPrefix + option)) {
            options.add(option);
        }
    }

    public boolean giveWand(CommandSender sender, Player player, String wandKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        Wand wand;
        Mage mage = this.controller.getMage(player);
        Wand currentWand = mage.getActiveWand();
        if (currentWand != null) {
            currentWand.closeInventory();
        }
        if ((wand = this.api.createWand(wandKey)) != null) {
            if (giveItem) {
                ItemStack item = wand.getItem();
                if (item == null) {
                    if (!quiet) {
                        if (wandKey == null) {
                            wandKey = "(default)";
                        }
                        sender.sendMessage(this.api.getMessages().getParameterized("wand.unknown_template", "$name", wandKey));
                        if (sender != player) {
                            sender.sendMessage("Wand " + wand.getName() + " has an invalid icon");
                        }
                    }
                    return true;
                }
                this.api.giveItemToPlayer(player, wand.getItem());
                if (sender != player && !quiet) {
                    sender.sendMessage("Gave wand " + wand.getName() + " to " + player.getName());
                }
            }
            if (showWorth) {
                this.showWorth(sender, wand.getItem());
            }
        } else {
            if (!quiet) {
                if (wandKey == null) {
                    wandKey = "(default)";
                }
                sender.sendMessage(this.api.getMessages().getParameterized("wand.unknown_template", "$name", wandKey));
            }
            return false;
        }
        return true;
    }

    protected void showWorth(CommandSender sender, ItemStack item) {
        if (this.api.isWand(item) || this.api.isUpgrade(item)) {
            Wand wand = this.api.getWand(item);
            if (wand == null) {
                sender.sendMessage("I'm not sure what that's worth, sorry!");
                return;
            }
            sender.sendMessage(ChatColor.AQUA + "WIP: Wand " + ChatColor.GOLD + wand.getName() + ChatColor.AQUA + " is worth " + ChatColor.GREEN + wand.getWorth());
        } else if (this.api.isSpell(item)) {
            SpellTemplate template = this.api.getSpellTemplate(this.api.getSpell(item));
            if (template == null) {
                sender.sendMessage("I'm not sure what that's worth, sorry!");
                return;
            }
            sender.sendMessage(ChatColor.AQUA + "Spell " + ChatColor.GOLD + template.getName() + ChatColor.AQUA + " is worth " + ChatColor.GREEN + template.getWorth());
        } else if (this.api.isBrush(item)) {
            String materialBrush = this.api.getBrush(item);
            if (materialBrush == null) {
                sender.sendMessage("I'm not sure what that's worth, sorry!");
                return;
            }
            int brushWorth = 500;
            sender.sendMessage(ChatColor.AQUA + "WIP: Brush " + ChatColor.GOLD + materialBrush + ChatColor.AQUA + " is worth " + ChatColor.GREEN + brushWorth);
        } else {
            sender.sendMessage("I'm not sure what that's worth, sorry!");
        }
    }

    protected String getPermissionNode() {
        return "magic.commands." + this.commands[0];
    }
}

