/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.magic.MagicController;
import org.bukkit.configuration.ConfigurationSection;

public class WandUpgradeSlotTemplate {
    protected final String slotType;
    protected boolean hidden = false;
    protected boolean swappable = false;
    protected boolean replaceable = false;
    protected String defaultSlottedKey;

    public WandUpgradeSlotTemplate(MagicController controller, String slotType) {
        this.slotType = slotType;
        ConfigurationSection defaultConfig = controller.getWandSlotConfiguration(slotType);
        if (defaultConfig != null) {
            this.load(controller, defaultConfig);
        }
    }

    public WandUpgradeSlotTemplate(MagicController controller, String configKey, ConfigurationSection config) {
        this(controller, config.getString("type", configKey));
        this.load(controller, config);
    }

    protected void load(MagicController controller, ConfigurationSection config) {
        this.hidden = config.getBoolean("hidden", this.hidden);
        this.swappable = config.getBoolean("swappable", this.swappable);
        this.replaceable = config.getBoolean("replaceable", this.replaceable);
        this.defaultSlottedKey = config.getString("default_slotted");
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getType() {
        return this.slotType;
    }

    public String getDefaultSlottedKey() {
        return this.defaultSlottedKey;
    }
}

