/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradeSlotTemplate;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class WandUpgradeSlot
extends WandUpgradeSlotTemplate {
    private boolean hasDefaultSlotted = false;
    private Wand slotted;

    public WandUpgradeSlot(MagicController controller, String slotType) {
        super(controller, slotType);
    }

    public WandUpgradeSlot(MagicController controller, String configKey, ConfigurationSection config) {
        super(controller, configKey, config);
    }

    @Override
    protected void load(MagicController controller, ConfigurationSection config) {
        super.load(controller, config);
        if (this.defaultSlottedKey != null && !this.defaultSlottedKey.isEmpty() && this.slotted == null) {
            this.slotted = controller.createWand(this.defaultSlottedKey);
            this.hasDefaultSlotted = true;
        }
    }

    public boolean hasDefaultSlotted() {
        return this.hasDefaultSlotted;
    }

    public Wand getSlotted() {
        return this.slotted;
    }

    public boolean addSlotted(Wand upgrade, Mage mage) {
        String slotType = upgrade.getSlot();
        if (slotType == null || slotType.isEmpty() || this.slotType == null) {
            return false;
        }
        if (!slotType.equals(this.slotType)) {
            return false;
        }
        if (this.slotted == null || this.replaceable) {
            this.slotted = upgrade;
            this.hasDefaultSlotted = false;
            return true;
        }
        if (!this.swappable || mage == null) {
            return false;
        }
        mage.giveItem(this.slotted.getItem());
        this.slotted = upgrade;
        this.hasDefaultSlotted = false;
        return true;
    }

    public void addInstructionLore(List<String> lore, Messages messages) {
        String instructions = messages.getIfSet("wand_slots." + this.slotType + ".lore_instructions");
        if (this.slotted != null) {
            instructions = this.slotted.getMessage("slotted_lore_instructions", instructions);
        }
        CompatibilityLib.getInventoryUtils().wrapText(instructions, lore);
    }

    public void showControlInstructions(Mage mage, Messages messages) {
        String instructions = messages.getIfSet("wand_slots." + this.slotType + ".control_instructions");
        if (this.slotted != null) {
            instructions = this.slotted.getMessage("slotted_control_instructions", instructions);
        }
        mage.sendMessage(instructions);
    }
}

