/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.utility.help.HelpTopic;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class HelpTopicMatch
implements Comparable<HelpTopicMatch> {
    private static final int MAX_WIDTH = 50;
    private final int matchCount;
    private final HelpTopic topic;

    public HelpTopicMatch(HelpTopic topic, int matchCount) {
        this.topic = topic;
        this.matchCount = matchCount;
    }

    @Override
    public int compareTo(HelpTopicMatch o) {
        return o.matchCount > this.matchCount ? 1 : (o.matchCount < this.matchCount ? -1 : 0);
    }

    @Nonnull
    public HelpTopic getTopic() {
        return this.topic;
    }

    public String getSummary(List<String> keywords, String title) {
        int titleLength = title.length();
        if (titleLength > 46) {
            return "";
        }
        int remainingLength = 50 - titleLength;
        String[] lines = this.topic.getLines();
        if (lines.length == 0) {
            return "";
        }
        int summaryMatchCount = 0;
        String summary = null;
        for (String line : lines) {
            int startIndex;
            String matchLine = line.toLowerCase();
            int firstMatchIndex = -1;
            int lastMatchEnd = -1;
            int matchCount = 0;
            for (String arg : keywords) {
                startIndex = matchLine.indexOf(arg);
                if (startIndex < 0) continue;
                ++matchCount;
                int endIndex = startIndex + arg.length();
                if (firstMatchIndex == -1) {
                    firstMatchIndex = startIndex;
                    lastMatchEnd = endIndex;
                    continue;
                }
                firstMatchIndex = Math.min(firstMatchIndex, startIndex);
                lastMatchEnd = Math.max(lastMatchEnd, endIndex);
            }
            if (matchCount <= 0 || matchCount <= summaryMatchCount) continue;
            boolean fitAllMatches = true;
            summaryMatchCount = matchCount;
            if (line.length() > remainingLength) {
                if (lastMatchEnd < remainingLength) {
                    line = line.substring(0, remainingLength) + "\u00a77" + "...";
                } else if (line.length() - firstMatchIndex < remainingLength) {
                    line = "\u00a77...\u00a7r" + line.substring(line.length() - remainingLength);
                } else if (lastMatchEnd - firstMatchIndex < remainingLength) {
                    int padding = remainingLength - (lastMatchEnd - firstMatchIndex);
                    startIndex = firstMatchIndex - padding / 2;
                    line = "\u00a77...\u00a7r" + line.substring(startIndex, startIndex + remainingLength) + "\u00a77" + "...";
                } else {
                    line = "\u00a77..." + line.substring(firstMatchIndex, firstMatchIndex + remainingLength) + "\u00a77" + "...";
                    fitAllMatches = false;
                }
            }
            summary = line;
            if (fitAllMatches && summaryMatchCount == keywords.size()) break;
        }
        if (summary == null && (summary = lines[0]).length() > remainingLength) {
            summary = summary.substring(0, remainingLength) + "\u00a77" + "...";
        }
        for (String keyword : keywords) {
            summary = summary.replaceAll("((?i)" + Pattern.quote(keyword) + ")", "\u00a7b$1\u00a7r");
        }
        return summary;
    }
}

