/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.help.HelpTopic;
import com.elmakers.mine.bukkit.utility.help.HelpTopicMatch;
import com.elmakers.mine.bukkit.utility.help.ShowTopicsTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class Help {
    private final Messages messages;
    private final Map<String, HelpTopic> topics = new HashMap<String, HelpTopic>();
    private final Set<String> words = new HashSet<String>();

    public Help(Messages messages) {
        this.messages = messages;
    }

    public void load(ConfigurationSection helpSection, ConfigurationSection examplesSection) {
        ConfigurationSection helpExamples = helpSection.getConfigurationSection("examples");
        if (helpExamples != null) {
            ConfigurationUtils.addConfigurations(helpExamples, examplesSection);
        } else {
            helpSection.set("examples", (Object)examplesSection);
        }
        Set keys = helpSection.getKeys(true);
        for (String key : keys) {
            if (helpSection.isConfigurationSection(key)) continue;
            String value = helpSection.getString(key);
            HelpTopic helpTopic = new HelpTopic(this.messages, key, value);
            this.topics.put(key, helpTopic);
            for (String word : helpTopic.getWords()) {
                if (word.length() <= 1) continue;
                this.words.add(word);
            }
        }
    }

    public Set<String> getWords() {
        return this.words;
    }

    public Set<String> getTopicKeys() {
        return this.topics.keySet();
    }

    public boolean showTopic(Mage mage, String key) {
        HelpTopic topic = this.topics.get(key);
        if (topic == null) {
            return false;
        }
        mage.sendMessage(topic.getText());
        return true;
    }

    @Nonnull
    public List<HelpTopicMatch> findMatches(List<String> keywords) {
        ArrayList<HelpTopicMatch> matches = new ArrayList<HelpTopicMatch>();
        for (HelpTopic topic : this.topics.values()) {
            int matchCount = topic.match(keywords);
            if (matchCount <= 0) continue;
            matches.add(new HelpTopicMatch(topic, matchCount));
        }
        return matches;
    }

    public void search(Mage mage, String[] args) {
        ArrayList<String> keywords = new ArrayList<String>();
        for (String arg : args) {
            keywords.add(arg.toLowerCase());
        }
        List<HelpTopicMatch> matches = this.findMatches(keywords);
        Collections.sort(matches);
        ShowTopicsTask showTask = new ShowTopicsTask(mage, keywords, matches);
        Plugin plugin = mage.getController().getPlugin();
        plugin.getServer().getScheduler().runTask(plugin, (Runnable)showTask);
    }
}

