/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.BlockList;
import com.elmakers.mine.bukkit.api.block.BoundingBox;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.block.magic.MagicBlock;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.data.MageDataStore;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.effect.EffectContext;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.entity.TeamProvider;
import com.elmakers.mine.bukkit.api.event.LoadEvent;
import com.elmakers.mine.bukkit.api.event.PreLoadEvent;
import com.elmakers.mine.bukkit.api.event.SaveEvent;
import com.elmakers.mine.bukkit.api.integration.ClientPlatform;
import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.CastSourceLocation;
import com.elmakers.mine.bukkit.api.magic.DeathLocation;
import com.elmakers.mine.bukkit.api.magic.MageContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MagicProvider;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.api.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.api.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.api.protection.CastPermissionManager;
import com.elmakers.mine.bukkit.api.protection.EntityTargetingManager;
import com.elmakers.mine.bukkit.api.protection.PVPManager;
import com.elmakers.mine.bukkit.api.protection.PlayerWarp;
import com.elmakers.mine.bukkit.api.protection.PlayerWarpManager;
import com.elmakers.mine.bukkit.api.protection.PlayerWarpProvider;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.requirements.RequirementsProcessor;
import com.elmakers.mine.bukkit.api.requirements.RequirementsProvider;
import com.elmakers.mine.bukkit.api.rp.ResourcePackStatus;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.arena.ArenaController;
import com.elmakers.mine.bukkit.block.AbstractSchematic;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.LegacySchematic;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.Schematic;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.magic.MagicBlockTemplate;
import com.elmakers.mine.bukkit.bstats.Metrics;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.configuration.MageParameters;
import com.elmakers.mine.bukkit.configuration.MagicConfiguration;
import com.elmakers.mine.bukkit.crafting.MagicRecipe;
import com.elmakers.mine.bukkit.data.YamlDataFile;
import com.elmakers.mine.bukkit.dynmap.DynmapController;
import com.elmakers.mine.bukkit.economy.BaseMagicCurrency;
import com.elmakers.mine.bukkit.economy.CustomCurrency;
import com.elmakers.mine.bukkit.economy.ExperienceCurrency;
import com.elmakers.mine.bukkit.economy.HealthCurrency;
import com.elmakers.mine.bukkit.economy.HungerCurrency;
import com.elmakers.mine.bukkit.economy.ItemCurrency;
import com.elmakers.mine.bukkit.economy.LevelCurrency;
import com.elmakers.mine.bukkit.economy.ManaCurrency;
import com.elmakers.mine.bukkit.economy.SpellPointCurrency;
import com.elmakers.mine.bukkit.economy.VaultCurrency;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.elementals.ElementalsController;
import com.elmakers.mine.bukkit.entity.PermissionsTeamProvider;
import com.elmakers.mine.bukkit.entity.ScoreboardTeamProvider;
import com.elmakers.mine.bukkit.essentials.EssentialsController;
import com.elmakers.mine.bukkit.essentials.MagicItemDb;
import com.elmakers.mine.bukkit.essentials.Mailer;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.integration.AureliumSkillsManager;
import com.elmakers.mine.bukkit.integration.BattleArenaManager;
import com.elmakers.mine.bukkit.integration.GenericMetadataNPCSupplier;
import com.elmakers.mine.bukkit.integration.GeyserManager;
import com.elmakers.mine.bukkit.integration.LegacyLibsDisguiseManager;
import com.elmakers.mine.bukkit.integration.LibsDisguiseManager;
import com.elmakers.mine.bukkit.integration.LightAPIManager;
import com.elmakers.mine.bukkit.integration.LogBlockManager;
import com.elmakers.mine.bukkit.integration.ModelEngineManager;
import com.elmakers.mine.bukkit.integration.ModernLibsDisguiseManager;
import com.elmakers.mine.bukkit.integration.MythicMobManager;
import com.elmakers.mine.bukkit.integration.NPCSupplierSet;
import com.elmakers.mine.bukkit.integration.PlaceholderAPIManager;
import com.elmakers.mine.bukkit.integration.SkillAPIManager;
import com.elmakers.mine.bukkit.integration.SkriptManager;
import com.elmakers.mine.bukkit.integration.TokenManagerController;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.integration.mobarena.MobArenaManager;
import com.elmakers.mine.bukkit.item.Icon;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.kit.KitController;
import com.elmakers.mine.bukkit.kit.MagicKit;
import com.elmakers.mine.bukkit.magic.DamageType;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageIdentifier;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.elmakers.mine.bukkit.magic.ModifierTemplate;
import com.elmakers.mine.bukkit.magic.NoSuchMageException;
import com.elmakers.mine.bukkit.magic.PhysicsHandler;
import com.elmakers.mine.bukkit.magic.PluginNotLoadedException;
import com.elmakers.mine.bukkit.magic.SwingType;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicTraitCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.WandCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.config.FetchExampleRunnable;
import com.elmakers.mine.bukkit.magic.command.config.UpdateAllExamplesCallback;
import com.elmakers.mine.bukkit.magic.listener.AnvilController;
import com.elmakers.mine.bukkit.magic.listener.ArenaListener;
import com.elmakers.mine.bukkit.magic.listener.BlockController;
import com.elmakers.mine.bukkit.magic.listener.CraftingController;
import com.elmakers.mine.bukkit.magic.listener.EnchantingController;
import com.elmakers.mine.bukkit.magic.listener.EntityController;
import com.elmakers.mine.bukkit.magic.listener.ErrorNotifier;
import com.elmakers.mine.bukkit.magic.listener.ExplosionController;
import com.elmakers.mine.bukkit.magic.listener.HangingController;
import com.elmakers.mine.bukkit.magic.listener.InventoryController;
import com.elmakers.mine.bukkit.magic.listener.ItemController;
import com.elmakers.mine.bukkit.magic.listener.JumpController;
import com.elmakers.mine.bukkit.magic.listener.MinigamesListener;
import com.elmakers.mine.bukkit.magic.listener.MobController;
import com.elmakers.mine.bukkit.magic.listener.PlayerController;
import com.elmakers.mine.bukkit.magic.listener.WildStackerListener;
import com.elmakers.mine.bukkit.maps.MapController;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.materials.SimpleMaterialSetManager;
import com.elmakers.mine.bukkit.npc.MagicNPC;
import com.elmakers.mine.bukkit.protection.AJParkourManager;
import com.elmakers.mine.bukkit.protection.CitadelManager;
import com.elmakers.mine.bukkit.protection.DeadSoulsManager;
import com.elmakers.mine.bukkit.protection.FactionsManager;
import com.elmakers.mine.bukkit.protection.GriefPreventionManager;
import com.elmakers.mine.bukkit.protection.LocketteManager;
import com.elmakers.mine.bukkit.protection.MultiverseManager;
import com.elmakers.mine.bukkit.protection.NCPManager;
import com.elmakers.mine.bukkit.protection.PreciousStonesManager;
import com.elmakers.mine.bukkit.protection.ProtectionManager;
import com.elmakers.mine.bukkit.protection.PvPManagerManager;
import com.elmakers.mine.bukkit.protection.RedProtectManager;
import com.elmakers.mine.bukkit.protection.ResidenceManager;
import com.elmakers.mine.bukkit.protection.TownyManager;
import com.elmakers.mine.bukkit.protection.WorldGuardManager;
import com.elmakers.mine.bukkit.requirements.RequirementsController;
import com.elmakers.mine.bukkit.resourcepack.ResourcePackManager;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.SpellCategory;
import com.elmakers.mine.bukkit.tasks.ArmorUpdatedTask;
import com.elmakers.mine.bukkit.tasks.AutoSaveTask;
import com.elmakers.mine.bukkit.tasks.BatchUpdateTask;
import com.elmakers.mine.bukkit.tasks.ChangeServerTask;
import com.elmakers.mine.bukkit.tasks.ConfigCheckTask;
import com.elmakers.mine.bukkit.tasks.ConfigurationLoadTask;
import com.elmakers.mine.bukkit.tasks.DoMageLoadTask;
import com.elmakers.mine.bukkit.tasks.FinishGenericIntegrationTask;
import com.elmakers.mine.bukkit.tasks.LoadDataTask;
import com.elmakers.mine.bukkit.tasks.LogNotifyTask;
import com.elmakers.mine.bukkit.tasks.LogWatchdogTask;
import com.elmakers.mine.bukkit.tasks.MageLoadTask;
import com.elmakers.mine.bukkit.tasks.MageQuitTask;
import com.elmakers.mine.bukkit.tasks.MageUpdateTask;
import com.elmakers.mine.bukkit.tasks.MagicBlockUpdateTask;
import com.elmakers.mine.bukkit.tasks.MigrateDataTask;
import com.elmakers.mine.bukkit.tasks.MigrationTask;
import com.elmakers.mine.bukkit.tasks.PostStartupLoadTask;
import com.elmakers.mine.bukkit.tasks.SaveDataTask;
import com.elmakers.mine.bukkit.tasks.SaveMageDataTask;
import com.elmakers.mine.bukkit.tasks.SaveMageTask;
import com.elmakers.mine.bukkit.tasks.UndoUpdateTask;
import com.elmakers.mine.bukkit.tasks.ValidateSpellsTask;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.HitboxUtils;
import com.elmakers.mine.bukkit.utility.LogMessage;
import com.elmakers.mine.bukkit.utility.MagicLogger;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import com.elmakers.mine.bukkit.utility.SkullLoadedCallback;
import com.elmakers.mine.bukkit.utility.platform.DeprecatedUtils;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.warp.MagicWarp;
import com.elmakers.mine.bukkit.warp.WarpController;
import com.elmakers.mine.bukkit.world.MagicWorld;
import com.elmakers.mine.bukkit.world.WorldController;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class MagicController
implements MageController {
    private static final String BUILTIN_SPELL_CLASSPATH = "com.elmakers.mine.bukkit.spell.builtin";
    private static final String LOST_WANDS_FILE = "lostwands";
    private static final String WARPS_FILE = "warps";
    private static final String ARENAS_FILE = "arenas";
    private static final String SPELLS_DATA_FILE = "spells";
    private static final String BLOCKS_DATA_FILE = "blocks";
    private static final String NPC_DATA_FILE = "npcs";
    private static final String URL_MAPS_FILE = "imagemaps";
    private static final String DEFAULT_DATASTORE_PACKAGE = "com.elmakers.mine.bukkit.data";
    private static final long MAGE_CACHE_EXPIRY = 10000L;
    private static final int MAX_WARNINGS = 10;
    private static long LOG_WATCHDOG_TIMEOUT = 30000L;
    private static final int MAX_ERRORS = 10;
    protected static Random random = new Random();
    private final Set<String> builtinMageAttributes = ImmutableSet.of((Object)"health", (Object)"health_max", (Object)"armor", (Object)"luck", (Object)"knockback_resistance", (Object)"movement_speed", (Object[])new String[]{"attack_damage", "location_x", "location_y", "location_z", "temperature", "humidity", "time", "moon", "mana", "mana_max", "xp", "level", "bowpull", "bowpower", "damage", "damage_dealt", "fall_distance", "air", "air_max", "hunger", "play_time"});
    private final Set<String> builtinTargetAttributes = ImmutableSet.of((Object)"target_health", (Object)"target_health_max", (Object)"target_armor", (Object)"target_luck", (Object)"target_knockback_resistance", (Object)"target_location_x", (Object[])new String[]{"target_location_y", "target_location_z", "target_mana", "target_mana_max", "target_air", "target_air_max", "target_hunger", "target_fall_distance", "target_humidity", "target_temperature"});
    private final Set<String> builtinAttributes = ImmutableSet.of((Object)"epoch", (Object)"hours", (Object)"minutes", (Object)"seconds", (Object)"days", (Object)"weeks", (Object[])new String[]{"pi", "degrees"});
    private final Map<String, MagicBlockTemplate> magicBlockTemplates = new HashMap<String, MagicBlockTemplate>();
    private final Map<String, com.elmakers.mine.bukkit.wand.WandTemplate> wandTemplates = new HashMap<String, com.elmakers.mine.bukkit.wand.WandTemplate>();
    private final Map<String, MageClassTemplate> mageClasses = new HashMap<String, MageClassTemplate>();
    private final Map<String, ModifierTemplate> modifiers = new HashMap<String, ModifierTemplate>();
    private final Map<String, SpellTemplate> spells = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellTemplate> spellAliases = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellData> templateDataMap = new HashMap<String, SpellData>();
    private final Map<String, SpellCategory> categories = new HashMap<String, SpellCategory>();
    private final Map<String, MagicAttribute> attributes = new HashMap<String, MagicAttribute>();
    private final Map<String, Icon> icons = new HashMap<String, Icon>();
    private final Set<String> registeredAttributes = new HashSet<String>();
    private final Map<String, Mage> mages = Maps.newConcurrentMap();
    private final Set<com.elmakers.mine.bukkit.api.magic.Mage> pendingConstruction = new HashSet<com.elmakers.mine.bukkit.api.magic.Mage>();
    private final PriorityQueue<com.elmakers.mine.bukkit.api.block.UndoList> scheduledUndo = new PriorityQueue();
    private final Map<String, WeakReference<com.elmakers.mine.bukkit.api.block.Schematic>> schematics = new HashMap<String, WeakReference<com.elmakers.mine.bukkit.api.block.Schematic>>();
    private final Map<String, Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer>> effects = new HashMap<String, Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer>>();
    private final Map<Chunk, Integer> lockedChunks = new HashMap<Chunk, Integer>();
    private final MagicLogger logger;
    private final File configFolder;
    private final File dataFolder;
    private final File defaultsFolder;
    private final Map<String, String> exampleKeyNames = new HashMap<String, String>();
    private final Object saveLock = new Object();
    private final SimpleMaterialSetManager materialSetManager = new SimpleMaterialSetManager();
    private final Map<String, Integer> maxSpellLevels = new HashMap<String, Integer>();
    private final int undoTimeWindow = 6000;
    private final Map<String, DamageType> damageTypes = new HashMap<String, DamageType>();
    private final Map<Material, String> blockSkins = new HashMap<Material, String>();
    private final Map<EntityType, String> mobSkins = new HashMap<EntityType, String>();
    private final Map<EntityType, MaterialAndData> skullItems = new HashMap<EntityType, MaterialAndData>();
    private final Map<EntityType, MaterialAndData> skullWallBlocks = new HashMap<EntityType, MaterialAndData>();
    private final Map<EntityType, MaterialAndData> skullGroundBlocks = new HashMap<EntityType, MaterialAndData>();
    private final Map<EntityType, Material> mobEggs = new HashMap<EntityType, Material>();
    private final int toggleMessageRange = 1024;
    private final Material defaultMaterial = Material.DIRT;
    private final Set<EntityType> undoEntityTypes = new HashSet<EntityType>();
    private final Set<EntityType> friendlyEntityTypes = new HashSet<EntityType>();
    private final Map<String, Currency> currencies = new HashMap<String, Currency>();
    private final Map<String, List<MagicNPC>> npcsByChunk = new HashMap<String, List<MagicNPC>>();
    private final Map<UUID, MagicNPC> npcs = new HashMap<UUID, MagicNPC>();
    private final Map<String, Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock>> magicBlocks = new HashMap<String, Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock>>();
    private final Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> activeBlocks = new HashMap<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock>();
    private final Map<String, LostWand> lostWands = new HashMap<String, LostWand>();
    private final Map<String, Set<String>> lostWandChunks = new HashMap<String, Set<String>>();
    private final Map<Long, Integer> lightBlocks = new HashMap<Long, Integer>();
    private final Map<String, Integer> lightChunks = new HashMap<String, Integer>();
    private final boolean hasDynmap = false;
    private final Messages messages = new Messages();
    private final Set<String> resolvingKeys = new LinkedHashSet<String>();
    private final Map<String, MageData> mageDataPreCache = new ConcurrentHashMap<String, MageData>();
    private final FactionsManager factionsManager = new FactionsManager();
    private final LocketteManager locketteManager = new LocketteManager();
    private final WorldGuardManager worldGuardManager = new WorldGuardManager();
    private final PvPManagerManager pvpManager = new PvPManagerManager();
    private final MultiverseManager multiverseManager = new MultiverseManager();
    private final PreciousStonesManager preciousStonesManager = new PreciousStonesManager();
    private final TownyManager townyManager = new TownyManager();
    private final GriefPreventionManager griefPreventionManager = new GriefPreventionManager();
    private final NCPManager ncpManager = new NCPManager();
    private final ProtectionManager protectionManager = new ProtectionManager();
    private final Set<MagicProvider> externalProviders = new HashSet<MagicProvider>();
    private final List<BlockBreakManager> blockBreakManagers = new ArrayList<BlockBreakManager>();
    private final List<BlockBuildManager> blockBuildManagers = new ArrayList<BlockBuildManager>();
    private final List<PVPManager> pvpManagers = new ArrayList<PVPManager>();
    private final List<CastPermissionManager> castManagers = new ArrayList<CastPermissionManager>();
    private final List<AttributeProvider> attributeProviders = new ArrayList<AttributeProvider>();
    private final List<TeamProvider> teamProviders = new ArrayList<TeamProvider>();
    private final List<EntityTargetingManager> targetingProviders = new ArrayList<EntityTargetingManager>();
    private final NPCSupplierSet npcSuppliers = new NPCSupplierSet();
    private final Map<String, RequirementsProcessor> requirementProcessors = new HashMap<String, RequirementsProcessor>();
    private final Map<String, PlayerWarpManager> playerWarpManagers = new HashMap<String, PlayerWarpManager>();
    private final Map<Material, String> autoWands = new HashMap<Material, String>();
    private final Map<String, String> builtinExternalExamples = new HashMap<String, String>();
    private MaterialAndData redstoneReplacement = new MaterialAndData(Material.OBSIDIAN);
    @Nonnull
    private MaterialSet buildingMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet indestructibleMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet restrictedMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet destructibleMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet interactibleMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet containerMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet wearableMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet meleeMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet climbableMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet undoableMaterials = MaterialSets.wildcard();
    private ConfigurationSection wandSlotConfigurations;
    private boolean backupInventories = true;
    private int undoQueueDepth = 256;
    private int pendingQueueDepth = 16;
    private int undoMaxPersistSize = 0;
    private boolean commitOnQuit = false;
    private boolean saveNonPlayerMages = false;
    private String defaultWandPath = "";
    private WandMode defaultWandMode = WandMode.NONE;
    private WandMode defaultBrushMode = WandMode.CHEST;
    private boolean showMessages = true;
    private boolean showCastMessages = false;
    private String messagePrefix = "";
    private String castMessagePrefix = "";
    private boolean soundsEnabled = true;
    private String welcomeWand = "";
    private int messageThrottle = 0;
    private boolean spellDroppingEnabled = false;
    private boolean fillingEnabled = false;
    private int maxFillLevel = 0;
    private boolean essentialsSignsEnabled = false;
    private boolean dynmapUpdate = true;
    private boolean dynmapShowWands = true;
    private boolean dynmapOnlyPlayerSpells = false;
    private boolean dynmapShowSpells = true;
    private boolean createWorldsEnabled = true;
    private float maxDamagePowerMultiplier = 2.0f;
    private float maxConstructionPowerMultiplier = 5.0f;
    private float maxRadiusPowerMultiplier = 2.5f;
    private float maxRadiusPowerMultiplierMax = 4.0f;
    private float maxRangePowerMultiplier = 3.0f;
    private float maxRangePowerMultiplierMax = 5.0f;
    private float maxPower = 100.0f;
    private float maxCostReduction = 0.5f;
    private float maxCooldownReduction = 0.5f;
    private int maxMana = 1000;
    private int maxManaRegeneration = 100;
    private double worthBase = 1.0;
    private boolean spEnabled = true;
    private boolean spEarnEnabled = true;
    private boolean castCommandCostFree = false;
    private boolean castCommandCooldownFree = false;
    private float castCommandPowerMultiplier = 0.0f;
    private boolean castConsoleCostFree = false;
    private boolean castConsoleCooldownFree = false;
    private float castConsolePowerMultiplier = 0.0f;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private int autoUndo = 0;
    private int autoSaveTaskId = 0;
    private BukkitTask configCheckTask = null;
    private BukkitTask logNotifyTask = null;
    private boolean savePlayerData = true;
    private boolean externalPlayerData = false;
    private boolean asynchronousSaving = true;
    private boolean debugEffectLib = false;
    private WarpController warpController = null;
    private KitController kitController = null;
    private Collection<ConfigurationSection> materialColors = null;
    private List<Object> materialVariants = null;
    private ConfigurationSection blockItems = null;
    private MageDataStore mageDataStore = null;
    private MageDataStore migrateDataStore = null;
    private MigrateDataTask migrateDataTask = null;
    private BukkitTask logWatchdogTimer = null;
    private MagicPlugin plugin = null;
    private int magicBlockUpdateFrequency = 1;
    private int mageUpdateFrequency = 5;
    private int workFrequency = 1;
    private int undoFrequency = 10;
    private int workPerUpdate = 5000;
    private int logVerbosity = 0;
    private boolean urlIconsEnabled = true;
    private boolean legacyIconsEnabled = false;
    private boolean autoSpellUpgradesEnabled = true;
    private boolean autoPathUpgradesEnabled = true;
    private boolean spellProgressionEnabled = true;
    private boolean bypassBuildPermissions = false;
    private boolean bypassBreakPermissions = false;
    private boolean bypassPvpPermissions = false;
    private boolean wandsBreakHanging = true;
    private boolean bypassFriendlyFire = false;
    private boolean useScoreboardTeams = false;
    private boolean defaultFriendly = true;
    private boolean protectLocked = true;
    private boolean bindOnGive = false;
    private List<List<String>> permissionTeams = null;
    private String extraSchematicFilePath = null;
    private Mailer mailer = null;
    private PhysicsHandler physicsHandler = null;
    private List<ConfigurationSection> invalidNPCs = new ArrayList<ConfigurationSection>();
    private List<ConfigurationSection> invalidMagicBlocks = new ArrayList<ConfigurationSection>();
    private int metricsLevel = 5;
    private Metrics metrics = null;
    private boolean hasEssentials = false;
    private boolean hasCommandBook = false;
    private String exampleDefaults = null;
    private Collection<String> addExamples = null;
    private boolean loaded = false;
    private PostStartupLoadTask finalizingConfig = null;
    private boolean shuttingDown = false;
    private boolean dataLoaded = false;
    private String defaultSkillIcon = "stick";
    private boolean despawnMagicMobs = false;
    private int skillInventoryRows = 6;
    private boolean skillsUseHeroes = true;
    private boolean useBattleArenaTeams = true;
    private boolean skillsUsePermissions = false;
    private boolean useWildStacker = true;
    private String heroesSkillPrefix = "";
    private String skillsSpell = "";
    private boolean isFileLockingEnabled = false;
    private int fileLoadDelay = 0;
    private com.elmakers.mine.bukkit.api.magic.Mage reloadingMage = null;
    private ResourcePackManager resourcePacks = null;
    private CraftingController crafting = null;
    private MobController mobs = null;
    private ItemController items = null;
    private EnchantingController enchanting = null;
    private AnvilController anvil = null;
    private MapController maps = null;
    private DynmapController dynmap = null;
    private ElementalsController elementals = null;
    private CitizensController citizens = null;
    private BlockController blockController = null;
    private HangingController hangingController = null;
    private PlayerController playerController = null;
    private EntityController entityController = null;
    private InventoryController inventoryController = null;
    private ExplosionController explosionController = null;
    private JumpController jumpController = null;
    private WorldController worldController = null;
    private ArenaController arenaController = null;
    @Nonnull
    private MageIdentifier mageIdentifier = new MageIdentifier();
    private boolean citizensEnabled = true;
    private boolean logBlockEnabled = true;
    private boolean libsDisguiseEnabled = true;
    private boolean mythicMobsEnabled = true;
    private boolean skillAPIEnabled = true;
    private boolean placeholdersEnabled = true;
    private boolean lightAPIEnabled = true;
    private boolean skriptEnabled = true;
    private boolean vaultEnabled = true;
    private ConfigurationSection residenceConfiguration = null;
    private ConfigurationSection redProtectConfiguration = null;
    private ConfigurationSection citadelConfiguration = null;
    private ConfigurationSection mobArenaConfiguration = null;
    private ConfigurationSection ajParkourConfiguration = null;
    private boolean castConsoleFeedback = false;
    private String editorURL = null;
    private boolean reloadVerboseLogging = true;
    private boolean hasShopkeepers = false;
    private CitadelManager citadelManager = null;
    private ResidenceManager residenceManager = null;
    private RedProtectManager redProtectManager = null;
    private RequirementsController requirementsController = null;
    private HeroesManager heroesManager = null;
    private AureliumSkillsManager aureliumSkillsManager = null;
    private TokenManagerController tokenManager = null;
    private LibsDisguiseManager libsDisguiseManager = null;
    private ModelEngineManager modelEngineManager = null;
    private SkillAPIManager skillAPIManager = null;
    private BattleArenaManager battleArenaManager = null;
    private PlaceholderAPIManager placeholderAPIManager = null;
    private LightAPIManager lightAPIManager = null;
    private MobArenaManager mobArenaManager = null;
    private LogBlockManager logBlockManager = null;
    private EssentialsController essentialsController = null;
    private DeadSoulsManager deadSoulsController = null;
    private MythicMobManager mythicMobManager = null;
    private boolean loading = false;
    private boolean showExampleInstructions = false;
    private int disableSpawnReplacement = 0;
    private SwingType swingType = SwingType.ANIMATE_IF_ADVENTURE;
    private String blockExchangeCurrency = null;
    @Nonnull
    private MaterialSet offhandMaterials = MaterialSets.empty();
    private GeyserManager geyserManager = null;

    public MagicController() {
        this.configFolder = null;
        this.dataFolder = null;
        this.defaultsFolder = null;
        this.logger = new MagicLogger(null, Logger.getLogger("Magic"));
        this.materialSetManager.setLogger(this.logger);
    }

    public MagicController(MagicPlugin plugin) {
        this.plugin = plugin;
        this.logger = new MagicLogger((Plugin)plugin, plugin.getLogger());
        this.resourcePacks = new ResourcePackManager(this);
        this.configFolder = plugin.getDataFolder();
        this.configFolder.mkdirs();
        this.dataFolder = new File(this.configFolder, "data");
        this.dataFolder.mkdirs();
        this.defaultsFolder = new File(this.configFolder, "defaults");
        this.defaultsFolder.mkdirs();
        ConfigurationUtils.setMagicController(this);
    }

    @Nullable
    public static Spell loadSpell(String name, ConfigurationSection node, MageController controller) {
        Object newObject;
        String className = node.getString("class");
        if (className == null || className.equalsIgnoreCase("action") || className.equalsIgnoreCase("actionspell")) {
            className = "com.elmakers.mine.bukkit.spell.ActionSpell";
        } else if (className.indexOf(46) <= 0) {
            className = "com.elmakers.mine.bukkit.spell.builtin." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().log(Level.WARNING, "Error loading spell: " + className, ex);
            return null;
        }
        if (spellClass.getAnnotation(Deprecated.class) != null) {
            controller.getLogger().warning("Spell " + name + " is using a deprecated spell class " + className + ". This will be removed in the future, please see the default configs for alternatives.");
        }
        try {
            newObject = spellClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            controller.getLogger().log(Level.WARNING, "Error loading spell: " + className, ex);
            return null;
        }
        if (newObject == null || !(newObject instanceof MageSpell)) {
            controller.getLogger().warning("Error loading spell: " + className + ", does it implement MageSpell?");
            return null;
        }
        MageSpell newSpell = (MageSpell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        com.elmakers.mine.bukkit.api.spell.SpellCategory category = newSpell.getCategory();
        if (category instanceof SpellCategory) {
            ((SpellCategory)category).addSpellTemplate(newSpell);
        }
        return newSpell;
    }

    public boolean registerNMSBindings() {
        return CompatibilityLib.initialize((Plugin)this.getPlugin(), this.getLogger());
    }

    @Override
    public void onPlayerJump(Player player, Vector velocity) {
        if (this.climbableMaterials.testBlock(player.getLocation().getBlock())) {
            return;
        }
        Mage mage = this.getRegisteredMage((Entity)player);
        if (mage != null) {
            if (velocity != null && mage instanceof Mage) {
                mage.setVelocity(velocity);
            }
            mage.trigger("jump");
        }
    }

    @Override
    public void onResourcePackStatus(Player player, ResourcePackStatus status) {
        this.resourcePacks.onResourcePackStatus(player, status);
    }

    @Override
    @Nullable
    public Mage getRegisteredMage(String mageId) {
        Preconditions.checkNotNull((Object)mageId);
        if (!this.loaded || this.shuttingDown) {
            return null;
        }
        return this.mages.get(mageId);
    }

    @Nullable
    public Mage getRegisteredMage(@Nonnull CommandSender commandSender) {
        Preconditions.checkNotNull((Object)commandSender);
        if (commandSender instanceof Player) {
            return this.getRegisteredMage((Entity)((Player)commandSender));
        }
        String mageId = this.mageIdentifier.fromCommandSender(commandSender);
        return this.getRegisteredMage(mageId);
    }

    @Override
    @Nullable
    public Mage getRegisteredMage(@Nonnull Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        String id = this.mageIdentifier.fromEntity(entity);
        return this.mages.get(id);
    }

    @Nonnull
    protected Mage getMageFromEntity(@Nonnull Entity entity, @Nullable CommandSender commandSender) {
        Preconditions.checkNotNull((Object)entity);
        String id = this.mageIdentifier.fromEntity(entity);
        return this.getMage(id, commandSender, entity);
    }

    @Override
    @Deprecated
    public Mage getAutomaton(String mageId, String mageName) {
        return this.getBlockMage(mageId, mageName);
    }

    @Override
    public Mage getBlockMage(String mageId, String mageName) {
        Preconditions.checkNotNull((Object)mageId);
        Preconditions.checkNotNull((Object)mageName);
        Mage mage = this.getMage(mageId, mageName, null, null);
        mage.setIsAutomaton(true);
        return mage;
    }

    @Override
    public Mage getMage(String mageId, String mageName) {
        Preconditions.checkNotNull((Object)mageId);
        Preconditions.checkNotNull((Object)mageName);
        return this.getMage(mageId, mageName, null, null);
    }

    @Nonnull
    public Mage getMage(@Nonnull String mageId, @Nullable CommandSender commandSender, @Nullable Entity entity) {
        Preconditions.checkState((commandSender != null || entity != null ? 1 : 0) != 0, (Object)"Need to provide either an entity or a command sender for a non-automata mage.");
        return this.getMage(mageId, null, commandSender, entity);
    }

    @Override
    @Nonnull
    public Mage getMage(@Nonnull Player player) {
        Preconditions.checkNotNull((Object)player);
        return this.getMageFromEntity((Entity)player, (CommandSender)player);
    }

    @Override
    @Nonnull
    public Mage getMage(@Nonnull Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        Player commandSender = entity instanceof Player ? (Player)entity : null;
        return this.getMageFromEntity(entity, (CommandSender)commandSender);
    }

    @Override
    @Nonnull
    public Mage getMage(@Nonnull CommandSender commandSender) {
        Preconditions.checkNotNull((Object)commandSender);
        if (commandSender instanceof Player) {
            return this.getMage((Player)commandSender);
        }
        String mageId = this.mageIdentifier.fromCommandSender(commandSender);
        return this.getMage(mageId, commandSender, null);
    }

    @Nonnull
    protected Mage getMage(@Nonnull String mageId, @Nullable String mageName, @Nullable CommandSender commandSender, @Nullable Entity entity) throws PluginNotLoadedException, NoSuchMageException {
        Preconditions.checkNotNull((Object)mageId);
        if (!this.loaded) {
            if (entity instanceof Player) {
                this.getLogger().warning("Player data request for " + mageId + " (" + commandSender.getName() + ") failed, plugin not loaded yet");
            }
            throw new PluginNotLoadedException();
        }
        Mage apiMage = null;
        if (!this.mages.containsKey(mageId)) {
            boolean isPlayer;
            if (this.shuttingDown) {
                if (entity instanceof Player) {
                    this.getLogger().warning("Player data request for " + mageId + " (" + commandSender.getName() + ") failed, plugin is shutting down");
                }
                throw new PluginNotLoadedException();
            }
            if (entity instanceof Player && !((Player)entity).isOnline() && !this.isNPC(entity)) {
                this.getLogger().warning("Player data for " + mageId + " (" + entity.getName() + ") loaded while offline!");
                Thread.dumpStack();
                if (this.isFileLockingEnabled) {
                    this.getLogger().warning("Returning dummy Mage to avoid locking issues");
                    return new Mage(mageId, this);
                }
            }
            Mage mage = new Mage(mageId, this);
            this.mages.put(mageId, mage);
            mage.setName(mageName);
            mage.setCommandSender(commandSender);
            mage.setEntity(entity);
            if (entity instanceof Player) {
                mage.setPlayer((Player)entity);
            }
            boolean bl = isPlayer = (isPlayer = entity instanceof Player) && !this.isNPC(entity);
            if (this.savePlayerData && this.mageDataStore != null) {
                if (isPlayer) {
                    mage.setLoading(true);
                    this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)new DoMageLoadTask(this, mage), (long)(this.fileLoadDelay * 20 / 1000));
                } else if (this.saveNonPlayerMages) {
                    this.info("Loading mage data for " + mage.getName() + " (" + mage.getId() + ") synchronously");
                    this.doLoadData(mage);
                } else {
                    mage.load(null);
                }
            } else if (this.externalPlayerData && (isPlayer || this.saveNonPlayerMages)) {
                mage.setLoading(true);
            } else {
                mage.load(null);
            }
            apiMage = mage;
        } else {
            Mage mage = apiMage = this.mages.get(mageId);
            mage.setName(mageName);
            mage.setCommandSender(commandSender);
            mage.setEntity(entity);
            if (entity instanceof Player) {
                mage.setPlayer((Player)entity);
            }
        }
        if (apiMage == null) {
            this.getLogger().warning("getMage returning null mage for " + entity + " and " + commandSender);
            throw new NoSuchMageException(mageId);
        }
        return apiMage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSynchronizedLoadData(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        Object object = this.saveLock;
        synchronized (object) {
            this.info("Loading mage data for " + mage.getName() + " (" + mage.getId() + ") at " + System.currentTimeMillis());
            this.doLoadData(mage);
        }
    }

    private void doLoadData(final com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.getMageData(mage.getId(), new MageDataCallback(){

            @Override
            public void run(MageData data) {
                MagicController.this.plugin.getServer().getScheduler().runTask((Plugin)MagicController.this.plugin, (Runnable)new MageLoadTask(mage, data));
            }
        });
    }

    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        final String id = this.mageIdentifier.fromPreLogin(event);
        Iterator<Map.Entry<String, MageData>> it = this.mageDataPreCache.entrySet().iterator();
        while (it.hasNext()) {
            MageData data = it.next().getValue();
            if (data.getId().equals(id) || data.getCachedTimestamp() >= System.currentTimeMillis() - 10000L) continue;
            it.remove();
            this.info("Removed expired pre-login mage data cache for id " + data.getId());
        }
        if (this.mageDataPreCache.containsKey(id)) {
            return;
        }
        this.getMageData(id, new MageDataCallback(){

            @Override
            public void run(MageData data) {
                if (data != null) {
                    MagicController.this.info("Cached preloaded mage data cache for id " + data.getId());
                    MagicController.this.mageDataPreCache.put(id, data);
                }
            }
        });
    }

    public void onPlayerJoin(Mage mage) {
        this.worldController.onPlayerJoin(mage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMageData(final String id, final MageDataCallback callback) {
        Object object = this.saveLock;
        synchronized (object) {
            MageData cached = this.mageDataPreCache.get(id);
            if (cached != null) {
                this.info("Loaded preloaded mage data from cache for id " + id);
                this.mageDataPreCache.remove(id);
                callback.run(cached);
                return;
            }
            if (this.mageDataStore == null) {
                callback.run(null);
                return;
            }
            try {
                this.mageDataStore.load(id, new MageDataCallback(){

                    @Override
                    public void run(MageData data) {
                        if (data == null && MagicController.this.migrateDataStore != null) {
                            MagicController.this.info(" Checking migration data store for mage data for " + id);
                            MagicController.this.migrateDataStore.load(id, new MageDataCallback(){

                                @Override
                                public void run(MageData data) {
                                    if (data != null) {
                                        MagicController.this.migrateDataStore.migrate(id);
                                        MagicController.this.info(" Auto-migrated mage data for " + id + " on load");
                                    }
                                    callback.run(data);
                                    MagicController.this.info(" Finished Loading mage data for " + id + " from migration store at " + System.currentTimeMillis());
                                }
                            });
                        } else {
                            callback.run(data);
                            MagicController.this.info(" Finished Loading mage data for " + id + " at " + System.currentTimeMillis());
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.getLogger().warning("Failed to load mage data for " + id);
                ex.printStackTrace();
            }
        }
    }

    public void finalizeMageLoad(Mage mage) {
        if (mage.isPlayer()) {
            this.kitController.onJoin(mage);
        }
    }

    @Override
    public MagicKit getKit(String key) {
        return this.kitController.getKit(key);
    }

    @Override
    public Set<String> getKitKeys() {
        return this.kitController.getKitKeys();
    }

    @Override
    @Nonnull
    public com.elmakers.mine.bukkit.api.magic.Mage getConsoleMage() {
        return this.getMage((CommandSender)this.plugin.getServer().getConsoleSender());
    }

    public void log(String message) {
        this.info(message, 0);
    }

    @Override
    public void info(String message) {
        this.info(message, 1);
    }

    @Override
    public void info(String message, int verbosity) {
        if (this.loading && !this.reloadVerboseLogging) {
            return;
        }
        if (this.logVerbosity >= verbosity) {
            this.getLogger().info(message);
        }
    }

    public float getMaxDamagePowerMultiplier() {
        return this.maxDamagePowerMultiplier;
    }

    public float getMaxConstructionPowerMultiplier() {
        return this.maxConstructionPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplier() {
        return this.maxRadiusPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplierMax() {
        return this.maxRadiusPowerMultiplierMax;
    }

    public float getMaxRangePowerMultiplier() {
        return this.maxRangePowerMultiplier;
    }

    public float getMaxRangePowerMultiplierMax() {
        return this.maxRangePowerMultiplierMax;
    }

    public int getAutoUndoInterval() {
        return this.autoUndo;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public double getMaxDamageReduction(String protectionType) {
        DamageType damageType = this.damageTypes.get(protectionType);
        return damageType == null ? 0.0 : damageType.getMaxReduction();
    }

    public double getMaxAttackMultiplier(String protectionType) {
        DamageType damageType = this.damageTypes.get(protectionType);
        return damageType == null ? 1.0 : damageType.getMaxAttackMultiplier();
    }

    public double getMaxDefendMultiplier(String protectionType) {
        DamageType damageType = this.damageTypes.get(protectionType);
        return damageType == null ? 1.0 : damageType.getMaxDefendMultiplier();
    }

    @Override
    @Nonnull
    public Set<String> getDamageTypes() {
        return this.damageTypes.keySet();
    }

    @Override
    @Nonnull
    public Set<String> getAttributes() {
        return this.registeredAttributes;
    }

    @Override
    @Nonnull
    public Set<String> getInternalAttributes() {
        return this.attributes.keySet();
    }

    public float getMaxCostReduction() {
        return this.maxCostReduction;
    }

    public float getMaxCooldownReduction() {
        return this.maxCooldownReduction;
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public int getMaxManaRegeneration() {
        return this.maxManaRegeneration;
    }

    @Override
    public double getWorthBase() {
        return this.worthBase;
    }

    @Override
    public double getWorthXP() {
        return this.getCurrency("xp", 1.0).getWorth();
    }

    @Override
    public double getWorthSkillPoints() {
        return this.getCurrency("sp", 1.0).getWorth();
    }

    @Override
    @Nullable
    public ItemStack getWorthItem() {
        Currency itemCurrency = this.getCurrency("item");
        if (itemCurrency == null || !(itemCurrency instanceof ItemCurrency)) {
            return null;
        }
        return ((ItemCurrency)itemCurrency).getItem();
    }

    @Override
    public double getWorthItemAmount() {
        return this.getCurrency("item").getWorth();
    }

    @Override
    @Nullable
    public Currency getCurrency(String key) {
        return this.currencies.get(key);
    }

    private Currency getCurrency(String key, double defaultWorth) {
        Currency currency = this.currencies.get(key);
        if (currency == null) {
            currency = new CustomCurrency(key, defaultWorth);
        }
        return currency;
    }

    @Override
    @Nonnull
    public Set<String> getCurrencyKeys() {
        return this.currencies.keySet();
    }

    public int getUndoQueueDepth() {
        return this.undoQueueDepth;
    }

    public int getPendingQueueDepth() {
        return this.pendingQueueDepth;
    }

    @Override
    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public String getCastMessagePrefix() {
        return this.castMessagePrefix;
    }

    public boolean showCastMessages() {
        return this.showCastMessages;
    }

    public boolean showMessages() {
        return this.showMessages;
    }

    @Override
    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean fillWands() {
        return this.fillingEnabled;
    }

    @Override
    public int getMaxWandFillLevel() {
        return this.maxFillLevel;
    }

    @Override
    public MagicLogger getLogger() {
        return this.logger;
    }

    public boolean isIndestructible(Location location) {
        return this.isIndestructible(location.getBlock());
    }

    public boolean isIndestructible(Block block) {
        return this.indestructibleMaterials.testBlock(block);
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.testBlock(block);
    }

    @Override
    public boolean isUndoable(Material material) {
        return this.undoableMaterials.testMaterial(material);
    }

    protected boolean isRestricted(Material material) {
        return this.restrictedMaterials.testMaterial(material);
    }

    protected boolean isRestricted(Material material, @Nullable Short data) {
        if (this.restrictedMaterials.testMaterial(material)) {
            return true;
        }
        MaterialAndData materialAndData = new MaterialAndData(material, data);
        return this.restrictedMaterials.testMaterialAndData(materialAndData);
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.bypassBuildPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("magic.bypass_build")) {
            return true;
        }
        if (this.hasBypassPermission((CommandSender)player)) {
            return true;
        }
        boolean allowed = true;
        for (BlockBuildManager manager : this.blockBuildManagers) {
            if (manager.hasBuildPermission(player, block)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public boolean hasBreakPermission(Player player, Block block) {
        if (this.bypassBreakPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("magic.bypass_break")) {
            return true;
        }
        if (this.hasBypassPermission((CommandSender)player)) {
            return true;
        }
        boolean allowed = true;
        for (BlockBreakManager manager : this.blockBreakManagers) {
            if (manager.hasBreakPermission(player, block)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    @Override
    public boolean isExitAllowed(Player player, Location location) {
        if (location == null) {
            return true;
        }
        return this.worldGuardManager.isExitAllowed(player, location);
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (location == null) {
            return true;
        }
        if (this.bypassPvpPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("magic.bypass_pvp")) {
            return true;
        }
        boolean allowed = true;
        for (PVPManager manager : this.pvpManagers) {
            if (manager.isPVPAllowed(player, location)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public boolean canWandsBreakHanging() {
        return this.wandsBreakHanging;
    }

    public void clearCache() {
        this.schematics.clear();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).clearCache();
        }
        this.maps.clearCache();
        this.maps.resetAll();
    }

    @Nullable
    protected InputStream findSchematic(String schematicName, String extension) {
        InputStream inputSchematic;
        try {
            File schematicFolder;
            File extraSchematicFile = null;
            File magicSchematicFolder = new File(this.plugin.getDataFolder(), "schematics");
            if (magicSchematicFolder.exists()) {
                extraSchematicFile = new File(magicSchematicFolder, schematicName + "." + extension);
                this.info("Checking for schematic: " + extraSchematicFile.getAbsolutePath(), 2);
                if (!extraSchematicFile.exists()) {
                    extraSchematicFile = null;
                }
            }
            if (extraSchematicFile == null && this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0 && (schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath)).exists()) {
                extraSchematicFile = new File(schematicFolder, schematicName + "." + extension);
                this.info("Checking for external schematic: " + extraSchematicFile.getAbsolutePath(), 2);
            }
            if (extraSchematicFile != null && extraSchematicFile.exists()) {
                inputSchematic = new FileInputStream(extraSchematicFile);
                this.info("Loading file: " + extraSchematicFile.getAbsolutePath());
            } else {
                String fileName = schematicName + "." + extension;
                inputSchematic = this.plugin.getResource("schematics/" + fileName);
                this.info("Loading builtin schematic: " + fileName);
            }
            if (inputSchematic == null) {
                throw new FileNotFoundException();
            }
        }
        catch (Exception ignored) {
            inputSchematic = null;
        }
        return inputSchematic;
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.Schematic loadSchematic(String schematicName) {
        AbstractSchematic schematic;
        InputStream inputSchematic;
        com.elmakers.mine.bukkit.api.block.Schematic cached;
        WeakReference<com.elmakers.mine.bukkit.api.block.Schematic> schematic2;
        if (schematicName == null || schematicName.length() == 0) {
            return null;
        }
        if (this.schematics.containsKey(schematicName) && (schematic2 = this.schematics.get(schematicName)) != null && (cached = (com.elmakers.mine.bukkit.api.block.Schematic)schematic2.get()) != null) {
            return cached;
        }
        if (CompatibilityLib.getCompatibilityUtils().hasBlockDataSupport() && (inputSchematic = this.findSchematic(schematicName, "schem")) != null) {
            schematic = new Schematic(this);
            this.schematics.put(schematicName, new WeakReference<Schematic>((Schematic)schematic));
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.lambda$loadSchematic$0(inputSchematic, (Schematic)schematic));
            return schematic;
        }
        InputStream legacySchematic = this.findSchematic(schematicName, "schematic");
        if (legacySchematic == null) {
            return null;
        }
        schematic = new LegacySchematic(this);
        this.schematics.put(schematicName, new WeakReference<Schematic>((Schematic)schematic));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.lambda$loadSchematic$1(legacySchematic, (LegacySchematic)schematic));
        return schematic;
    }

    @Override
    public Collection<String> getBrushKeys() {
        Material[] materials;
        ArrayList<String> names = new ArrayList<String>();
        for (Material material : materials = Material.values()) {
            if (!material.isBlock()) continue;
            names.add(material.name().toLowerCase());
        }
        for (String string : MaterialBrush.SPECIAL_MATERIAL_KEYS) {
            names.add(string.toLowerCase());
        }
        Collection<String> collection = this.getSchematicNames();
        for (String schematic : collection) {
            names.add("schematic:" + schematic);
        }
        return names;
    }

    public Collection<String> getSchematicNames() {
        String schematicName;
        ArrayList<String> schematicNames;
        block13: {
            schematicNames = new ArrayList<String>();
            try {
                CodeSource codeSource = MagicTabExecutor.class.getProtectionDomain().getCodeSource();
                if (codeSource == null) break block13;
                URL jar = codeSource.getLocation();
                try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (name.startsWith("schematics/") && (name.endsWith(".schem") || name.endsWith(".schematic"))) {
                            schematicName = name.replace(".schematic", "").replace(".schem", "").replace("schematics/", "");
                            schematicNames.add(schematicName);
                        }
                        entry = zip.getNextEntry();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                for (File schematicFile : schematicFolder.listFiles()) {
                    if (!schematicFile.getName().endsWith(".schematic") && !schematicFile.getName().endsWith(".schem")) continue;
                    schematicName = schematicFile.getName().replace(".schematic", "").replace(".schem", "");
                    schematicNames.add(schematicName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schematicNames;
    }

    public void initialize() {
        this.warpController = new WarpController(this);
        this.kitController = new KitController(this);
        this.crafting = new CraftingController(this);
        this.mobs = new MobController(this);
        this.items = new ItemController(this);
        this.enchanting = new EnchantingController(this);
        this.anvil = new AnvilController(this);
        this.blockController = new BlockController(this);
        this.hangingController = new HangingController(this);
        this.entityController = new EntityController(this);
        this.playerController = new PlayerController(this);
        this.inventoryController = new InventoryController(this);
        this.explosionController = new ExplosionController(this);
        this.requirementsController = new RequirementsController(this);
        this.worldController = new WorldController(this);
        this.arenaController = new ArenaController(this);
        this.arenaController.start();
        if (CompatibilityLib.hasStatistics() && !CompatibilityLib.hasJumpEvent()) {
            this.jumpController = new JumpController(this);
        }
        File examplesFolder = new File(this.getPlugin().getDataFolder(), "examples");
        examplesFolder.mkdirs();
        File urlMapFile = this.getDataFile(URL_MAPS_FILE);
        File imageCache = new File(this.dataFolder, "imagemapcache");
        imageCache.mkdirs();
        this.maps = new MapController((Plugin)this.plugin, urlMapFile, imageCache);
        if (EffectPlayer.initialize((Plugin)this.plugin, this.getLogger())) {
            this.getLogger().info("EffectLib initialized");
        } else {
            this.getLogger().warning("Failed to initialize EffectLib");
        }
        File magicSchematicFolder = new File(this.plugin.getDataFolder(), "schematics");
        magicSchematicFolder.mkdirs();
        this.migrateConfig("enchanting", "paths");
        this.migrateConfig("automata", BLOCKS_DATA_FILE);
        this.migrateDataFile("automata", BLOCKS_DATA_FILE);
        this.load();
        this.resourcePacks.startResourcePackChecks();
    }

    private void migrateDataFile(String fromName, String toName) {
        this.migrateConfig("data/" + fromName, "data/" + toName, true);
    }

    private void migrateConfig(String fromName, String toName) {
        this.migrateConfig(fromName, toName, false);
    }

    private void migrateConfig(String fromName, String toName, boolean dataFile) {
        File legacyConfig = new File(this.configFolder, fromName + ".yml");
        File newConfig = new File(this.configFolder, toName + ".yml");
        if (!newConfig.exists() && legacyConfig.exists()) {
            String message = "Migrating " + fromName + ".yml to " + toName + ".yml";
            if (!dataFile) {
                message = message + ", please update " + toName + ".yml from now on";
            }
            this.getLogger().info(message);
            legacyConfig.renameTo(newConfig);
        } else if (newConfig.exists() && legacyConfig.exists()) {
            this.getLogger().warning("Both files exist, will not migrate: " + fromName + ".yml and " + toName + ".yml");
        }
        if (!dataFile) {
            File legacyFolder = new File(this.configFolder, fromName);
            File newFolder = new File(this.configFolder, toName);
            if (!newFolder.exists() && legacyFolder.exists()) {
                this.getLogger().info("Migrating folder " + fromName + " to " + toName);
                legacyFolder.renameTo(newFolder);
            } else if (newFolder.exists() && legacyFolder.exists()) {
                this.getLogger().warning("Both folders exist, will not migrate: " + fromName + " and " + toName);
            }
        }
    }

    public void processUndo() {
        com.elmakers.mine.bukkit.api.block.UndoList undo;
        long now = System.currentTimeMillis();
        while (this.scheduledUndo.size() > 0 && now >= (undo = this.scheduledUndo.peek()).getScheduledTime()) {
            this.scheduledUndo.poll();
            undo.undoScheduled();
        }
    }

    public void processPendingBatches() {
        int remainingWork = this.workPerUpdate;
        if (this.pendingConstruction.isEmpty()) {
            return;
        }
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> pending = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>(this.pendingConstruction);
        while (remainingWork > 0 && !pending.isEmpty()) {
            int workPerMage = Math.max(10, remainingWork / pending.size());
            Iterator iterator = pending.iterator();
            while (iterator.hasNext()) {
                com.elmakers.mine.bukkit.api.magic.Mage apiMage = (com.elmakers.mine.bukkit.api.magic.Mage)iterator.next();
                if (!(apiMage instanceof Mage)) continue;
                Mage mage = (Mage)apiMage;
                int workPerformed = mage.processPendingBatches(workPerMage);
                if (!mage.hasPendingBatches()) {
                    iterator.remove();
                    this.pendingConstruction.remove(mage);
                } else if (workPerformed < workPerMage) {
                    iterator.remove();
                }
                remainingWork -= workPerformed;
            }
        }
    }

    protected void activateMetrics() {
        final MagicController controller = this;
        this.metrics = null;
        if (this.metricsLevel > 0) {
            try {
                this.metrics = new Metrics(this.plugin);
                if (this.metricsLevel > 1) {
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Plugin Integration"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            valueMap.put("Essentials", controller.hasEssentials ? 1 : 0);
                            valueMap.put("Dynmap", 0);
                            valueMap.put("Factions", controller.factionsManager.isEnabled() ? 1 : 0);
                            valueMap.put("WorldGuard", controller.worldGuardManager.isEnabled() ? 1 : 0);
                            valueMap.put("Elementals", controller.elementalsEnabled() ? 1 : 0);
                            valueMap.put("Citizens", controller.citizens != null ? 1 : 0);
                            valueMap.put("CommandBook", controller.hasCommandBook ? 1 : 0);
                            valueMap.put("PvpManager", controller.pvpManager.isEnabled() ? 1 : 0);
                            valueMap.put("Multiverse-Core", controller.multiverseManager.isEnabled() ? 1 : 0);
                            valueMap.put("Towny", controller.townyManager.isEnabled() ? 1 : 0);
                            valueMap.put("GriefPrevention", controller.griefPreventionManager.isEnabled() ? 1 : 0);
                            valueMap.put("PreciousStones", controller.preciousStonesManager.isEnabled() ? 1 : 0);
                            valueMap.put("Lockette", controller.locketteManager.isEnabled() ? 1 : 0);
                            valueMap.put("NoCheatPlus", controller.ncpManager.isEnabled() ? 1 : 0);
                            valueMap.put("MythicMobs", controller.mythicMobManager != null ? 1 : 0);
                            return valueMap;
                        }
                    });
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Features Enabled"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            valueMap.put("Crafting", controller.crafting.isEnabled() ? 1 : 0);
                            valueMap.put("Enchanting", controller.enchanting.isEnabled() ? 1 : 0);
                            valueMap.put("SP", controller.isSPEnabled() ? 1 : 0);
                            return valueMap;
                        }
                    });
                }
                if (this.metricsLevel > 2) {
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Total Casts by Category"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            for (SpellCategory category : MagicController.this.categories.values()) {
                                valueMap.put(category.getName(), (int)category.getCastCount());
                            }
                            return valueMap;
                        }
                    });
                }
                if (this.metricsLevel > 3) {
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Total Casts"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            for (SpellTemplate spell : MagicController.this.spells.values()) {
                                if (!(spell instanceof Spell)) continue;
                                valueMap.put(spell.getName(), (int)spell.getCastCount());
                            }
                            return valueMap;
                        }
                    });
                }
                this.getLogger().info("Activated BStats");
            }
            catch (Exception ex) {
                this.getLogger().warning("Failed to load BStats: " + ex.getMessage());
            }
        }
    }

    protected void registerListeners() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this.crafting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.mobs, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.enchanting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.anvil, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.blockController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.hangingController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.entityController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.playerController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.inventoryController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.explosionController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.kitController, (Plugin)this.plugin);
        ArenaListener listener = new ArenaListener(this.arenaController);
        pm.registerEvents((Listener)listener, (Plugin)this.plugin);
        if (this.jumpController != null) {
            pm.registerEvents((Listener)this.jumpController, (Plugin)this.plugin);
        }
        CompatibilityLib.registerEvents(this, pm);
        this.worldController.registerEvents();
    }

    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getPending() {
        return this.pendingConstruction;
    }

    public Collection<com.elmakers.mine.bukkit.api.block.UndoList> getPendingUndo() {
        return this.scheduledUndo;
    }

    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList getPendingUndo(Location location) {
        return UndoList.getUndoList(location);
    }

    public BlockData getUndoData(Location location) {
        return UndoList.getBlockData(location);
    }

    protected void addPending(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingConstruction.add(mage);
    }

    public boolean removeMarker(String id, String group) {
        boolean removed = false;
        if (this.dynmap != null) {
            return this.dynmap.removeMarker(id, group);
        }
        return removed;
    }

    public boolean addMarker(String id, String icon, String group, String title, Location location, String description) {
        if (location == null || location.getWorld() == null) {
            return false;
        }
        return this.addMarker(id, icon, group, title, location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), description);
    }

    public boolean addMarker(String id, String icon, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null) {
            created = this.dynmap.addMarker(id, icon, group, title, world, x, y, z, description);
        }
        return created;
    }

    @Nullable
    public Collection<String> getMarkerIcons() {
        if (this.dynmap == null) {
            return null;
        }
        return this.dynmap.getIcons();
    }

    @Nullable
    public Collection<String> getMarkerSets() {
        if (this.dynmap == null) {
            return null;
        }
        return this.dynmap.getSets();
    }

    @Override
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    protected File getDataFile(String fileName) {
        return new File(this.dataFolder, fileName + ".yml");
    }

    @Nullable
    protected ConfigurationSection loadDataFile(String fileName) {
        File dataFile = this.getDataFile(fileName);
        if (!dataFile.exists()) {
            return null;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)dataFile);
        return configuration;
    }

    protected YamlDataFile createDataFile(String fileName) {
        return this.createDataFile(fileName, true);
    }

    protected YamlDataFile createDataFile(String fileName, boolean checkBackupSize) {
        File dataFile = new File(this.dataFolder, fileName + ".yml");
        YamlDataFile configuration = new YamlDataFile(this.getLogger(), dataFile, checkBackupSize);
        return configuration;
    }

    protected void notify(CommandSender sender, String message) {
        if (sender != null) {
            sender.sendMessage(message);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == sender || !player.hasPermission("magic.notify")) continue;
            player.sendMessage(message);
        }
    }

    public void finalizeLoad(ConfigurationLoadTask loader, CommandSender sender) {
        if (!loader.isSuccessful()) {
            this.notify(sender, ChatColor.RED + "An error occurred reloading configurations, please check server logs!");
            if (!this.loaded) {
                this.getLogger().severe("*** An error occurred while loading configurations ***");
                this.getLogger().severe("*** Magic will be disabled until the next restart  ***");
                this.getLogger().severe("***   Please check the errors above, fix configs   ***");
                this.getLogger().severe("***             And restart the server             ***");
                this.getLogger().warning("");
                this.getLogger().warning("Note that if you start the server with working configs and");
                this.getLogger().warning("Then use /magic load to test changes, Magic won't break");
                this.getLogger().warning("if there are config issues.");
                PluginManager pm = this.plugin.getServer().getPluginManager();
                pm.registerEvents((Listener)new ErrorNotifier(), (Plugin)this.plugin);
            }
            this.loading = false;
            this.resetLoading(sender);
            return;
        }
        this.schematics.clear();
        EquationStore.clear();
        this.exampleKeyNames.clear();
        this.exampleKeyNames.putAll(loader.getExampleKeyNames());
        this.clearHandlers();
        this.processConfigurations(loader, sender);
        this.registerHandlers(loader.getMainConfiguration());
        this.finalizingConfig = new PostStartupLoadTask(this, loader, sender);
        if (!this.loaded) {
            this.activateMetrics();
            this.registerListeners();
            this.finalizeIntegration();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)this.finalizingConfig, 1L);
        } else {
            this.finalizingConfig.run();
        }
    }

    public void checkPostStartupLoad() {
        if (this.finalizingConfig != null) {
            this.finalizingConfig.run();
        }
    }

    private void loadIntegrations(ConfigurationSection configuration) {
        if (this.aureliumSkillsManager != null) {
            ConfigurationSection aureliumSkillsConfiguration = configuration.getConfigurationSection("aurelium_skills");
            this.aureliumSkillsManager.load(aureliumSkillsConfiguration);
            this.costReduction = (float)((double)this.costReduction + this.aureliumSkillsManager.getManaCostReduction());
        }
        if (this.tokenManager != null) {
            ConfigurationSection tokenManagerConfiguration = configuration.getConfigurationSection("token_manager");
            this.tokenManager.load(tokenManagerConfiguration);
        }
        if (this.heroesManager != null) {
            this.heroesManager.load(configuration);
        }
        if (this.skillAPIManager != null) {
            this.skillAPIManager.load(configuration);
        }
    }

    public void finalizePostStartupLoad(ConfigurationLoadTask loader, CommandSender sender) {
        if (this.finalizingConfig == null) {
            return;
        }
        this.finalizingConfig = null;
        if (!this.loaded) {
            this.finalizeIntegrationPreLoad();
        }
        this.loadIntegrations(loader.getMainConfiguration());
        this.registerPreLoad(loader.getMainConfiguration());
        this.logger.setContext(SPELLS_DATA_FILE);
        this.loadSpells(sender, loader.getSpells());
        this.log("Loaded " + this.spells.size() + " spells");
        this.logger.setContext("paths");
        this.loadPaths(loader.getPaths());
        this.log("Loaded " + this.getPathCount() + " progression paths");
        this.logger.setContext("crafting");
        this.crafting.load(loader.getCrafting());
        this.crafting.register(this, (Plugin)this.plugin);
        MagicRecipe.FIRST_REGISTER = false;
        this.log("Loaded " + this.crafting.getCount() + " crafting recipes");
        this.logger.setContext("Finalize items");
        this.items.finalizeItems();
        if (!this.loaded) {
            this.finalizeIntegrationPostLoad();
        } else {
            this.logger.setContext("reload active magic blocks");
            try {
                this.updateActiveBlocks();
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Error updating automata", ex);
            }
            this.logger.setContext("reload active mobs");
            try {
                this.mobs.updateAllMobs();
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Error updating mobs", ex);
            }
            this.logger.setContext("reload active npcs");
            for (MagicNPC magicNPC : this.npcs.values()) {
                try {
                    magicNPC.update();
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.SEVERE, "Error updating npc " + magicNPC.getName(), ex);
                }
            }
            this.logger.setContext("reload active mages");
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
                if (mage instanceof Mage) {
                    Mage impl = (Mage)mage;
                    impl.reloadClasses();
                    impl.reloadModifiers();
                }
                mage.updatePassiveEffects();
            }
        }
        this.logger.setContext(ARENAS_FILE);
        this.arenaController.loadTemplates(loader.getArenas());
        this.logger.setContext(null);
        this.log("Loaded " + this.arenaController.getArenas().size() + " arenas");
        this.logger.setContext("finalizingLoad");
        this.finishLoad(sender);
        LoadEvent loadEvent = new LoadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)loadEvent);
        this.logger.setContext(null);
    }

    public void processConfigurations(ConfigurationLoadTask loader, CommandSender sender) {
        this.exampleDefaults = loader.getExampleDefaults();
        this.addExamples = loader.getAddExamples();
        this.logger.setContext("attributes");
        this.loadAttributes(loader.getAttributes());
        this.logger.setContext(null);
        this.log("Loaded " + this.attributes.size() + " attributes");
        this.logger.setContext("integration");
        this.logger.setContext("config");
        this.loadProperties(sender, loader.getMainConfiguration());
        this.finalizeAttributes();
        this.logger.setContext("icons");
        this.loadIcons(loader.getIcons());
        this.log("Loaded " + this.icons.size() + " icons");
        this.logger.setContext("messages");
        this.messages.load(loader.getMessages(), this.icons);
        this.processMessages();
        this.logger.setContext("materials");
        this.loadMaterials(loader.getMaterials());
        this.logger.setContext("effects");
        this.loadEffects(loader.getEffects());
        this.logger.setContext(null);
        this.log("Loaded " + this.effects.size() + " effect lists");
        this.logger.setContext("items");
        this.items.load(loader.getItems());
        this.logger.setContext(null);
        this.log("Loaded " + this.items.getCount() + " items");
        this.logger.setContext("wands");
        this.loadWandTemplates(loader.getWands());
        this.logger.setContext(null);
        this.log("Loaded " + this.getWandTemplates().size() + " wands");
        this.logger.setContext("kits");
        this.kitController.load(loader.getKits());
        this.logger.setContext(null);
        this.log("Loaded " + this.kitController.getCount() + " kits");
        this.logger.setContext("classes");
        this.loadMageClasses(loader.getClasses());
        this.logger.setContext(null);
        this.log("Loaded " + this.mageClasses.size() + " classes");
        this.logger.setContext("modifiers");
        this.loadModifiers(loader.getModifiers());
        this.logger.setContext(null);
        this.log("Loaded " + this.modifiers.size() + " classes");
        this.logger.setContext("mobs");
        this.loadMobs(loader.getMobs());
        this.logger.setContext(null);
        this.log("Loaded " + this.mobs.getCount() + " mob templates");
        this.logger.setContext(BLOCKS_DATA_FILE);
        this.loadBlockTemplates(loader.getBlocks());
        this.logger.setContext(null);
        this.log("Loaded " + this.magicBlockTemplates.size() + " automata templates");
        this.logger.setContext("worlds");
        this.loadWorlds(loader.getWorlds());
        this.logger.setContext(null);
        this.log("Loaded " + this.worldController.getCount() + " customized worlds");
        this.logger.setContext(null);
    }

    public void finishLoad(CommandSender sender) {
        this.logger.setContext(null);
        this.loaded = true;
        this.loading = false;
        this.logger.setContext("registerManagers");
        this.registerManagers();
        Collection allPlayers = this.plugin.getServer().getOnlinePlayers();
        for (Player player : allPlayers) {
            this.getMage(player);
        }
        if (!(sender instanceof ConsoleCommandSender)) {
            this.getLogger().info("Finished loading configuration");
        }
        if (sender != null && this.logger.isCapturing() && this.isLoaded()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new ValidateSpellsTask(this, sender));
        } else {
            this.resetLoading(sender);
            this.notify(sender, ChatColor.AQUA + "Magic " + ChatColor.DARK_AQUA + "configuration reloaded.");
        }
        if (sender instanceof Player && this.reloadingMage == null) {
            this.reloadingMage = this.getMage(sender);
        }
        if (this.reloadingMage != null) {
            Player player = this.reloadingMage.getPlayer();
            if (!player.hasPermission("magic.notify")) {
                player.sendMessage(ChatColor.AQUA + "Magic " + ChatColor.DARK_AQUA + "configuration reloaded.");
            }
            this.reloadingMage.deactivate();
            this.reloadingMage.checkWand();
            this.reloadingMage = null;
        }
        if (this.showExampleInstructions && sender != null) {
            this.showExampleInstructions = false;
            this.showExampleInstructions(sender);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new MigrationTask(this), 100L);
    }

    private void processMessages() {
        BaseMagicCurrency.formatter = new DecimalFormat(this.messages.get("numbers.decimal", "#,###.00"));
        BaseMagicCurrency.intFormatter = new DecimalFormat(this.messages.get("numbers.integer", "#,###"));
        ChatUtils.initialize(this.messages, this.getLogger());
    }

    private void registerManagers() {
        this.registerProviders();
        if (this.worldGuardManager.isEnabled()) {
            this.castManagers.add(this.worldGuardManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.castManagers.add(this.preciousStonesManager);
        }
        if (this.redProtectManager != null && this.redProtectManager.isFlagsEnabled()) {
            this.castManagers.add(this.redProtectManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.targetingProviders.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.targetingProviders.add(this.townyManager);
        }
        if (this.residenceManager != null) {
            this.targetingProviders.add(this.residenceManager);
        }
        if (this.redProtectManager != null) {
            this.targetingProviders.add(this.redProtectManager);
        }
        if (this.worldGuardManager.isEnabled()) {
            this.pvpManagers.add(this.worldGuardManager);
        }
        if (this.pvpManager.isEnabled()) {
            this.pvpManagers.add(this.pvpManager);
        }
        if (this.multiverseManager.isEnabled()) {
            this.pvpManagers.add(this.multiverseManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.pvpManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.pvpManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.pvpManagers.add(this.griefPreventionManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.pvpManagers.add(this.factionsManager);
        }
        if (this.residenceManager != null) {
            this.pvpManagers.add(this.residenceManager);
        }
        if (this.redProtectManager != null) {
            this.pvpManagers.add(this.redProtectManager);
        }
        if (this.worldGuardManager.isEnabled()) {
            this.blockBuildManagers.add(this.worldGuardManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.blockBuildManagers.add(this.factionsManager);
        }
        if (this.locketteManager.isEnabled()) {
            this.blockBuildManagers.add(this.locketteManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.blockBuildManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.blockBuildManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.blockBuildManagers.add(this.griefPreventionManager);
        }
        if (this.mobArenaManager != null && this.mobArenaManager.isProtected()) {
            this.blockBuildManagers.add(this.mobArenaManager);
        }
        if (this.residenceManager != null) {
            this.blockBuildManagers.add(this.residenceManager);
        }
        if (this.redProtectManager != null) {
            this.blockBuildManagers.add(this.redProtectManager);
        }
        if (this.worldGuardManager.isEnabled()) {
            this.blockBreakManagers.add(this.worldGuardManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.blockBreakManagers.add(this.factionsManager);
        }
        if (this.locketteManager.isEnabled()) {
            this.blockBreakManagers.add(this.locketteManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.blockBreakManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.blockBreakManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.blockBreakManagers.add(this.griefPreventionManager);
        }
        if (this.mobArenaManager != null && this.mobArenaManager.isProtected()) {
            this.blockBreakManagers.add(this.mobArenaManager);
        }
        if (this.citadelManager != null) {
            this.blockBreakManagers.add(this.citadelManager);
        }
        if (this.residenceManager != null) {
            this.blockBreakManagers.add(this.residenceManager);
        }
        if (this.redProtectManager != null) {
            this.blockBreakManagers.add(this.redProtectManager);
        }
        if (this.heroesManager != null && this.heroesManager.useParties()) {
            this.teamProviders.add(this.heroesManager);
        }
        if (this.skillAPIManager != null && this.skillAPIManager.usesAllies()) {
            this.teamProviders.add(this.skillAPIManager);
        }
        if (this.useScoreboardTeams) {
            this.teamProviders.add(new ScoreboardTeamProvider());
        }
        if (this.permissionTeams != null && !this.permissionTeams.isEmpty()) {
            this.teamProviders.add(new PermissionsTeamProvider(this.permissionTeams));
        }
        if (this.factionsManager != null) {
            this.teamProviders.add(this.factionsManager);
        }
        if (this.battleArenaManager != null && this.useBattleArenaTeams) {
            this.teamProviders.add(this.battleArenaManager);
        }
        if (this.preciousStonesManager != null && this.preciousStonesManager.isEnabled()) {
            this.playerWarpManagers.put("fields", this.preciousStonesManager);
        }
        if (this.redProtectManager != null) {
            this.playerWarpManagers.put("redprotect", this.redProtectManager);
        }
        if (this.residenceManager != null) {
            this.playerWarpManagers.put("residence", this.residenceManager);
        }
    }

    private void registerProviders() {
        if (this.skillAPIManager != null) {
            this.registerAttributes(this.skillAPIManager);
        }
        if (this.heroesManager != null) {
            this.registerAttributes(this.heroesManager);
        }
        if (this.aureliumSkillsManager != null && this.aureliumSkillsManager.useAttributes()) {
            this.registerAttributes(this.aureliumSkillsManager);
        }
        if (this.mythicMobManager != null) {
            this.mobs.registerMythicMobs(this.mythicMobManager.getMobKeys());
        }
        this.mobs.validate();
        if (this.skillAPIManager != null) {
            this.requirementProcessors.put("skillapi", this.skillAPIManager);
        }
        FinishGenericIntegrationTask genericIntegrationTask = new FinishGenericIntegrationTask(this);
        if (!this.loaded) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)genericIntegrationTask, 1L);
        } else {
            genericIntegrationTask.run();
        }
    }

    public void finishGenericIntegration() {
        this.protectionManager.check();
        if (this.protectionManager.isEnabled()) {
            this.blockBreakManagers.add(this.protectionManager);
            this.blockBuildManagers.add(this.protectionManager);
        }
    }

    public void showExampleInstructions(CommandSender sender, String example) {
        String exampleInstructions;
        Mage mage = this.getMage(sender);
        String exampleKey = this.exampleKeyNames.get(example);
        if (exampleKey == null || exampleKey.isEmpty()) {
            exampleKey = example;
        }
        if ((exampleInstructions = this.messages.get("examples." + exampleKey + ".instructions", "")).isEmpty()) {
            mage.sendMessage(this.messages.get("example.not_found").replace("$example", exampleKey));
            return;
        }
        mage.sendMessage(exampleInstructions);
    }

    public void showExampleInstructions(CommandSender sender) {
        Mage mage = this.getMage(sender);
        ArrayList<String> instructions = new ArrayList<String>();
        for (String example : this.getLoadedExamples()) {
            String exampleInstructions;
            String exampleKey = this.exampleKeyNames.get(example);
            if (exampleKey == null || exampleKey.isEmpty()) {
                exampleKey = example;
            }
            if ((exampleInstructions = this.messages.get("examples." + exampleKey + ".instructions", "")).isEmpty()) continue;
            instructions.add(exampleInstructions);
        }
        if (!instructions.isEmpty()) {
            mage.sendMessage(this.messages.get("example.instructions_header"));
            for (String exampleInstructions : instructions) {
                mage.sendMessage(exampleInstructions);
            }
            mage.sendMessage(this.messages.get("example.instructions_footer"));
        }
    }

    private int getPathCount() {
        return WandUpgradePath.getPathKeys().size();
    }

    private void loadPaths(ConfigurationSection pathConfiguration) {
        WandUpgradePath.loadPaths(this, pathConfiguration);
    }

    private void loadAttributes(ConfigurationSection attributeConfiguration) {
        Set keys = attributeConfiguration.getKeys(false);
        this.attributes.clear();
        for (String key : keys) {
            this.logger.setContext("attribute." + key);
            if (!attributeConfiguration.isConfigurationSection(key)) {
                this.logger.warning("attribute." + key + " does not have the proper parameters. It will not be loaded.");
                continue;
            }
            MagicAttribute attribute = new MagicAttribute(key, attributeConfiguration.getConfigurationSection(key));
            this.attributes.put(key, attribute);
        }
    }

    private void loadBlockTemplates(ConfigurationSection blockConfiguration) {
        Set keys = blockConfiguration.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        this.magicBlockTemplates.clear();
        for (String key : keys) {
            this.logger.setContext("blocks." + key);
            Object config = this.resolveConfiguration(key, blockConfiguration, templateConfigurations);
            if (!ConfigurationUtils.isEnabled(config)) continue;
            config = MagicConfiguration.getKeyed(this, config, "block", key);
            MagicBlockTemplate template = new MagicBlockTemplate(this, key, (ConfigurationSection)config);
            this.magicBlockTemplates.put(key, template);
        }
    }

    public void updateActiveBlocks() {
        for (com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock : this.activeBlocks.values()) {
            magicBlock.pause();
        }
        for (Map map : this.magicBlocks.values()) {
            for (com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock : map.values()) {
                magicBlock.reload();
            }
        }
        for (com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock : this.activeBlocks.values()) {
            magicBlock.resume();
        }
    }

    public boolean isMagicBlockTemplate(@Nonnull String key) {
        return this.magicBlockTemplates.containsKey(key);
    }

    @Override
    @Nonnull
    @Deprecated
    public Collection<String> getAutomatonTemplateKeys() {
        return this.getMagicBlockTemplateKeys();
    }

    @Override
    @Nonnull
    public Collection<String> getMagicBlockTemplateKeys() {
        return this.magicBlockTemplates.keySet();
    }

    public com.elmakers.mine.bukkit.block.magic.MagicBlock getActiveAutomaton(long id) {
        return this.activeBlocks.get(id);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.block.magic.MagicBlock getMagicBlock(String name) {
        for (Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> chunk : this.magicBlocks.values()) {
            for (com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock : chunk.values()) {
                if (!magicBlock.getName().equals(name)) continue;
                return magicBlock;
            }
        }
        return null;
    }

    @Override
    public Collection<MagicBlock> getMagicBlocks() {
        ArrayList<MagicBlock> list = new ArrayList<MagicBlock>();
        for (Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> chunk : this.magicBlocks.values()) {
            list.addAll(chunk.values());
        }
        return list;
    }

    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getAutomataMages() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> all = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!mage.isAutomaton()) continue;
            all.add(mage);
        }
        return all;
    }

    public boolean isActive(@Nonnull com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        return this.activeBlocks.containsKey(magicBlock.getId());
    }

    @Nullable
    public com.elmakers.mine.bukkit.block.magic.MagicBlock getMagicBlockAt(@Nonnull Location location) {
        String chunkId = this.getChunkKey(location);
        if (chunkId == null) {
            return null;
        }
        Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> restoreChunk = this.magicBlocks.get(chunkId);
        if (restoreChunk == null) {
            return null;
        }
        long blockId = com.elmakers.mine.bukkit.block.BlockData.getBlockId(location);
        return restoreChunk.get(blockId);
    }

    public boolean checkMagicBlockBreak(Block block) {
        com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock = this.getMagicBlockAt(block.getLocation());
        if (magicBlock != null && magicBlock.removeWhenBroken()) {
            this.unregisterMagicBlock(magicBlock);
            return true;
        }
        return false;
    }

    @Nullable
    public MagicBlockTemplate getMagicBlockTemplate(String key) {
        return this.magicBlockTemplates.get(key);
    }

    private void loadEffects(ConfigurationSection effectsNode) {
        this.effects.clear();
        effectsNode = MagicConfiguration.getKeyed(this, effectsNode, "effects");
        Set effectKeys = effectsNode.getKeys(false);
        for (String effectKey : effectKeys) {
            this.logger.setContext("effects." + effectKey);
            this.effects.put(effectKey, this.loadEffects((ConfigurationSection)effectsNode, effectKey));
        }
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> loadEffects(ConfigurationSection configuration, String effectKey) {
        return this.loadEffects(configuration, effectKey, null);
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> loadEffects(ConfigurationSection configuration, String effectKey, String logContext) {
        return this.loadEffects(configuration, effectKey, null, null);
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> loadEffects(ConfigurationSection configuration, String effectKey, String logContext, ConfigurationSection parameterMap) {
        if (configuration.isString(effectKey)) {
            return this.getEffects(configuration.getString(effectKey));
        }
        return EffectPlayer.loadEffects((Plugin)this.getPlugin(), configuration, effectKey, this.getLogger(), logContext, parameterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLoading(CommandSender sender) {
        MagicLogger magicLogger = this.logger;
        synchronized (magicLogger) {
            EffectPlayer.debugEffects(this.debugEffectLib);
            if (sender != null) {
                int i;
                List<LogMessage> errors = this.logger.getErrors();
                List<LogMessage> warnings = this.logger.getWarnings();
                if (!warnings.isEmpty()) {
                    if (warnings.size() == 1) {
                        sender.sendMessage(ChatColor.YELLOW + "WARNING: " + ChatColor.WHITE + warnings.get(0).getMessage());
                    } else {
                        sender.sendMessage(ChatColor.YELLOW + "WARNINGS: " + ChatColor.WHITE + warnings.size());
                        for (i = 0; i < warnings.size() && i < 10; ++i) {
                            sender.sendMessage(ChatColor.WHITE + " " + warnings.get(i).getMessage());
                        }
                        if (warnings.size() > 10) {
                            sender.sendMessage(ChatColor.GRAY + "  ...");
                        }
                    }
                }
                if (!errors.isEmpty()) {
                    if (errors.size() == 1) {
                        sender.sendMessage(ChatColor.RED + "ERROR: " + ChatColor.WHITE + errors.get(0).getMessage());
                    } else {
                        sender.sendMessage(ChatColor.RED + "ERRORS: " + ChatColor.WHITE + errors.size());
                        for (i = 0; i < errors.size() && i < 10; ++i) {
                            sender.sendMessage(ChatColor.WHITE + " " + errors.get(i).getMessage());
                        }
                        if (errors.size() > 10) {
                            sender.sendMessage(ChatColor.GRAY + "  ...");
                        }
                    }
                }
                if (warnings.isEmpty() && errors.isEmpty()) {
                    sender.sendMessage(ChatColor.GREEN + "Finished loading, No issues found!");
                } else if (!errors.isEmpty()) {
                    sender.sendMessage(ChatColor.RED + "Finished loading " + ChatColor.DARK_RED + "with errors");
                } else {
                    sender.sendMessage(ChatColor.GOLD + "Finished loading " + ChatColor.YELLOW + "with warnings");
                }
            }
            this.logger.enableCapture(false);
            if (this.logWatchdogTimer != null) {
                this.logWatchdogTimer.cancel();
                this.logWatchdogTimer = null;
            }
        }
    }

    @Override
    public void loadConfigurationQuietly(CommandSender sender) {
        this.loadConfiguration(sender, false, false);
    }

    public void loadConfiguration() {
        this.loadConfiguration(null);
    }

    public void loadConfiguration(CommandSender sender) {
        if (sender != null && !this.loaded) {
            this.getLogger().warning("Can't reload configuration, Magic did not start up properly. Please restart your server.");
            return;
        }
        this.loadConfiguration(sender, false);
    }

    public void loadConfiguration(CommandSender sender, boolean forceSynchronous) {
        this.loadConfiguration(sender, forceSynchronous, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(CommandSender sender, boolean forceSynchronous, boolean verboseLogging) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (sender != null) {
            MagicLogger magicLogger = this.logger;
            synchronized (magicLogger) {
                EffectPlayer.debugEffects(true);
                this.logger.enableCapture(true);
                if (this.logWatchdogTimer != null) {
                    this.logWatchdogTimer.cancel();
                }
                this.logWatchdogTimer = this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)new LogWatchdogTask(this, sender), LOG_WATCHDOG_TIMEOUT / 50L);
                sender.sendMessage(ChatColor.DARK_AQUA + "Please wait while the configuration is reloaded and validated");
            }
        }
        this.reloadVerboseLogging = verboseLogging;
        this.loading = true;
        ConfigurationLoadTask loadTask = new ConfigurationLoadTask(this, sender);
        loadTask.setVerbose(verboseLogging);
        if (this.loaded && !forceSynchronous) {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)loadTask);
        } else {
            loadTask.runNow();
        }
    }

    @Override
    public void updateConfiguration(CommandSender sender) {
        this.updateExternalExamples(sender);
    }

    public void loadConfigurationExamples(CommandSender sender) {
        this.showExampleInstructions = true;
        this.loadConfiguration(sender, false, false);
    }

    protected void loadSpellData() {
        try {
            ConfigurationSection configNode = this.loadDataFile(SPELLS_DATA_FILE);
            if (configNode == null) {
                return;
            }
            Set keys = configNode.getKeys(false);
            for (String key : keys) {
                ConfigurationSection node = configNode.getConfigurationSection(key);
                SpellKey spellKey = new SpellKey(key);
                SpellData templateData = this.templateDataMap.get(spellKey.getBaseKey());
                if (templateData == null) {
                    templateData = new SpellData(spellKey.getBaseKey());
                    this.templateDataMap.put(templateData.getKey().getBaseKey(), templateData);
                }
                templateData.setCastCount(templateData.getCastCount() + node.getLong("cast_count", 0L));
                templateData.setLastCast(Math.max(templateData.getLastCast(), node.getLong("last_cast", 0L)));
            }
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to load spell metrics");
        }
    }

    public void load() {
        this.loadConfiguration();
        this.loadData();
    }

    protected void loadData() {
        this.loadSpellData();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new LoadDataTask(this), 2L);
    }

    public void finishLoadData() {
        ConfigurationSection arenas;
        if (!this.loaded) {
            this.getLogger().info("Magic did not load properly, skipping data load");
            return;
        }
        this.loadSpellData();
        this.loadLostWands();
        this.loadMagicBlocks();
        this.loadNPCs();
        try {
            this.maps.resetAll();
            this.maps.loadConfiguration();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ConfigurationSection warps = this.loadDataFile(WARPS_FILE);
        if (warps != null) {
            this.warpController.load(warps);
            this.info("Loaded " + this.warpController.getCustomWarps().size() + " warps");
        }
        if ((arenas = this.loadDataFile(ARENAS_FILE)) != null) {
            this.arenaController.loadArenas(arenas);
            this.info("Loaded arena data");
        }
        this.getLogger().info("Finished loading data.");
        this.dataLoaded = true;
    }

    public void migratePlayerData(CommandSender sender) {
        if (this.migrateDataTask == null) {
            if (this.migrateDataStore != null) {
                this.migrateDataTask = new MigrateDataTask(this, this.mageDataStore, this.migrateDataStore, sender);
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)this.migrateDataTask);
            } else {
                sender.sendMessage(ChatColor.RED + "You must first configure 'migrate_data_store' in config.yml");
            }
        } else {
            sender.sendMessage(ChatColor.YELLOW + "Data migration is already in progress");
        }
    }

    public void finishMigratingPlayerData() {
        this.migrateDataTask = null;
    }

    public void checkForMigration() {
        this.checkForMigration((CommandSender)this.plugin.getServer().getConsoleSender());
    }

    public void checkForMigration(CommandSender sender) {
        if (this.migrateDataStore != null) {
            Collection<String> ids = this.migrateDataStore.getAllIds();
            if (ids.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "Migration is complete, please remove migrate_data_store from config.yml");
            } else {
                sender.sendMessage(ChatColor.YELLOW + "Please use the command 'magic migrate' to migrate player data");
            }
        }
    }

    protected void loadLostWands() {
        try {
            ConfigurationSection lostWandConfiguration = this.loadDataFile(LOST_WANDS_FILE);
            if (lostWandConfiguration != null) {
                Set wandIds = lostWandConfiguration.getKeys(false);
                for (String wandId : wandIds) {
                    if (wandId == null || wandId.length() == 0) continue;
                    LostWand lostWand = new LostWand(wandId, lostWandConfiguration.getConfigurationSection(wandId));
                    if (!lostWand.isValid()) {
                        this.getLogger().info("Skipped invalid entry in lostwands.yml file, entry will be deleted. The wand is really lost now!");
                        continue;
                    }
                    this.addLostWand(lostWand);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.info("Loaded " + this.lostWands.size() + " lost wands");
    }

    public void checkNPCs(World world) {
        if (this.invalidNPCs.isEmpty()) {
            return;
        }
        List<ConfigurationSection> check = this.invalidNPCs;
        this.invalidNPCs = new ArrayList<ConfigurationSection>();
        int npcCount = this.loadNPCs(check);
        if (npcCount > 0) {
            this.info("Loaded " + npcCount + " NPCs in world " + world.getName());
            for (Chunk chunk : world.getLoadedChunks()) {
                this.restoreNPCs(chunk);
            }
        }
    }

    protected void loadNPCs() {
        List<ConfigurationSection> list;
        int npcCount;
        ConfigurationSection npcData = this.loadDataFile(NPC_DATA_FILE);
        if (npcData != null && (npcCount = this.loadNPCs(list = ConfigurationUtils.getNodeList(npcData, NPC_DATA_FILE))) > 0 && this.dataLoaded) {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    this.restoreNPCs(chunk);
                }
            }
            this.info("Loaded " + npcCount + " NPCs");
        }
    }

    protected int loadNPCs(Collection<ConfigurationSection> list) {
        int npcCount = 0;
        try {
            for (ConfigurationSection node : list) {
                MagicNPC npc = new MagicNPC(this, node);
                if (!npc.isValid()) {
                    this.invalidNPCs.add(node);
                    continue;
                }
                String chunkId = this.getChunkKey(npc.getLocation());
                if (chunkId == null) {
                    this.invalidNPCs.add(node);
                    continue;
                }
                List<MagicNPC> restoreChunk = this.npcsByChunk.get(chunkId);
                if (restoreChunk == null) {
                    restoreChunk = new ArrayList<MagicNPC>();
                    this.npcsByChunk.put(chunkId, restoreChunk);
                }
                ++npcCount;
                restoreChunk.add(npc);
                this.npcs.put(npc.getId(), npc);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Something went wrong loading NPC data", ex);
        }
        return npcCount;
    }

    public void checkMagicBlocks(World world) {
        if (this.invalidMagicBlocks.isEmpty()) {
            return;
        }
        List<ConfigurationSection> check = this.invalidMagicBlocks;
        this.invalidMagicBlocks = new ArrayList<ConfigurationSection>();
        int blockCount = this.loadMagicBlocks(check);
        if (blockCount > 0) {
            this.info("Loaded " + blockCount + " magic blocks in world " + world.getName());
        }
    }

    protected void loadMagicBlocks() {
        List<ConfigurationSection> list;
        int blockCount;
        ConfigurationSection toggleBlockData = this.loadDataFile(BLOCKS_DATA_FILE);
        if (toggleBlockData != null && (blockCount = this.loadMagicBlocks(list = ConfigurationUtils.getNodeList(toggleBlockData, "automata"))) > 0) {
            this.info("Loaded " + blockCount + " magic blocks");
        }
    }

    protected int loadMagicBlocks(Collection<ConfigurationSection> list) {
        int blockCount = 0;
        try {
            for (ConfigurationSection node : list) {
                long id;
                com.elmakers.mine.bukkit.block.magic.MagicBlock existing;
                com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock = new com.elmakers.mine.bukkit.block.magic.MagicBlock(this, node);
                if (magicBlock.isPendingWorldLoad()) {
                    this.invalidMagicBlocks.add(node);
                    continue;
                }
                String chunkId = this.getChunkKey(magicBlock.getLocation());
                if (chunkId == null) {
                    this.invalidMagicBlocks.add(node);
                    continue;
                }
                Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> restoreChunk = this.magicBlocks.get(chunkId);
                if (restoreChunk == null) {
                    restoreChunk = new HashMap<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock>();
                    this.magicBlocks.put(chunkId, restoreChunk);
                }
                if ((existing = restoreChunk.get(id = magicBlock.getId())) != null) {
                    this.getLogger().warning("Duplicate magic blocks exist at " + magicBlock.getLocation() + ", one will be removed!");
                    continue;
                }
                ++blockCount;
                restoreChunk.put(id, magicBlock);
                if (!magicBlock.shouldBeActive()) continue;
                this.activeBlocks.put(magicBlock.getId(), magicBlock);
                magicBlock.resume();
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Something went wrong loading magic block data", ex);
        }
        return blockCount;
    }

    protected void saveWarps(Collection<YamlDataFile> stores) {
        try {
            YamlDataFile warpData = this.createDataFile(WARPS_FILE);
            this.warpController.save((ConfigurationSection)warpData);
            stores.add(warpData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void saveArenas(Collection<YamlDataFile> stores) {
        try {
            YamlDataFile arenaData = this.createDataFile(ARENAS_FILE);
            this.arenaController.saveData((ConfigurationSection)arenaData);
            stores.add(arenaData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void saveAutomata(Collection<YamlDataFile> stores) {
        try {
            YamlDataFile automataData = this.createDataFile(BLOCKS_DATA_FILE);
            ArrayList<ConfigurationSection> nodes = new ArrayList<ConfigurationSection>();
            for (Map.Entry<String, Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock>> toggleEntry : this.magicBlocks.entrySet()) {
                Collection<com.elmakers.mine.bukkit.block.magic.MagicBlock> blocks = toggleEntry.getValue().values();
                if (blocks.size() <= 0) continue;
                for (com.elmakers.mine.bukkit.block.magic.MagicBlock block : blocks) {
                    ConfigurationSection node = ConfigurationUtils.newConfigurationSection();
                    block.save(node);
                    nodes.add(node);
                }
            }
            nodes.addAll(this.invalidMagicBlocks);
            automataData.set("automata", nodes);
            stores.add(automataData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void saveNPCs(Collection<YamlDataFile> stores) {
        try {
            YamlDataFile npcData = this.createDataFile(NPC_DATA_FILE);
            ArrayList<ConfigurationSection> nodes = new ArrayList<ConfigurationSection>();
            for (MagicNPC npc : this.npcs.values()) {
                ConfigurationSection node = ConfigurationUtils.newConfigurationSection();
                npc.save(node);
                nodes.add(node);
            }
            nodes.addAll(this.invalidNPCs);
            npcData.set(NPC_DATA_FILE, nodes);
            stores.add(npcData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void moveMagicBlock(com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock, Location location) {
        this.unregisterMagicBlock(magicBlock);
        magicBlock.setLocation(location);
        this.registerMagicBlock(magicBlock);
    }

    public void registerMagicBlock(com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        String chunkId = this.getChunkKey(magicBlock.getLocation());
        if (chunkId == null) {
            return;
        }
        Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> chunkAutomata = this.magicBlocks.get(chunkId);
        if (chunkAutomata == null) {
            chunkAutomata = new HashMap<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock>();
            this.magicBlocks.put(chunkId, chunkAutomata);
        }
        long id = magicBlock.getId();
        chunkAutomata.put(id, magicBlock);
        if (magicBlock.shouldBeActive()) {
            this.activeBlocks.put(id, magicBlock);
            magicBlock.resume();
        }
    }

    public boolean unregisterMagicBlock(com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock) {
        boolean removed = false;
        String chunkId = this.getChunkKey(magicBlock.getLocation());
        long id = magicBlock.getId();
        Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> chunkAutomata = this.magicBlocks.get(chunkId);
        if (chunkAutomata != null) {
            boolean bl = removed = chunkAutomata.remove(id) != null;
            if (chunkAutomata.size() == 0) {
                this.magicBlocks.remove(chunkId);
            }
        }
        if (this.activeBlocks.remove(id) != null) {
            magicBlock.pause();
        }
        magicBlock.removed();
        return removed;
    }

    public void resumeMagicBlocks(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> chunkData = this.magicBlocks.get(chunkKey);
        if (chunkData != null) {
            this.activeBlocks.putAll(chunkData);
            for (com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock : chunkData.values()) {
                if (magicBlock.isAlwaysActive()) continue;
                magicBlock.resume();
            }
        }
    }

    public void pauseMagicBlocks(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, com.elmakers.mine.bukkit.block.magic.MagicBlock> chunkData = this.magicBlocks.get(chunkKey);
        if (chunkData != null) {
            for (com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock : chunkData.values()) {
                if (magicBlock.isAlwaysActive()) continue;
                magicBlock.pause();
                this.activeBlocks.remove(magicBlock.getId());
            }
        }
    }

    public void tickMagicBlocks() {
        for (com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock : this.activeBlocks.values()) {
            magicBlock.tick();
        }
    }

    @Override
    @Nullable
    @Deprecated
    public com.elmakers.mine.bukkit.block.magic.MagicBlock addAutomaton(@Nonnull Location location, @Nonnull String templateKey, String creatorId, String creatorName, @Nullable ConfigurationSection parameters) {
        return this.addMagicBlock(location, templateKey, creatorId, creatorName, parameters);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.block.magic.MagicBlock addMagicBlock(@Nonnull Location location, @Nonnull String templateKey, String creatorId, String creatorName, @Nullable ConfigurationSection parameters) {
        if (!this.isMagicBlockTemplate(templateKey)) {
            return null;
        }
        com.elmakers.mine.bukkit.block.magic.MagicBlock existing = this.getMagicBlockAt(location);
        if (existing != null) {
            return null;
        }
        com.elmakers.mine.bukkit.block.magic.MagicBlock magicBlock = new com.elmakers.mine.bukkit.block.magic.MagicBlock(this, location, templateKey, creatorId, creatorName, parameters);
        this.registerMagicBlock(magicBlock);
        return magicBlock;
    }

    protected void saveSpellData(Collection<YamlDataFile> stores) {
        String lastKey = "";
        try {
            YamlDataFile spellsDataFile = this.createDataFile(SPELLS_DATA_FILE, false);
            for (SpellData data : this.templateDataMap.values()) {
                lastKey = data.getKey().getBaseKey();
                ConfigurationSection spellNode = spellsDataFile.createSection(lastKey);
                if (spellNode == null) {
                    this.getLogger().warning("Error saving spell data for " + lastKey);
                    continue;
                }
                spellNode.set("cast_count", (Object)data.getCastCount());
                spellNode.set("last_cast", (Object)data.getLastCast());
            }
            stores.add(spellsDataFile);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving spell data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void saveLostWands(Collection<YamlDataFile> stores) {
        String lastKey = "";
        try {
            YamlDataFile lostWandsConfiguration = this.createDataFile(LOST_WANDS_FILE, false);
            for (Map.Entry<String, LostWand> wandEntry : this.lostWands.entrySet()) {
                lastKey = wandEntry.getKey();
                if (lastKey == null || lastKey.length() == 0) continue;
                ConfigurationSection wandNode = lostWandsConfiguration.createSection(lastKey);
                if (wandNode == null) {
                    this.getLogger().warning("Error saving lost wand data for " + lastKey);
                    continue;
                }
                if (!wandEntry.getValue().isValid()) {
                    this.getLogger().warning("Invalid lost and data for " + lastKey);
                    continue;
                }
                wandEntry.getValue().save(wandNode);
            }
            stores.add(lostWandsConfiguration);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving lost wand data for " + lastKey);
            ex.printStackTrace();
        }
    }

    @Nullable
    protected String getChunkKey(Block block) {
        return this.getChunkKey(block.getLocation());
    }

    @Nullable
    protected String getChunkKey(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        return world.getName() + "|" + (location.getBlockX() >> 4) + "," + (location.getBlockZ() >> 4);
    }

    protected String getChunkKey(Chunk chunk) {
        return chunk.getWorld().getName() + "|" + chunk.getX() + "," + chunk.getZ();
    }

    public boolean addLostWand(LostWand lostWand) {
        this.lostWands.put(lostWand.getId(), lostWand);
        try {
            String chunkKey = this.getChunkKey(lostWand.getLocation());
            if (chunkKey == null) {
                return false;
            }
            Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
            if (chunkWands == null) {
                chunkWands = new HashSet<String>();
                this.lostWandChunks.put(chunkKey, chunkWands);
            }
            chunkWands.add(lostWand.getId());
            if (this.dynmapShowWands) {
                this.addLostWandMarker(lostWand);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Error loading lost wand id " + lostWand.getId() + " - is it in an unloaded world?", ex);
        }
        return true;
    }

    public boolean addLostWand(Wand wand, Location dropLocation) {
        this.addLostWand(wand.makeLost(dropLocation));
        return true;
    }

    public boolean removeLostWand(String wandId) {
        if (wandId == null || wandId.length() == 0 || !this.lostWands.containsKey(wandId)) {
            return false;
        }
        LostWand lostWand = this.lostWands.get(wandId);
        this.lostWands.remove(wandId);
        String chunkKey = this.getChunkKey(lostWand.getLocation());
        if (chunkKey == null) {
            return false;
        }
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands != null) {
            chunkWands.remove(wandId);
            if (chunkWands.size() == 0) {
                this.lostWandChunks.remove(chunkKey);
            }
        }
        if (this.dynmapShowWands && this.removeMarker("wand-" + wandId, "wands")) {
            this.info("Wand removed from map");
        }
        return true;
    }

    public WandMode getDefaultWandMode() {
        return this.defaultWandMode;
    }

    public WandMode getDefaultBrushMode() {
        return this.defaultBrushMode;
    }

    public String getDefaultWandPath() {
        return this.defaultWandPath;
    }

    protected void saveMageData(Collection<MageData> stores) {
        try {
            for (Map.Entry<String, Mage> mageEntry : this.mages.entrySet()) {
                com.elmakers.mine.bukkit.api.magic.Mage mage = mageEntry.getValue();
                if (!mage.isPlayer() && !this.saveNonPlayerMages) continue;
                if (!mage.isLoading()) {
                    MageData mageData = new MageData(mage.getId());
                    if (!mage.save(mageData)) continue;
                    stores.add(mageData);
                    continue;
                }
                this.getLogger().info("Skipping save of mage, already loading: " + mage.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean asynchronous) {
        if (!this.loaded || !this.dataLoaded) {
            return;
        }
        this.maps.save(asynchronous);
        ArrayList<YamlDataFile> saveData = new ArrayList<YamlDataFile>();
        ArrayList<MageData> saveMages = new ArrayList<MageData>();
        if (this.savePlayerData && this.mageDataStore != null && !this.shuttingDown) {
            this.saveMageData(saveMages);
            this.info("Saving " + saveMages.size() + " players");
        }
        this.saveSpellData(saveData);
        this.saveLostWands(saveData);
        this.saveAutomata(saveData);
        this.saveWarps(saveData);
        this.saveNPCs(saveData);
        this.saveArenas(saveData);
        if (this.mageDataStore != null && !this.shuttingDown) {
            if (asynchronous) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new SaveMageDataTask(this, saveMages));
            } else {
                this.persistMageData(saveMages);
            }
        }
        if (asynchronous) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new SaveDataTask(this, saveData));
        } else {
            this.saveData(saveData);
        }
        SaveEvent saveEvent = new SaveEvent(asynchronous);
        Bukkit.getPluginManager().callEvent((Event)saveEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveData(Collection<YamlDataFile> saveData) {
        Object object = this.saveLock;
        synchronized (object) {
            for (YamlDataFile config : saveData) {
                config.save();
            }
            this.info("Finished saving");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistMageData(Collection<MageData> saveMages) {
        Object object = this.saveLock;
        synchronized (object) {
            for (MageData mageData : saveMages) {
                this.mageDataStore.save(mageData, null, false);
            }
        }
    }

    public void addSpell(Spell variant) {
        SpellTemplate conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.getLogger().log(Level.WARNING, "Duplicate spell key: '" + conflict.getKey() + "'");
        } else {
            String alias;
            SpellData data;
            Integer currentMax;
            SpellKey spellKey = variant.getSpellKey();
            this.spells.put(spellKey.getKey(), variant);
            if (spellKey.getLevel() > 1 && ((currentMax = this.maxSpellLevels.get(spellKey.getBaseKey())) == null || spellKey.getLevel() > currentMax)) {
                this.maxSpellLevels.put(spellKey.getBaseKey(), spellKey.getLevel());
            }
            if ((data = this.templateDataMap.get(variant.getSpellKey().getBaseKey())) == null) {
                data = new SpellData(variant.getSpellKey().getBaseKey());
                this.templateDataMap.put(variant.getSpellKey().getBaseKey(), data);
            }
            if (variant instanceof MageSpell) {
                ((MageSpell)variant).setSpellData(data);
            }
            if ((alias = variant.getAlias()) != null && alias.length() > 0) {
                this.spellAliases.put(alias, variant);
            }
        }
    }

    @Override
    @Nullable
    public String getReflectiveMaterials(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getReflective(mage.getPlayer(), location);
    }

    @Override
    @Nullable
    public String getDestructibleMaterials(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getDestructible(mage.getPlayer(), location);
    }

    @Override
    @Deprecated
    public Set<Material> getDestructibleMaterials() {
        return MaterialSets.toLegacyNN(this.destructibleMaterials);
    }

    @Override
    @Nullable
    public Set<String> getSpellOverrides(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getSpellOverrides(mage.getPlayer(), location);
    }

    public boolean isOffhandMaterial(ItemStack itemStack) {
        return !CompatibilityLib.getItemUtils().isEmpty(itemStack) && this.offhandMaterials.testItem(itemStack);
    }

    public boolean hasAddedExamples() {
        return this.addExamples != null && this.addExamples.size() > 0;
    }

    @Nullable
    private MageDataStore loadMageDataStore(ConfigurationSection configuration) {
        MageDataStore mageDataStore = null;
        String dataStoreClassName = configuration.getString("class");
        if (!dataStoreClassName.contains(".")) {
            dataStoreClassName = "com.elmakers.mine.bukkit.data." + dataStoreClassName + "MageDataStore";
        }
        try {
            Class<?> dataStoreClass = Class.forName(dataStoreClassName);
            Object dataStore = dataStoreClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (dataStore == null || !(dataStore instanceof MageDataStore)) {
                this.getLogger().log(Level.WARNING, "Invalid player_data_store class " + dataStoreClassName + ", does it implement MageDataStore? Player data saving is disabled!");
            } else {
                mageDataStore = (MageDataStore)dataStore;
                mageDataStore.initialize(this, configuration);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Failed to create player_data_store class from " + dataStoreClassName, ex);
            mageDataStore = null;
        }
        return mageDataStore;
    }

    protected void loadMobEggs(ConfigurationSection skins) {
        this.mobEggs.clear();
        Set keys = skins.getKeys(false);
        for (String key : keys) {
            try {
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                Material material = this.getVersionedMaterial(skins, key);
                if (material == null) continue;
                this.mobEggs.put(entityType, material);
            }
            catch (Exception exception) {}
        }
    }

    protected void loadMobSkins(ConfigurationSection skins) {
        this.mobSkins.clear();
        Set keys = skins.getKeys(false);
        for (String key : keys) {
            try {
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                this.mobSkins.put(entityType, skins.getString(key));
            }
            catch (Exception exception) {}
        }
    }

    protected void loadBlockSkins(ConfigurationSection skins) {
        this.blockSkins.clear();
        Set keys = skins.getKeys(false);
        for (String key : keys) {
            try {
                Material material = Material.getMaterial((String)key.toUpperCase());
                this.blockSkins.put(material, skins.getString(key));
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    protected Material getVersionedMaterial(ConfigurationSection configuration, String key) {
        Material material = null;
        List<String> candidates = ConfigurationUtils.getStringList(configuration, key);
        for (String candidate : candidates) {
            try {
                material = Material.valueOf((String)candidate.toUpperCase());
                break;
            }
            catch (Exception exception) {
            }
        }
        return material;
    }

    @Nullable
    protected MaterialAndData getVersionedMaterialAndData(ConfigurationSection configuration, String key) {
        List<String> candidates = ConfigurationUtils.getStringList(configuration, key);
        for (String candidate : candidates) {
            MaterialAndData test = new MaterialAndData(candidate);
            if (!test.isValid()) continue;
            return test;
        }
        return null;
    }

    protected void loadOtherMaterials(ConfigurationSection configuration) {
        DefaultMaterials defaultMaterials = DefaultMaterials.getInstance();
        defaultMaterials.setGroundSignBlock(this.getVersionedMaterial(configuration, "ground_sign_block"));
        defaultMaterials.setWallSignBlock(this.getVersionedMaterial(configuration, "wall_sign_block"));
        defaultMaterials.setFirework(this.getVersionedMaterial(configuration, "firework"));
        defaultMaterials.setFireworkStar(this.getVersionedMaterial(configuration, "firework_star"));
        defaultMaterials.setWallTorch(this.getVersionedMaterialAndData(configuration, "wall_torch"));
        defaultMaterials.setRedstoneTorchOn(this.getVersionedMaterialAndData(configuration, "redstone_torch_on"));
        defaultMaterials.setRedstoneTorchOff(this.getVersionedMaterialAndData(configuration, "redstone_torch_off"));
        defaultMaterials.setRedstoneWallTorchOn(this.getVersionedMaterialAndData(configuration, "redstone_wall_torch_on"));
        defaultMaterials.setRedstoneWallTorchOff(this.getVersionedMaterialAndData(configuration, "redstone_wall_torch_off"));
        defaultMaterials.setMobSpawner(this.getVersionedMaterial(configuration, "mob_spawner"));
        defaultMaterials.setNetherPortal(this.getVersionedMaterial(configuration, "nether_portal"));
        defaultMaterials.setWriteableBook(this.getVersionedMaterial(configuration, "writable_book"));
        defaultMaterials.setFilledMap(this.getVersionedMaterial(configuration, "filled_map"));
    }

    protected void loadSkulls(ConfigurationSection skulls) {
        this.skullItems.clear();
        this.skullGroundBlocks.clear();
        this.skullWallBlocks.clear();
        Set keys = skulls.getKeys(false);
        for (String key : keys) {
            try {
                ConfigurationSection types = skulls.getConfigurationSection(key);
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                MaterialAndData item = this.parseSkullCandidate(types, "item");
                if (item != null) {
                    this.skullItems.put(entityType, item);
                }
                MaterialAndData floor = this.parseSkullCandidate(types, "ground");
                if (item != null) {
                    this.skullGroundBlocks.put(entityType, floor);
                }
                MaterialAndData wall = this.parseSkullCandidate(types, "wall");
                if (item == null) continue;
                this.skullWallBlocks.put(entityType, wall);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    protected MaterialAndData parseSkullCandidate(ConfigurationSection section, String key) {
        List<String> candidates = ConfigurationUtils.getStringList(section, key);
        for (String candidate : candidates) {
            MaterialAndData test = new MaterialAndData(candidate.trim());
            if (!test.isValid()) continue;
            return test;
        }
        return null;
    }

    protected void populateEntityTypes(Set<EntityType> entityTypes, ConfigurationSection configuration, String key) {
        entityTypes.clear();
        if (configuration.contains(key)) {
            List<String> typeStrings = ConfigurationUtils.getStringList(configuration, key);
            for (String typeString : typeStrings) {
                try {
                    entityTypes.add(EntityType.valueOf((String)typeString.toUpperCase()));
                }
                catch (Exception ex) {
                    this.getLogger().warning("Unknown entity type: " + typeString + " in " + key);
                }
            }
        }
    }

    public void addCurrency(Currency currency) {
        this.currencies.put(currency.getKey(), currency);
    }

    protected void clearHandlers() {
        this.externalProviders.clear();
        this.currencies.clear();
        this.attributeProviders.clear();
        this.teamProviders.clear();
        this.requirementProcessors.clear();
        this.blockBreakManagers.clear();
        this.blockBuildManagers.clear();
        this.pvpManagers.clear();
        this.castManagers.clear();
        this.playerWarpManagers.clear();
        this.targetingProviders.clear();
        this.registeredAttributes.clear();
    }

    protected void registerHandlers(ConfigurationSection configuration) {
        ConfigurationSection legacyItemCurrency;
        ConfigurationSection currencyConfiguration = configuration.getConfigurationSection("builtin_currency");
        ConfigurationSection spSection = currencyConfiguration.getConfigurationSection("sp");
        ConfigurationSection xpSection = currencyConfiguration.getConfigurationSection("xp");
        String skillPointIcon = configuration.getString("sp_item_icon_url");
        if (skillPointIcon != null) {
            this.getLogger().warning("The config option sp_item_icon_url is deprecated, see builtin_currencies section");
            spSection.set("icon", (Object)("skull:" + skillPointIcon));
        }
        if (configuration.contains("sp_max")) {
            this.getLogger().warning("The config option sp_max is deprecated, see builtin_currencies section");
            spSection.set("max", (Object)configuration.getInt("sp_max"));
        }
        if (configuration.contains("worth_sp")) {
            this.getLogger().warning("The config option worth_sp is deprecated, see builtin_currencies section");
            spSection.set("worth", (Object)configuration.getInt("worth_sp"));
        }
        if (configuration.contains("sp_default")) {
            this.getLogger().warning("The config option sp_default is deprecated, see builtin_currencies section");
            spSection.set("default", (Object)configuration.getInt("sp_default"));
        }
        if (configuration.contains("worth_xp")) {
            this.getLogger().warning("The config option worth_xp is deprecated, see builtin_currencies section");
            xpSection.set("worth", (Object)configuration.getDouble("worth_xp"));
        }
        if ((legacyItemCurrency = configuration.getConfigurationSection("currency")) != null) {
            ConfigurationSection itemConfiguration = currencyConfiguration.getConfigurationSection("item");
            this.getLogger().warning("The config section currency is deprecated, see builtin_currencies.item section");
            Set worthItemKeys = legacyItemCurrency.getKeys(false);
            for (String worthItemKey : worthItemKeys) {
                ConfigurationSection currencyConfig = legacyItemCurrency.getConfigurationSection(worthItemKey);
                if (!currencyConfig.getBoolean("enabled", true)) continue;
                itemConfiguration.set("item", (Object)worthItemKey);
                itemConfiguration.set("worth", (Object)currencyConfig.getDouble("worth"));
                if (worthItemKey.equals("emerald")) continue;
                break;
            }
        }
        this.addCurrency(new ItemCurrency(this, currencyConfiguration.getConfigurationSection("item")));
        this.addCurrency(new ManaCurrency(this, currencyConfiguration.getConfigurationSection("mana")));
        this.addCurrency(new ExperienceCurrency(this, xpSection));
        this.addCurrency(new HealthCurrency(this, currencyConfiguration.getConfigurationSection("health")));
        this.addCurrency(new HungerCurrency(this, currencyConfiguration.getConfigurationSection("hunger")));
        this.addCurrency(new LevelCurrency(this, currencyConfiguration.getConfigurationSection("levels")));
        this.addCurrency(new SpellPointCurrency(this, spSection));
    }

    protected void registerPreLoad(ConfigurationSection configuration) {
        PreLoadEvent loadEvent = new PreLoadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)loadEvent);
        this.blockBreakManagers.addAll(loadEvent.getBlockBreakManagers());
        this.blockBuildManagers.addAll(loadEvent.getBlockBuildManagers());
        this.pvpManagers.addAll(loadEvent.getPVPManagers());
        this.teamProviders.addAll(loadEvent.getTeamProviders());
        this.castManagers.addAll(loadEvent.getCastManagers());
        this.targetingProviders.addAll(loadEvent.getTargetingManagers());
        this.teamProviders.addAll(loadEvent.getTeamProviders());
        this.playerWarpManagers.putAll(loadEvent.getWarpManagers());
        ConfigurationSection currencyConfiguration = configuration.getConfigurationSection("builtin_currency");
        this.addCurrency(new VaultCurrency(this, currencyConfiguration.getConfigurationSection("currency")));
        for (Currency currency : loadEvent.getCurrencies()) {
            this.addCurrency(currency);
        }
        if (this.aureliumSkillsManager != null) {
            this.aureliumSkillsManager.register(currencyConfiguration);
        }
        if (this.tokenManager != null) {
            this.tokenManager.register(currencyConfiguration);
        }
        currencyConfiguration = configuration.getConfigurationSection("custom_currency");
        Set keys = currencyConfiguration.getKeys(false);
        for (String string : keys) {
            this.addCurrency(new CustomCurrency(this, string, currencyConfiguration.getConfigurationSection(string)));
        }
        this.log("Registered currencies: " + StringUtils.join(this.currencies.keySet(), (String)","));
        for (AttributeProvider attributeProvider : loadEvent.getAttributeProviders()) {
            this.externalProviders.add(attributeProvider);
        }
        for (MagicProvider magicProvider : this.externalProviders) {
            this.registerAndUpdate(magicProvider);
        }
        this.checkMagicRequirements();
    }

    private void registerPlayerAttributes(Collection<String> attributes) {
        this.registeredAttributes.addAll(attributes);
        for (String attribute : attributes) {
            this.registeredAttributes.add("target_" + attribute);
        }
    }

    private void finalizeAttributes() {
        this.registeredAttributes.addAll(this.builtinMageAttributes);
        this.registeredAttributes.addAll(this.builtinAttributes);
        this.registeredAttributes.addAll(this.builtinTargetAttributes);
        this.registerPlayerAttributes(this.attributes.keySet());
        for (AttributeProvider provider : this.attributeProviders) {
            Set<String> providerAttributes = provider.getAllAttributes();
            if (providerAttributes == null) continue;
            this.registerPlayerAttributes(providerAttributes);
        }
        MageParameters.initializeAttributes(this.registeredAttributes);
        MageParameters.setLogger(this.getLogger());
        this.log("Registered attributes: " + this.registeredAttributes);
    }

    private void checkMagicRequirements() {
        if (this.requirementProcessors.containsKey("magic")) {
            this.getLogger().warning("Something tried to register requirements for the magic type, but that is Magic's job.");
        }
        this.requirementProcessors.put("magic", this.requirementsController);
    }

    private void registerAttributes(AttributeProvider attributes) {
        this.registerAttributes(attributes, true);
    }

    private void registerAttributes(AttributeProvider attributes, boolean update) {
        Set<String> providerAttributes;
        this.attributeProviders.add(attributes);
        if (update && (providerAttributes = attributes.getAllAttributes()) != null) {
            this.registerPlayerAttributes(providerAttributes);
            MageParameters.initializeAttributes(this.registeredAttributes);
            this.log("Registered additional attributes: " + providerAttributes);
        }
    }

    private boolean registerAndUpdate(MagicProvider provider) {
        return this.register(provider, true);
    }

    @Override
    public boolean register(MagicProvider provider) {
        return this.register(provider, !this.loading);
    }

    private boolean register(MagicProvider provider, boolean update) {
        boolean added = false;
        if (provider instanceof EntityTargetingManager) {
            added = true;
            this.targetingProviders.add((EntityTargetingManager)provider);
        }
        if (provider instanceof AttributeProvider) {
            added = true;
            this.registerAttributes((AttributeProvider)provider, update);
        }
        if (provider instanceof TeamProvider) {
            added = true;
            this.teamProviders.add((TeamProvider)provider);
        }
        if (provider instanceof Currency) {
            added = true;
            this.addCurrency((Currency)provider);
        }
        if (provider instanceof RequirementsProvider) {
            added = true;
            RequirementsProvider requirements = (RequirementsProvider)provider;
            this.requirementProcessors.put(requirements.getKey(), requirements);
            if (!this.loading) {
                this.checkMagicRequirements();
            }
        }
        if (provider instanceof PlayerWarpProvider) {
            added = true;
            PlayerWarpProvider warp = (PlayerWarpProvider)provider;
            this.playerWarpManagers.put(warp.getKey(), warp);
        }
        if (provider instanceof BlockBreakManager) {
            added = true;
            this.blockBreakManagers.add((BlockBreakManager)provider);
        }
        if (provider instanceof PVPManager) {
            added = true;
            this.pvpManagers.add((PVPManager)provider);
        }
        if (provider instanceof BlockBuildManager) {
            added = true;
            this.blockBuildManagers.add((BlockBuildManager)provider);
        }
        if (provider instanceof CastPermissionManager) {
            added = true;
            this.castManagers.add((CastPermissionManager)provider);
        }
        if (added && !this.loading) {
            this.externalProviders.add(provider);
        }
        return added;
    }

    protected void clear() {
        if (!this.loaded) {
            return;
        }
        ArrayList<Mage> saveMages = new ArrayList<Mage>(this.mages.values());
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : saveMages) {
            this.playerQuit(mage);
        }
        this.mages.clear();
        this.pendingConstruction.clear();
        this.spells.clear();
        this.loaded = false;
    }

    protected void unregisterPhysicsHandler(Listener listener) {
        BlockPhysicsEvent.getHandlerList().unregister(listener);
        this.physicsHandler = null;
    }

    @Override
    public void scheduleUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        undoList.setHasBeenScheduled();
        this.scheduledUndo.add(undoList);
    }

    @Override
    public void cancelScheduledUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        this.scheduledUndo.remove(undoList);
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "magic.wand.use");
    }

    public boolean hasWandPermission(Player player, Wand wand) {
        String pNode;
        if (this.hasBypassPermission((CommandSender)player)) {
            return true;
        }
        if (wand.isSuperPowered() && !player.hasPermission("magic.wand.use.powered")) {
            return false;
        }
        if (wand.isSuperProtected() && !player.hasPermission("magic.wand.use.protected")) {
            return false;
        }
        String template = wand.getTemplateKey();
        if (template != null && !template.isEmpty() && !this.hasPermission(player, pNode = "magic.use." + template)) {
            return false;
        }
        Location location = player.getLocation();
        Boolean override = this.worldGuardManager.getWandPermission(player, wand, location);
        return override == null || override != false;
    }

    @Override
    public boolean hasCastPermission(CommandSender sender, SpellTemplate spell) {
        if (sender == null) {
            return true;
        }
        if (this.hasBypassPermission(sender)) {
            return true;
        }
        String categoryPermission = spell.getCategoryPermissionNode();
        if (categoryPermission != null && !this.hasPermission(sender, categoryPermission)) {
            return false;
        }
        return this.hasPermission(sender, spell.getPermissionNode());
    }

    @Override
    @Nullable
    public Boolean getRegionCastPermission(Player player, SpellTemplate spell, Location location) {
        if (this.hasBypassPermission((CommandSender)player)) {
            return true;
        }
        Boolean result = null;
        for (CastPermissionManager manager : this.castManagers) {
            Boolean managerResult = manager.getRegionCastPermission(player, spell, location);
            if (managerResult == null) continue;
            if (!managerResult.booleanValue()) {
                return false;
            }
            if (result != null) continue;
            result = managerResult;
        }
        return result;
    }

    @Override
    @Nullable
    public Boolean getPersonalCastPermission(Player player, SpellTemplate spell, Location location) {
        if (this.hasBypassPermission((CommandSender)player)) {
            return true;
        }
        Boolean result = null;
        for (CastPermissionManager manager : this.castManagers) {
            Boolean managerResult = manager.getPersonalCastPermission(player, spell, location);
            if (managerResult == null) continue;
            if (!managerResult.booleanValue()) {
                return false;
            }
            if (result != null) continue;
            result = managerResult;
        }
        return result;
    }

    @Override
    public boolean hasBypassPermission(CommandSender sender) {
        if (sender == null) {
            return false;
        }
        if (sender instanceof Player && sender.hasPermission("magic.bypass")) {
            return true;
        }
        Mage mage = this.getRegisteredMage(sender);
        if (mage == null) {
            return false;
        }
        return mage.isBypassEnabled();
    }

    @Override
    public boolean inTaggedRegion(Location location, Set<String> tags) {
        Boolean inRegion = this.worldGuardManager.inTaggedRegion(location, tags);
        return inRegion != null && inRegion != false;
    }

    public String getPortalSpell(Location location, Entity entity) {
        Player player = entity instanceof Player ? (Player)entity : null;
        return this.worldGuardManager.getPortalSpell(player, location);
    }

    public String getPortalWarp(Location location, Entity entity) {
        Player player = entity instanceof Player ? (Player)entity : null;
        return this.worldGuardManager.getPortalWarp(player, location);
    }

    public boolean hasPermission(Player player, String pNode) {
        if (player == null) {
            return true;
        }
        boolean hasPermission = player.hasPermission(pNode);
        if (player.isPermissionSet(pNode)) {
            return hasPermission;
        }
        boolean hasWildcard = false;
        if (pNode.contains(".")) {
            String parentNode = pNode.substring(0, pNode.lastIndexOf(46) + 1) + "*";
            hasWildcard = player.hasPermission(parentNode);
        }
        return hasPermission || hasWildcard;
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode);
    }

    @Override
    @Deprecated
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultValue) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode);
    }

    @Override
    public boolean hasPermission(Entity entity, String pNode) {
        EntityData entityData = this.getMob(entity);
        if (entityData != null && entityData.hasPermission(pNode)) {
            return true;
        }
        if (entity instanceof Player) {
            return this.hasPermission((CommandSender)entity, pNode);
        }
        return false;
    }

    public void registerFallingBlock(Entity fallingBlock, Block block) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(fallingBlock.getLocation());
        if (undoList != null) {
            undoList.fall(fallingBlock, block);
        }
    }

    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList getEntityUndo(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        Projectile projectile;
        ProjectileSource source;
        if (entity == null) {
            return null;
        }
        com.elmakers.mine.bukkit.api.block.UndoList blockList = UndoList.getUndoList(entity);
        if (blockList != null) {
            return blockList;
        }
        if (entity instanceof Projectile && (source = (projectile = (Projectile)entity).getShooter()) instanceof Entity && (blockList = UndoList.getUndoList(entity = (Entity)source)) != null) {
            return blockList;
        }
        Mage mage = this.getRegisteredMage(entity);
        if (mage != null && (undoList = mage.getLastUndoList()) != null) {
            long now = System.currentTimeMillis();
            if (undoList.getModifiedTime() > now - 6000L) {
                blockList = undoList;
            }
        }
        return blockList;
    }

    public boolean isBindOnGive() {
        return this.bindOnGive;
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        Mage mage = this.getMage(player);
        mage.giveItem(itemStack);
    }

    @Override
    public boolean commitOnQuit() {
        return this.commitOnQuit;
    }

    public void onShutdown() {
        this.shuttingDown = true;
        if (this.despawnMagicMobs) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mobMage : this.getMobMages()) {
                Entity entity = mobMage.getEntity();
                if (entity == null) continue;
                entity.remove();
            }
        }
        if (this.mageDataStore != null) {
            this.mageDataStore.close();
        }
        if (this.migrateDataStore != null) {
            this.migrateDataStore.close();
        }
        this.arenaController.cancel();
    }

    public void undoScheduled() {
        int undid = 0;
        while (!this.scheduledUndo.isEmpty()) {
            com.elmakers.mine.bukkit.api.block.UndoList undoList = this.scheduledUndo.poll();
            undoList.undoScheduled(true);
        }
        if (undid > 0) {
            this.info("Undid " + undid + " pending spells");
        }
    }

    protected void mageQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, MageDataCallback callback) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        boolean isOpen = wand != null && wand.isInventoryOpen();
        Mage implementation = null;
        if (mage instanceof Mage) {
            implementation = (Mage)mage;
            implementation.flagForReactivation();
        }
        mage.deactivate();
        mage.undoScheduled();
        mage.deactivateClasses();
        mage.deactivateModifiers();
        if (this.loaded && implementation != null && !this.shuttingDown) {
            Mage quitMage = implementation;
            quitMage.setUnloading(true);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new MageQuitTask(this, quitMage, callback, isOpen), 1L);
        } else {
            this.finalizeMageQuit(mage, callback, isOpen);
        }
    }

    public void finalizeMageQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, MageDataCallback callback, boolean isOpen) {
        if (!this.externalPlayerData || !mage.isPlayer()) {
            this.removeMage(mage);
        }
        if (!mage.isLoading() && (mage.isPlayer() || this.saveNonPlayerMages) && this.loaded) {
            this.saveMage(mage, !this.shuttingDown, callback, isOpen, true);
        } else if (callback != null) {
            callback.run(null);
        }
    }

    protected void playerQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, MageDataCallback callback) {
        this.maps.resend(mage.getName());
        this.mageQuit(mage, callback);
    }

    public void playerQuit(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.playerQuit(mage, null);
    }

    @Override
    public void forgetMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage instanceof Mage) {
            ((Mage)mage).setForget(true);
        }
    }

    @Override
    public void removeMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.removeMage(mage.getId());
    }

    @Override
    public void removeMage(String id) {
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.mages.remove(id);
        if (mage != null) {
            mage.removed();
        }
    }

    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous) {
        this.saveMage(mage, asynchronous, null);
    }

    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous, MageDataCallback callback) {
        this.saveMage(mage, asynchronous, callback, false, false);
    }

    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous, MageDataCallback callback, boolean wandInventoryOpen, boolean releaseLock) {
        if (!this.savePlayerData) {
            if (callback != null) {
                callback.run(null);
            }
            return;
        }
        asynchronous = asynchronous && this.asynchronousSaving;
        this.info("Saving player data for " + mage.getName() + " (" + mage.getId() + ") " + (asynchronous ? "" : " synchronously ") + "at " + System.currentTimeMillis());
        MageData mageData = new MageData(mage.getId());
        if (this.mageDataStore != null && mage.save(mageData)) {
            if (wandInventoryOpen) {
                mageData.setOpenWand(true);
            }
            if (asynchronous) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new SaveMageTask(this, mageData, callback, releaseLock));
            } else {
                this.doSaveMage(mageData, callback, releaseLock);
            }
        } else if (releaseLock && this.mageDataStore != null) {
            this.getLogger().warning("Player logging out, but data never loaded. Force-releasing lock");
            this.mageDataStore.releaseLock(mageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveMage(MageData mageData, MageDataCallback callback, boolean releaseLock) {
        Object object = this.saveLock;
        synchronized (object) {
            try {
                this.mageDataStore.save(mageData, callback, releaseLock);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Error saving mage data for mage " + mageData.getId(), ex);
            }
        }
    }

    @Nullable
    public ItemStack removeItemFromWand(Wand wand, ItemStack droppedItem) {
        if (wand == null || droppedItem == null || Wand.isWand(droppedItem)) {
            return null;
        }
        if (Wand.isSpell(droppedItem)) {
            String spellKey = Wand.getSpell(droppedItem);
            wand.removeSpell(spellKey);
            SpellTemplate spell = this.getSpellTemplate(spellKey);
            if (spell != null) {
                Wand.updateSpellItem(this.messages, droppedItem, spell, "", null, null, true);
            }
        } else if (Wand.isBrush(droppedItem)) {
            String brushKey = Wand.getBrush(droppedItem);
            wand.removeBrush(brushKey);
            Wand.updateBrushItem(this.getMessages(), droppedItem, brushKey, null);
        }
        return droppedItem;
    }

    public void onArmorUpdated(Mage mage) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new ArmorUpdatedTask(mage), 1L);
    }

    @Override
    public boolean isLocked(Block block) {
        return this.protectLocked && this.containerMaterials.testBlock(block) && CompatibilityLib.getCompatibilityUtils().isLocked(block);
    }

    protected boolean addLostWandMarker(LostWand lostWand) {
        if (!this.dynmapShowWands) {
            return false;
        }
        Location location = lostWand.getLocation();
        return this.addMarker("wand-" + lostWand.getId(), "wand", "wands", lostWand.getName(), location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), lostWand.getDescription());
    }

    public void toggleCastCommandOverrides(com.elmakers.mine.bukkit.api.magic.Mage apiMage, CommandSender sender, boolean override) {
        if (apiMage instanceof Mage) {
            Mage mage = (Mage)apiMage;
            if (sender != null && sender instanceof BlockCommandSender) {
                mage.setCostFree(override && this.castCommandCostFree);
                mage.setCooldownFree(override && this.castCommandCooldownFree);
                mage.setPowerMultiplier(override ? this.castCommandPowerMultiplier : 1.0f);
            } else {
                mage.setCostFree(override && this.castConsoleCostFree);
                mage.setCooldownFree(override && this.castConsoleCooldownFree);
                mage.setPowerMultiplier(override ? this.castConsolePowerMultiplier : 1.0f);
            }
        }
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.wand.LostWand> getLostWands() {
        return new ArrayList<com.elmakers.mine.bukkit.api.wand.LostWand>(this.lostWands.values());
    }

    @Override
    public boolean cast(String spellName, String[] parameters) {
        return this.cast(spellName, parameters, (CommandSender)Bukkit.getConsoleSender(), null);
    }

    public boolean cast(String spellName, String[] parameters, CommandSender sender, Entity entity) {
        ConfigurationSection config = null;
        if (parameters != null && parameters.length > 0) {
            config = ConfigurationUtils.newConfigurationSection();
            ConfigurationUtils.addParameters(parameters, config);
        }
        return this.cast(null, spellName, config, sender, entity);
    }

    @Override
    public boolean cast(com.elmakers.mine.bukkit.api.magic.Mage mage, String spellName, ConfigurationSection parameters, CommandSender sender) {
        return this.cast(mage, spellName, parameters, sender, null);
    }

    public boolean cast(com.elmakers.mine.bukkit.api.magic.Mage mage, String spellName, ConfigurationSection parameters, CommandSender sender, Entity entity) {
        SpellTemplate template;
        Player usePermissions;
        Player player = sender == entity && entity instanceof Player ? (Player)entity : (usePermissions = sender instanceof Player ? (Player)sender : null);
        if (entity == null && sender instanceof Player) {
            entity = (Player)sender;
        }
        Location targetLocation = null;
        if (mage == null) {
            CommandSender mageController;
            Object object = mageController = entity != null && entity instanceof Player ? (Player)entity : sender;
            if (sender != null && sender instanceof BlockCommandSender) {
                targetLocation = ((BlockCommandSender)sender).getBlock().getLocation();
            }
            mage = entity == null ? this.getMage(mageController) : this.getMageFromEntity(entity, mageController);
        }
        if ((template = this.getSpellTemplate(spellName)) == null || !template.hasCastPermission((CommandSender)usePermissions)) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        this.toggleCastCommandOverrides(mage, sender, true);
        boolean success = false;
        try {
            success = spell.cast(parameters, targetLocation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.toggleCastCommandOverrides(mage, sender, false);
        return success;
    }

    public void onCast(com.elmakers.mine.bukkit.api.magic.Mage mage, Spell spell, SpellResult result) {
        if (this.dynmapShowSpells && this.dynmap != null && result.isSuccess()) {
            if (this.dynmapOnlyPlayerSpells && (mage == null || !mage.isPlayer())) {
                return;
            }
            this.dynmap.showCastMarker(mage, spell, result);
        }
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public MapController getMaps() {
        return this.maps;
    }

    public String getWelcomeWand() {
        return this.welcomeWand;
    }

    @Override
    public void sendToMages(String message, Location location) {
        this.sendToMages(message, location, 1024);
    }

    public void sendToMages(String message, Location location, int range) {
        int rangeSquared = range * range;
        if (message != null && message.length() > 0) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
                if (!mage.isPlayer() || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || !mage.getLocation().getWorld().equals(location.getWorld()) || !(mage.getLocation().toVector().distanceSquared(location.toVector()) < (double)rangeSquared)) continue;
                mage.sendMessage(message);
            }
        }
    }

    @Override
    public boolean isNPC(Entity entity) {
        if (this.isMagicNPC(entity)) {
            return true;
        }
        return this.npcSuppliers.isNPC(entity);
    }

    public boolean isStaticMagicNPC(Entity entity) {
        MagicNPC npc = this.getNPC(entity);
        return npc != null && npc.isStatic();
    }

    @Override
    public boolean isStaticNPC(Entity entity) {
        if (this.isStaticMagicNPC(entity)) {
            return true;
        }
        return this.npcSuppliers.isStaticNPC(entity);
    }

    @Override
    public boolean isPet(Entity entity) {
        return entity.hasMetadata("pet");
    }

    @Override
    public boolean isMagicNPC(Entity entity) {
        return CompatibilityLib.getEntityMetadataUtils().getString(entity, MagicMetaKeys.NPC_ID) != null;
    }

    @Override
    public boolean isVanished(Entity entity) {
        if (entity == null) {
            return false;
        }
        Mage mage = this.getRegisteredMage(entity);
        if (mage != null && mage.isVanished()) {
            return true;
        }
        if (this.essentialsController != null && this.essentialsController.isVanished(entity)) {
            return true;
        }
        Iterator iterator = entity.getMetadata("vanished").iterator();
        if (iterator.hasNext()) {
            MetadataValue meta = (MetadataValue)iterator.next();
            return meta.asBoolean();
        }
        return false;
    }

    @Override
    public void disableDrops(Entity entity) {
        CompatibilityLib.getEntityMetadataUtils().setBoolean(entity, MagicMetaKeys.NO_DROPS, true);
    }

    @Override
    public void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    @Override
    public void updateBlock(String worldName, int x, int y, int z) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfBlock(worldName, x, y, z);
        }
    }

    @Override
    public void updateVolume(String worldName, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap != null && this.dynmapUpdate && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, minx, miny, minz, maxx, maxy, maxz);
        }
    }

    public void update(String worldName, BoundingBox area) {
        if (this.dynmap != null && this.dynmapUpdate && area != null && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, area.getMin().getBlockX(), area.getMin().getBlockY(), area.getMin().getBlockZ(), area.getMax().getBlockX(), area.getMax().getBlockY(), area.getMax().getBlockZ());
        }
    }

    @Override
    public void update(BlockList blockList) {
        if (blockList != null) {
            for (Map.Entry<String, ? extends BoundingBox> entry : blockList.getAreas().entrySet()) {
                this.update(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void cleanItem(ItemStack item) {
        CompatibilityLib.getNBTUtils().removeMeta(item, Wand.WAND_KEY);
        CompatibilityLib.getNBTUtils().removeMeta(item, Wand.UPGRADE_KEY);
        CompatibilityLib.getNBTUtils().removeMeta(item, "spell");
        CompatibilityLib.getNBTUtils().removeMeta(item, "skill");
        CompatibilityLib.getNBTUtils().removeMeta(item, "brush");
        CompatibilityLib.getNBTUtils().removeMeta(item, "sp");
        CompatibilityLib.getNBTUtils().removeMeta(item, "keep");
        CompatibilityLib.getNBTUtils().removeMeta(item, "temporary");
        CompatibilityLib.getNBTUtils().removeMeta(item, "undroppable");
        CompatibilityLib.getNBTUtils().removeMeta(item, "unplaceable");
        CompatibilityLib.getNBTUtils().removeMeta(item, "unstashable");
        CompatibilityLib.getNBTUtils().removeMeta(item, "unmoveable");
    }

    @Override
    public boolean canCreateWorlds() {
        return this.createWorldsEnabled;
    }

    @Override
    public int getMaxUndoPersistSize() {
        return this.undoMaxPersistSize;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public MagicAPI getAPI() {
        return this.plugin;
    }

    public Collection<? extends com.elmakers.mine.bukkit.api.magic.Mage> getMutableMages() {
        return this.mages.values();
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMages() {
        Collection<Mage> values = this.mages.values();
        return Collections.unmodifiableCollection(values);
    }

    @Override
    @Deprecated
    public Set<Material> getBuildingMaterials() {
        return MaterialSets.toLegacyNN(this.buildingMaterials);
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMobMages() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> mobMages = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (mage.getEntityData() == null) continue;
            mobMages.add(mage);
        }
        return Collections.unmodifiableCollection(mobMages);
    }

    @Override
    public Collection<Entity> getActiveMobs() {
        return this.mobs.getActiveMobs();
    }

    @Override
    @Deprecated
    public Set<Material> getRestrictedMaterials() {
        return MaterialSets.toLegacyNN(this.restrictedMaterials);
    }

    @Override
    public MaterialSet getBuildingMaterialSet() {
        return this.buildingMaterials;
    }

    @Override
    public MaterialSet getDestructibleMaterialSet() {
        return this.destructibleMaterials;
    }

    @Override
    public MaterialSet getRestrictedMaterialSet() {
        return this.restrictedMaterials;
    }

    @Override
    public int getMessageThrottle() {
        return this.messageThrottle;
    }

    @Override
    public boolean isMage(Entity entity) {
        if (entity == null) {
            return false;
        }
        String id = this.mageIdentifier.fromEntity(entity);
        return this.mages.containsKey(id);
    }

    @Override
    public MaterialSetManager getMaterialSetManager() {
        return this.materialSetManager;
    }

    @Override
    @Deprecated
    public Collection<String> getMaterialSets() {
        return this.getMaterialSetManager().getMaterialSets();
    }

    @Override
    @Nullable
    @Deprecated
    public Set<Material> getMaterialSet(String string) {
        return MaterialSets.toLegacy(this.getMaterialSetManager().fromConfig(string));
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        Collection players = this.plugin.getServer().getOnlinePlayers();
        for (Player player : players) {
            if (this.isNPC((Entity)player)) continue;
            playerNames.add(player.getName());
        }
        return playerNames;
    }

    @Override
    public void disablePhysics(int interval) {
        if (this.physicsHandler == null && interval > 0) {
            this.physicsHandler = new PhysicsHandler(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.physicsHandler, (Plugin)this.plugin);
        }
        if (this.physicsHandler != null) {
            this.physicsHandler.setInterval(interval);
        }
    }

    @Override
    public boolean commitAll() {
        boolean undid = false;
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            undid = mage.commit() || undid;
        }
        UndoList.commitAll();
        return undid;
    }

    @Override
    public boolean canTarget(Entity attacker, Entity entity) {
        if (attacker == entity) {
            return true;
        }
        if (attacker == null || entity == null) {
            return true;
        }
        if (this.isFriendly(attacker, entity, false)) {
            return false;
        }
        for (EntityTargetingManager manager : this.targetingProviders) {
            if (manager.canTarget(attacker, entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFriendly(Entity attacker, Entity entity) {
        return this.isFriendly(attacker, entity, true);
    }

    public boolean isFriendly(Entity attacker, Entity entity, boolean friendlyByDefault) {
        if (attacker == entity) {
            return true;
        }
        for (TeamProvider provider : this.teamProviders) {
            if (!provider.isFriendly(attacker, entity)) continue;
            return true;
        }
        EntityData mob = this.getMob(attacker);
        if (mob != null && mob.isFriendly(entity)) {
            return true;
        }
        if (friendlyByDefault) {
            if (!(attacker instanceof Player)) {
                return true;
            }
            if (entity instanceof Player) {
                return this.defaultFriendly;
            }
            return this.friendlyEntityTypes.contains(entity.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public Location getWarp(String warpName) {
        Location location = null;
        if (this.warpController != null) {
            try {
                location = this.warpController.getWarp(warpName);
            }
            catch (Exception ex) {
                location = null;
            }
        }
        return location;
    }

    public WarpController getWarps() {
        return this.warpController;
    }

    @Override
    @Nullable
    public Location getTownLocation(Player player) {
        return this.townyManager.getTownLocation(player);
    }

    @Override
    @Deprecated
    @Nullable
    public Map<String, Location> getHomeLocations(Player player) {
        return this.preciousStonesManager.getFieldLocations(player);
    }

    @Override
    @Nonnull
    public Set<String> getPlayerWarpProviderKeys() {
        return this.playerWarpManagers.keySet();
    }

    @Override
    @Nullable
    public Collection<PlayerWarp> getPlayerWarps(@Nonnull Player player, String key) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        PlayerWarpManager manager = this.playerWarpManagers.get(key);
        if (manager == null) {
            return null;
        }
        return manager.getWarps(player);
    }

    @Override
    @Nullable
    public Collection<PlayerWarp> getAllPlayerWarps(String key) {
        PlayerWarpManager manager = this.playerWarpManagers.get(key);
        if (manager == null) {
            return null;
        }
        return manager.getAllWarps();
    }

    public TownyManager getTowny() {
        return this.townyManager;
    }

    public PreciousStonesManager getPreciousStones() {
        return this.preciousStonesManager;
    }

    @Override
    public boolean sendMail(CommandSender sender, String fromPlayer, String toPlayer, String message) {
        if (this.mailer != null) {
            return this.mailer.sendMail(sender, fromPlayer, toPlayer, message);
        }
        return false;
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList undoAny(Block target) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            com.elmakers.mine.bukkit.api.block.UndoList undid = mage.undo(target);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList undoRecent(Block target, int timeout) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            UndoQueue queue = mage.getUndoQueue();
            com.elmakers.mine.bukkit.api.block.UndoList undid = queue.undoRecent(target, timeout);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    @Override
    @Nullable
    public Wand getIfWand(ItemStack itemStack) {
        if (Wand.isWand(itemStack)) {
            return this.getWand(itemStack);
        }
        return null;
    }

    @Override
    public Wand getWand(ItemStack itemStack) {
        Wand wand = new Wand(this, itemStack);
        return wand;
    }

    @Override
    public Wand getWand(ConfigurationSection config) {
        return new Wand(this, config);
    }

    @Override
    @Nullable
    public Wand createWand(String wandKey) {
        return Wand.createWand(this, wandKey);
    }

    @Nullable
    public Wand createWand(String wandKey, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return Wand.createWand(this, wandKey, mage instanceof Mage ? (Mage)mage : null);
    }

    @Override
    @Nonnull
    public Wand createWand(@Nonnull ItemStack itemStack) {
        return Wand.createWand(this, itemStack);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.wand.WandTemplate getWandTemplate(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.wandTemplates.get(key);
    }

    @Override
    public Collection<WandTemplate> getWandTemplates() {
        return new ArrayList<WandTemplate>(this.wandTemplates.values());
    }

    @Override
    @Nullable
    public String getAutoWandKey(@Nonnull Material material) {
        return this.autoWands.get(material);
    }

    @Nullable
    public ItemStack getAutoWand(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        String templateKey = this.getAutoWandKey(itemStack.getType());
        if (templateKey != null && !templateKey.isEmpty()) {
            Wand wand = this.createWand(templateKey);
            if (wand == null) {
                this.getLogger().warning("Invalid wand template in auto_wands config: " + templateKey);
            } else {
                return wand.getItem();
            }
        }
        return null;
    }

    @Nullable
    protected ConfigurationSection resolveConfiguration(String key, ConfigurationSection properties, Map<String, ConfigurationSection> configurations) {
        this.resolvingKeys.clear();
        return this.resolveConfiguration(key, properties, configurations, this.resolvingKeys);
    }

    @Nullable
    protected ConfigurationSection resolveConfiguration(String key, ConfigurationSection properties, Map<String, ConfigurationSection> configurations, Set<String> resolving) {
        if (resolving.contains(key)) {
            this.getLogger().log(Level.WARNING, "Circular dependency detected: " + StringUtils.join(resolving, (String)" -> ") + " -> " + key);
            return properties;
        }
        resolving.add(key);
        ConfigurationSection configuration = configurations.get(key);
        if (configuration == null) {
            ConfigurationSection baseConfiguration;
            configuration = properties.getConfigurationSection(key);
            if (configuration == null) {
                return null;
            }
            String inherits = configuration.getString("inherit");
            if (inherits != null && (baseConfiguration = this.resolveConfiguration(inherits, properties, configurations, resolving)) != null) {
                ConfigurationSection newConfiguration = ConfigurationUtils.cloneConfiguration(baseConfiguration);
                ConfigurationUtils.addConfigurations(newConfiguration, configuration);
                newConfiguration.set("hidden", configuration.get("hidden"));
                newConfiguration.set("enabled", configuration.get("enabled"));
                configuration = newConfiguration;
            }
            configurations.put(key, configuration);
        }
        return configuration;
    }

    public void loadMageClasses(ConfigurationSection properties) {
        this.mageClasses.clear();
        Set classKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : classKeys) {
            this.logger.setContext("classes." + key);
            Object classConfig = this.resolveConfiguration(key, properties, templateConfigurations);
            classConfig = MagicConfiguration.getKeyed(this, classConfig, "class", key);
            this.loadMageClassTemplate(key, (ConfigurationSection)classConfig);
        }
        for (String key : classKeys) {
            String parentKey;
            this.logger.setContext("classes." + key);
            MageClassTemplate template = this.mageClasses.get(key);
            if (template == null || (parentKey = properties.getConfigurationSection(key).getString("parent")) == null) continue;
            MageClassTemplate parent = this.mageClasses.get(parentKey);
            if (parent == null) {
                this.getLogger().warning("Class '" + key + "' has unknown parent: " + parentKey);
                continue;
            }
            template.setParent(parent);
        }
    }

    public void loadModifiers(ConfigurationSection properties) {
        this.modifiers.clear();
        Set modifierKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : modifierKeys) {
            this.logger.setContext("modifiers." + key);
            Object modifierConfig = this.resolveConfiguration(key, properties, templateConfigurations);
            modifierConfig = MagicConfiguration.getKeyed(this, modifierConfig, "modifier", key);
            this.loadModifierTemplate(key, (ConfigurationSection)modifierConfig);
        }
        for (String key : modifierKeys) {
            String parentKey;
            this.logger.setContext("modifiers." + key);
            ModifierTemplate template = this.modifiers.get(key);
            if (template == null || (parentKey = properties.getConfigurationSection(key).getString("parent")) == null) continue;
            ModifierTemplate parent = this.modifiers.get(parentKey);
            if (parent == null) {
                this.getLogger().warning("Modifier '" + key + "' has unknown parent: " + parentKey);
                continue;
            }
            template.setParent(parent);
        }
    }

    @Override
    public Set<String> getMageClassKeys() {
        return this.mageClasses.keySet();
    }

    @Nonnull
    public MageClassTemplate getMageClass(String key) {
        MageClassTemplate template = this.mageClasses.get(key);
        if (template == null) {
            ConfigurationSection configuration = ConfigurationUtils.newConfigurationSection();
            template = new MageClassTemplate(this, key, configuration);
            this.mageClasses.put(key, template);
        }
        return template;
    }

    public void loadMageClassTemplate(String key, ConfigurationSection classNode) {
        if (ConfigurationUtils.isEnabled(classNode)) {
            this.mageClasses.put(key, new MageClassTemplate(this, key, classNode));
        }
    }

    public void loadModifierTemplate(String key, ConfigurationSection modifierNode) {
        if (ConfigurationUtils.isEnabled(modifierNode)) {
            this.modifiers.put(key, new ModifierTemplate(this, key, modifierNode));
        }
    }

    public void loadWandTemplates(ConfigurationSection properties) {
        this.wandTemplates.clear();
        Set wandKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : wandKeys) {
            this.logger.setContext("wands." + key);
            this.loadWandTemplate(key, this.resolveConfiguration(key, properties, templateConfigurations));
        }
    }

    public void loadMobs(ConfigurationSection properties) {
        this.mobs.clear();
        Set mobKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : mobKeys) {
            this.logger.setContext("mobs." + key);
            Object mobConfig = this.resolveConfiguration(key, properties, templateConfigurations);
            mobConfig = MagicConfiguration.getKeyed(this, mobConfig, "mob", key);
            this.mobs.load(key, (ConfigurationSection)mobConfig);
        }
    }

    public void loadWorlds(ConfigurationSection properties) {
        Set worldKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : worldKeys) {
            if (key.equalsIgnoreCase("worlds")) continue;
            this.logger.setContext("worlds." + key);
            Object worldConfig = this.resolveConfiguration(key, properties, templateConfigurations);
            worldConfig = MagicConfiguration.getKeyed(this, worldConfig, "world", key);
            properties.set(key, worldConfig);
        }
        this.worldController.loadWorlds(properties);
    }

    @Override
    public void timeSkipped(World changedWorld, long skippedAmount) {
        for (MagicWorld world : this.worldController.getWorlds()) {
            world.updateTimeFrom(changedWorld, skippedAmount);
        }
    }

    @Override
    public MageClassTemplate getMageClassTemplate(String key) {
        return this.mageClasses.get(key);
    }

    @Override
    @Nullable
    public ModifierTemplate getModifierTemplate(String key) {
        return this.modifiers.get(key);
    }

    @Override
    @Nonnull
    public Collection<String> getModifierTemplateKeys() {
        return this.modifiers.keySet();
    }

    @Override
    public void loadWandTemplate(String key, ConfigurationSection wandNode) {
        if (ConfigurationUtils.isEnabled(wandNode)) {
            wandNode = MagicConfiguration.getKeyed(this, wandNode, "wand", key);
            this.wandTemplates.put(key, new com.elmakers.mine.bukkit.wand.WandTemplate(this, key, (ConfigurationSection)wandNode));
        }
    }

    @Override
    public void unloadWandTemplate(String key) {
        this.wandTemplates.remove(key);
    }

    @Override
    public Collection<String> getWandTemplateKeys() {
        return this.wandTemplates.keySet();
    }

    @Nullable
    public ConfigurationSection getWandTemplateConfiguration(String key) {
        com.elmakers.mine.bukkit.wand.WandTemplate template = this.getWandTemplate(key);
        return template == null ? null : template.getConfiguration();
    }

    @Override
    public boolean elementalsEnabled() {
        return this.elementals != null;
    }

    @Override
    public boolean createElemental(Location location, String templateName, CommandSender creator) {
        return this.elementals.createElemental(location, templateName, creator);
    }

    @Override
    public boolean isElemental(Entity entity) {
        if (this.elementals == null || entity.getType() != EntityType.FALLING_BLOCK) {
            return false;
        }
        return this.elementals.isElemental(entity);
    }

    @Override
    public boolean damageElemental(Entity entity, double damage, int fireTicks, CommandSender attacker) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.damageElemental(entity, damage, fireTicks, attacker);
    }

    @Override
    public boolean setElementalScale(Entity entity, double scale) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.setElementalScale(entity, scale);
    }

    @Override
    public double getElementalScale(Entity entity) {
        if (this.elementals == null) {
            return 0.0;
        }
        return this.elementals.getElementalScale(entity);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.spell.SpellCategory getCategory(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        SpellCategory category = this.categories.get(key);
        if (category == null) {
            category = new SpellCategory(key, this);
            this.categories.put(key, category);
        }
        return category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.SpellCategory> getCategories() {
        ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory> allCategories = new ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory>();
        allCategories.addAll(this.categories.values());
        return allCategories;
    }

    @Override
    public Collection<String> getSpellTemplateKeys() {
        return this.spells.keySet();
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        return this.getSpellTemplates(false);
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates(boolean showHidden) {
        ArrayList<SpellTemplate> allSpells = new ArrayList<SpellTemplate>();
        for (SpellTemplate spell : this.spells.values()) {
            if (!showHidden && spell.isHidden()) continue;
            allSpells.add(spell);
        }
        return allSpells;
    }

    @Override
    @Nullable
    public SpellTemplate getSpellTemplate(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        SpellTemplate spell = this.spellAliases.get(name);
        if (spell == null) {
            spell = this.spells.get(name);
        }
        if (spell == null && name.startsWith("heroes*")) {
            if (this.heroesManager == null) {
                return null;
            }
            spell = this.heroesManager.createSkillSpell(this, name.substring(7));
            if (spell != null) {
                this.spells.put(name, spell);
            }
        }
        return spell;
    }

    protected void loadIcons(ConfigurationSection iconConfigs) {
        this.icons.clear();
        for (String key : iconConfigs.getKeys(false)) {
            ConfigurationSection iconConfig = iconConfigs.getConfigurationSection(key);
            if (iconConfig == null) continue;
            Icon icon = new Icon(this, iconConfig);
            this.icons.put(key, icon);
        }
    }

    @Override
    @Nullable
    public Icon getIcon(String iconKey) {
        return this.icons.get(iconKey);
    }

    @Override
    @Nonnull
    public Icon getDefaultIcon() {
        Icon defaultIcon = this.icons.get("default");
        if (defaultIcon == null) {
            defaultIcon = new Icon(this);
        }
        return defaultIcon;
    }

    @Override
    @Nonnull
    public Set<String> getIconKeys() {
        return this.icons.keySet();
    }

    protected void loadSpells(CommandSender sender, ConfigurationSection spellConfigs) {
        if (spellConfigs == null) {
            return;
        }
        this.spells.clear();
        this.spellAliases.clear();
        this.categories.clear();
        this.maxSpellLevels.clear();
        Set keys = spellConfigs.getKeys(false);
        for (String string : keys) {
            String icon;
            if (string.equals("default") || string.equals("override")) continue;
            this.logger.setContext("spells." + string);
            Object spellNode = spellConfigs.getConfigurationSection(string);
            if (!ConfigurationUtils.isEnabled(spellNode)) continue;
            if (!(spellNode instanceof MagicConfiguration)) {
                spellNode = MagicConfiguration.getKeyed(this, spellNode, "spell", string);
                spellConfigs.set(string, spellNode);
            }
            Spell newSpell = null;
            try {
                newSpell = MagicController.loadSpell(string, spellNode, this);
            }
            catch (Exception ex) {
                newSpell = null;
                ex.printStackTrace();
            }
            if (newSpell == null) {
                this.getLogger().warning("Magic: Error loading spell " + string);
                continue;
            }
            if (!newSpell.hasIcon() && (icon = spellNode.getString("icon")) != null && !icon.isEmpty()) {
                this.getLogger().info("Couldn't load spell icon '" + icon + "' for spell: " + newSpell.getKey());
            }
            this.addSpell(newSpell);
        }
        for (String string : keys) {
            this.logger.setContext("spells." + string);
            SpellTemplate template = this.getSpellTemplate(string);
            if (template == null) continue;
            template.loadPrerequisites(spellConfigs.getConfigurationSection(string));
        }
        this.logger.setContext("Reload Mage spells");
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).loadSpells(spellConfigs);
        }
    }

    public SpellKey unalias(SpellKey spellKey) {
        SpellTemplate spell = this.spellAliases.get(spellKey.getBaseKey());
        if (spell != null) {
            return new SpellKey(spell.getSpellKey().getBaseKey(), spellKey.getLevel());
        }
        return spellKey;
    }

    @Override
    public String getEntityDisplayName(Entity target) {
        return this.getEntityName(target, true);
    }

    @Override
    public String getEntityName(Entity target) {
        return this.getEntityName(target, false);
    }

    protected String getEntityName(Entity target, boolean display) {
        String localizedName;
        if (target == null) {
            return "Unknown";
        }
        if (target instanceof Player) {
            return display ? ((Player)target).getDisplayName() : target.getName();
        }
        if (this.isElemental(target)) {
            return "Elemental";
        }
        if (display) {
            if (target instanceof LivingEntity) {
                LivingEntity li = (LivingEntity)target;
                String customName = li.getCustomName();
                if (customName != null && customName.length() > 0) {
                    return customName;
                }
            } else if (target instanceof Item) {
                ItemMeta meta;
                Item item = (Item)target;
                ItemStack itemStack = item.getItemStack();
                if (itemStack.hasItemMeta() && (meta = itemStack.getItemMeta()).hasDisplayName()) {
                    return meta.getDisplayName();
                }
                MaterialAndData material = new MaterialAndData(itemStack);
                return material.getName(this.getMessages());
            }
        }
        if (!(localizedName = this.messages.get("entities." + target.getType().name().toLowerCase(), "")).isEmpty()) {
            return localizedName;
        }
        return target.getType().name().toLowerCase().replace('_', ' ');
    }

    public ItemStack getSpellBook(int count) {
        return this.getSpellBook((com.elmakers.mine.bukkit.api.spell.SpellCategory)null, count);
    }

    public ItemStack getSpellBook(com.elmakers.mine.bukkit.api.spell.SpellCategory category, int count) {
        HashMap<String, ArrayList<SpellTemplate>> categories = new HashMap<String, ArrayList<SpellTemplate>>();
        Collection<SpellTemplate> spellVariants = this.spells.values();
        String categoryKey = category == null ? null : category.getKey();
        for (SpellTemplate spell : spellVariants) {
            com.elmakers.mine.bukkit.api.spell.SpellCategory spellCategory;
            if (spell.isHidden() || spell.getSpellKey().isVariant() || (spellCategory = spell.getCategory()) == null) continue;
            String spellCategoryKey = spellCategory.getKey();
            if (categoryKey != null && !spellCategoryKey.equalsIgnoreCase(categoryKey)) continue;
            ArrayList<SpellTemplate> categorySpells = (ArrayList<SpellTemplate>)categories.get(spellCategoryKey);
            if (categorySpells == null) {
                categorySpells = new ArrayList<SpellTemplate>();
                categories.put(spellCategoryKey, categorySpells);
            }
            categorySpells.add(spell);
        }
        ArrayList categoryKeys = new ArrayList(categories.keySet());
        Collections.sort(categoryKeys);
        ItemStack bookItem = new ItemStack(Material.WRITTEN_BOOK, count);
        BookMeta book = (BookMeta)bookItem.getItemMeta();
        book.setAuthor(this.messages.get("books.default.author"));
        String title = null;
        title = category != null ? this.messages.get("books.default.title").replace("$category", category.getName()) : this.messages.get("books.all.title");
        book.setTitle(title);
        ArrayList<String> pages = new ArrayList<String>();
        for (String key : categoryKeys) {
            category = this.getCategory(key);
            title = this.messages.get("books.default.title").replace("$category", category.getName());
            String description = "" + ChatColor.BOLD + ChatColor.BLUE + title + "\n\n";
            description = description + "" + ChatColor.RESET + ChatColor.DARK_BLUE + category.getDescription();
            pages.add(description);
            List categorySpells = (List)categories.get(key);
            Collections.sort(categorySpells);
            for (SpellTemplate spell : categorySpells) {
                List<String> lines = this.getSpellBookDescription(spell);
                pages.add(StringUtils.join(lines, (String)"\n"));
            }
        }
        book.setPages(pages);
        bookItem.setItemMeta((ItemMeta)book);
        return bookItem;
    }

    public ItemStack getSpellBook(SpellTemplate spell, int count) {
        ItemStack bookItem = new ItemStack(Material.WRITTEN_BOOK, count);
        BookMeta book = (BookMeta)bookItem.getItemMeta();
        book.setAuthor(this.messages.get("books.default.author"));
        book.setTitle(this.messages.get("books.spell.title").replace("$spell", spell.getName()));
        ArrayList<String> pages = new ArrayList<String>();
        List<String> lines = this.getSpellBookDescription(spell);
        pages.add(StringUtils.join(lines, (String)"\n"));
        book.setPages(pages);
        bookItem.setItemMeta((ItemMeta)book);
        return bookItem;
    }

    protected List<String> getSpellBookDescription(SpellTemplate spell) {
        String spellExtendedDescription;
        String usage;
        String string;
        WandUpgradePath checkPath;
        Set<String> paths = WandUpgradePath.getPathKeys();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("" + ChatColor.GOLD + ChatColor.BOLD + spell.getName());
        lines.add("" + ChatColor.RESET);
        String spellDescription = spell.getDescription();
        if (spellDescription != null && spellDescription.length() > 0) {
            lines.add("" + ChatColor.BLACK + spellDescription);
            lines.add("");
        }
        int charges = spell.getMaxCharges();
        String description = this.messages.get("charges.description");
        if (charges > 1 && !description.isEmpty()) {
            String chargesDescription = description.replace("$count", Integer.toString(charges));
            lines.add("" + ChatColor.DARK_PURPLE + chargesDescription);
        }
        String spellCooldownDescription = spell.getCooldownDescription();
        description = this.messages.get("cooldown.description");
        if (spellCooldownDescription != null && spellCooldownDescription.length() > 0 && !description.isEmpty()) {
            spellCooldownDescription = description.replace("$time", spellCooldownDescription);
            lines.add("" + ChatColor.DARK_PURPLE + spellCooldownDescription);
        }
        String spellMageCooldownDescription = spell.getMageCooldownDescription();
        description = this.messages.get("cooldown.mage_description");
        if (spellMageCooldownDescription != null && spellMageCooldownDescription.length() > 0 && !description.isEmpty()) {
            spellMageCooldownDescription = description.replace("$time", spellMageCooldownDescription);
            lines.add("" + ChatColor.RED + spellMageCooldownDescription);
        }
        Collection<CastingCost> costs = spell.getCosts();
        description = this.messages.get("wand.costs_description");
        if (costs != null && !description.isEmpty()) {
            for (CastingCost castingCost : costs) {
                if (castingCost.isEmpty()) continue;
                lines.add(ChatColor.DARK_PURPLE + description.replace("$description", castingCost.getFullDescription(this.messages)));
            }
        }
        Collection<CastingCost> activeCosts = spell.getActiveCosts();
        description = this.messages.get("wand.active_costs_description");
        if (activeCosts != null) {
            for (CastingCost cost : activeCosts) {
                if (cost.isEmpty()) continue;
                lines.add(ChatColor.DARK_PURPLE + description.replace("$description", cost.getFullDescription(this.messages)));
            }
        }
        if (!(description = this.messages.get("spell.available_path")).isEmpty()) {
            for (String pathKey : paths) {
                checkPath = WandUpgradePath.getPath(pathKey);
                if (checkPath.isHidden() || !checkPath.hasSpell(spell.getKey()) && !checkPath.hasExtraSpell(spell.getKey())) continue;
                lines.add(ChatColor.DARK_BLUE + description.replace("$path", checkPath.getName()));
                break;
            }
        }
        if (!(description = this.messages.get("spell.required_path")).isEmpty()) {
            for (String pathKey : paths) {
                checkPath = WandUpgradePath.getPath(pathKey);
                if (!checkPath.requiresSpell(spell.getKey())) continue;
                lines.add(ChatColor.DARK_RED + description.replace("$path", checkPath.getName()));
                break;
            }
        }
        if ((string = spell.getDurationDescription(this.messages)) != null) {
            lines.add(ChatColor.DARK_GREEN + string);
        } else if (spell.showUndoable()) {
            if (spell.isUndoable()) {
                String undoable = this.messages.get("spell.undoable", "");
                if (!undoable.isEmpty()) {
                    lines.add(undoable);
                }
            } else {
                String notUndoable = this.messages.get("spell.not_undoable", "");
                if (!notUndoable.isEmpty()) {
                    lines.add(notUndoable);
                }
            }
        }
        description = this.messages.get("spell.brush");
        if (spell.usesBrush() && !description.isEmpty()) {
            lines.add(ChatColor.DARK_GRAY + description);
        }
        SpellKey baseKey = spell.getSpellKey();
        SpellKey upgradeKey = new SpellKey(baseKey.getBaseKey(), baseKey.getLevel() + 1);
        SpellTemplate upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
        int spellLevels = 0;
        while (upgradeSpell != null) {
            ++spellLevels;
            upgradeKey = new SpellKey(upgradeKey.getBaseKey(), upgradeKey.getLevel() + 1);
            upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
        }
        description = this.messages.get("spell.levels_available");
        if (spellLevels > 0 && !description.isEmpty()) {
            lines.add(ChatColor.DARK_AQUA + description.replace("$levels", Integer.toString(++spellLevels)));
        }
        if ((usage = spell.getUsage()) != null && usage.length() > 0) {
            lines.add("" + ChatColor.GRAY + ChatColor.ITALIC + usage + ChatColor.RESET);
            lines.add("");
        }
        if ((spellExtendedDescription = spell.getExtendedDescription()) != null && spellExtendedDescription.length() > 0) {
            lines.add("" + ChatColor.BLACK + spellExtendedDescription);
            lines.add("");
        }
        return lines;
    }

    public ItemStack getSpellCategoriesBook(int count) {
        ArrayList<String> categoryKeys = new ArrayList<String>(this.categories.keySet());
        Collections.sort(categoryKeys);
        ItemStack bookItem = new ItemStack(Material.WRITTEN_BOOK, count);
        BookMeta book = (BookMeta)bookItem.getItemMeta();
        book.setAuthor(this.messages.get("books.default.author"));
        String title = this.messages.get("books.categories.title");
        book.setTitle(title);
        ArrayList<String> pages = new ArrayList<String>();
        for (String key : categoryKeys) {
            com.elmakers.mine.bukkit.api.spell.SpellCategory category = this.getCategory(key);
            String description = this.messages.get("books.categories.category").replace("$category", category.getName());
            description = description + "\n\n" + ChatColor.RESET + category.getDescription();
            pages.add(description);
        }
        book.setPages(pages);
        bookItem.setItemMeta((ItemMeta)book);
        return bookItem;
    }

    public ItemStack getLearnSpellBook(SpellTemplate spell, int amount) {
        ConfigurationSection wandConfiguration = ConfigurationUtils.newConfigurationSection();
        wandConfiguration.set("template", (Object)"learnspell");
        wandConfiguration.set("icon", (Object)("book:" + spell.getKey()));
        wandConfiguration.set("name", (Object)this.messages.get("books.learnspell.name").replace("$spell", spell.getName()));
        wandConfiguration.set("description", (Object)this.messages.get("books.learnspell.description").replace("$spell", spell.getName()));
        wandConfiguration.set("overrides", (Object)("spell " + spell.getKey()));
        Wand wand = new Wand(this, wandConfiguration);
        ItemStack item = wand.getItem();
        item.setAmount(amount);
        return item;
    }

    @Override
    public MaterialAndData getRedstoneReplacement() {
        return this.redstoneReplacement;
    }

    @Override
    public Set<EntityType> getUndoEntityTypes() {
        return this.undoEntityTypes;
    }

    @Override
    @Nonnull
    public String describeItem(ItemStack item) {
        return this.messages.describeItem(item);
    }

    public boolean checkForItem(Player player, ItemStack requireItem, boolean take) {
        boolean foundItem = false;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (!this.itemsAreEqual(item, requireItem)) continue;
            Wand wand = null;
            if (Wand.isWand(item) && Wand.isBound(item) && !(wand = this.getWand(item)).canUse(player)) continue;
            if (take) {
                player.getInventory().setItem(i, null);
                if (wand != null) {
                    wand.unbind();
                }
            }
            foundItem = true;
            break;
        }
        return foundItem;
    }

    @Override
    public boolean hasItem(Player player, ItemStack requireItem) {
        return this.checkForItem(player, requireItem, false);
    }

    @Override
    public boolean takeItem(Player player, ItemStack requireItem) {
        return this.checkForItem(player, requireItem, true);
    }

    @Override
    public boolean isWand(ItemStack item) {
        return Wand.isWand(item);
    }

    @Override
    public boolean isWandUpgrade(ItemStack item) {
        return Wand.isUpgrade(item);
    }

    @Override
    public boolean isSkill(ItemStack item) {
        return Wand.isSkill(item);
    }

    @Override
    public boolean isMagic(ItemStack item) {
        return Wand.isSpecial(item);
    }

    @Override
    @Nullable
    public String getWandKey(ItemStack item) {
        if (Wand.isWand(item)) {
            return Wand.getWandTemplate(item);
        }
        return null;
    }

    @Override
    public String getItemKey(ItemStack item) {
        if (item == null) {
            return "";
        }
        if (Wand.isUpgrade(item)) {
            return "upgrade:" + Wand.getWandTemplate(item);
        }
        if (Wand.isWand(item)) {
            return "wand:" + Wand.getWandTemplate(item);
        }
        if (Wand.isSpell(item)) {
            return "spell:" + Wand.getSpell(item);
        }
        if (Wand.isBrush(item)) {
            return "brush:" + Wand.getBrush(item);
        }
        com.elmakers.mine.bukkit.api.item.ItemData mappedItem = this.getItem(item);
        if (mappedItem != null) {
            return mappedItem.getKey();
        }
        MaterialAndData material = new MaterialAndData(item);
        return material.getKey();
    }

    @Override
    @Nullable
    public ItemStack createDisabledItem(String magicItemKey, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return this.createItem(magicItemKey, mage, false, null, true);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicItemKey, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return this.createItem(magicItemKey, mage, false, null);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicItemKey) {
        return this.createItem(magicItemKey, false);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicItemKey, boolean brief) {
        return this.createItem(magicItemKey, null, brief, null);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicItemKey, com.elmakers.mine.bukkit.api.magic.Mage mage, boolean brief, ItemUpdatedCallback callback) {
        return this.createItem(magicItemKey, mage, brief, callback, false);
    }

    @Nullable
    public ItemStack createItem(String magicItemKey, com.elmakers.mine.bukkit.api.magic.Mage mage, boolean brief, ItemUpdatedCallback callback, boolean disabled) {
        com.elmakers.mine.bukkit.api.block.MaterialAndData material;
        Icon icon;
        String[] pieces;
        ItemStack itemStack = null;
        if (magicItemKey == null || magicItemKey.isEmpty()) {
            if (callback != null) {
                callback.updated(null);
            }
            return null;
        }
        if (magicItemKey.startsWith("skill:")) {
            String spellKey = magicItemKey.substring(6);
            itemStack = Wand.createSpellItem(spellKey, this, mage, null, false);
            CompatibilityLib.getNBTUtils().setString(itemStack, "skill", "true");
            if (callback != null) {
                callback.updated(itemStack);
            }
            return itemStack;
        }
        int amount = 1;
        if (magicItemKey.contains("@")) {
            pieces = StringUtils.split((String)magicItemKey, (char)'@');
            magicItemKey = pieces[0];
            try {
                amount = Integer.parseInt(pieces[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        magicItemKey = magicItemKey.replace("|", ":");
        pieces = StringUtils.split((String)magicItemKey, (String)":", (int)2);
        String itemKey = pieces[0];
        if (pieces.length > 1) {
            String itemData = pieces[1];
            try {
                switch (itemKey) {
                    case "icon": {
                        icon = this.getIcon(itemData);
                        if (icon != null) {
                            com.elmakers.mine.bukkit.api.block.MaterialAndData materialAndData = material = disabled ? icon.getItemDisabledMaterial(this.isLegacyIconsEnabled()) : icon.getItemMaterial(this.isLegacyIconsEnabled());
                            if (material != null) {
                                itemStack = material.getItemStack(1);
                            }
                        }
                        break;
                    }
                    case "egg": {
                        itemStack = this.getSpawnEgg(itemData);
                        break;
                    }
                    case "book": {
                        com.elmakers.mine.bukkit.api.spell.SpellCategory category = null;
                        if (itemData.equals("categories")) {
                            itemStack = this.getSpellCategoriesBook(amount);
                            break;
                        }
                        if (!itemData.isEmpty() && !itemData.equalsIgnoreCase("all")) {
                            category = this.categories.get(itemData);
                        }
                        if (category != null) {
                            itemStack = this.getSpellBook(category, amount);
                            break;
                        }
                        String[] spell = this.getSpellTemplate(itemData);
                        if (spell != null) {
                            itemStack = this.getSpellBook((SpellTemplate)spell, amount);
                            break;
                        }
                        itemStack = this.getSpellBook(amount);
                        break;
                    }
                    case "learnbook": {
                        SpellTemplate spell = this.getSpellTemplate(itemData);
                        if (spell == null) {
                            if (callback != null) {
                                callback.updated(null);
                            }
                            return null;
                        }
                        itemStack = this.getLearnSpellBook(spell, amount);
                        break;
                    }
                    case "recipe": {
                        String[] recipeKeys;
                        List<String> keys;
                        itemStack = CompatibilityLib.getCompatibilityUtils().getKnowledgeBook();
                        if (itemStack != null) {
                            if (itemData.equals("*")) {
                                keys = this.crafting.getRecipeKeys();
                                for (String key : keys) {
                                    CompatibilityLib.getCompatibilityUtils().addRecipeToBook(itemStack, (Plugin)this.plugin, key);
                                }
                            } else {
                                recipeKeys = StringUtils.split((String)itemData, (String)",");
                                for (String recipe : recipeKeys) {
                                    CompatibilityLib.getCompatibilityUtils().addRecipeToBook(itemStack, (Plugin)this.plugin, recipe);
                                }
                            }
                        }
                        break;
                    }
                    case "recipes": {
                        String[] recipeKeys;
                        List<String> keys;
                        itemStack = CompatibilityLib.getCompatibilityUtils().getKnowledgeBook();
                        if (itemStack != null) {
                            if (itemData.equals("*")) {
                                keys = this.crafting.getRecipeKeys();
                                for (String key : keys) {
                                    CompatibilityLib.getCompatibilityUtils().addRecipeToBook(itemStack, (Plugin)this.plugin, key);
                                }
                            } else {
                                recipeKeys = StringUtils.split((String)itemData, (String)",");
                                for (String recipe : recipeKeys) {
                                    MageClassTemplate mageClass = this.getMageClassTemplate(recipe);
                                    if (mageClass == null) continue;
                                    for (String key : mageClass.getRecipies()) {
                                        CompatibilityLib.getCompatibilityUtils().addRecipeToBook(itemStack, (Plugin)this.plugin, key);
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case "spell": {
                        String spellKey = itemData.replace(":", "|");
                        itemStack = this.createSpellItem(spellKey, mage, brief);
                        break;
                    }
                    case "wand": {
                        Wand wand = this.createWand(itemData, mage);
                        if (wand != null) {
                            itemStack = wand.getItem();
                        }
                        break;
                    }
                    case "upgrade": {
                        Wand wand = this.createWand(itemData, mage);
                        if (wand != null) {
                            wand.makeUpgrade();
                            itemStack = wand.getItem();
                        }
                        break;
                    }
                    case "brush": {
                        itemStack = this.createBrushItem(itemData);
                        break;
                    }
                    case "item": {
                        itemStack = this.createGenericItem(itemData);
                        break;
                    }
                    default: {
                        int intAmount;
                        com.elmakers.mine.bukkit.api.block.MaterialAndData currencyIcon;
                        Currency currency = this.currencies.get(itemKey);
                        com.elmakers.mine.bukkit.api.block.MaterialAndData materialAndData = currencyIcon = currency == null ? null : currency.getIcon();
                        if (pieces.length <= 1 || currencyIcon == null) break;
                        itemStack = currencyIcon.getItemStack(1);
                        if (CompatibilityLib.getItemUtils().isEmpty(itemStack)) {
                            this.getLogger().warning("Trying to get a currency item for '" + itemKey + "', which an invalid icon defined");
                            return null;
                        }
                        ItemMeta meta = itemStack.getItemMeta();
                        String name = currency.getName(this.messages);
                        String itemName = this.messages.get("currency." + itemKey + ".item_name", this.messages.get("currency.default.item_name"));
                        itemName = itemName.replace("$type", name);
                        itemName = itemName.replace("$amount", itemData);
                        meta.setDisplayName(itemName);
                        try {
                            intAmount = Integer.parseInt(itemData);
                        }
                        catch (Exception ex) {
                            this.getLogger().warning("Invalid amount '" + itemData + "' in " + currency.getKey() + " cost: " + magicItemKey);
                            if (callback != null) {
                                callback.updated(null);
                            }
                            return null;
                        }
                        String currencyDescription = this.messages.get("currency." + itemKey + ".description", this.messages.get("currency.default.description"));
                        if (currencyDescription.length() > 0) {
                            currencyDescription = currencyDescription.replace("$type", name);
                            currencyDescription = currencyDescription.replace("$amount", itemData);
                            ArrayList<String> lore = new ArrayList<String>();
                            CompatibilityLib.getInventoryUtils().wrapText(CompatibilityLib.getCompatibilityUtils().translateColors(currencyDescription), lore);
                            meta.setLore(lore);
                        }
                        itemStack.setItemMeta(meta);
                        itemStack = CompatibilityLib.getItemUtils().makeReal(itemStack);
                        CompatibilityLib.getItemUtils().makeUnbreakable(itemStack);
                        CompatibilityLib.getItemUtils().hideFlags(itemStack, 63);
                        Object currencyNode = CompatibilityLib.getNBTUtils().createTag(itemStack, "currency");
                        CompatibilityLib.getNBTUtils().setInt(currencyNode, "amount", intAmount);
                        CompatibilityLib.getNBTUtils().setString(currencyNode, "type", itemKey);
                    }
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Error creating item: " + magicItemKey, ex);
            }
        }
        if (itemStack == null && this.items != null) {
            try {
                ItemStack genericItem = this.getGenericItemStack(magicItemKey, amount, callback);
                if (genericItem != null) {
                    return genericItem;
                }
                Wand wand = this.createWand(magicItemKey, mage);
                if (wand != null) {
                    ItemStack wandItem = wand.getItem();
                    if (wandItem != null) {
                        wandItem.setAmount(amount);
                    }
                    if (callback != null) {
                        callback.updated(wandItem);
                    }
                    return wandItem;
                }
                String spellKey = magicItemKey.replace(":", "|");
                itemStack = this.createSpellItem(spellKey, mage, brief);
                if (itemStack != null) {
                    itemStack.setAmount(amount);
                    if (callback != null) {
                        callback.updated(itemStack);
                    }
                    return itemStack;
                }
                itemStack = this.createBrushItem(magicItemKey);
                if (itemStack != null) {
                    itemStack.setAmount(amount);
                }
                if (itemStack == null && (icon = this.getIcon(magicItemKey)) != null) {
                    com.elmakers.mine.bukkit.api.block.MaterialAndData materialAndData = material = disabled ? icon.getItemDisabledMaterial(this.isLegacyIconsEnabled()) : icon.getItemMaterial(this.isLegacyIconsEnabled());
                    if (material != null) {
                        itemStack = material.getItemStack(1);
                    }
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Error creating item: " + magicItemKey, ex);
            }
        }
        if (callback != null) {
            callback.updated(itemStack);
        }
        return itemStack;
    }

    @Override
    @Nullable
    public ItemStack getSpawnEgg(String mobType) {
        com.elmakers.mine.bukkit.entity.EntityData entityData = this.getMob(mobType);
        String customName = null;
        EntityType entityType = null;
        if (entityData == null) {
            entityType = com.elmakers.mine.bukkit.entity.EntityData.parseEntityType(mobType);
        } else {
            entityType = entityData.getType();
            customName = entityData.getName();
        }
        Material eggMaterial = this.getMobEgg(entityType);
        if (eggMaterial == null) {
            this.getLogger().warning("Could not get a mob egg for entity of type " + entityType);
            return null;
        }
        ItemStack spawnEgg = new ItemStack(eggMaterial);
        if (customName != null && !customName.isEmpty()) {
            ItemMeta meta = spawnEgg.getItemMeta();
            String title = this.getMessages().get("general.spawn_egg_title");
            title = title.replace("$entity", customName);
            meta.setDisplayName(title);
            spawnEgg.setItemMeta(meta);
            spawnEgg = CompatibilityLib.getItemUtils().makeReal(spawnEgg);
            Object entityTag = CompatibilityLib.getNBTUtils().createTag(spawnEgg, "EntityTag");
            CompatibilityLib.getNBTUtils().setString(entityTag, "CustomName", "{\"text\":\"" + customName + "\"}");
        }
        return spawnEgg;
    }

    protected ItemStack getGenericItemStack(String magicItemKey, int amount, ItemUpdatedCallback callback) {
        ItemData customItem = this.items.get(magicItemKey);
        if (customItem != null) {
            ItemStack itemStack = customItem.getItemStack(amount);
            if (callback != null) {
                callback.updated(itemStack);
            }
            return itemStack;
        }
        MaterialAndData item = new MaterialAndData(magicItemKey);
        if (item.isValid() && CompatibilityLib.getCompatibilityUtils().isLegacy(item.getMaterial())) {
            short convertData = item.getData() == null ? (short)0 : item.getData();
            item = new MaterialAndData(CompatibilityLib.getCompatibilityUtils().migrateMaterial(item.getMaterial(), (byte)convertData));
        }
        if (item.isValid()) {
            return item.getItemStack(amount, callback);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack createGenericItem(String key) {
        ConfigurationSection template = this.getWandTemplateConfiguration(key);
        if (template == null || !template.contains("icon")) {
            return this.getGenericItemStack(key, 1, null);
        }
        MaterialAndData icon = ConfigurationUtils.toMaterialAndData(template.getString("icon"));
        ItemStack item = icon.getItemStack(1);
        ItemMeta meta = item.getItemMeta();
        if (template.contains("name")) {
            meta.setDisplayName(template.getString("name"));
        } else {
            String name = this.messages.get("wands." + key + ".name");
            if (!name.isEmpty()) {
                meta.setDisplayName(name);
            }
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (template.contains("description")) {
            lore.add(template.getString("description"));
        } else {
            String description = this.messages.get("wands." + key + ".description");
            if (!description.isEmpty()) {
                lore.add(description);
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createUpgrade(String wandKey) {
        Wand wand = Wand.createWand(this, wandKey);
        if (!wand.isUpgrade()) {
            wand.makeUpgrade();
        }
        return wand;
    }

    @Override
    @Nullable
    public ItemStack createSpellItem(String spellKey) {
        return Wand.createSpellItem(spellKey, this, null, true);
    }

    @Override
    @Nullable
    public ItemStack createSpellItem(String spellKey, boolean brief) {
        return Wand.createSpellItem(spellKey, this, null, !brief);
    }

    @Override
    @Nullable
    public ItemStack createSpellItem(String spellKey, com.elmakers.mine.bukkit.api.magic.Mage mage, boolean brief) {
        com.elmakers.mine.bukkit.api.wand.Wand apiWand = mage == null ? null : mage.getActiveWand();
        Wand wand = apiWand instanceof Wand ? (Wand)apiWand : null;
        return Wand.createSpellItem(spellKey, this, mage, wand, !brief);
    }

    @Override
    @Nullable
    public ItemStack createBrushItem(String brushKey) {
        return Wand.createBrushItem(brushKey, this, null, true);
    }

    @Override
    @Nullable
    public ItemStack createBrushItem(String materialKey, com.elmakers.mine.bukkit.api.wand.Wand wand, boolean isItem) {
        return Wand.createBrushItem(materialKey, this, (Wand)wand, isItem, false);
    }

    public boolean isSameItem(ItemStack first, ItemStack second) {
        if (first.getType() != second.getType()) {
            return false;
        }
        DeprecatedUtils deprecatedUtils = CompatibilityLib.getDeprecatedUtils();
        if (deprecatedUtils.getItemDamage(first) != deprecatedUtils.getItemDamage(second)) {
            return false;
        }
        if (first.hasItemMeta() != second.hasItemMeta()) {
            return false;
        }
        if (!first.hasItemMeta()) {
            return true;
        }
        return first.getItemMeta().equals(second.getItemMeta());
    }

    @Override
    public boolean itemsAreEqual(ItemStack first, ItemStack second) {
        return this.itemsAreEqual(first, second, false);
    }

    @Override
    public boolean itemsAreEqual(ItemStack first, ItemStack second, boolean ignoreDamage) {
        String secondName;
        boolean firstIsEmpty = CompatibilityLib.getItemUtils().isEmpty(first);
        boolean secondIsEmpty = CompatibilityLib.getItemUtils().isEmpty(second);
        if (secondIsEmpty && firstIsEmpty) {
            return true;
        }
        if (secondIsEmpty || firstIsEmpty) {
            return false;
        }
        if (first.getType() != second.getType()) {
            return false;
        }
        DeprecatedUtils deprecatedUtils = CompatibilityLib.getDeprecatedUtils();
        if (!ignoreDamage && deprecatedUtils.getItemDamage(first) != deprecatedUtils.getItemDamage(second)) {
            return false;
        }
        boolean firstIsWand = Wand.isWandOrUpgrade(first);
        boolean secondIsWand = Wand.isWandOrUpgrade(second);
        if (firstIsWand || secondIsWand) {
            if (!firstIsWand || !secondIsWand) {
                return false;
            }
            Wand firstWand = this.getWand(CompatibilityLib.getItemUtils().getCopy(first));
            Wand secondWand = this.getWand(CompatibilityLib.getItemUtils().getCopy(second));
            String firstTemplate = firstWand.getTemplateKey();
            String secondTemplate = secondWand.getTemplateKey();
            if (firstTemplate == null || secondTemplate == null) {
                return false;
            }
            return firstTemplate.equalsIgnoreCase(secondTemplate);
        }
        String firstSpellKey = Wand.getSpell(first);
        String secondSpellKey = Wand.getSpell(second);
        if (firstSpellKey != null || secondSpellKey != null) {
            if (firstSpellKey == null || secondSpellKey == null) {
                return false;
            }
            return firstSpellKey.equalsIgnoreCase(secondSpellKey);
        }
        String firstBrushKey = Wand.getBrush(first);
        String secondBrushKey = Wand.getBrush(second);
        if (firstBrushKey != null || secondBrushKey != null) {
            if (firstBrushKey == null || secondBrushKey == null) {
                return false;
            }
            return firstBrushKey.equalsIgnoreCase(secondBrushKey);
        }
        String firstName = first.hasItemMeta() ? first.getItemMeta().getDisplayName() : null;
        String string = secondName = second.hasItemMeta() ? second.getItemMeta().getDisplayName() : null;
        if (!Objects.equals(firstName, secondName)) {
            return false;
        }
        MaterialAndData firstData = new MaterialAndData(first);
        MaterialAndData secondData = new MaterialAndData(second);
        return firstData.equals(secondData);
    }

    @Override
    public Set<String> getWandPathKeys() {
        return WandUpgradePath.getPathKeys();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.WandUpgradePath getPath(String key) {
        return WandUpgradePath.getPath(key);
    }

    @Override
    @Nullable
    public ItemStack deserialize(ConfigurationSection root, String key) {
        ItemStack item;
        ConfigurationSection itemSection = root.getConfigurationSection(key);
        if (itemSection == null) {
            return null;
        }
        if (itemSection.getInt("amount", 0) == 0) {
            itemSection.set("amount", (Object)1);
        }
        if ((item = itemSection.getItemStack("item")) == null) {
            return null;
        }
        if (itemSection.contains("wand")) {
            if (CompatibilityLib.getItemUtils().isEmpty(item)) {
                item.setType(Wand.DefaultWandMaterial);
            }
            item = CompatibilityLib.getItemUtils().makeReal(item);
            Wand.configToItem(itemSection, item);
        } else if (itemSection.contains("spell")) {
            item = CompatibilityLib.getItemUtils().makeReal(item);
            Object spellNode = CompatibilityLib.getNBTUtils().createTag(item, "spell");
            CompatibilityLib.getNBTUtils().setString(spellNode, "key", itemSection.getString("spell"));
            if (itemSection.contains("skill")) {
                CompatibilityLib.getNBTUtils().setString(item, "skill", "true");
            }
        } else if (itemSection.contains("brush")) {
            item = CompatibilityLib.getItemUtils().makeReal(item);
            CompatibilityLib.getNBTUtils().setString(item, "brush", itemSection.getString("brush"));
        }
        return item;
    }

    @Override
    public void serialize(ConfigurationSection root, String key, ItemStack item) {
        ConfigurationSection itemSection = root.createSection(key);
        itemSection.set("item", (Object)item);
        if (Wand.isWandOrUpgrade(item)) {
            ConfigurationSection stateNode = itemSection.createSection("wand");
            Wand.itemToConfig(item, stateNode);
        } else if (Wand.isSpell(item)) {
            itemSection.set("spell", (Object)Wand.getSpell(item));
            if (Wand.isSkill(item)) {
                itemSection.set("skill", (Object)"true");
            }
        } else if (Wand.isBrush(item)) {
            itemSection.set("brush", (Object)Wand.getBrush(item));
        }
    }

    @Override
    public void disableItemSpawn() {
        this.entityController.setDisableItemSpawn(true);
    }

    @Override
    public void enableItemSpawn() {
        this.entityController.setDisableItemSpawn(false);
    }

    @Override
    public void setForceSpawn(boolean force) {
        this.entityController.setForceSpawn(force);
    }

    public HeroesManager getHeroes() {
        return this.heroesManager;
    }

    @Nullable
    public ManaController getManaController(String mageClass) {
        if (mageClass != null) {
            if (this.heroesManager != null && this.heroesManager.usesMana(mageClass)) {
                return this.heroesManager;
            }
            if (this.aureliumSkillsManager != null && this.aureliumSkillsManager.useMana(mageClass)) {
                return this.aureliumSkillsManager;
            }
            if (this.skillAPIManager != null && this.skillAPIManager.usesMana(mageClass)) {
                return this.skillAPIManager;
            }
        }
        return null;
    }

    public String getDefaultSkillIcon() {
        return this.defaultSkillIcon;
    }

    public int getSkillInventoryRows() {
        return this.skillInventoryRows;
    }

    public boolean usePermissionSkills() {
        return this.skillsUsePermissions;
    }

    public boolean useHeroesSkills() {
        return this.skillsUseHeroes;
    }

    @Override
    public void addFlightExemption(Player player, int duration) {
        this.ncpManager.addFlightExemption(player, duration);
        CompatibilityLib.getCompatibilityUtils().addFlightExemption(player, duration * 20 / 1000);
    }

    @Override
    public void addFlightExemption(Player player) {
        this.ncpManager.addFlightExemption(player);
    }

    @Override
    public void removeFlightExemption(Player player) {
        this.ncpManager.removeFlightExemption(player);
    }

    public String getExtraSchematicFilePath() {
        return this.extraSchematicFilePath;
    }

    @Override
    public void warpPlayerToServer(Player player, String server, String warp) {
        Mage mage = this.getMage(player);
        mage.setDestinationWarp(warp);
        this.info("Cross-server warping " + player.getName() + " to warp " + warp, 1);
        this.sendPlayerToServer(player, server);
    }

    @Override
    public void sendPlayerToServer(final Player player, final String server) {
        MageDataCallback callback = new MageDataCallback(){

            @Override
            public void run(MageData data) {
                Bukkit.getScheduler().runTaskLater((Plugin)MagicController.this.plugin, (Runnable)new ChangeServerTask((Plugin)MagicController.this.plugin, player, server), 1L);
            }
        };
        this.info("Moving " + player.getName() + " to server " + server, 1);
        Mage mage = this.getRegisteredMage((Entity)player);
        if (mage != null) {
            this.playerQuit(mage, callback);
        } else {
            callback.run(null);
        }
    }

    @Override
    public boolean isDisguised(Entity entity) {
        try {
            return this.libsDisguiseEnabled && this.libsDisguiseManager != null && entity != null && this.libsDisguiseManager.isDisguised(entity);
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.SEVERE, "Error checking for a disguised mob, disabling libsDisguises integration until next restart", ex);
            this.libsDisguiseEnabled = false;
            return false;
        }
    }

    @Override
    public boolean hasDisguises() {
        return this.libsDisguiseEnabled && this.libsDisguiseManager != null;
    }

    @Override
    public boolean disguise(Entity entity, ConfigurationSection configuration) {
        if (!this.libsDisguiseEnabled || this.libsDisguiseManager == null || entity == null) {
            return false;
        }
        try {
            return this.libsDisguiseManager.disguise(entity, configuration);
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.SEVERE, "Error trying to disguise a mob, disabling libsDisguises integration until next restart", ex);
            this.libsDisguiseEnabled = false;
            return false;
        }
    }

    @Override
    @Deprecated
    public boolean applyModel(Entity entity, ConfigurationSection configuration) {
        if (this.modelEngineManager == null || entity == null) {
            return false;
        }
        return this.modelEngineManager.applyModel(entity, configuration);
    }

    @Override
    public ModelEngineManager getModelEngine() {
        return this.modelEngineManager;
    }

    @Override
    public boolean isPathUpgradingEnabled() {
        return this.autoPathUpgradesEnabled;
    }

    @Override
    public boolean isSpellUpgradingEnabled() {
        return this.autoSpellUpgradesEnabled;
    }

    @Override
    public boolean isSpellProgressionEnabled() {
        return this.spellProgressionEnabled;
    }

    public boolean isLoaded() {
        return this.loaded && !this.shuttingDown;
    }

    public boolean isDataLoaded() {
        return this.loaded && this.dataLoaded && !this.shuttingDown;
    }

    public boolean areLocksProtected() {
        return this.protectLocked;
    }

    public boolean isContainer(Block block) {
        return block != null && this.containerMaterials.testBlock(block);
    }

    public boolean isMeleeWeapon(ItemStack item) {
        return item != null && this.meleeMaterials.testItem(item);
    }

    public boolean isWearable(ItemStack item) {
        return item != null && this.wearableMaterials.testItem(item);
    }

    public boolean isInteractible(Block block) {
        return block != null && this.interactibleMaterials.testBlock(block);
    }

    public boolean isSpellDroppingEnabled() {
        return this.spellDroppingEnabled;
    }

    @Override
    public boolean isSPEnabled() {
        return this.spEnabled;
    }

    @Override
    public boolean isSPEarnEnabled() {
        return this.spEnabled && this.spEarnEnabled;
    }

    @Override
    public int getSPMaximum() {
        return (int)this.getCurrency("sp").getMaxValue();
    }

    @Override
    public boolean isVaultCurrencyEnabled() {
        return VaultController.hasEconomy();
    }

    @Override
    public void depositVaultCurrency(OfflinePlayer player, double amount) {
        VaultController.getInstance().depositPlayer(player, amount);
    }

    @Override
    public void deleteMage(final String id) {
        final Mage mage = this.getRegisteredMage(id);
        if (mage != null) {
            this.playerQuit(mage, new MageDataCallback(){

                @Override
                public void run(MageData data) {
                    MagicController.this.info("Deleted mage id " + id);
                    MagicController.this.mageDataStore.delete(id);
                    Player player = mage.getPlayer();
                    if (player != null && player.isOnline()) {
                        MagicController.this.getMage(player);
                    }
                }
            });
        } else {
            this.info("Deleted offline mage id " + id);
            this.mageDataStore.delete(id);
        }
    }

    public long getPhysicsTimeout() {
        if (this.physicsHandler != null) {
            return this.physicsHandler.getTimeout();
        }
        return 0L;
    }

    @Override
    @Nullable
    public String getSpell(ItemStack item) {
        return Wand.getSpell(item);
    }

    @Override
    @Nullable
    public String getSpellArgs(ItemStack item) {
        return Wand.getSpellArgs(item);
    }

    @Override
    public Set<String> getNPCKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (EntityData entityData : this.mobs.getMobs()) {
            if (!entityData.isNPC() || entityData.isHidden()) continue;
            keys.add(entityData.getKey());
        }
        return keys;
    }

    @Override
    public Set<String> getMobKeys(boolean showHidden) {
        if (showHidden) {
            return this.mobs.getKeys();
        }
        return new HashSet<String>(this.mobs.getMobs().stream().filter(mob -> !mob.isHidden()).map(EntityData::getKey).collect(Collectors.toList()));
    }

    @Override
    public Set<String> getMobKeys() {
        return this.getMobKeys(false);
    }

    @Override
    @Nullable
    public Entity spawnMob(String key, Location location) {
        com.elmakers.mine.bukkit.entity.EntityData mobType = this.mobs.get(key);
        if (mobType != null) {
            return mobType.spawn(location);
        }
        EntityType entityType = com.elmakers.mine.bukkit.entity.EntityData.parseEntityType(key);
        if (entityType == null) {
            return null;
        }
        return location.getWorld().spawnEntity(location, entityType);
    }

    @Override
    @Nullable
    public EntityData getMob(Entity entity) {
        return this.mobs.getEntityData(entity);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.entity.EntityData getMob(String key) {
        EntityType entityType;
        com.elmakers.mine.bukkit.entity.EntityData mob;
        if (key == null) {
            return null;
        }
        com.elmakers.mine.bukkit.entity.EntityData entityData = mob = this.mobs == null ? null : this.mobs.get(key);
        if (mob == null && this.mobs != null && (entityType = com.elmakers.mine.bukkit.entity.EntityData.parseEntityType(key)) != null) {
            mob = this.mobs.getDefaultMob(entityType);
        }
        return mob;
    }

    @Override
    @Nullable
    public EntityData getMob(ConfigurationSection parameters) {
        String mobType = parameters.getString("type");
        com.elmakers.mine.bukkit.entity.EntityData mob = null;
        if (mobType != null && !mobType.isEmpty()) {
            mob = this.getMob(mobType);
        }
        if (mob != null && !parameters.getKeys(false).isEmpty()) {
            mob = mob.clone();
            ConfigurationSection effectiveParameters = parameters;
            ConfigurationSection defaultConfig = mob.getConfiguration();
            if (defaultConfig != null && !defaultConfig.getKeys(false).isEmpty()) {
                effectiveParameters = ConfigurationUtils.cloneConfiguration(mob.getConfiguration());
                String originalType = effectiveParameters.getString("type", mobType);
                effectiveParameters = ConfigurationUtils.addConfigurations(effectiveParameters, parameters);
                effectiveParameters.set("type", (Object)originalType);
            }
            mob.load(effectiveParameters);
        } else if (mob == null) {
            mob = new com.elmakers.mine.bukkit.entity.EntityData((MageController)this, parameters);
        }
        return mob;
    }

    @Override
    @Nullable
    public EntityData getMobByName(String name) {
        return this.mobs.getByName(name);
    }

    @Override
    public EntityData loadMob(ConfigurationSection configuration) {
        return new com.elmakers.mine.bukkit.entity.EntityData((MageController)this, configuration);
    }

    @Override
    @Nullable
    public Entity replaceMob(Entity targetEntity, EntityData replaceType, boolean force, CreatureSpawnEvent.SpawnReason reason) {
        EntityData targetData = this.getMob(targetEntity);
        EntityData newData = replaceType;
        if (targetData != null) {
            newData = targetData.clone();
            ConfigurationSection effectiveParameters = ConfigurationUtils.cloneConfiguration(newData.getConfiguration());
            ConfigurationSection newParameters = replaceType.getConfiguration();
            effectiveParameters = ConfigurationUtils.addConfigurations(effectiveParameters, newParameters);
            effectiveParameters.set("type", (Object)replaceType.getType().name());
            newData.load(effectiveParameters);
        }
        if (force) {
            this.setForceSpawn(true);
        }
        Entity spawnedEntity = null;
        try {
            spawnedEntity = newData.spawn(targetEntity.getLocation(), reason);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (force) {
            this.setForceSpawn(false);
        }
        if (spawnedEntity != null) {
            targetEntity.remove();
        }
        return spawnedEntity;
    }

    @Override
    public Set<String> getItemKeys() {
        return this.items.getKeys();
    }

    @Nullable
    public com.elmakers.mine.bukkit.api.item.ItemData getItemByMaterial(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        com.elmakers.mine.bukkit.api.item.ItemData data = this.getItem(itemStack);
        if (data == null) {
            data = this.getItem(itemStack.getType().name().toLowerCase());
        }
        return data;
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.item.ItemData getItem(String key) {
        return this.items.get(key);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.item.ItemData getItem(ItemStack match) {
        return this.items.get(match);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.item.ItemData getOrCreateItem(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.items.getOrCreate(key);
    }

    @Override
    @Nullable
    @Deprecated
    public com.elmakers.mine.bukkit.api.item.ItemData getOrCreateItemOrWand(String key) {
        return this.getOrCreateItem(key);
    }

    @Override
    @Nullable
    @Deprecated
    public com.elmakers.mine.bukkit.api.item.ItemData getOrCreateMagicItem(String key) {
        return this.getOrCreateItem(key);
    }

    public void updateOnEquip(ItemStack stack) {
        this.items.updateOnEquip(stack);
    }

    @Override
    public com.elmakers.mine.bukkit.api.item.ItemData createItemData(ItemStack itemStack) {
        return new ItemData(itemStack, (MageController)this);
    }

    @Nullable
    public String getLockKey(ItemStack itemStack) {
        com.elmakers.mine.bukkit.api.item.ItemData data = this.getItemByMaterial(itemStack);
        if (data != null && data.isLocked()) {
            return data.getKey();
        }
        return null;
    }

    @Override
    public void unloadItemTemplate(String key) {
        this.items.remove(key);
    }

    @Override
    public void loadItemTemplate(String key, ConfigurationSection configuration) {
        this.items.loadItem(key, configuration);
    }

    @Override
    @Nullable
    public Double getWorth(ItemStack item) {
        return this.getWorth(item, "currency");
    }

    @Override
    @Nullable
    public Double getWorth(ItemStack item, String inCurrencyKey) {
        Currency toCurrency = this.getCurrency(inCurrencyKey);
        if (toCurrency == null || toCurrency.getWorth() == 0.0) {
            return null;
        }
        String spellKey = Wand.getSpell(item);
        if (spellKey != null) {
            Currency spellPointCurrency = this.getCurrency("sp");
            SpellTemplate spell = this.getSpellTemplate(spellKey);
            if (spell != null) {
                double spWorth = spellPointCurrency == null ? 1.0 : spellPointCurrency.getWorth();
                return spell.getWorth() * spWorth / toCurrency.getWorth();
            }
        }
        int amount = item.getAmount();
        item.setAmount(1);
        ItemData configuredItem = this.items.get(item);
        item.setAmount(amount);
        if (configuredItem == null) {
            Wand wand = this.getIfWand(item);
            if (wand == null) {
                Currency currency;
                CurrencyAmount currencyAmount = CompatibilityLib.getInventoryUtils().getCurrencyAmount(item);
                Currency currency2 = currency = currencyAmount == null ? null : this.getCurrency(currencyAmount.getType());
                if (currency != null) {
                    return currency.getWorth() * (double)currencyAmount.getAmount() * (double)item.getAmount() / toCurrency.getWorth();
                }
                return null;
            }
            return (double)wand.getWorth() / toCurrency.getWorth();
        }
        return configuredItem.getWorth() * (double)amount / toCurrency.getWorth();
    }

    @Override
    @Nullable
    public Double getEarns(ItemStack item) {
        return this.getEarns(item, "currency");
    }

    @Override
    @Nullable
    public Double getEarns(ItemStack item, String inCurrencyKey) {
        Currency toCurrency = this.getCurrency(inCurrencyKey);
        if (toCurrency == null || toCurrency.getWorth() == 0.0) {
            return null;
        }
        int amount = item.getAmount();
        item.setAmount(1);
        ItemData configuredItem = this.items.get(item);
        item.setAmount(amount);
        if (configuredItem == null) {
            return null;
        }
        return configuredItem.getEarns() * (double)amount / toCurrency.getWorth();
    }

    public boolean isInventoryBackupEnabled() {
        return this.backupInventories;
    }

    @Override
    @Nullable
    public String getBlockSkin(Material blockType) {
        return this.blockSkins.get(blockType);
    }

    @Override
    @Nonnull
    public Random getRandom() {
        return random;
    }

    @Override
    public boolean sendResourcePackToAllPlayers(CommandSender sender) {
        return this.resourcePacks.sendResourcePackToAllPlayers(sender);
    }

    @Override
    public boolean promptResourcePack(Player player) {
        return this.resourcePacks.checkPromptResourcePack(player);
    }

    public boolean promptResourcePack(Player player, String resourcePack) {
        return this.resourcePacks.checkPromptResourcePack(player, resourcePack);
    }

    @Override
    public boolean promptNoResourcePack(Player player) {
        return this.resourcePacks.promptNoResourcePack(player);
    }

    @Override
    public boolean sendResourcePack(Player player) {
        return this.resourcePacks.sendResourcePack(player);
    }

    @Override
    public void checkResourcePack(CommandSender sender) {
        this.resourcePacks.clearChecked();
        this.checkResourcePack(sender, false, true);
    }

    public boolean checkResourcePack(CommandSender sender, boolean quiet) {
        return this.checkResourcePack(sender, quiet, false);
    }

    public boolean checkResourcePack(CommandSender sender, boolean quiet, boolean force) {
        return this.resourcePacks.checkResourcePack(sender, quiet, force, false);
    }

    @Override
    public boolean isResourcePackEnabled() {
        return this.resourcePacks.isResourcePackEnabled();
    }

    @Override
    @Nullable
    public Material getMobEgg(EntityType mobType) {
        return this.mobEggs.get(mobType);
    }

    @Override
    @Nullable
    public String getMobSkin(EntityType mobType) {
        return this.mobSkins.get(mobType);
    }

    @Override
    @Nullable
    public String getPlayerSkin(Player player) {
        return this.libsDisguiseManager == null ? null : this.libsDisguiseManager.getSkin(player);
    }

    @Override
    @Nonnull
    public ItemStack getURLSkull(String url) {
        try {
            ItemStack stack = this.getURLSkull(new URL(url), CompatibilityConstants.SKULL_UUID);
            return stack == null ? new ItemStack(Material.AIR) : stack;
        }
        catch (MalformedURLException e) {
            Bukkit.getLogger().log(Level.WARNING, "Malformed URL: " + url, e);
            return new ItemStack(Material.AIR);
        }
    }

    @Nullable
    private ItemStack getURLSkull(URL url, UUID id) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack skull = skullType.getItemStack(1);
        return CompatibilityLib.getInventoryUtils().setSkullURL(skull, url, id);
    }

    @Override
    public void setSkullOwner(Skull skull, String ownerName) {
        CompatibilityLib.getDeprecatedUtils().setOwner(skull, ownerName);
    }

    @Override
    public void setSkullOwner(Skull skull, UUID uuid) {
        CompatibilityLib.getDeprecatedUtils().setOwner(skull, uuid);
    }

    @Override
    @Nonnull
    @Deprecated
    public ItemStack getSkull(String ownerName, String itemName) {
        return this.getSkull(ownerName, itemName, null);
    }

    @Override
    @Nonnull
    public ItemStack getSkull(String ownerName, String itemName, final ItemUpdatedCallback callback) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            ItemStack air = new ItemStack(Material.AIR);
            if (callback != null) {
                callback.updated(air);
            }
            return air;
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        SkullLoadedCallback skullCallback = null;
        if (callback != null) {
            skullCallback = new SkullLoadedCallback(){

                @Override
                public void updated(ItemStack itemStack) {
                    callback.updated(itemStack);
                }
            };
        }
        CompatibilityLib.getDeprecatedUtils().setSkullOwner(skull, ownerName, skullCallback);
        return skull;
    }

    @Override
    @Nonnull
    public ItemStack getSkull(UUID uuid, String itemName, final ItemUpdatedCallback callback) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        SkullLoadedCallback skullCallback = null;
        if (callback != null) {
            skullCallback = new SkullLoadedCallback(){

                @Override
                public void updated(ItemStack itemStack) {
                    callback.updated(itemStack);
                }
            };
        }
        CompatibilityLib.getDeprecatedUtils().setSkullOwner(skull, uuid, skullCallback);
        return skull;
    }

    @Override
    @Nonnull
    public ItemStack getSkull(Player player, String itemName) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        CompatibilityLib.getDeprecatedUtils().setSkullOwner(skull, player.getName(), null);
        return skull;
    }

    @Override
    @Nonnull
    @Deprecated
    public ItemStack getSkull(Entity entity, String itemName) {
        if (entity instanceof Player) {
            return this.getSkull((Player)entity, itemName);
        }
        return this.getSkull(entity, itemName, null);
    }

    @Override
    @Nonnull
    public ItemStack getSkull(Entity entity, String itemName, final ItemUpdatedCallback callback) {
        String ownerName = null;
        MaterialAndData skullType = this.skullItems.get(entity.getType());
        if (skullType == null) {
            ownerName = this.getMobSkin(entity.getType());
            skullType = this.skullItems.get(EntityType.PLAYER);
            if (skullType == null || ownerName == null) {
                ItemStack air = new ItemStack(Material.AIR);
                if (callback != null) {
                    callback.updated(air);
                }
                return air;
            }
        }
        if (entity instanceof Player) {
            ownerName = entity.getName();
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        if (ownerName != null) {
            SkullLoadedCallback skullCallback = null;
            if (callback != null) {
                skullCallback = new SkullLoadedCallback(){

                    @Override
                    public void updated(ItemStack itemStack) {
                        callback.updated(itemStack);
                    }
                };
            }
            if (ownerName.startsWith("http")) {
                skull = CompatibilityLib.getInventoryUtils().setSkullURL(skull, ownerName);
                if (callback != null) {
                    callback.updated(skull);
                }
            } else {
                CompatibilityLib.getDeprecatedUtils().setSkullOwner(skull, ownerName, skullCallback);
            }
        } else if (callback != null) {
            callback.updated(skull);
        }
        return skull;
    }

    @Override
    @Nonnull
    public ItemStack getMap(int mapId) {
        short durability = CompatibilityLib.isCurrentVersion() ? (short)0 : (short)mapId;
        ItemStack mapItem = CompatibilityLib.getDeprecatedUtils().createItemStack(DefaultMaterials.getFilledMap(), 1, durability);
        if (CompatibilityLib.isCurrentVersion()) {
            mapItem = CompatibilityLib.getItemUtils().makeReal(mapItem);
            CompatibilityLib.getNBTUtils().setInt(mapItem, "map", mapId);
        }
        return mapItem;
    }

    @Override
    public void managePlayerData(boolean external, boolean backupInventories) {
        this.savePlayerData = !external;
        this.externalPlayerData = external;
        this.backupInventories = backupInventories;
    }

    public void initializeWorldGuardFlags() {
        this.worldGuardManager.initializeFlags((Plugin)this.plugin);
    }

    @Override
    public String getDefaultWandTemplate() {
        return Wand.DEFAULT_WAND_TEMPLATE;
    }

    @Override
    @Nullable
    public Object getWandProperty(ItemStack item, String key) {
        com.elmakers.mine.bukkit.wand.WandTemplate template;
        Preconditions.checkNotNull((Object)key, (Object)"key");
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return null;
        }
        Object wandNode = CompatibilityLib.getNBTUtils().getTag(item, Wand.WAND_KEY);
        if (wandNode == null) {
            return null;
        }
        Object value = CompatibilityLib.getInventoryUtils().getMetaObject(wandNode, key);
        if (value == null && (template = this.getWandTemplate(CompatibilityLib.getNBTUtils().getString(wandNode, "template"))) != null) {
            value = template.getProperty(key);
        }
        return value;
    }

    @Override
    public <T> T getWandProperty(ItemStack item, String key, T defaultValue) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        if (CompatibilityLib.getItemUtils().isEmpty(item)) {
            return defaultValue;
        }
        Object wandNode = CompatibilityLib.getNBTUtils().getTag(item, Wand.WAND_KEY);
        if (wandNode == null) {
            return defaultValue;
        }
        Class<?> clazz = defaultValue.getClass();
        Object value = CompatibilityLib.getInventoryUtils().getMetaObject(wandNode, key);
        if (value != null) {
            if (clazz.isInstance(value)) {
                return (T)clazz.cast(value);
            }
            return defaultValue;
        }
        String tplName = CompatibilityLib.getNBTUtils().getString(wandNode, "template");
        com.elmakers.mine.bukkit.wand.WandTemplate template = this.getWandTemplate(tplName);
        if (template != null) {
            return template.getProperty(key, defaultValue);
        }
        return defaultValue;
    }

    @Nonnull
    public MageIdentifier getMageIdentifier() {
        return this.mageIdentifier;
    }

    public void setMageIdentifier(@Nonnull MageIdentifier mageIdentifier) {
        Preconditions.checkNotNull((Object)mageIdentifier, (Object)"mageIdentifier");
        this.mageIdentifier = mageIdentifier;
    }

    @Override
    public String getHeroesSkillPrefix() {
        return this.heroesSkillPrefix;
    }

    public List<AttributeProvider> getAttributeProviders() {
        return this.attributeProviders;
    }

    @Override
    @Nullable
    public MagicAttribute getAttribute(String attributeKey) {
        return this.attributes.get(attributeKey);
    }

    @Override
    public boolean createLight(Location location, int lightLevel, boolean async) {
        if (this.lightAPIManager == null) {
            return false;
        }
        long blockId = com.elmakers.mine.bukkit.block.BlockData.getBlockId(location);
        String chunkId = this.getChunkKey(location);
        Integer chunkRefs = this.lightChunks.get(chunkId);
        if (chunkRefs == null) {
            this.lightChunks.put(chunkId, 1);
        } else {
            this.lightChunks.put(chunkId, chunkRefs + 1);
        }
        Integer refCount = this.lightBlocks.get(blockId);
        if (refCount != null) {
            this.lightBlocks.put(blockId, refCount + 1);
            return false;
        }
        this.lightBlocks.put(blockId, 1);
        return this.lightAPIManager.createLight(location, lightLevel, async);
    }

    @Override
    public boolean deleteLight(Location location, boolean async) {
        if (this.lightAPIManager == null) {
            return false;
        }
        long blockId = com.elmakers.mine.bukkit.block.BlockData.getBlockId(location);
        Integer refCount = this.lightBlocks.get(blockId);
        String chunkId = this.getChunkKey(location);
        Integer chunkRefs = this.lightChunks.get(chunkId);
        if (chunkRefs != null) {
            if (chunkRefs <= 1) {
                this.lightChunks.remove(chunkId);
            } else {
                this.lightChunks.put(chunkId, chunkRefs - 1);
            }
        }
        if (refCount != null) {
            if (refCount <= 1) {
                this.lightBlocks.remove(blockId);
            } else {
                this.lightBlocks.put(blockId, refCount - 1);
                return false;
            }
        }
        return this.lightAPIManager.deleteLight(location, async);
    }

    @Override
    public boolean updateLight(Location location) {
        return this.updateLight(location, true);
    }

    @Override
    public boolean updateLight(Location location, boolean force) {
        String chunkId;
        Integer chunkRefs;
        if (this.lightAPIManager == null) {
            return false;
        }
        if (!force && (chunkRefs = this.lightChunks.get(chunkId = this.getChunkKey(location))) != null) {
            return false;
        }
        return this.lightAPIManager.updateChunks(location);
    }

    @Override
    public int getLightCount() {
        return this.lightBlocks.size();
    }

    @Override
    public boolean isLightingAvailable() {
        return this.lightAPIManager != null;
    }

    @Override
    @Nullable
    public String checkRequirements(@Nonnull MageContext context, @Nullable Collection<Requirement> requirements) {
        if (requirements == null) {
            return null;
        }
        for (Requirement requirement : requirements) {
            String type = requirement.getType();
            RequirementsProcessor processor = this.requirementProcessors.get(type);
            if (processor == null || processor.checkRequirement(context, requirement)) continue;
            String message = processor.getRequirementDescription(context, requirement);
            if (message == null || message.isEmpty()) {
                message = this.messages.get("requirements.unknown");
            }
            return message;
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<String> getLoadedExamples() {
        ArrayList<String> examples = new ArrayList<String>();
        if (this.exampleDefaults != null && !this.exampleDefaults.isEmpty()) {
            examples.add(this.exampleDefaults);
        }
        if (this.addExamples != null) {
            examples.addAll(this.addExamples);
        }
        return examples;
    }

    @Override
    @Nullable
    public String getExample() {
        return this.exampleDefaults != null && this.exampleDefaults.isEmpty() ? null : this.exampleDefaults;
    }

    @Override
    @Nonnull
    public Collection<String> getExamples() {
        ArrayList<String> examples;
        block15: {
            examples = new ArrayList<String>();
            try {
                CodeSource src = MagicController.class.getProtectionDomain().getCodeSource();
                if (src == null) break block15;
                URL jar = src.getLocation();
                try (InputStream is = jar.openStream();
                     ZipInputStream zip = new ZipInputStream(is);){
                    ZipEntry e;
                    while ((e = zip.getNextEntry()) != null) {
                        String name = e.getName();
                        if (name.equals("examples/") || name.equals("examples/localizations/") || name.equals("examples/versions/") || !name.startsWith("examples/") || !name.endsWith("/")) continue;
                        examples.add(name.replace("examples/", "").replace("/", ""));
                    }
                }
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error scanning example files", ex);
            }
        }
        examples.addAll(this.getDownloadedExternalExamples());
        return examples;
    }

    @Override
    @Nonnull
    public Collection<String> getLocalizations() {
        ArrayList<String> examples;
        block15: {
            examples = new ArrayList<String>();
            try {
                CodeSource src = MagicController.class.getProtectionDomain().getCodeSource();
                if (src == null) break block15;
                URL jar = src.getLocation();
                try (InputStream is = jar.openStream();
                     ZipInputStream zip = new ZipInputStream(is);){
                    ZipEntry e;
                    while ((e = zip.getNextEntry()) != null) {
                        String name = e.getName();
                        if (name.equals("examples/") || name.equals("examples/localizations/") || !name.startsWith("examples/localizations/messages.") || !name.endsWith(".yml")) continue;
                        examples.add(name.replace("examples/localizations/messages.", "").replace(".yml", ""));
                    }
                }
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error scanning example files", ex);
            }
        }
        return examples;
    }

    @Override
    @Nonnull
    public Collection<String> getExternalExamples() {
        Set<String> examples = this.getDownloadedExternalExamples();
        examples.addAll(this.builtinExternalExamples.keySet());
        return examples;
    }

    public Set<String> getDownloadedExternalExamples() {
        HashSet<String> examples = new HashSet<String>();
        File examplesFolder = new File(this.getPlugin().getDataFolder(), "examples");
        if (examplesFolder.exists()) {
            for (File file : examplesFolder.listFiles()) {
                if (!file.isDirectory() || file.getName().contains(".")) continue;
                examples.add(file.getName());
            }
        }
        return examples;
    }

    public void updateExternalExamples(CommandSender sender) {
        Set<String> examples = this.getDownloadedExternalExamples();
        if (examples.isEmpty()) {
            this.loadConfiguration(sender);
            return;
        }
        HashSet<String> loadedExamples = new HashSet<String>(this.getLoadedExamples());
        sender.sendMessage(this.getMessages().get("commands.mconfig.example.fetch.wait_all").replace("$count", Integer.toString(examples.size())));
        UpdateAllExamplesCallback callback = new UpdateAllExamplesCallback(sender, this);
        for (String exampleKey : examples) {
            if (!loadedExamples.contains(exampleKey)) {
                sender.sendMessage(this.getMessages().get("commands.mconfig.example.fetch.skip").replace("$example", exampleKey));
                continue;
            }
            String url = this.getExternalExampleURL(exampleKey);
            if (url == null || url.isEmpty()) continue;
            callback.loading();
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new FetchExampleRunnable(this, sender, exampleKey, url, callback, true));
        }
        callback.check();
    }

    @Override
    @Nullable
    public String getExternalExampleURL(String exampleKey) {
        String url = null;
        File exampleFolder = new File(this.getPlugin().getDataFolder(), "examples");
        File urlFile = new File(exampleFolder = new File(exampleFolder, exampleKey), "url.txt");
        if (urlFile.exists()) {
            try {
                url = new String(Files.readAllBytes(Paths.get(urlFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Error loading example url from file: " + urlFile.getAbsolutePath(), ex);
            }
        }
        if (url == null) {
            url = this.builtinExternalExamples.get(exampleKey);
        }
        return url;
    }

    @Override
    public double getBlockDurability(@Nonnull Block block) {
        Integer reinforcement;
        double durability = CompatibilityLib.getCompatibilityUtils().getDurability(block.getType());
        if (this.citadelManager != null && (reinforcement = this.citadelManager.getDurability(block.getLocation())) != null) {
            durability += (double)reinforcement.intValue();
        }
        return durability;
    }

    @Override
    @Nonnull
    public String getSkillsSpell() {
        return this.skillsSpell;
    }

    @Override
    @Nonnull
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(@Nonnull String effectKey) {
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effectList = this.effects.get(effectKey);
        if (effectList == null) {
            effectList = new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return effectList;
    }

    @Override
    public void playEffects(@Nonnull String effectKey, @Nonnull Location sourceLocation, @Nonnull Location targetLocation) {
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effectPlayers = this.effects.get(effectKey);
        if (effectPlayers == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : effectPlayers) {
            player.start(sourceLocation, targetLocation);
        }
    }

    @Override
    public void playEffects(@Nonnull String effectKey, @Nonnull EffectContext context) {
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effectPlayers = this.effects.get(effectKey);
        if (effectPlayers == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : effectPlayers) {
            player.start(context);
        }
    }

    @Override
    @Nonnull
    public Collection<String> getEffectKeys() {
        return this.effects.keySet();
    }

    @Override
    public Collection<String> getRecipeKeys() {
        return this.crafting.getRecipeKeys();
    }

    @Override
    public Collection<String> getArenaKeys() {
        return this.arenaController.getArenaKeys();
    }

    @Override
    public Collection<String> getArenaTemplateKeys() {
        return this.arenaController.getArenaTemplateKeys();
    }

    @Override
    public Collection<String> getAutoDiscoverRecipeKeys() {
        return this.crafting.getAutoDiscoverRecipeKeys();
    }

    public void checkVanished(Player player) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!mage.isVanished()) continue;
            CompatibilityLib.getDeprecatedUtils().hidePlayer((Plugin)this.plugin, player, mage.getPlayer());
        }
    }

    @Override
    public void logBlockChange(@Nonnull com.elmakers.mine.bukkit.api.magic.Mage mage, @Nonnull BlockState priorState, @Nonnull BlockState newState) {
        Entity entity;
        if (this.logBlockManager != null && (entity = mage.getEntity()) != null) {
            this.logBlockManager.logBlockChange(entity, priorState, newState);
        }
    }

    @Override
    public boolean isFileLockingEnabled() {
        return this.isFileLockingEnabled;
    }

    public NPCSupplierSet getNPCSuppliers() {
        return this.npcSuppliers;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.npc.MagicNPC> getNPCs() {
        return new ArrayList<com.elmakers.mine.bukkit.api.npc.MagicNPC>(this.npcs.values());
    }

    public void unregisterNPC(com.elmakers.mine.bukkit.api.npc.MagicNPC npc) {
        String chunkId = this.getChunkKey(npc.getLocation());
        if (chunkId == null) {
            return;
        }
        List<MagicNPC> chunkNPCs = this.npcsByChunk.get(chunkId);
        if (chunkNPCs == null) {
            return;
        }
        Iterator<MagicNPC> it = chunkNPCs.iterator();
        while (it.hasNext()) {
            if (!it.next().getId().equals(npc.getId())) continue;
            it.remove();
            break;
        }
    }

    public boolean registerNPC(MagicNPC npc) {
        Location location = npc.getLocation();
        String chunkId = this.getChunkKey(location);
        if (chunkId == null) {
            return false;
        }
        List<MagicNPC> chunkNPCs = this.npcsByChunk.get(chunkId);
        if (chunkNPCs == null) {
            chunkNPCs = new ArrayList<MagicNPC>();
            this.npcsByChunk.put(chunkId, chunkNPCs);
        }
        chunkNPCs.add(npc);
        this.npcs.put(npc.getId(), npc);
        return true;
    }

    @Override
    @Nullable
    public MagicNPC addNPC(com.elmakers.mine.bukkit.api.magic.Mage creator, String name) {
        com.elmakers.mine.bukkit.entity.EntityData template = this.mobs.get(name);
        MagicNPC npc = template != null && template instanceof com.elmakers.mine.bukkit.entity.EntityData ? new MagicNPC(this, creator, creator.getLocation(), template) : new MagicNPC(this, creator, creator.getLocation(), name);
        if (!this.registerNPC(npc)) {
            return null;
        }
        return npc;
    }

    @Override
    public void removeNPC(com.elmakers.mine.bukkit.api.npc.MagicNPC npc) {
        this.unregisterNPC(npc);
        npc.remove();
        this.npcs.remove(npc.getId());
    }

    @Override
    @Nullable
    public MagicNPC getNPC(@Nullable Entity entity) {
        String npcId = CompatibilityLib.getEntityMetadataUtils().getString(entity, MagicMetaKeys.NPC_ID);
        return this.getNPC(npcId);
    }

    @Override
    @Nullable
    public MagicNPC getNPC(String id) {
        if (id == null) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(id);
            return this.getNPC(uuid);
        }
        catch (Exception ex) {
            this.getLogger().warning("Invalid npc_id found on mob: " + id);
            return null;
        }
    }

    @Override
    @Nullable
    public MagicNPC getNPC(UUID id) {
        return this.npcs.get(id);
    }

    public void restoreNPCs(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        List<MagicNPC> chunkData = this.npcsByChunk.get(chunkKey);
        if (chunkData != null) {
            for (MagicNPC npc : chunkData) {
                npc.restore();
            }
        }
    }

    @Override
    @Nullable
    public String getPlaceholder(Player player, String namespace, String placeholder) {
        return this.placeholderAPIManager == null ? null : this.placeholderAPIManager.getPlaceholder(player, namespace, placeholder);
    }

    @Override
    @Nonnull
    public String setPlaceholders(Player player, String message) {
        return this.placeholderAPIManager == null ? message : this.placeholderAPIManager.setPlaceholders(player, message);
    }

    @Override
    public void registerMob(@Nonnull Entity entity, @Nonnull EntityData entityData) {
        this.mobs.register(entity, (com.elmakers.mine.bukkit.entity.EntityData)entityData);
    }

    public CitizensController getCitizensController() {
        return this.citizens;
    }

    @Override
    public void lockChunk(Chunk chunk) {
        Integer locked = this.lockedChunks.get(chunk);
        if (locked == null) {
            this.lockedChunks.put(chunk, 1);
            CompatibilityLib.getCompatibilityUtils().lockChunk(chunk);
        } else {
            this.lockedChunks.put(chunk, locked + 1);
        }
    }

    @Override
    public void unlockChunk(Chunk chunk) {
        Integer locked = this.lockedChunks.get(chunk);
        if (locked == null || locked <= 1) {
            this.lockedChunks.remove(chunk);
            CompatibilityLib.getCompatibilityUtils().unlockChunk(chunk);
        } else {
            this.lockedChunks.put(chunk, locked - 1);
        }
    }

    @Override
    @Nonnull
    public Collection<Chunk> getLockedChunks() {
        return this.lockedChunks.keySet();
    }

    @Override
    @Nullable
    public String getResourcePackURL() {
        return this.resourcePacks.getDefaultResourcePackURL();
    }

    @Override
    @Nullable
    public String getResourcePackURL(CommandSender sender) {
        return this.resourcePacks.getResourcePackURL(sender);
    }

    @Override
    public boolean isUrlIconsEnabled() {
        return this.urlIconsEnabled;
    }

    @Override
    public boolean isLegacyIconsEnabled() {
        return this.legacyIconsEnabled;
    }

    public boolean resourcePackUsesSkulls(String pack) {
        Boolean packOverride = this.resourcePacks.resourcePackUsesSkulls(pack);
        return packOverride == null ? this.urlIconsEnabled : packOverride;
    }

    @Override
    public Collection<String> getAlternateResourcePacks() {
        return this.resourcePacks.getAlternateResourcePacks();
    }

    @Override
    public boolean isResourcePackEnabledByDefault() {
        return this.resourcePacks.isResourcePackEnabledByDefault();
    }

    @Override
    public boolean showConsoleCastFeedback() {
        return this.castConsoleFeedback;
    }

    public String getEditorURL() {
        return this.editorURL;
    }

    public void setReloadingMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.reloadingMage = mage;
    }

    public boolean useAnimationEvents(Player player) {
        if (this.swingType == SwingType.ANIMATE) {
            return true;
        }
        if (this.swingType == SwingType.INTERACT) {
            return false;
        }
        return player.getGameMode() == GameMode.ADVENTURE;
    }

    @Override
    @Nullable
    public List<DeathLocation> getDeathLocations(Player player) {
        ArrayList<DeathLocation> locations = null;
        if (this.deadSoulsController != null) {
            locations = new ArrayList<DeathLocation>();
            this.deadSoulsController.getSoulLocations(player, locations);
        }
        return locations;
    }

    public boolean isDespawnMagicMobs() {
        return this.despawnMagicMobs;
    }

    public void checkLogs(CommandSender sender) {
        this.logger.notify(this.messages, sender);
    }

    public MagicWorld getMagicWorld(String name) {
        return this.worldController.getWorld(name);
    }

    public WorldController getWorlds() {
        return this.worldController;
    }

    @Override
    public World createWorld(String worldName) {
        return this.worldController.createWorld(worldName);
    }

    @Override
    public World copyWorld(String worldName, World world) {
        return this.worldController.copyWorld(worldName, world);
    }

    @Override
    public int getMaxHeight(World world) {
        MagicWorld magicWorld = this.getMagicWorld(world.getName());
        int maxHeight = CompatibilityLib.getCompatibilityUtils().getMaxHeight(world);
        if (magicWorld != null) {
            maxHeight = magicWorld.getMaxHeight(maxHeight);
        }
        return maxHeight;
    }

    @Override
    public int getMinHeight(World world) {
        MagicWorld magicWorld = this.getMagicWorld(world.getName());
        int minHeight = CompatibilityLib.getCompatibilityUtils().getMinHeight(world);
        if (magicWorld != null) {
            minHeight = magicWorld.getMinHeight(minHeight);
        }
        return minHeight;
    }

    public boolean isDisableSpawnReplacement() {
        return this.disableSpawnReplacement > 0;
    }

    @Override
    public void setDisableSpawnReplacement(boolean disable) {
        this.disableSpawnReplacement = disable ? ++this.disableSpawnReplacement : --this.disableSpawnReplacement;
    }

    public ArenaController getArenas() {
        return this.arenaController;
    }

    @Override
    @Nullable
    public MagicWarp getMagicWarp(String warpKey) {
        return this.warpController.getMagicWarp(warpKey);
    }

    @Nonnull
    public Collection<? extends MagicWarp> getMagicWarps() {
        return this.warpController.getMagicWarps();
    }

    public void finalizeIntegration() {
        this.logger.setContext("integration");
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        Plugin mobArenaPlugin = pluginManager.getPlugin("MobArena");
        if (mobArenaPlugin == null) {
            this.getLogger().info("MobArena not found");
        } else if (this.mobArenaConfiguration.getBoolean("enabled", true)) {
            try {
                this.mobArenaManager = new MobArenaManager(this, mobArenaPlugin, this.mobArenaConfiguration);
                this.getLogger().info("Integrated with MobArena, use \"magic:<itemkey>\" in arena configs for Magic items, magic mobs can be used in monster configurations");
            }
            catch (Throwable ex) {
                this.getLogger().warning("MobArena integration failed, you may need to update the MobArena plugin to use Magic items");
            }
        } else {
            this.getLogger().info("MobArena integration disabled");
        }
        Plugin libsDisguisePlugin = pluginManager.getPlugin("LibsDisguises");
        if (libsDisguisePlugin == null) {
            this.getLogger().info("LibsDisguises not found, magic mob disguises will not be available");
        } else if (this.libsDisguiseEnabled) {
            if (!LibsDisguiseManager.isCurrentVersion()) {
                this.getLogger().info("Using legacy LibsDisguise integration, please update");
                this.libsDisguiseManager = new LegacyLibsDisguiseManager((Plugin)this.getPlugin(), libsDisguisePlugin);
            } else {
                this.libsDisguiseManager = new ModernLibsDisguiseManager(this, libsDisguisePlugin);
            }
            if (this.libsDisguiseManager.initialize()) {
                this.getLogger().info("LibsDisguises found, mob disguises and disguise_restricted features enabled");
            } else {
                this.getLogger().warning("LibsDisguises integration failed");
                this.libsDisguiseManager = null;
            }
        } else {
            this.libsDisguiseManager = null;
            this.getLogger().info("LibsDisguises integration disabled");
        }
        Plugin modelEnginePlugin = pluginManager.getPlugin("ModelEngine");
        if (modelEnginePlugin != null) {
            this.modelEngineManager = new ModelEngineManager((Plugin)this.plugin, modelEnginePlugin);
            if (this.modelEngineManager.isValid()) {
                this.getLogger().info("ModelEngine found, model magic mob configuration available");
            } else {
                this.getLogger().warning("ModelEngine found but integration failed");
            }
        }
        if (this.skriptEnabled) {
            if (pluginManager.getPlugin("Skript") != null) {
                try {
                    new SkriptManager(this);
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with Skript", ex);
                }
            }
        } else {
            this.getLogger().info("Skript integration disabled.");
        }
        try {
            Plugin heroesPlugin = pluginManager.getPlugin("Heroes");
            this.heroesManager = heroesPlugin != null ? new HeroesManager((Plugin)this.plugin, heroesPlugin) : null;
        }
        catch (Throwable ex) {
            this.getLogger().warning(ex.getMessage());
        }
        try {
            Plugin aureliumSkillsPlugin = pluginManager.getPlugin("AureliumSkills");
            this.aureliumSkillsManager = aureliumSkillsPlugin != null ? new AureliumSkillsManager(this) : null;
        }
        catch (Throwable ex) {
            this.getLogger().warning(ex.getMessage());
        }
        try {
            Plugin tokenManagerPlugin = pluginManager.getPlugin("TokenManager");
            this.tokenManager = tokenManagerPlugin != null ? new TokenManagerController(this, tokenManagerPlugin) : null;
        }
        catch (Throwable ex) {
            this.getLogger().warning(ex.getMessage());
        }
        Plugin skillAPIPlugin = pluginManager.getPlugin("SkillAPI");
        if (skillAPIPlugin != null && this.skillAPIEnabled) {
            this.skillAPIManager = new SkillAPIManager(this, skillAPIPlugin);
            if (this.skillAPIManager.initialize()) {
                this.getLogger().info("SkillAPI found, attributes can be used in spell parameters. Classes and skills can be used in requirements.");
            } else {
                this.skillAPIManager = null;
                this.getLogger().warning("SkillAPI integration failed");
            }
        } else if (!this.skillAPIEnabled) {
            this.skillAPIManager = null;
            this.getLogger().info("SkillAPI integration disabled");
        }
        Plugin mythicMobsPlugin = pluginManager.getPlugin("MythicMobs");
        if (mythicMobsPlugin != null) {
            if (this.mythicMobsEnabled) {
                this.mythicMobManager = new MythicMobManager(this, mythicMobsPlugin);
                if (this.mythicMobManager.initialize()) {
                    this.getLogger().info("MythicMobs found, mobs can be spawned in arenas, spells, actions, etc.");
                } else {
                    this.getLogger().warning("MythicMobs integration failed");
                    this.mythicMobManager = null;
                }
            } else {
                this.mythicMobManager = null;
                this.getLogger().info("MythicMobs integration disabled");
            }
        }
    }

    private void finalizeIntegrationPreLoad() {
        this.logger.setContext("integration");
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        if (!this.vaultEnabled) {
            this.getLogger().info("Vault integration disabled");
        } else {
            Plugin vaultPlugin = pluginManager.getPlugin("Vault");
            if (vaultPlugin == null) {
                this.getLogger().info("Vault not found, 'currency' cost types unavailable");
            } else if (!VaultController.initialize((Plugin)this.plugin, vaultPlugin)) {
                this.getLogger().warning("Vault integration failed");
            }
        }
    }

    public void finalizeIntegrationPostLoad() {
        Plugin logBlockPlugin;
        Plugin minigamesPlugin;
        this.logger.setContext("integration");
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        this.blockController.finalizeIntegration();
        Plugin battleArenaPlugin = pluginManager.getPlugin("BattleArena");
        if (battleArenaPlugin != null) {
            if (this.useBattleArenaTeams) {
                try {
                    this.battleArenaManager = new BattleArenaManager();
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.SEVERE, "Error integrating with BattleArena", ex);
                }
                this.getLogger().info("BattleArena found, teams will be respected in friendly fire checks");
            } else {
                this.battleArenaManager = null;
                this.getLogger().info("BattleArena integration disabled");
            }
        }
        if (pluginManager.isPluginEnabled("WildStacker")) {
            if (this.useWildStacker) {
                this.getLogger().info("Wild Stacker integration enabled");
                pluginManager.registerEvents((Listener)new WildStackerListener(), (Plugin)this.plugin);
            } else {
                this.getLogger().info("Wild Stacker found, but integration disabled");
            }
        }
        if ((minigamesPlugin = pluginManager.getPlugin("Minigames")) != null && minigamesPlugin.isEnabled()) {
            pluginManager.registerEvents((Listener)new MinigamesListener(this), (Plugin)this.plugin);
            this.getLogger().info("Minigames found, wands will deactivate before joining a minigame");
        }
        if ((logBlockPlugin = pluginManager.getPlugin("LogBlock")) == null || !logBlockPlugin.isEnabled()) {
            this.getLogger().info("LogBlock not found");
        } else if (this.logBlockEnabled) {
            try {
                this.logBlockManager = new LogBlockManager((Plugin)this.plugin, logBlockPlugin);
                this.getLogger().info("Integrated with LogBlock, engineering magic will be logged");
            }
            catch (Throwable ex) {
                this.getLogger().log(Level.WARNING, "LogBlock integration failed", ex);
            }
        } else {
            this.getLogger().info("LogBlock integration disabled");
        }
        Plugin essentials = pluginManager.getPlugin("Essentials");
        this.essentialsController = null;
        boolean bl = this.hasEssentials = essentials != null && essentials.isEnabled();
        if (this.hasEssentials) {
            this.essentialsController = EssentialsController.initialize(essentials);
            if (this.essentialsController == null) {
                this.getLogger().warning("Error integrating with Essentials");
            } else {
                this.getLogger().info("Integrating with Essentials for vanish detection");
            }
            if (this.warpController.setEssentials(essentials)) {
                this.getLogger().info("Integrating with Essentials for Recall warps");
            }
            try {
                this.mailer = new Mailer(essentials);
            }
            catch (Exception ex) {
                this.getLogger().warning("Essentials found, but failed to hook up to Mailer");
                this.mailer = null;
            }
        }
        if (this.essentialsSignsEnabled) {
            try {
                if (essentials != null) {
                    Class<?> essentialsClass = essentials.getClass();
                    essentialsClass.getMethod("getItemDb", new Class[0]);
                    if (MagicItemDb.register(this, essentials)) {
                        this.getLogger().info("Essentials found, hooked up custom item handler");
                    } else {
                        this.getLogger().warning("Essentials found, but something went wrong hooking up the custom item handler");
                    }
                }
            }
            catch (Throwable ex) {
                this.getLogger().warning("Essentials found, but is not up to date. Magic item integration will not work with this version of Magic. Please upgrade EssentialsX or downgrade Magic to 7.6.19");
            }
        }
        this.hasCommandBook = false;
        try {
            Plugin commandBookPlugin = this.plugin.getServer().getPluginManager().getPlugin("CommandBook");
            if (commandBookPlugin != null && commandBookPlugin.isEnabled()) {
                if (this.warpController.setCommandBook(commandBookPlugin)) {
                    this.getLogger().info("CommandBook found, integrating for Recall warps");
                    this.hasCommandBook = true;
                } else {
                    this.getLogger().warning("CommandBook integration failed");
                }
            }
        }
        catch (Throwable commandBookPlugin) {
            // empty catch block
        }
        this.factionsManager.initialize((Plugin)this.plugin);
        this.worldGuardManager.initialize((Plugin)this.plugin);
        this.pvpManager.initialize((Plugin)this.plugin);
        this.multiverseManager.initialize((Plugin)this.plugin);
        Plugin deadSoulsPlugin = this.plugin.getServer().getPluginManager().getPlugin("DeadSouls");
        if (deadSoulsPlugin != null) {
            try {
                this.deadSoulsController = new DeadSoulsManager(this);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Error integrating with DeadSouls, is it up to date? Version 1.6 or higher required.", ex);
            }
        }
        this.preciousStonesManager.initialize((Plugin)this.plugin);
        this.townyManager.initialize((Plugin)this.plugin);
        this.locketteManager.initialize((Plugin)this.plugin);
        this.griefPreventionManager.initialize((Plugin)this.plugin);
        this.ncpManager.initialize((Plugin)this.plugin);
        try {
            Plugin dynmapPlugin = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
            this.dynmap = dynmapPlugin != null && dynmapPlugin.isEnabled() ? new DynmapController((Plugin)this.plugin, dynmapPlugin, this.messages) : null;
        }
        catch (Throwable ex) {
            this.getLogger().warning(ex.getMessage());
        }
        if (this.dynmap == null) {
            this.getLogger().info("dynmap not found, not integrating.");
        } else {
            this.getLogger().info("dynmap found, integrating.");
        }
        try {
            Plugin elementalsPlugin = this.plugin.getServer().getPluginManager().getPlugin("Splateds_Elementals");
            this.elementals = elementalsPlugin != null && elementalsPlugin.isEnabled() ? new ElementalsController(elementalsPlugin) : null;
        }
        catch (Throwable ex) {
            this.getLogger().warning(ex.getMessage());
        }
        if (this.elementals != null) {
            this.getLogger().info("Elementals found, integrating.");
        }
        this.hasShopkeepers = pluginManager.isPluginEnabled("Shopkeepers");
        if (this.hasShopkeepers) {
            this.npcSuppliers.register(new GenericMetadataNPCSupplier("shopkeeper"));
        }
        try {
            Plugin citizensPlugin = this.plugin.getServer().getPluginManager().getPlugin("Citizens");
            if (citizensPlugin != null && citizensPlugin.isEnabled()) {
                this.citizens = new CitizensController(citizensPlugin, this, this.citizensEnabled);
                new MagicTraitCommandExecutor(MagicPlugin.getAPI(), this.citizens).register(this.plugin);
            } else {
                this.citizens = null;
                this.getLogger().info("Citizens not found, Magic trait unavailable.");
            }
        }
        catch (Throwable ex) {
            this.citizens = null;
            this.getLogger().warning("Error integrating with Citizens");
            this.getLogger().warning(ex.getMessage());
        }
        if (this.citizens != null) {
            this.npcSuppliers.register(this.citizens);
        }
        if (this.placeholdersEnabled) {
            if (pluginManager.isPluginEnabled("PlaceholderAPI")) {
                try {
                    if (this.placeholderAPIManager == null) {
                        this.placeholderAPIManager = new PlaceholderAPIManager(this);
                    }
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with PlaceholderAPI", ex);
                }
            }
        } else {
            this.getLogger().info("PlaceholderAPI integration disabled.");
        }
        if (this.lightAPIEnabled) {
            if (pluginManager.isPluginEnabled("LightAPI")) {
                try {
                    this.lightAPIManager = new LightAPIManager((Plugin)this.plugin);
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with LightAPI", ex);
                }
            } else {
                this.getLogger().info("LightAPI not found, Light action will not work");
            }
        } else {
            this.lightAPIManager = null;
            this.getLogger().info("LightAPI integration disabled.");
        }
        if (pluginManager.isPluginEnabled("Geyser-Spigot")) {
            try {
                this.geyserManager = new GeyserManager(this);
            }
            catch (Throwable ex) {
                this.getLogger().log(Level.WARNING, "Error integrating with Geyser", ex);
            }
        }
        if (this.ajParkourConfiguration.getBoolean("enabled")) {
            if (pluginManager.isPluginEnabled("ajParkour")) {
                try {
                    new AJParkourManager(this);
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with ajParkour", ex);
                }
            }
        } else {
            this.getLogger().info("ajParkour integration disabled.");
        }
        if (this.citadelConfiguration.getBoolean("enabled")) {
            if (pluginManager.isPluginEnabled("Citadel")) {
                try {
                    this.citadelManager = new CitadelManager(this, this.citadelConfiguration);
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with Citadel", ex);
                }
            }
        } else {
            this.getLogger().info("Citadel integration disabled.");
        }
        if (this.residenceConfiguration.getBoolean("enabled")) {
            if (pluginManager.isPluginEnabled("Residence")) {
                try {
                    this.residenceManager = new ResidenceManager(pluginManager.getPlugin("Residence"), this, this.residenceConfiguration);
                    this.getLogger().info("Integrated with residence for build/break/pvp/target checks");
                    this.getLogger().info("Disable warping to residences in recall config with allow_residence: false");
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with Residence", ex);
                }
            }
        } else {
            this.getLogger().info("Residence integration disabled.");
        }
        if (this.redProtectConfiguration.getBoolean("enabled")) {
            if (pluginManager.isPluginEnabled("RedProtect")) {
                try {
                    this.redProtectManager = new RedProtectManager(pluginManager.getPlugin("RedProtect"), this, this.redProtectConfiguration);
                    this.getLogger().info("Integrated with RedProtect for build/break/pvp/target checks");
                    this.getLogger().info("Disable warping to fields in recall config with allow_redprotect: false");
                    if (this.redProtectManager.isFlagsEnabled()) {
                        this.getLogger().info("Added custom flags: " + StringUtils.join((Object[])RedProtectManager.flags, (char)','));
                    }
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with RedProtect", ex);
                }
            }
        } else {
            this.getLogger().info("RedProtect integration disabled.");
        }
        MageUpdateTask mageTask = new MageUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)mageTask, 0L, (long)this.mageUpdateFrequency);
        BatchUpdateTask batchTask = new BatchUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)batchTask, 0L, (long)this.workFrequency);
        MagicBlockUpdateTask blockTask = new MagicBlockUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)blockTask, 0L, (long)this.magicBlockUpdateFrequency);
        UndoUpdateTask undoTask = new UndoUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)undoTask, 0L, (long)this.undoFrequency);
    }

    protected void loadProperties(CommandSender sender, ConfigurationSection properties) {
        ConfigurationSection migrateDataStoreConfiguration;
        ConfigurationSection mageDataStoreConfiguration;
        if (properties == null) {
            return;
        }
        this.resourcePacks.load(properties, sender, !this.loaded);
        this.logVerbosity = properties.getInt("log_verbosity", 0);
        this.logger.setNotify(properties.getBoolean("log_notify", CompatibilityLib.isModern()));
        CompatibilityConstants.DEBUG = this.logVerbosity >= 5;
        LOG_WATCHDOG_TIMEOUT = properties.getInt("load_watchdog_timeout", 30000);
        this.logger.setColorize(properties.getBoolean("colored_logs", true));
        if (this.autoSaveTaskId > 0) {
            Bukkit.getScheduler().cancelTask(this.autoSaveTaskId);
            this.autoSaveTaskId = 0;
        }
        if (this.configCheckTask != null) {
            this.configCheckTask.cancel();
            this.configCheckTask = null;
        }
        if (this.logNotifyTask != null) {
            this.logNotifyTask.cancel();
            this.logNotifyTask = null;
        }
        this.debugEffectLib = properties.getBoolean("debug_effects", false);
        EffectPlayer.debugEffects(this.debugEffectLib);
        boolean effectLibStackTraces = properties.getBoolean("debug_effects_stack_traces", false);
        EffectPlayer.showStackTraces(effectLibStackTraces);
        CompatibilityLib.getCompatibilityUtils().load(properties);
        EffectPlayer.setParticleRange(properties.getInt("particle_range", EffectPlayer.PARTICLE_RANGE));
        this.wandSlotConfigurations = properties.getConfigurationSection("wand_slots");
        this.urlIconsEnabled = properties.getBoolean("url_icons_enabled", this.urlIconsEnabled);
        this.legacyIconsEnabled = properties.getBoolean("legacy_icons_enabled", this.legacyIconsEnabled);
        this.spellProgressionEnabled = properties.getBoolean("enable_spell_progression", this.spellProgressionEnabled);
        this.autoSpellUpgradesEnabled = properties.getBoolean("enable_automatic_spell_upgrades", this.autoSpellUpgradesEnabled);
        this.autoPathUpgradesEnabled = properties.getBoolean("enable_automatic_spell_upgrades", this.autoPathUpgradesEnabled);
        this.undoQueueDepth = properties.getInt("undo_depth", this.undoQueueDepth);
        this.workPerUpdate = properties.getInt("work_per_update", this.workPerUpdate);
        this.workFrequency = properties.getInt("work_frequency", this.workFrequency);
        this.magicBlockUpdateFrequency = properties.getInt("magic_block_update_frequency", this.magicBlockUpdateFrequency);
        this.mageUpdateFrequency = properties.getInt("mage_update_frequency", this.mageUpdateFrequency);
        this.undoFrequency = properties.getInt("undo_frequency", this.undoFrequency);
        this.pendingQueueDepth = properties.getInt("pending_depth", this.pendingQueueDepth);
        this.undoMaxPersistSize = properties.getInt("undo_max_persist_size", this.undoMaxPersistSize);
        this.commitOnQuit = properties.getBoolean("commit_on_quit", this.commitOnQuit);
        this.saveNonPlayerMages = properties.getBoolean("save_non_player_mages", this.saveNonPlayerMages);
        this.defaultWandPath = properties.getString("default_wand_path", "");
        Wand.DEFAULT_WAND_TEMPLATE = properties.getString("default_wand", "");
        this.defaultWandMode = Wand.parseWandMode(properties.getString("default_wand_mode", ""), this.defaultWandMode);
        this.defaultBrushMode = Wand.parseWandMode(properties.getString("default_brush_mode", ""), this.defaultBrushMode);
        this.backupInventories = properties.getBoolean("backup_player_inventory", true);
        Wand.brushSelectSpell = properties.getString("brush_select_spell", Wand.brushSelectSpell);
        this.showMessages = properties.getBoolean("show_messages", this.showMessages);
        this.showCastMessages = properties.getBoolean("show_cast_messages", this.showCastMessages);
        this.messageThrottle = properties.getInt("message_throttle", 0);
        this.soundsEnabled = properties.getBoolean("sounds", this.soundsEnabled);
        this.fillingEnabled = properties.getBoolean("fill_wands", this.fillingEnabled);
        Wand.FILL_CREATOR = properties.getBoolean("fill_wand_creator", Wand.FILL_CREATOR);
        Wand.CREATIVE_CHEST_MODE = properties.getBoolean("wand_creative_chest_switch", Wand.CREATIVE_CHEST_MODE);
        Wand.OLD_WAND_LOCKED = properties.getBoolean("old_wand_locked_behavior", Wand.OLD_WAND_LOCKED);
        this.maxFillLevel = properties.getInt("fill_wand_level", this.maxFillLevel);
        this.welcomeWand = properties.getString("welcome_wand", "");
        this.maxDamagePowerMultiplier = (float)properties.getDouble("max_power_damage_multiplier", (double)this.maxDamagePowerMultiplier);
        this.maxConstructionPowerMultiplier = (float)properties.getDouble("max_power_construction_multiplier", (double)this.maxConstructionPowerMultiplier);
        this.maxRangePowerMultiplier = (float)properties.getDouble("max_power_range_multiplier", (double)this.maxRangePowerMultiplier);
        this.maxRangePowerMultiplierMax = (float)properties.getDouble("max_power_range_multiplier_max", (double)this.maxRangePowerMultiplierMax);
        this.maxRadiusPowerMultiplier = (float)properties.getDouble("max_power_radius_multiplier", (double)this.maxRadiusPowerMultiplier);
        this.maxRadiusPowerMultiplierMax = (float)properties.getDouble("max_power_radius_multiplier_max", (double)this.maxRadiusPowerMultiplierMax);
        this.materialColors = ConfigurationUtils.getNodeList(properties, "material_colors");
        this.materialVariants = ConfigurationUtils.getList(properties, "material_variants");
        this.blockItems = properties.getConfigurationSection("block_items");
        this.loadBlockSkins(properties.getConfigurationSection("block_skins"));
        this.loadMobSkins(properties.getConfigurationSection("mob_skins"));
        this.loadMobEggs(properties.getConfigurationSection("mob_eggs"));
        this.loadSkulls(properties.getConfigurationSection("skulls"));
        this.loadOtherMaterials(properties);
        WandCommandExecutor.CONSOLE_BYPASS_MODIFIABLE = properties.getBoolean("console_bypass_modifiable", properties.getBoolean("console_bypass_locked_wands", true));
        this.maxPower = (float)properties.getDouble("max_power", (double)this.maxPower);
        ConfigurationSection damageTypes = properties.getConfigurationSection("damage_types");
        if (damageTypes != null) {
            Set typeKeys = damageTypes.getKeys(false);
            for (Object typeKey : typeKeys) {
                ConfigurationSection damageType = damageTypes.getConfigurationSection((String)typeKey);
                this.damageTypes.put((String)typeKey, new DamageType(damageType));
            }
        }
        this.maxCostReduction = (float)properties.getDouble("max_cost_reduction", (double)this.maxCostReduction);
        this.maxCooldownReduction = (float)properties.getDouble("max_cooldown_reduction", (double)this.maxCooldownReduction);
        this.maxMana = properties.getInt("max_mana", this.maxMana);
        this.maxManaRegeneration = properties.getInt("max_mana_regeneration", this.maxManaRegeneration);
        this.worthBase = properties.getDouble("worth_base", 1.0);
        ItemData.EARN_SCALE = properties.getDouble("default_earn_scale", 0.5);
        SafetyUtils.MAX_VELOCITY = properties.getDouble("max_velocity", 10.0);
        HitboxUtils.setHitboxScale(properties.getDouble("hitbox_scale", 1.0));
        HitboxUtils.setHitboxScaleY(properties.getDouble("hitbox_scale_y", 1.0));
        HitboxUtils.setHitboxSneakScaleY(properties.getDouble("hitbox_sneaking_scale_y", 0.75));
        if (properties.contains("hitboxes")) {
            HitboxUtils.configureHitboxes(properties.getConfigurationSection("hitboxes"));
        }
        if (properties.contains("head_sizes")) {
            HitboxUtils.configureHeadSizes(properties.getConfigurationSection("head_sizes"));
        }
        if (properties.contains("max_height")) {
            CompatibilityLib.getCompatibilityUtils().configureMaxHeights(properties.getConfigurationSection("max_height"));
        }
        this.castCommandCostFree = properties.contains("cast_command_cost_reduction") ? properties.getDouble("cast_command_cost_reduction") > 0.0 : properties.getBoolean("cast_command_cost_free", this.castCommandCostFree);
        this.castCommandCooldownFree = properties.contains("cast_command_cooldown_reduction") ? properties.getDouble("cast_command_cooldown_reduction") > 0.0 : properties.getBoolean("cast_command_cooldown_free", this.castCommandCooldownFree);
        this.castConsoleCostFree = properties.contains("cast_console_cost_reduction") ? properties.getDouble("cast_console_cost_reduction") > 0.0 : properties.getBoolean("cast_console_cost_free", this.castConsoleCostFree);
        this.castConsoleCooldownFree = properties.contains("cast_console_cooldown_reduction") ? properties.getDouble("cast_console_cooldown_reduction") > 0.0 : properties.getBoolean("cast_console_cooldown_free", this.castConsoleCooldownFree);
        this.castConsoleFeedback = properties.getBoolean("cast_console_feedback", false);
        this.editorURL = properties.getString("editor_url");
        this.castCommandPowerMultiplier = (float)properties.getDouble("cast_command_power_multiplier", (double)this.castCommandPowerMultiplier);
        this.castConsolePowerMultiplier = (float)properties.getDouble("cast_console_power_multiplier", (double)this.castConsolePowerMultiplier);
        this.maps.setAnimationAllowed(properties.getBoolean("enable_map_animations", true));
        this.costReduction = (float)properties.getDouble("cost_reduction", (double)this.costReduction);
        this.cooldownReduction = (float)properties.getDouble("cooldown_reduction", (double)this.cooldownReduction);
        this.autoUndo = properties.getInt("auto_undo", this.autoUndo);
        this.spellDroppingEnabled = properties.getBoolean("allow_spell_dropping", this.spellDroppingEnabled);
        this.essentialsSignsEnabled = properties.getBoolean("enable_essentials_signs", this.essentialsSignsEnabled);
        this.logBlockEnabled = properties.getBoolean("logblock_enabled", this.logBlockEnabled);
        this.citizensEnabled = properties.getBoolean("enable_citizens", this.citizensEnabled);
        this.dynmapShowWands = properties.getBoolean("dynmap_show_wands", this.dynmapShowWands);
        this.dynmapShowSpells = properties.getBoolean("dynmap_show_spells", this.dynmapShowSpells);
        this.dynmapOnlyPlayerSpells = properties.getBoolean("dynmap_only_player_spells", this.dynmapOnlyPlayerSpells);
        this.dynmapUpdate = properties.getBoolean("dynmap_update", this.dynmapUpdate);
        this.protectLocked = properties.getBoolean("protect_locked", this.protectLocked);
        this.bindOnGive = properties.getBoolean("bind_on_give", this.bindOnGive);
        this.bypassBuildPermissions = properties.getBoolean("bypass_build", this.bypassBuildPermissions);
        this.bypassBreakPermissions = properties.getBoolean("bypass_break", this.bypassBreakPermissions);
        this.bypassPvpPermissions = properties.getBoolean("bypass_pvp", this.bypassPvpPermissions);
        this.wandsBreakHanging = properties.getBoolean("wands_break_hanging", this.wandsBreakHanging);
        this.bypassFriendlyFire = properties.getBoolean("bypass_friendly_fire", this.bypassFriendlyFire);
        this.useScoreboardTeams = properties.getBoolean("use_scoreboard_teams", this.useScoreboardTeams);
        this.defaultFriendly = properties.getBoolean("default_friendly", this.defaultFriendly);
        this.extraSchematicFilePath = properties.getString("schematic_files", this.extraSchematicFilePath);
        this.createWorldsEnabled = properties.getBoolean("enable_world_creation", this.createWorldsEnabled);
        this.defaultSkillIcon = properties.getString("default_skill_icon", this.defaultSkillIcon);
        this.skillInventoryRows = properties.getInt("skill_inventory_max_rows", this.skillInventoryRows);
        this.skillsSpell = properties.getString("mskills_spell", this.skillsSpell);
        CompatibilityConstants.MAX_LORE_LENGTH = properties.getInt("lore_wrap_limit", CompatibilityConstants.MAX_LORE_LENGTH);
        CompatibilityConstants.LORE_WRAP_PREFIX = properties.getString("lore_wrap_prefix", CompatibilityConstants.LORE_WRAP_PREFIX);
        this.libsDisguiseEnabled = properties.getBoolean("enable_libsdisguises", this.libsDisguiseEnabled);
        this.mythicMobsEnabled = properties.getBoolean("mythicmobs.enabled", this.mythicMobsEnabled);
        this.skillAPIEnabled = properties.getBoolean("skillapi_enabled", this.skillAPIEnabled);
        this.placeholdersEnabled = properties.getBoolean("placeholder_api_enabled", this.placeholdersEnabled);
        this.lightAPIEnabled = properties.getBoolean("light_api_enabled", this.lightAPIEnabled);
        this.skriptEnabled = properties.getBoolean("skript_enabled", this.skriptEnabled);
        this.vaultEnabled = properties.getConfigurationSection("vault").getBoolean("enabled");
        this.citadelConfiguration = properties.getConfigurationSection("citadel");
        this.mobArenaConfiguration = properties.getConfigurationSection("mobarena");
        this.residenceConfiguration = properties.getConfigurationSection("residence");
        this.redProtectConfiguration = properties.getConfigurationSection("redprotect");
        this.ajParkourConfiguration = properties.getConfigurationSection("ajparkour");
        CompatibilityConstants.USE_METADATA_LOCATIONS = properties.getBoolean("vivecraft.enabled");
        if (this.mobArenaManager != null) {
            this.mobArenaManager.configure(this.mobArenaConfiguration);
        }
        String swingTypeString = properties.getString("left_click_type");
        try {
            this.swingType = SwingType.valueOf(swingTypeString.toUpperCase());
        }
        catch (Exception ex) {
            this.getLogger().warning("Invalid left_click_type: " + swingTypeString);
        }
        List permissionTeams = properties.getList("permission_teams");
        if (permissionTeams != null) {
            this.permissionTeams = new ArrayList<List<String>>();
            for (Object o : permissionTeams) {
                if (o instanceof List) {
                    List stringList = (List)o;
                    this.permissionTeams.add(stringList);
                    continue;
                }
                if (!(o instanceof String)) continue;
                ArrayList<String> newList = new ArrayList<String>();
                newList.add((String)o);
                this.permissionTeams.add(newList);
            }
        }
        String defaultSpellIcon = properties.getString("default_spell_icon");
        try {
            BaseSpell.DEFAULT_SPELL_ICON = Material.valueOf((String)defaultSpellIcon.toUpperCase());
        }
        catch (Exception ex) {
            this.getLogger().warning("Invalid default_spell_icon: " + defaultSpellIcon);
        }
        this.skillsUseHeroes = properties.getBoolean("skills_use_heroes", this.skillsUseHeroes);
        this.useBattleArenaTeams = properties.getBoolean("use_battlearena_teams", this.useBattleArenaTeams);
        this.heroesSkillPrefix = properties.getString("heroes_skill_prefix", this.heroesSkillPrefix);
        this.skillsUsePermissions = properties.getBoolean("skills_use_permissions", this.skillsUsePermissions);
        this.messagePrefix = properties.getString("message_prefix", this.messagePrefix);
        this.castMessagePrefix = properties.getString("cast_message_prefix", this.castMessagePrefix);
        Messages.RANGE_FORMATTER = new DecimalFormat(properties.getString("range_formatter"));
        Messages.MOMENT_SECONDS_FORMATTER = new DecimalFormat(properties.getString("moment_seconds_formatter"));
        Messages.MOMENT_MILLISECONDS_FORMATTER = new DecimalFormat(properties.getString("moment_milliseconds_formatter"));
        Messages.SECONDS_FORMATTER = new DecimalFormat(properties.getString("seconds_formatter"));
        Messages.MINUTES_FORMATTER = new DecimalFormat(properties.getString("minutes_formatter"));
        Messages.HOURS_FORMATTER = new DecimalFormat(properties.getString("hours_formatter"));
        this.redstoneReplacement = ConfigurationUtils.getMaterialAndData(properties, "redstone_replacement", this.redstoneReplacement);
        this.messagePrefix = CompatibilityLib.getCompatibilityUtils().translateColors(this.messagePrefix);
        this.castMessagePrefix = CompatibilityLib.getCompatibilityUtils().translateColors(this.castMessagePrefix);
        ConfigurationSection worldGuardConfiguration = properties.getConfigurationSection("worldguard");
        if (!properties.getBoolean("region_manager_enabled", true)) {
            worldGuardConfiguration.set("enabled", (Object)false);
        }
        this.worldGuardManager.load(worldGuardConfiguration);
        this.factionsManager.setEnabled(properties.getBoolean("factions_enabled", this.factionsManager.isEnabled()));
        this.pvpManager.setEnabled(properties.getBoolean("pvp_manager_enabled", this.pvpManager.isEnabled()));
        this.multiverseManager.setEnabled(properties.getBoolean("multiverse_enabled", this.multiverseManager.isEnabled()));
        this.preciousStonesManager.setEnabled(properties.getBoolean("precious_stones_enabled", this.preciousStonesManager.isEnabled()));
        this.preciousStonesManager.setOverride(properties.getBoolean("precious_stones_override", true));
        this.townyManager.setEnabled(properties.getBoolean("towny_enabled", this.townyManager.isEnabled()));
        this.townyManager.setWildernessBypass(properties.getBoolean("towny_wilderness_bypass", true));
        this.locketteManager.setEnabled(properties.getBoolean("lockette_enabled", this.locketteManager.isEnabled()));
        this.griefPreventionManager.setEnabled(properties.getBoolean("grief_prevention_enabled", this.griefPreventionManager.isEnabled()));
        this.ncpManager.setEnabled(properties.getBoolean("ncp_enabled", false));
        this.useWildStacker = properties.getBoolean("wildstacker.enabled", true);
        Mage.DEFAULT_CLASS = properties.getString("default_mage_class", "");
        this.metricsLevel = properties.getInt("metrics_level", this.metricsLevel);
        ConfigurationSection autoWandsConfig = properties.getConfigurationSection("auto_wands");
        Set autoWandsKeys = autoWandsConfig.getKeys(false);
        this.autoWands.clear();
        for (String autoWandKey : autoWandsKeys) {
            try {
                Material autoWandMaterial = Material.valueOf((String)autoWandKey.toUpperCase());
                this.autoWands.put(autoWandMaterial, autoWandsConfig.getString(autoWandKey));
            }
            catch (Exception ex) {
                this.getLogger().warning("Invalid material in auto_wands config: " + autoWandKey);
            }
        }
        ConfigurationSection builtinExampleConfigs = properties.getConfigurationSection("external_examples");
        Set exampleKeys = builtinExampleConfigs.getKeys(false);
        this.builtinExternalExamples.clear();
        for (String exampleKey : exampleKeys) {
            this.builtinExternalExamples.put(exampleKey, builtinExampleConfigs.getString(exampleKey));
        }
        Wand.regenWhileInactive = properties.getBoolean("regenerate_while_inactive", Wand.regenWhileInactive);
        if (properties.contains("mana_display")) {
            String manaDisplay = properties.getString("mana_display");
            if (manaDisplay.equalsIgnoreCase("bar") || manaDisplay.equalsIgnoreCase("hybrid")) {
                Wand.manaMode = WandManaMode.BAR;
            } else if (manaDisplay.equalsIgnoreCase("number")) {
                Wand.manaMode = WandManaMode.NUMBER;
            } else if (manaDisplay.equalsIgnoreCase("durability")) {
                Wand.manaMode = WandManaMode.DURABILITY;
            } else if (manaDisplay.equalsIgnoreCase("glow")) {
                Wand.manaMode = WandManaMode.GLOW;
            } else if (manaDisplay.equalsIgnoreCase("none")) {
                Wand.manaMode = WandManaMode.NONE;
            }
        }
        this.spEnabled = properties.getBoolean("sp_enabled", true);
        this.spEarnEnabled = properties.getBoolean("sp_earn_enabled", true);
        this.populateEntityTypes(this.undoEntityTypes, properties, "entity_undo_types");
        this.populateEntityTypes(this.friendlyEntityTypes, properties, "friendly_entity_types");
        ActionHandler.setRestrictedActions(properties.getStringList("restricted_spell_actions"));
        String defaultLocationString = properties.getString("default_cast_location");
        try {
            Mage.DEFAULT_CAST_LOCATION = CastSourceLocation.valueOf(defaultLocationString.toUpperCase());
        }
        catch (Exception ex) {
            Mage.DEFAULT_CAST_LOCATION = CastSourceLocation.MAINHAND;
            this.getLogger().warning("Invalid default_cast_location: " + defaultLocationString);
        }
        Mage.DEFAULT_CAST_OFFSET.setZ(properties.getDouble("default_cast_location_offset", Mage.DEFAULT_CAST_OFFSET.getZ()));
        Mage.DEFAULT_CAST_OFFSET.setY(properties.getDouble("default_cast_location_offset_vertical", Mage.DEFAULT_CAST_OFFSET.getY()));
        Mage.OFFHAND_CAST_COOLDOWN = properties.getInt("offhand_cast_cooldown", Mage.OFFHAND_CAST_COOLDOWN);
        Mage.SNEAKING_CAST_OFFSET = properties.getDouble("sneaking_cast_location_offset_vertical", Mage.SNEAKING_CAST_OFFSET);
        Mage.CURRENCY_MESSAGE_DELAY = properties.getInt("currency_message_delay", Mage.CURRENCY_MESSAGE_DELAY);
        Mage.COMMAND_BLOCKS_SUPERPOWERED = properties.getBoolean("command_block_superpowered", Mage.COMMAND_BLOCKS_SUPERPOWERED);
        Mage.CONSOLE_SUPERPOWERED = properties.getBoolean("console_superpowered", Mage.CONSOLE_SUPERPOWERED);
        Wand.DefaultUpgradeMaterial = ConfigurationUtils.getMaterial(properties, "wand_upgrade_item", Wand.DefaultUpgradeMaterial);
        Wand.SpellGlow = properties.getBoolean("spell_glow", Wand.SpellGlow);
        Wand.LiveHotbarSkills = properties.getBoolean("live_hotbar_skills", Wand.LiveHotbarSkills);
        Wand.LiveHotbar = properties.getBoolean("live_hotbar", Wand.LiveHotbar);
        Wand.LiveHotbarCooldown = properties.getBoolean("live_hotbar_cooldown", Wand.LiveHotbarCooldown);
        Wand.LiveHotbarMana = properties.getBoolean("live_hotbar_mana", Wand.LiveHotbarMana);
        Wand.LiveHotbarCharges = properties.getBoolean("live_hotbar_charges", Wand.LiveHotbarCharges);
        Wand.BrushGlow = properties.getBoolean("brush_glow", Wand.BrushGlow);
        Wand.BrushItemGlow = properties.getBoolean("brush_item_glow", Wand.BrushItemGlow);
        Wand.WAND_KEY = properties.getString("wand_key", "wand");
        Wand.UPGRADE_KEY = properties.getString("wand_upgrade_key", "wand");
        Wand.WAND_SELF_DESTRUCT_KEY = properties.getString("wand_self_destruct_key", "");
        if (Wand.WAND_SELF_DESTRUCT_KEY.isEmpty()) {
            Wand.WAND_SELF_DESTRUCT_KEY = null;
        }
        Wand.HIDE_FLAGS = (byte)properties.getInt("wand_hide_flags", Wand.HIDE_FLAGS);
        Wand.Unbreakable = properties.getBoolean("wand_unbreakable", Wand.Unbreakable);
        Wand.Unstashable = properties.getBoolean("wand_undroppable", properties.getBoolean("wand_unstashable", Wand.Unstashable));
        MaterialBrush.CopyMaterial = ConfigurationUtils.getIconMaterialAndData(properties, "copy_item", this.legacyIconsEnabled, MaterialBrush.CopyMaterial);
        MaterialBrush.EraseMaterial = ConfigurationUtils.getIconMaterialAndData(properties, "erase_item", this.legacyIconsEnabled, MaterialBrush.EraseMaterial);
        MaterialBrush.CloneMaterial = ConfigurationUtils.getIconMaterialAndData(properties, "clone_item", this.legacyIconsEnabled, MaterialBrush.CloneMaterial);
        MaterialBrush.ReplicateMaterial = ConfigurationUtils.getIconMaterialAndData(properties, "replicate_item", this.legacyIconsEnabled, MaterialBrush.ReplicateMaterial);
        MaterialBrush.SchematicMaterial = ConfigurationUtils.getIconMaterialAndData(properties, "schematic_item", this.legacyIconsEnabled, MaterialBrush.SchematicMaterial);
        MaterialBrush.MapMaterial = ConfigurationUtils.getIconMaterialAndData(properties, "map_item", this.legacyIconsEnabled, MaterialBrush.MapMaterial);
        MaterialBrush.DefaultBrushMaterial = ConfigurationUtils.getIconMaterialAndData(properties, "default_brush_item", this.legacyIconsEnabled, MaterialBrush.DefaultBrushMaterial);
        MaterialBrush.configureReplacements(properties.getConfigurationSection("brush_replacements"));
        MaterialBrush.CopyCustomIcon = properties.getString("copy_icon_url", MaterialBrush.CopyCustomIcon);
        MaterialBrush.EraseCustomIcon = properties.getString("erase_icon_url", MaterialBrush.EraseCustomIcon);
        MaterialBrush.CloneCustomIcon = properties.getString("clone_icon_url", MaterialBrush.CloneCustomIcon);
        MaterialBrush.ReplicateCustomIcon = properties.getString("replicate_icon_url", MaterialBrush.ReplicateCustomIcon);
        MaterialBrush.SchematicCustomIcon = properties.getString("schematic_icon_url", MaterialBrush.SchematicCustomIcon);
        MaterialBrush.MapCustomIcon = properties.getString("map_icon_url", MaterialBrush.MapCustomIcon);
        MaterialBrush.DefaultBrushCustomIcon = properties.getString("default_brush_icon_url", MaterialBrush.DefaultBrushCustomIcon);
        MaterialBrush.CopyEnabled = properties.getBoolean("copy_brush_enabled", MaterialBrush.CopyEnabled);
        MaterialBrush.EraseEnabled = properties.getBoolean("erase_brush_enabled", MaterialBrush.CopyEnabled);
        MaterialBrush.CloneEnabled = properties.getBoolean("clone_brush_enabled", MaterialBrush.CopyEnabled);
        MaterialBrush.ReplicateEnabled = properties.getBoolean("replicate_brush_enabled", MaterialBrush.CopyEnabled);
        MaterialBrush.SchematicEnabled = properties.getBoolean("schematic_brush_enabled", MaterialBrush.CopyEnabled);
        MaterialBrush.MapEnabled = properties.getBoolean("map_brush_enabled", MaterialBrush.CopyEnabled);
        BaseSpell.DEFAULT_DISABLED_ICON_URL = properties.getString("disabled_icon_url", BaseSpell.DEFAULT_DISABLED_ICON_URL);
        Wand.DEFAULT_CAST_OFFSET.setZ(properties.getDouble("wand_location_offset", Wand.DEFAULT_CAST_OFFSET.getZ()));
        Wand.DEFAULT_CAST_OFFSET.setY(properties.getDouble("wand_location_offset_vertical", Wand.DEFAULT_CAST_OFFSET.getY()));
        Mage.JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION = properties.getInt("jump_exemption", 0);
        Mage.CHANGE_WORLD_EQUIP_COOLDOWN = properties.getInt("change_world_equip_cooldown", 0);
        String variableBoolean = "true|false";
        String closeWandVariable = properties.getString("close_wand_on_world_change", "true|false");
        if (closeWandVariable.equalsIgnoreCase("true|false")) {
            boolean hasPerWorldInventory = this.plugin.getServer().getPluginManager().getPlugin("PerWorldInventory") != null;
            boolean bl = hasPerWorldInventory = hasPerWorldInventory || this.plugin.getServer().getPluginManager().getPlugin("Multiverse-Inventories") != null;
            if (hasPerWorldInventory) {
                this.info("PerWorldInventory found, will close spell inventories on game mode or world change");
            }
            Mage.DEACTIVATE_WAND_ON_WORLD_CHANGE = hasPerWorldInventory;
        } else {
            Mage.DEACTIVATE_WAND_ON_WORLD_CHANGE = properties.getBoolean("close_wand_on_world_change", false);
        }
        Mage.DEACTIVATE_WAND_ON_GAME_MODE_CHANGE = properties.getBoolean("close_wand_on_game_mode_change", Mage.DEACTIVATE_WAND_ON_WORLD_CHANGE);
        Mage.ALLOW_PERSISTENT_INVISIBILITY = properties.getBoolean("allow_player_persistent_invisibility", true);
        Wand.inventoryOpenSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_open_sound"));
        Wand.inventoryCloseSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_close_sound"));
        Wand.inventoryCycleSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_cycle_sound"));
        Wand.noActionSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_no_action_sound"));
        Wand.itemPickupSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_pickup_item_sound"));
        this.explosionController.loadProperties(properties);
        this.inventoryController.loadProperties(properties);
        this.entityController.loadProperties(properties);
        this.playerController.loadProperties(properties);
        this.blockController.loadProperties(properties);
        EffectPlayer.SOUNDS_ENABLED = this.soundsEnabled;
        int autoSaveIntervalTicks = properties.getInt("auto_save", 0) * 20 / 1000;
        if (autoSaveIntervalTicks > 1) {
            AutoSaveTask autoSave = new AutoSaveTask(this);
            this.autoSaveTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)autoSave, (long)autoSaveIntervalTicks, (long)autoSaveIntervalTicks);
        }
        this.savePlayerData = properties.getBoolean("save_player_data", true);
        this.externalPlayerData = properties.getBoolean("external_player_data", false);
        if (this.externalPlayerData) {
            this.getLogger().info("Magic is expecting player data to be loaded from an external source");
        } else if (!this.savePlayerData) {
            this.getLogger().info("Magic player data saving is disabled");
        }
        this.asynchronousSaving = properties.getBoolean("save_player_data_asynchronously", true);
        this.isFileLockingEnabled = properties.getBoolean("use_file_locking", false);
        this.fileLoadDelay = properties.getInt("file_load_delay", 0);
        this.despawnMagicMobs = properties.getBoolean("despawn_magic_mobs", false);
        MobController.REMOVE_INVULNERABLE = properties.getBoolean("remove_invulnerable_mobs", false);
        EffectPlayer.ENABLE_VANILLA_SOUNDS = properties.getBoolean("enable_vanilla_sounds", true);
        EffectPlayer.ENABLE_CUSTOM_SOUNDS = properties.getBoolean("enable_custom_sounds", true);
        EffectPlayer.VOLUME_SCALE = properties.getDouble("sound_volume", 1.0);
        ConfigurationSection blockExchange = properties.getConfigurationSection("block_exchange");
        if (blockExchange != null) {
            if (blockExchange.getBoolean("enabled", true)) {
                this.blockExchangeCurrency = blockExchange.getString("currency");
                if (this.blockExchangeCurrency != null && this.blockExchangeCurrency.isEmpty()) {
                    this.blockExchangeCurrency = null;
                }
            } else {
                this.blockExchangeCurrency = null;
            }
        } else {
            this.blockExchangeCurrency = null;
        }
        if (this.mageDataStore != null) {
            this.mageDataStore.close();
        }
        if ((mageDataStoreConfiguration = properties.getConfigurationSection("player_data_store")) != null) {
            this.mageDataStore = this.loadMageDataStore(mageDataStoreConfiguration);
            if (this.mageDataStore == null) {
                this.getLogger().log(Level.WARNING, "Failed to load player_data_store configuration, player data saving disabled!");
            }
        } else {
            this.getLogger().log(Level.WARNING, "Missing player_data_store configuration, player data saving disabled!");
            this.mageDataStore = null;
        }
        if ((migrateDataStoreConfiguration = properties.getConfigurationSection("migrate_data_store")) != null) {
            this.migrateDataStore = this.loadMageDataStore(migrateDataStoreConfiguration);
            if (this.migrateDataStore == null) {
                this.getLogger().log(Level.WARNING, "Failed to load migrate_data_store configuration, migration will not work");
            }
        } else {
            this.migrateDataStore = null;
        }
        if (this.migrateDataStore != null) {
            this.migrateDataStore.close();
        }
        Wand.DefaultWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item", Wand.DefaultWandMaterial);
        Wand.EnchantableWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item_enchantable", Wand.EnchantableWandMaterial);
        this.enchanting.load(properties);
        if (this.enchanting.isEnabled()) {
            this.log("Wand enchanting is enabled");
        }
        this.crafting.loadMainConfiguration(properties);
        if (this.crafting.isEnabled()) {
            this.log("Wand crafting is enabled");
        }
        this.anvil.load(properties);
        if (this.anvil.isCombiningEnabled()) {
            this.log("Wand anvil combining is enabled");
        }
        if (this.anvil.isOrganizingEnabled()) {
            this.log("Wand anvil organizing is enabled");
        }
        if (this.isUrlIconsEnabled()) {
            this.log("Skin-based spell icons enabled");
        } else {
            this.log("Skin-based spell icons disabled");
        }
        int configUpdateInterval = properties.getInt("config_update_interval");
        if (configUpdateInterval > 0) {
            this.log("Sandbox enabled, will check for updates from the web UI");
            ConfigCheckTask configCheck = new ConfigCheckTask(this);
            this.configCheckTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)configCheck, (long)(configUpdateInterval * 20 / 1000), (long)(configUpdateInterval * 20 / 1000));
        }
        this.logger.clearNotify();
        int logNotifyInterval = properties.getInt("log_notify_interval");
        if (logNotifyInterval > 0) {
            LogNotifyTask logNotify = new LogNotifyTask(this);
            this.logNotifyTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)logNotify, (long)(logNotifyInterval * 20 / 1000), (long)(logNotifyInterval * 20 / 1000));
        }
        this.worldController.load(properties.getConfigurationSection("world_modification"));
        this.protectionManager.initialize((Plugin)this.plugin, ConfigurationUtils.getStringList(properties, "generic_protection"));
    }

    protected void loadMaterials(ConfigurationSection materialNode) {
        if (materialNode == null) {
            return;
        }
        this.materialSetManager.loadMaterials(materialNode);
        DefaultMaterials defaultMaterials = DefaultMaterials.getInstance();
        defaultMaterials.initialize(this.materialSetManager);
        defaultMaterials.loadColors(this.materialColors);
        defaultMaterials.loadVariants(this.materialVariants);
        defaultMaterials.loadBlockItems(this.blockItems);
        defaultMaterials.setPlayerSkullItem(this.skullItems.get(EntityType.PLAYER));
        defaultMaterials.setPlayerSkullWallBlock(this.skullWallBlocks.get(EntityType.PLAYER));
        defaultMaterials.setSkeletonSkullItem(this.skullItems.get(EntityType.SKELETON));
        this.buildingMaterials = this.materialSetManager.getMaterialSetEmpty("building");
        this.indestructibleMaterials = this.materialSetManager.getMaterialSetEmpty("indestructible");
        this.restrictedMaterials = this.materialSetManager.getMaterialSetEmpty("restricted");
        this.destructibleMaterials = this.materialSetManager.getMaterialSetEmpty("destructible");
        this.interactibleMaterials = this.materialSetManager.getMaterialSetEmpty("interactible");
        this.containerMaterials = this.materialSetManager.getMaterialSetEmpty("containers");
        this.climbableMaterials = this.materialSetManager.getMaterialSetEmpty("climbable");
        this.undoableMaterials = this.materialSetManager.getMaterialSetEmpty("undoable");
        this.wearableMaterials = this.materialSetManager.getMaterialSetEmpty("wearable");
        this.meleeMaterials = this.materialSetManager.getMaterialSetEmpty("melee");
        this.offhandMaterials = this.materialSetManager.getMaterialSetEmpty("offhand");
        UndoList.attachables = this.materialSetManager.getMaterialSetEmpty("attachable");
        UndoList.attachablesWall = this.materialSetManager.getMaterialSetEmpty("attachable_wall");
        UndoList.attachablesDouble = this.materialSetManager.getMaterialSetEmpty("attachable_double");
    }

    @Override
    @Nullable
    public Currency getBlockExchangeCurrency() {
        return this.blockExchangeCurrency == null ? null : this.getCurrency(this.blockExchangeCurrency);
    }

    public int getMaxLevel(String spellName) {
        Integer maxLevel = this.maxSpellLevels.get(spellName);
        return maxLevel == null ? 1 : maxLevel;
    }

    @Override
    @Nullable
    public Double getBuiltinAttribute(String attributeKey) {
        switch (attributeKey) {
            case "weeks": {
                return 6.048E8;
            }
            case "days": {
                return 8.64E7;
            }
            case "hours": {
                return 3600000.0;
            }
            case "minutes": {
                return 60000.0;
            }
            case "seconds": {
                return 1000.0;
            }
            case "epoch": {
                return System.currentTimeMillis();
            }
            case "pi": {
                return Math.PI;
            }
            case "degrees": {
                return Math.PI / 180;
            }
        }
        return null;
    }

    public ClientPlatform getClientPlatform(Player player) {
        return this.geyserManager != null && this.geyserManager.isBedrock(player.getUniqueId()) ? ClientPlatform.BEDROCk : ClientPlatform.JAVA;
    }

    @Override
    public Entity getDamageSource(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList blockList;
        Entity source = CompatibilityLib.getCompatibilityUtils().getSource(entity);
        if (source instanceof TNTPrimed && (blockList = this.getEntityUndo(source)) != null) {
            Entity mageEntity;
            com.elmakers.mine.bukkit.api.magic.Mage owner = blockList.getOwner();
            Entity entity2 = mageEntity = owner == null ? null : owner.getEntity();
            if (mageEntity != null) {
                source = mageEntity;
            }
        }
        return source;
    }

    @Override
    public boolean isDamaging() {
        return CompatibilityLib.getCompatibilityUtils().isDamaging();
    }

    @Override
    public MaterialAndData createMaterialAndData(Material material, String blockData) {
        return new MaterialAndData(material, blockData);
    }

    @Override
    public MaterialAndData createMaterialAndData(Material material, byte legacyBlockData) {
        return new MaterialAndData(material, legacyBlockData);
    }

    @Override
    public MaterialAndData createMaterialAndData(String materialKey) {
        return new MaterialAndData(materialKey);
    }

    @Override
    @Nullable
    public Entity spawnMythicMob(String mythicMobKey, Location location) {
        if (this.mythicMobManager != null) {
            return this.mythicMobManager.spawn(mythicMobKey, location);
        }
        return null;
    }

    @Override
    @Nullable
    public String getMythicMobKey(Entity entity) {
        if (this.mythicMobManager != null) {
            return this.mythicMobManager.getMobKey(entity);
        }
        return null;
    }

    @Override
    public Double getMythicMobLevel(Entity entity) {
        if (this.mythicMobManager != null) {
            return this.mythicMobManager.getMobLevel(entity);
        }
        return null;
    }

    @Override
    public void setMythicMobLevel(Entity entity, double level) {
        if (this.mythicMobManager != null) {
            this.mythicMobManager.setMobLevel(entity, level);
        }
    }

    @Override
    public boolean isMythicMobKey(String mythicMobKey) {
        if (this.mythicMobManager != null) {
            return this.mythicMobManager.isMobKey(mythicMobKey);
        }
        return false;
    }

    @Nullable
    public ConfigurationSection getWandSlotConfiguration(String slotKey) {
        return this.wandSlotConfigurations == null ? null : this.wandSlotConfigurations.getConfigurationSection(slotKey);
    }

    private /* synthetic */ void lambda$loadSchematic$1(InputStream legacySchematic, LegacySchematic schematic) {
        try {
            CompatibilityLib.getSchematicUtils().loadLegacySchematic(legacySchematic, schematic);
            this.info("Finished loading schematic");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$loadSchematic$0(InputStream inputSchematic, Schematic schematic) {
        try {
            CompatibilityLib.getSchematicUtils().loadSchematic(inputSchematic, schematic, this.getLogger());
            this.info("Finished loading schematic");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

