/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit;

import com.elmakers.mine.bukkit.api.magic.Messages;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;

public class ChatUtils {
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("[\\s0-9\\p{Punct}\\p{IsPunctuation}\u2150-\u2bff\ue000-\uffff]");
    private static Messages messages;
    private static Logger logger;
    private static Gson gson;

    public static void initialize(Messages messages, Logger logger) {
        ChatUtils.messages = messages;
        ChatUtils.logger = logger;
    }

    protected static Gson getGson() {
        if (gson == null) {
            gson = new Gson();
        }
        return gson;
    }

    protected static void getSimpleMessage(Map<String, Object> mapped, StringBuilder plainMessage, boolean onlyText) {
        for (Map.Entry<String, Object> entry : mapped.entrySet()) {
            String action;
            Map properties;
            if (entry.getKey().equals("text")) {
                plainMessage.append(entry.getValue());
                continue;
            }
            if (entry.getKey().equals("extra")) {
                Object rawExtra = entry.getValue();
                if (!(rawExtra instanceof List)) continue;
                List mapList = (List)rawExtra;
                for (Map child : mapList) {
                    ChatUtils.getSimpleMessage(child, plainMessage, onlyText);
                }
                continue;
            }
            if (entry.getKey().equals("keybind")) {
                String key = entry.getValue().toString().replace("key.", "");
                if (messages != null) {
                    key = messages.get("keybind." + key, key);
                }
                plainMessage.append(key);
                continue;
            }
            if (onlyText) continue;
            if (entry.getKey().equals("color")) {
                String colorKey = entry.getValue().toString();
                try {
                    ChatColor color = ChatColor.valueOf((String)colorKey.toUpperCase());
                    plainMessage.append(color);
                }
                catch (Exception color) {}
                continue;
            }
            if (!entry.getKey().equals("clickEvent") || !(properties = (Map)entry.getValue()).containsKey("action") || !properties.containsKey("value")) continue;
            String value = properties.get("value").toString();
            switch (action = properties.get("action").toString()) {
                case "open_url": 
                case "run_command": 
                case "suggest_command": {
                    plainMessage.append(ChatColor.RESET + " " + ChatColor.GRAY + value);
                }
            }
        }
    }

    public static String getSimpleMessage(String containsJson) {
        return ChatUtils.getSimpleMessage(containsJson, false);
    }

    public static String getSimpleMessage(String containsJson, boolean onlyText) {
        String[] components = ChatUtils.getComponents(containsJson);
        StringBuilder plainMessage = new StringBuilder();
        for (String component : components) {
            if (component.startsWith("{")) {
                try {
                    JsonReader reader = new JsonReader((Reader)new StringReader(component));
                    reader.setLenient(true);
                    Map mapped = (Map)ChatUtils.getGson().fromJson(reader, Map.class);
                    ChatUtils.getSimpleMessage(mapped, plainMessage, onlyText);
                }
                catch (Exception ex) {
                    plainMessage.append(component);
                }
                continue;
            }
            plainMessage.append(component);
        }
        return plainMessage.toString();
    }

    public static String[] getComponents(String containsJson) {
        return StringUtils.split((String)containsJson, (String)"`");
    }

    public static String[] getWords(String text) {
        return PUNCTUATION_PATTERN.split(text);
    }

    public static boolean hasJSON(String text) {
        return text.contains("`{");
    }

    public static boolean isDefaultFont(String font) {
        return font == null || font.isEmpty() || font.equals("default");
    }

    public static void sendToConsoleSender(String message, Logger logger) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        if (sender == null) {
            logger.info(ChatColor.stripColor((String)message));
        } else {
            sender.sendMessage(message);
        }
    }
}

